/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.tableformat.renderers;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

class IgnoreMouseDragListener
implements MouseListener,
MouseMotionListener,
CellEditorListener {
    private final int COUNT_TO_IGNORE = 30;
    private int count = 30;
    private boolean isSame = false;
    private boolean isEditing = false;
    private TableCellEditor myEditor;

    public IgnoreMouseDragListener(TableCellEditor editor) {
        this.myEditor = editor;
        this.myEditor.addCellEditorListener(this);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.isSame = true;
    }

    public boolean mayEdit() {
        return this.isSame;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.isSame = false;
        this.count = 0;
        if (!this.isEditing) {
            this.myEditor.cancelCellEditing();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.count > 0) {
            --this.count;
        } else {
            this.isSame = false;
            if (!this.isEditing) {
                this.myEditor.cancelCellEditing();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.isSame = true;
        this.count = 30;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.isSame = true;
        this.isEditing = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.isEditing = true;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.isEditing = this.isSame;
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        this.isEditing = false;
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        this.isEditing = false;
    }
}

