/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.tableformat.renderers;

import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import ordermate.OrderMate;

public class NumberFormatRenderer
extends DefaultTableCellRenderer {
    private final NumberFormat format;

    public NumberFormatRenderer(NumberFormat format) {
        this.format = format;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Object localValue = value;
        if (!(value instanceof Number)) {
            try {
                localValue = Double.parseDouble(value.toString());
            }
            catch (NumberFormatException ex) {
                OrderMate.LOG.error("cannot parse the value.");
            }
        }
        localValue = this.format.format(((Number)localValue).doubleValue());
        return super.getTableCellRendererComponent(table, localValue, isSelected, hasFocus, row, column);
    }
}

