/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.tableformat.renderers;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;

public class NumericLongCellEditor
extends DefaultCellEditor {
    public NumericLongCellEditor() {
        super(new JTextField());
        JTextField textField = (JTextField)this.getComponent();
        textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (!Character.isDigit(c) && c != '\b') {
                    e.consume();
                }
            }
        });
    }

    @Override
    public Object getCellEditorValue() {
        String text = ((JTextField)this.getComponent()).getText();
        try {
            return Long.parseLong(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

