/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.tableformat.renderers;

import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class TableCellRendererHelper {
    public static void updateTableCellRendererComponent(JTable table, boolean isSelected, boolean hasFocus, int row, int column, JComponent toUpdate) {
        Color fg = null;
        Color bg = null;
        JTable.DropLocation dropLocation = table.getDropLocation();
        if (dropLocation != null && !dropLocation.isInsertRow() && !dropLocation.isInsertColumn() && dropLocation.getRow() == row && dropLocation.getColumn() == column) {
            fg = UIManager.getColor("Table.dropCellForeground");
            bg = UIManager.getColor("Table.dropCellBackground");
            isSelected = true;
        }
        if (isSelected) {
            toUpdate.setForeground(fg == null ? table.getSelectionForeground() : fg);
            toUpdate.setBackground(bg == null ? table.getSelectionBackground() : bg);
        } else {
            toUpdate.setForeground(table.getForeground());
            toUpdate.setBackground(table.getBackground());
        }
        toUpdate.setFont(table.getFont());
        if (hasFocus) {
            Border border = null;
            if (isSelected) {
                border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            toUpdate.setBorder(border);
            if (!isSelected && table.isCellEditable(row, column)) {
                Color col = UIManager.getColor("Table.focusCellForeground");
                if (col != null) {
                    toUpdate.setForeground(col);
                }
                if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                    toUpdate.setBackground(col);
                }
            }
        } else {
            toUpdate.setBorder(new EmptyBorder(1, 1, 1, 1));
        }
    }
}

