/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.tree;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.components.AbstractObjectEditor;
import officemate.components.tree.TreeNodeTransferHandler;
import ordermate.OrderMate;
import ordermate.database.users.Permission;

public abstract class AbstractTreeEditorState<T>
extends BasicOfficeMateState
implements TreeSelectionListener {
    private boolean initCalled;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private Object selectedObject;
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private boolean changed;
    private final Set<Action> selectionDependentActions = new HashSet<Action>();
    private final Set<DefaultMutableTreeNode> deletedNodes = new HashSet<DefaultMutableTreeNode>();
    private JPanel searchPanel;
    private DefaultMutableTreeNode rootNode;
    private int splitDividerLocation = 280;

    public AbstractTreeEditorState(String stateName, Permission permission, String description) {
        super(stateName, permission, description);
        if (!SwingUtilities.isEventDispatchThread() && Config.isDebuging()) {
            throw new IllegalStateException("Not running the EDT");
        }
    }

    @Override
    protected void onStart() {
        if (!this.initCalled) {
            this.init();
            this.initCalled = true;
        }
        this.refreshSearchPanel();
    }

    @Override
    protected void init() {
        if (!SwingUtilities.isEventDispatchThread() && Config.isDebuging()) {
            throw new IllegalStateException("Not running the EDT");
        }
        this.createSelectionDependentActions();
        this.addAction((Action)new RefreshAction((Refreshable)this));
        JPanel screenPanel = new JPanel();
        screenPanel.setLayout(new BorderLayout());
        this.searchPanel = this.getSearchPanel();
        if (this.searchPanel != null) {
            screenPanel.add((Component)this.searchPanel, "North");
        }
        JSplitPane splitter = new JSplitPane();
        screenPanel.add((Component)splitter, "Center");
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new JTree(this.treeModel);
        this.tree.setName("editorTree");
        this.tree.setShowsRootHandles(false);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.addTreeSelectionListener(this);
        this.treeModel.addTreeModelListener(new TreeEditorModelListener());
        DefaultTreeCellRenderer renderer = this.getCellRenderer();
        if (renderer != null) {
            this.tree.setCellRenderer(renderer);
        }
        JScrollPane spTree = new JScrollPane(this.tree);
        spTree.setMinimumSize(new Dimension(100, 200));
        splitter.setLeftComponent(spTree);
        this.getObjectEditor().getComponent().setVisible(false);
        JScrollPane spEditor = new JScrollPane(this.getObjectEditor().getComponent());
        spEditor.setMinimumSize(new Dimension(100, 200));
        splitter.setRightComponent(spEditor);
        this.setScreenPanel(screenPanel);
        splitter.setDividerLocation(this.getSplitDividerLocation());
        this.tree.setDragEnabled(true);
        this.tree.setTransferHandler(new TreeNodeTransferHandler());
        this.getObjectEditor().objectEdited.connect((Object)this, "gotObjectEdited");
    }

    protected JTree getTree() {
        return this.tree;
    }

    protected void createSelectionDependentActions() {
        this.selectionDependentActions.add(this.getNewAction());
        this.selectionDependentActions.add(this.getDeleteAction());
    }

    @Override
    public void refresh() {
        if (!SwingUtilities.isEventDispatchThread() && Config.isDebuging()) {
            throw new IllegalStateException("Not running the EDT");
        }
        this.promptForSave();
        super.refresh();
        this.rootNode = this.getRootNode();
        this.treeModel.setRoot(this.rootNode);
        this.setChanged(false);
        this.valueChanged(null);
    }

    protected abstract JPanel getSearchPanel();

    protected abstract void refreshSearchPanel();

    protected abstract void setSearchPanelEnabled(boolean var1);

    protected abstract DefaultMutableTreeNode getRootNode();

    protected abstract AbstractObjectEditor getObjectEditor();

    protected abstract Class getDisplayingType();

    protected abstract boolean isEditable(Object var1);

    protected DefaultTreeCellRenderer getCellRenderer() {
        return null;
    }

    public final Object getSelectedObject() {
        return this.selectedObject;
    }

    public final DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            this.getObjectEditor().getComponent().setVisible(false);
            this.selectedObject = null;
        } else {
            this.selectedObject = node.getUserObject();
        }
        if (this.isEditable(this.selectedObject)) {
            this.getObjectEditor().getComponent().setVisible(true);
            this.getObjectEditor().setObject(this.selectedObject);
        } else {
            this.getObjectEditor().getComponent().setVisible(false);
        }
        this.setSelectionDependantActionEnabled(this.selectedObject != null);
    }

    public void gotObjectEdited() {
        this.setChanged();
        try {
            this.getObjectEditor().saveObject();
        }
        catch (Exception e) {
            OrderMate.LOG.debug("Cannot save the edited object " + this.selectedObject, (Throwable)e);
        }
        this.treeModel.nodeChanged(this.getSelectedNode());
    }

    @Override
    public void doDeleteAction() {
        DefaultMutableTreeNode currentNode;
        MutableTreeNode parent;
        if (this.getSelectedNode() != null && (parent = (MutableTreeNode)(currentNode = this.getSelectedNode()).getParent()) != null && this.canDelete(currentNode)) {
            this.deletedNodes.add(currentNode);
            this.treeModel.removeNodeFromParent(currentNode);
            this.gotObjectEdited();
            return;
        }
        this.toolkit.beep();
    }

    protected boolean canDelete(DefaultMutableTreeNode currentNode) {
        return currentNode.getChildCount() <= 1 && (currentNode.getChildCount() != 1 || currentNode.getFirstChild().isLeaf()) || Dialogs.showWarningDialog("Really Delete?", "Are you sure you want to delete " + currentNode + " containing " + currentNode.getChildCount() + " children?");
    }

    @Override
    public void doNewAction() {
        if (this.getSelectedNode() != null) {
            T newObject = this.createNewObject();
            DefaultMutableTreeNode selectedNode = this.getSelectedNode();
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(newObject);
            if (selectedNode == null) {
                selectedNode = this.rootNode;
            }
            this.treeModel.insertNodeInto(childNode, selectedNode, selectedNode.getChildCount());
            this.tree.scrollPathToVisible(new TreePath(childNode.getPath()));
            this.tree.setSelectionPath(new TreePath(childNode));
            this.gotObjectEdited();
        } else {
            this.toolkit.beep();
        }
    }

    protected T createNewObject() {
        T newObject = null;
        try {
            newObject = this.getDisplayingType().newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Error constructing new object using reflection", ex);
        }
        return newObject;
    }

    public Set getDeletedNodes() {
        return this.deletedNodes;
    }

    protected void addSelectionDependentAction(Action toAdd) {
        this.selectionDependentActions.add(toAdd);
        this.addAction(toAdd);
    }

    protected void setSelectionDependantActionEnabled(boolean enabled) {
        for (Action action : this.selectionDependentActions) {
            action.setEnabled(enabled);
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged() {
        this.setChanged(true);
    }

    private void setChanged(boolean value) {
        this.changed = value;
        this.getSaveAction().setEnabled(value);
        this.getCancelAction().setEnabled(value);
        this.setSearchPanelEnabled(!value);
        if (!value) {
            this.deletedNodes.clear();
        }
    }

    protected void promptForSave() {
        int n;
        if (this.isChanged() && (n = JOptionPane.showConfirmDialog(this.getScreenPanel(), "Do you want to save your changes?", "Save changes", 0)) == 0) {
            this.doSaveAction();
        }
    }

    @Override
    public boolean isExitAllowed() {
        this.promptForSave();
        return true;
    }

    protected void doDelete(DefaultMutableTreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            Saveable saveable;
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            if (child instanceof Saveable) {
                saveable = (Saveable)child.getUserObject();
                this.doDelete(child);
                saveable.delete();
                continue;
            }
            if (!(child instanceof SaveableChild)) continue;
            saveable = (SaveableChild)child.getUserObject();
            this.doDelete(child);
            saveable.deleteChild();
        }
        if (node.getUserObject() instanceof Saveable) {
            ((Saveable)node.getUserObject()).delete();
        } else if (node.getUserObject() instanceof SaveableChild) {
            ((SaveableChild)node.getUserObject()).deleteChild();
        }
    }

    protected void setSplitDividerLocation(int newSplitDividerLocation) {
        this.splitDividerLocation = newSplitDividerLocation;
    }

    private int getSplitDividerLocation() {
        return this.splitDividerLocation;
    }

    protected abstract List<T> getChildren(T var1);

    protected void addChildren(DefaultMutableTreeNode node, List<T> children) {
        for (T child : children) {
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
            this.addChildren(childNode, this.getChildren(child));
            node.add(childNode);
        }
    }

    protected abstract void doSave(DefaultMutableTreeNode var1);

    @Override
    public void doSaveAction() {
        Set deleted = this.getDeletedNodes();
        for (DefaultMutableTreeNode node : deleted) {
            this.doDelete(node);
        }
        this.doSave(this.rootNode);
        this.setChanged(false);
    }

    @Override
    public void doCancelAction() {
        this.treeModel.setRoot(this.getRootNode());
        this.setChanged(false);
    }

    class TreeEditorModelListener
    implements TreeModelListener {
        TreeEditorModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            AbstractTreeEditorState.this.setChanged();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            AbstractTreeEditorState.this.setChanged();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            AbstractTreeEditorState.this.setChanged();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            AbstractTreeEditorState.this.setChanged();
        }
    }

    protected class CancelAction
    extends BasicAction {
        public CancelAction() {
            super("Cancel", (Icon)IconLoader.get((String)"/ordermate/images/button_cancel.png"), "Cancel");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            AbstractTreeEditorState.this.treeModel.setRoot(AbstractTreeEditorState.this.getRootNode());
            AbstractTreeEditorState.this.setChanged(false);
        }
    }
}

