/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens;

import au.com.ordermate.application.ApplicationFrame;
import au.com.ordermate.application.ApplicationStateBlueprint;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.guicore.task.GUIStateI;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import officemate.adminkit.state.ApplicationPanel;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.state.CompositeGuiState;
import officemate.adminkit.state.login.LoginState;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public abstract class DefaultApplicationFrame
implements ApplicationFrame {
    private final JLabel statusBar;
    private final JFrame applicationFrame;
    protected ApplicationPanel panel;
    private ApplicationStateBlueprint currentState;
    public final Signal<ApplicationStateBlueprint, ?, ?, ?, ?> stateSelected = Signals.createSignal(ApplicationStateBlueprint.class, (String)"state");
    public static final Signal exit = Signals.createSignal();
    public static final Signal logout = Signals.createSignal();

    public DefaultApplicationFrame() {
        this.applicationFrame = new JFrame();
        this.applicationFrame.setMinimumSize(new Dimension(800, 600));
        this.statusBar = new JLabel("Done.");
        this.setupMenuBar();
    }

    protected abstract void setupMenuBar();

    public void gotUserChanged() {
        this.panel.updateForNewUser();
    }

    protected boolean isStateFullScreen(ApplicationStateBlueprint state) {
        return state.getStateClazz().equals(LoginState.class);
    }

    public void refreshFavourites() {
        if (this.panel != null) {
            this.panel.refreshFavourites();
        }
    }

    public void setState(ApplicationStateBlueprint newState) {
        GUIStateI newGui;
        if (newState == null) {
            newState = GuiApp.getAppComplex().getApplicationStructure().getArchitecture().getBlueprint("Logout");
        }
        if ((newGui = GuiApp.getAppComplex().getApplicationStructure().getState(newState.getKey())) == null) {
            throw new IllegalStateException("DefaultApplicationFrame cannot be set a GuiState of null!");
        }
        if (!newState.equals(this.currentState)) {
            GUIStateI currentGui;
            if (this.currentState != null && (currentGui = GuiApp.getAppComplex().getApplicationStructure().getState(this.currentState.getKey())) != null) {
                currentGui.endState();
            }
            this.currentState = newState;
            newGui.startState();
            this.panel.showSelectedState(this.currentState, this.isStateFullScreen(this.currentState));
        } else if (newGui instanceof CompositeGuiState) {
            BasicOfficeMateState tabbedState = ((CompositeGuiState)newGui).getSelectedTabState();
            if (tabbedState != null) {
                tabbedState.startState();
            }
            this.panel.showSelectedState(this.currentState, this.isStateFullScreen(this.currentState));
        }
        this.stateSelected.emit((Object)this.currentState);
    }

    public JFrame getFrame() {
        return this.applicationFrame;
    }

    public JMenuBar getMenuBar() {
        return this.getFrame().getJMenuBar();
    }

    public void resetStatusBarText() {
        this.setStatusBarText("Logged in as " + GuiApp.getAppComplex().getApplicationSecurity().getUser());
    }

    public void setStatusBarText(String txt) {
        this.setStatusBarText(txt, Color.black);
    }

    public void setStatusBarText(String txt, Color color) {
        this.statusBar.setForeground(color);
        this.statusBar.setText(txt);
    }

    public JLabel getStatusBar() {
        return this.statusBar;
    }

    public ApplicationStateBlueprint getState() {
        return this.currentState;
    }

    public void setApplicationPanel(ApplicationPanel applicationPanel) {
        this.panel = applicationPanel;
        this.panel.stateSelected.connect((Object)this, "navigateTo");
        this.getFrame().getContentPane().add(this.panel);
    }

    public void navigateTo(ApplicationStateBlueprint bp) {
        GuiApp.getAppComplex().getApplicationNavigator().navigateTo(bp.getKey());
    }

    public Signal<ApplicationStateBlueprint, ?, ?, ?, ?> getStateSelectedSignal() {
        return this.stateSelected;
    }
}

