/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens;

import au.com.ordermate.application.ApplicationContext;
import au.com.ordermate.application.ApplicationFrame;
import au.com.ordermate.application.ApplicationNavigator;
import au.com.ordermate.application.ApplicationSecurity;
import au.com.ordermate.application.ApplicationStateBlueprint;
import au.com.ordermate.application.ApplicationStructure;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.configuration.Config;
import au.com.ordermate.gui.TextSelector;
import au.com.ordermate.guicore.task.GUIStateI;
import au.com.ordermate.persistence.cache.CacheManager;
import au.com.ordermate.persistence.cache.remote.InvalidateableRemoteCache;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import officemate.adminkit.AbstractApplicationComplex;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.EditFieldDialog;
import officemate.adminkit.search.SearchDialog;
import officemate.adminkit.search.SearchPanel;
import officemate.adminkit.state.ApplicationPanel;
import officemate.adminkit.state.FavoritesManager;
import officemate.adminkit.state.statebuilder.ApplicationStateBuilderListener;
import officemate.adminkit.state.statebuilder.DefaultApplicationNavigator;
import officemate.adminkit.state.statebuilder.OfficeMateArchitect;
import officemate.adminkit.state.statebuilder.OfficeMateStateBuilder;
import officemate.screens.DefaultApplicationFrame;
import officemate.screens.DefaultApplicationSecurity;
import officemate.screens.OfficeMateContext;
import officemate.screens.OfficeMateFrame;
import officemate.screens.favorites.FavoritesState;
import officemate.screens.integration.OfficeMateOnlineOrdersGuiUtils;
import ordermate.OrderMate;
import ordermate.database.DBConnectionInterface;
import ordermate.dbconnection.AbstractDatabaseConnection;
import ordermate.gui.modify.security.PosUserSecurityManager;
import ordermate.gui.modify.security.UserSecurityManager;
import ordermate.integration.onlinesales.OnlineOrderIntegrator;
import ordermate.serverconnection.ServerConnectionManager;

public class OfficeMateComplex
extends AbstractApplicationComplex
implements ApplicationStateBuilderListener {
    private OfficeMateArchitect architect;
    private OfficeMateStateBuilder bobTheBuilder;
    private ObjectManager manager;

    public void init(DBConnectionInterface control, ObjectManager manager) {
        this.manager = manager;
        this.init(control);
    }

    @Override
    public void init(DBConnectionInterface control) {
        super.init(control);
        ((DefaultApplicationSecurity)this.getApplicationSecurity()).setNavigator(this.getApplicationNavigator());
        ((DefaultApplicationSecurity)this.getApplicationSecurity()).userChanged.connect((Object)this.getApplicationFrame(), "gotUserChanged");
        this.getApplicationNavigator().getNavigationSignal().connect((Object)this.getApplicationFrame(), "setState");
        FavoritesManager.getInstance().setupFavourites((FavoritesState)this.getApplicationStructure().getState("Favourites"));
        ((DefaultApplicationSecurity)this.getApplicationSecurity()).userChanged.connect((Object)FavoritesManager.getInstance(), "updateFavourites");
        this.setupFrame(this.getApplicationFrame());
    }

    @Override
    protected ApplicationStructure createStructure() {
        this.architect = new OfficeMateArchitect();
        this.bobTheBuilder = new OfficeMateStateBuilder(this.architect.getBlueprintArchitecture());
        this.bobTheBuilder.addListener(this);
        return this.bobTheBuilder.buildStructure();
    }

    @Override
    protected ApplicationFrame createFrame() {
        return new OfficeMateFrame();
    }

    @Override
    protected ApplicationNavigator createNavigator() {
        return new DefaultApplicationNavigator(this.getApplicationStructure());
    }

    @Override
    protected ApplicationSecurity createSecurity() {
        DefaultApplicationFrame cfr_ignored_0 = (DefaultApplicationFrame)this.getApplicationFrame();
        DefaultApplicationFrame cfr_ignored_1 = (DefaultApplicationFrame)this.getApplicationFrame();
        return new DefaultApplicationSecurity(DefaultApplicationFrame.exit, DefaultApplicationFrame.logout){

            @Override
            public void doClose() {
                OfficeMateComplex.this.warnForHHMenuImportIfNeeded();
                if (ServerConnectionManager.isConnected()) {
                    // empty if block
                }
                AbstractDatabaseConnection.closeAllConnectionsOnExit();
                try {
                    CacheManager.getRemoteCacheSubscribeService().unsubscribe(InvalidateableRemoteCache.RMI_OBJ_NAME, InetAddress.getLocalHost(), 11102);
                    OrderMate.LOG.info("Application closing.");
                }
                catch (Exception ex) {
                    OrderMate.LOG.warn("Unable to unsubscribe remote cache on exit.", (Throwable)ex);
                }
                ApplicationStateBlueprint bp = GuiApp.getAppComplex().getApplicationFrame().getState();
                if (bp != null) {
                    GUIStateI state = GuiApp.getAppComplex().getApplicationStructure().getState(bp.getKey());
                    try {
                        state.endState();
                    }
                    catch (Exception ex) {
                        OrderMate.LOG.error("Cannot close state, terminating", (Throwable)ex);
                    }
                }
            }

            @Override
            protected UserSecurityManager createApplicationUserSecurityManager() {
                return new PosUserSecurityManager();
            }
        };
    }

    private void warnForHHMenuImportIfNeeded() {
        if (OnlineOrderIntegrator.getInstance().shouldWarnForHHMenuImport()) {
            OfficeMateOnlineOrdersGuiUtils.warnForOnlineMenuSync();
        }
    }

    @Override
    protected ApplicationContext createContext(DBConnectionInterface control) {
        OfficeMateContext context = new OfficeMateContext();
        context.setDatabaseConnection(control);
        context.setObjectManager(this.manager);
        SearchPanel.setDatabaseControl(control);
        return context;
    }

    protected void setupFrame(final ApplicationFrame appFrame) {
        JFrame frame = appFrame.getFrame();
        DefaultApplicationFrame cfr_ignored_0 = (DefaultApplicationFrame)appFrame;
        DefaultApplicationFrame cfr_ignored_1 = (DefaultApplicationFrame)appFrame;
        ((DefaultApplicationFrame)appFrame).setApplicationPanel(new ApplicationPanel(this.architect.getBlueprintArchitecture(), DefaultApplicationFrame.logout, DefaultApplicationFrame.exit));
        frame.setTitle("Officemate " + OrderMate.VERSION + " - " + appFrame.getBusinessLocation());
        Dialogs.setup(frame);
        EditFieldDialog.setParentFrame(frame);
        SearchDialog.setParentFrame(frame);
        ArrayList<Image> icons = new ArrayList<Image>();
        icons.add(IconLoader.get((String)"/ordermate/images/officemate_icon_16.png").getImage());
        icons.add(IconLoader.get((String)"/ordermate/images/officemate_icon_24.png").getImage());
        icons.add(IconLoader.get((String)"/ordermate/images/officemate_icon_32.png").getImage());
        icons.add(IconLoader.get((String)"/ordermate/images/officemate_icon_48.png").getImage());
        icons.add(IconLoader.get((String)"/ordermate/images/officemate_icon_256.png").getImage());
        frame.setIconImages(icons);
        frame.setDefaultCloseOperation(3);
        TextSelector.install();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                ((DefaultApplicationSecurity)OfficeMateComplex.this.getApplicationSecurity()).doClose();
            }
        });
        if (!Config.isDebuging()) {
            frame.setExtendedState(6);
        } else {
            frame.setSize(1024, 768);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                appFrame.setState((ApplicationStateBlueprint)OfficeMateComplex.this.architect.getBlueprintArchitecture().getBlueprint("Logout"));
            }
        });
        frame.setVisible(true);
    }

    public void createStateIfNeeded(String stateKey) {
        this.bobTheBuilder.rebuildStructure(stateKey);
    }

    @Override
    public void fireBuildFinished(String rootKey) {
    }
}

