/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens;

import au.com.ordermate.guicore.task.GUIStateI;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import officemate.adminkit.state.ApplicationPanel;
import officemate.adminkit.tree.SecurityMenuItem;
import officemate.screens.DefaultApplicationFrame;
import officemate.screens.OfficeMateMenuBarConfiguration;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class OfficeMateMenuBar {
    private final Signal exit;
    private final Signal logout;
    GUIStateI state;
    private OfficeMateMenuBarConfiguration menuBarConfiguration;
    public final Signal helpAbout = Signals.createSignal();
    public final Signal helpKnowledgeBase = Signals.createSignal();
    public final Signal exportCustomerAccounts = Signals.createSignal();
    public final Signal exportInvoices = Signals.createSignal();
    public final Signal exportAllCustomers = Signals.createSignal();
    public final Signal exportSettings = Signals.createSignal();
    public final Signal exportAccountSetup = Signals.createSignal();
    public final Signal exportReconciliations = Signals.createSignal();
    public final Signal exportSalesAndFinanceData = Signals.createSignal();
    private JMenuItem loggedInUser;

    public OfficeMateMenuBar(DefaultApplicationFrame frame, Signal logoutSignal, Signal exitSignal) {
        this.logout = logoutSignal;
        this.exit = exitSignal;
        frame.getFrame().setJMenuBar(this.createJMenuBar());
    }

    public void setMenuBarConfiguration(OfficeMateMenuBarConfiguration helper) {
        this.menuBarConfiguration = helper;
        this.menuBarConfiguration.configureMenuBar(this);
    }

    public JMenuBar createJMenuBar() {
        JMenuBar theMenuBar = new JMenuBar();
        this.loggedInUser = new JMenuItem("Not logged in");
        JMenu fileMenu = new JMenu("File");
        JMenu helpMenu = new JMenu("Help");
        JMenuItem logOutButton = new JMenuItem((Action)((Object)new ApplicationPanel.LogoutAction(this.logout)));
        SecurityMenuItem exportCustomerAccountsButton = new SecurityMenuItem((Object)"Customer Accounts...", AllPermissions.EXPORT_CUSTOMERS);
        exportCustomerAccountsButton.setAction(new AbstractAction("Customer accounts..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                OfficeMateMenuBar.this.exportCustomerAccounts.emit();
            }
        });
        SecurityMenuItem exportInvoicesButton = new SecurityMenuItem((Object)"Invoices...", AllPermissions.EXPORT_INVOICES);
        exportInvoicesButton.setAction(new AbstractAction("Invoices..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                OfficeMateMenuBar.this.exportInvoices.emit();
            }
        });
        SecurityMenuItem exportAllCustomersButton = new SecurityMenuItem((Object)"All Customers...", AllPermissions.EXPORT_ALL_CUSTOMERS);
        exportAllCustomersButton.setAction(new AbstractAction("All Customers..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                OfficeMateMenuBar.this.exportAllCustomers.emit();
            }
        });
        SecurityMenuItem exportSettingsButton = new SecurityMenuItem((Object)"Settings...", AllPermissions.EXPORT_SETTINGS);
        exportSettingsButton.setAction(new AbstractAction("Settings..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                OfficeMateMenuBar.this.exportSettings.emit();
            }
        });
        SecurityMenuItem exportAccountSetupButton = new SecurityMenuItem((Object)"Account Setup...", AllPermissions.EXPORT_SETTINGS);
        exportAccountSetupButton.setAction(new AbstractAction("Account Setup..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                OfficeMateMenuBar.this.exportAccountSetup.emit();
            }
        });
        SecurityMenuItem exportSalesAndTakingsButton = new SecurityMenuItem((Object)"Sales and Takings... ", AllPermissions.EXPORT_RECONCILIATIONS);
        exportSalesAndTakingsButton.setAction(new AbstractAction("Sales and Takings..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                OfficeMateMenuBar.this.exportSalesAndFinanceData.emit();
            }
        });
        JMenuItem exitButton = new JMenuItem((Action)((Object)new ApplicationPanel.ExitAction(this.exit)));
        JMenuItem aboutButton = new JMenuItem(new AbstractAction("About"){

            @Override
            public void actionPerformed(ActionEvent e) {
                OfficeMateMenuBar.this.helpAbout.emit();
            }
        });
        JMenuItem knowledgeBaseButton = new JMenuItem(new AbstractAction("Knowledge Base"){

            @Override
            public void actionPerformed(ActionEvent e) {
                OfficeMateMenuBar.this.helpKnowledgeBase.emit();
            }
        });
        if (!PersistentLicenseManager.getInstance().getBoolean(LicenseType.MYOBIntegrationEnabled)) {
            ((JMenuItem)exportCustomerAccountsButton).setEnabled(false);
            ((JMenuItem)exportInvoicesButton).setEnabled(false);
            ((JMenuItem)exportAllCustomersButton).setEnabled(false);
            ((JMenuItem)exportSalesAndTakingsButton).setEnabled(false);
        }
        fileMenu.add(logOutButton);
        fileMenu.addSeparator();
        fileMenu.add(exitButton);
        theMenuBar.add(fileMenu);
        helpMenu.add(this.loggedInUser);
        helpMenu.add(aboutButton);
        helpMenu.add(knowledgeBaseButton);
        theMenuBar.add(Box.createHorizontalGlue());
        theMenuBar.add(helpMenu);
        return theMenuBar;
    }

    public void setUser(User user) {
        this.loggedInUser.setText(user == null ? "Not Logged In" : "Logged in as " + user.getName());
    }
}

