/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.customers;

import au.com.ordermate.gui.ObjectEditor;
import ca.odell.glazedlists.EventList;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import officemate.components.AbstractObjectEditor;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import ordermate.database.misc.HOConfig;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.Permission;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.NotEmptyValidator;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Validator;

public class CustomerCategoryState
extends AbstractEditableTableState<CustomerCategory> {
    public CustomerCategoryState(Permission permission) {
        super("Customer Category", permission, "View, edit and delete customer categories");
    }

    public CustomerCategoryState() {
        super("Customer Category", AllPermissions.CUSTOMER_ADMIN, "View, edit and delete customer categories");
    }

    protected boolean isModificationAllowed() {
        return !HOConfig.getInstance().isEnabled() || HOConfig.getInstance().isEnabled() && !HOConfig.getInstance().isMultisiteCustomers();
    }

    @Override
    protected ObjectEditor createObjectEditor() {
        if (!this.isModificationAllowed()) {
            return null;
        }
        AbstractObjectEditor editor = new AbstractObjectEditor(){

            @Override
            protected void init() {
                FieldPanelBuilder builder = new FieldPanelBuilder();
                Binding labelBinding = this.addBoundRow(builder, "Name", new JTextField(20), CustomerCategory.Properties.LABEL, "text");
                labelBinding.setValidator((Validator)new NotEmptyValidator());
                JCheckBox loyaltyEnabled = this.setupCheckBox(CustomerCategory.Properties.LOYALTY_POINTS_ENABLED);
                builder.addRow("Loyalty Points Enabled", (Component)loyaltyEnabled);
                this.add(builder.getPanel());
            }
        };
        return editor;
    }

    @Override
    public String getTypeName() {
        return "Customer Category";
    }

    @Override
    protected TableStateCentralArea createCentralArea() {
        return new PersistentObjectTable<CustomerCategory>(this.getObjectList(), new CustomerCategoryColumnFormat(!this.isModificationAllowed()));
    }

    @Override
    public EventList<CustomerCategory> getObjectList() {
        this.setFilterActive(true);
        return super.getObjectList();
    }

    @Override
    protected Class<CustomerCategory> getDisplayingType() {
        return CustomerCategory.class;
    }

    @Override
    public void gotObjectEdited(CustomerCategory editedObject) {
        super.gotObjectEdited(editedObject);
        this.refresh();
    }

    @Override
    public boolean canCreateOrDelete() {
        return this.isModificationAllowed();
    }

    private static class CustomerCategoryColumnFormat
    extends ColumnTableFormat {
        CustomerCategoryColumnFormat(boolean readOnly) {
            if (!readOnly) {
                this.addColumn(new EditablePropertyColumnFormat(CustomerCategory.Properties.LABEL));
                this.addColumn(new EditablePropertyColumnFormat(CustomerCategory.Properties.IS_DEFAULT));
                this.addColumn(new EditablePropertyColumnFormat(CustomerCategory.Properties.LOYALTY_POINTS_ENABLED));
            } else {
                this.addColumn((ColumnFormat)new PropertyColumnFormat(CustomerCategory.Properties.LABEL));
                this.addColumn((ColumnFormat)new PropertyColumnFormat(CustomerCategory.Properties.IS_DEFAULT));
                this.addColumn((ColumnFormat)new PropertyColumnFormat(CustomerCategory.Properties.LOYALTY_POINTS_ENABLED));
            }
        }
    }
}

