/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.customers;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.util.Price;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import officemate.adminkit.dialogs.OfficeMateGuiHandler;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.components.AbstractObjectEditor;
import officemate.components.table.ResolvingColumnFormat;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.PopupEditableColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import officemate.screens.customers.stats.AverageSpendResolver;
import officemate.screens.customers.stats.FirstOrderResolver;
import officemate.screens.customers.stats.HighestGrossingItemResolver;
import officemate.screens.customers.stats.HighestGrossingSectionResolver;
import officemate.screens.customers.stats.LastOrderResolver;
import officemate.screens.customers.stats.MostOrderedItemResolver;
import officemate.screens.customers.stats.MostOrderedSectionResolver;
import officemate.screens.customers.stats.OrderFrequencyResolver;
import officemate.screens.customers.stats.TotalOrderResolver;
import officemate.screens.customers.stats.TotalSpendingResolver;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCardHelper;
import ordermate.database.sales.CustomerSearch;
import ordermate.database.sales.Gender;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.BindingHelper;
import ordermate.gui.binding.validators.PhoneNumberValidator;
import ordermate.gui.binding.validators.PositiveIntValidator;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Validator;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DatePickerCellEditor;

public class CustomerColumnTableFormat
extends ColumnTableFormat {
    private CustomerCardHelper cardHelper;
    private BindingHelper helper = new BindingHelper();
    private int CARD_COL = 0;

    protected CustomerColumnTableFormat(EventList customerCategories, BasicOfficeMateState parentState) {
        AddressEditor addressEditor = new AddressEditor();
        this.addColumn(new EditablePropertyColumnFormat(Customer.Properties.FIRST_NAME));
        this.addColumn(new EditablePropertyColumnFormat(Customer.Properties.LAST_NAME));
        JTextField field = new JTextField();
        JXTable.GenericEditor editor = new JXTable.GenericEditor(field);
        Binding binding = this.helper.createBinding(Customer.Properties.PRIMARY_PHONE_NUMBER, (Object)field, "text");
        binding.setValidator((Validator)new PhoneNumberValidator());
        this.addColumn(new EditablePropertyColumnFormat("Primary Phone", Customer.Properties.PRIMARY_PHONE_NUMBER).setCustomEditor((TableCellEditor)editor));
        this.addColumn(new EditablePropertyColumnFormat("Secondary Phone", Customer.Properties.SECONDARY_PHONE_NUMBER));
        this.addColumn(new PopupEditableColumnFormat(Customer.Properties.ROOM_APT_NUMBER, addressEditor, parentState));
        this.addColumn(new PopupEditableColumnFormat(Customer.Properties.HOUSE_NUMBER, addressEditor, parentState));
        this.addColumn(new PopupEditableColumnFormat(Customer.Properties.STREET_NAME, addressEditor, parentState));
        this.addColumn(new PopupEditableColumnFormat(Customer.Properties.STREET_TYPE, addressEditor, parentState));
        this.addColumn(new PopupEditableColumnFormat(Customer.Properties.SUBURB, addressEditor, parentState));
        this.addColumn(new PopupEditableColumnFormat(Customer.Properties.STATE, addressEditor, parentState));
        this.addColumn(new PopupEditableColumnFormat(Customer.Properties.POSTCODE, addressEditor, parentState));
        this.addColumn(new PopupEditableColumnFormat((PropertiedObject.Property)Customer.Properties.ADDRESS, addressEditor, parentState));
        this.addColumn(new EditablePropertyColumnFormat(Customer.Properties.CATEGORY).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(customerCategories))));
        this.addColumn((ColumnFormat)new PropertyColumnFormat(Customer.Properties.LOYALTY_POINTS));
        this.addColumn(new EditablePropertyColumnFormat(Customer.Properties.E_MAIL));
        this.addColumn(new EditablePropertyColumnFormat("<HTML>Receive<BR>Marketing</HTML>", Customer.Properties.RECEIVE_MARKETING));
        this.addColumn(new EditablePropertyColumnFormat(Customer.Properties.CARD_ID));
        this.CARD_COL = this.getColumnCount() - 1;
        this.addColumn(new EditablePropertyColumnFormat(Customer.Properties.OCCUPATION));
        this.addColumn(new EditablePropertyColumnFormat(Customer.Properties.GENDER).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(GlazedLists.eventListOf((Object[])Gender.values()), true))));
        this.addColumn(new EditablePropertyColumnFormat(Customer.Properties.COMPANY));
        this.addColumn(new EditablePropertyColumnFormat(Customer.Properties.COMMENTS));
        this.addColumn(new EditablePropertyColumnFormat("D.O.B.", (PropertyAccessor)Customer.Properties.DOB, new SimpleDateFormat("dd/MM/yyyy")).setCustomEditor((TableCellEditor)new DatePickerCellEditor((DateFormat)new SimpleDateFormat("dd/MM/yyyy"))));
        this.addColumn(new EditablePropertyColumnFormat("Anniversary", (PropertyAccessor)Customer.Properties.ANNIVERSARY, new SimpleDateFormat("dd/MM/yyyy")).setCustomEditor((TableCellEditor)new DatePickerCellEditor((DateFormat)new SimpleDateFormat("dd/MM/yyyy"))));
        this.addColumn((ColumnFormat)new PropertyColumnFormat("Creation Date", (PropertyAccessor)Customer.Properties.CREATION_TIME, (Format)new SimpleDateFormat("dd/MM/yyyy hh:mm:ss")));
        this.addColumn((ColumnFormat)new ResolvingColumnFormat("Total Orders", Integer.class, new TotalOrderResolver()));
        this.addColumn((ColumnFormat)new ResolvingColumnFormat("Total Spending", Price.class, new TotalSpendingResolver()));
        this.addColumn((ColumnFormat)new ResolvingColumnFormat("Average Spend", Price.class, new AverageSpendResolver()));
        this.addColumn((ColumnFormat)new ResolvingColumnFormat("Order Frequency", String.class, new OrderFrequencyResolver()));
        this.addColumn((ColumnFormat)new ResolvingColumnFormat("First Order", Date.class, new FirstOrderResolver()));
        this.addColumn((ColumnFormat)new ResolvingColumnFormat("Last Order", Date.class, new LastOrderResolver()));
        this.addColumn((ColumnFormat)new ResolvingColumnFormat("Most Ordered Item", String.class, new MostOrderedItemResolver()));
        this.addColumn((ColumnFormat)new ResolvingColumnFormat("Most Ordered Section", String.class, new MostOrderedSectionResolver()));
        this.addColumn((ColumnFormat)new ResolvingColumnFormat("Highest Grossing Item", String.class, new HighestGrossingItemResolver()));
        this.addColumn((ColumnFormat)new ResolvingColumnFormat("Highest Grossing Section", String.class, new HighestGrossingSectionResolver()));
    }

    @Override
    public Object setColumnValue(Object baseObject, Object editedValue, int column) {
        this.helper.setObject(baseObject);
        if (column == this.CARD_COL && editedValue != null) {
            if (this.cardHelper == null) {
                this.cardHelper = new CustomerCardHelper((GuiHandler)new OfficeMateGuiHandler());
            }
            editedValue = this.cardHelper.replaceCardMarker(String.valueOf(editedValue));
        }
        return super.setColumnValue(baseObject, editedValue, column);
    }

    private static class AddressEditor
    extends AbstractObjectEditor {
        public AddressEditor() {
            int WIDTH = 50;
            FieldPanelBuilder builder = new FieldPanelBuilder();
            JTextField appUnitNo = new JTextField(50);
            appUnitNo.setName("AppUnitNo");
            this.addBoundRow(builder, "Room Apt Number", appUnitNo, Customer.Properties.ROOM_APT_NUMBER, "text");
            this.addBoundRow(builder, "House Number", new JTextField(50), Customer.Properties.HOUSE_NUMBER, "text");
            this.addBoundRow(builder, "Street Name", new JTextField(50), Customer.Properties.STREET_NAME, "text");
            EventList streetTypes = GlazedLists.eventList((Collection)CustomerSearch.makeStreetTypeList());
            JComboBox streetTypesBox = new JComboBox(new EventComboBoxModel(streetTypes));
            AutoCompleteSupport.install(streetTypesBox, (EventList)streetTypes);
            this.addBoundRow(builder, "Street Type", streetTypesBox, Customer.Properties.STREET_TYPE, "selectedItem");
            this.addBoundRow(builder, "Suburb", new JTextField(50), Customer.Properties.SUBURB, "text");
            EventList states = GlazedLists.eventList(Arrays.asList(CustomerSearch.getStates()));
            JComboBox statesBox = new JComboBox(new EventComboBoxModel(states));
            AutoCompleteSupport.install(statesBox, (EventList)states);
            this.addBoundRow(builder, "State", statesBox, Customer.Properties.STATE, "selectedItem");
            Binding postCodeBinding = this.addBoundRow(builder, "Post Code", new JTextField(50), Customer.Properties.POSTCODE, "text");
            postCodeBinding.setValidator((Validator)new PositiveIntValidator(false, true));
            this.add(builder.getPanel());
        }
    }
}

