/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.customers.external;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.DateTimeUtils;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.OkCancelDialogBuilder;
import officemate.screens.customers.external.CustomerFieldMapper;
import officemate.screens.customers.external.ImportedCustomerPanel;
import ordermate.OrderMate;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCategory;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;

public class ImportMapCustomerPanel
extends JPanel {
    private EventList<String[]> customerData;
    private CustomerMappingTableModel mappingTable;
    private JTable customerMapTable;
    private EventList<MapColumnDisplayer> colsToMapOn;
    private Map<PropertiedObject.Property, MapColumnDisplayer> columnMapping;
    private JCheckBox headerFieldOnCsv;
    private JButton previewButton;
    private JButton automapButton;
    private ComboBoxModel colEditorModel;
    private final Map<String, CustomerCategory> categoryMap;
    private static final PropertiedObject.Property[] customerFieldNames = new PropertiedObject.Property[]{Customer.Properties.TITLE, Customer.Properties.FIRST_NAME, Customer.Properties.LAST_NAME, Customer.Properties.PRIMARY_PHONE_NUMBER, Customer.Properties.SECONDARY_PHONE_NUMBER, Customer.Properties.E_MAIL, Customer.Properties.DOB, Customer.Properties.ANNIVERSARY, Customer.Properties.COMPANY, Customer.Properties.OCCUPATION, Customer.Properties.ROOM_APT_NUMBER, Customer.Properties.HOUSE_NUMBER, Customer.Properties.STREET_NAME, Customer.Properties.STREET_TYPE, Customer.Properties.SUBURB, Customer.Properties.STATE, Customer.Properties.POSTCODE, Customer.Properties.STREET_DIR_REF, Customer.Properties.CATEGORY, Customer.Properties.CARD_ID, Customer.Properties.COMMENTS, Customer.Properties.GENDER, Customer.Properties.LOYALTY_POINTS};

    public ImportMapCustomerPanel(List<String[]> customerData) {
        super(new BorderLayout());
        this.customerData = GlazedLists.eventList(customerData);
        ArrayList<MapColumnDisplayer> columns = new ArrayList<MapColumnDisplayer>();
        columns.add(new MapColumnDisplayer(null, ""));
        for (int i = 0; i < customerData.get(0).length; ++i) {
            columns.add(new MapColumnDisplayer(i, customerData.get(0)[i]));
        }
        this.colsToMapOn = GlazedLists.eventList(columns);
        this.categoryMap = new HashMap<String, CustomerCategory>();
        for (CustomerCategory category : CustomerCategory.getAllCategories()) {
            this.categoryMap.put(category.getLabel(), category);
        }
        this.columnMapping = new LinkedHashMap<PropertiedObject.Property, MapColumnDisplayer>();
        this.createMappingTable();
    }

    private void createMappingTable() {
        this.mappingTable = new CustomerMappingTableModel();
        this.customerMapTable = new JTable(this.mappingTable);
        TableColumn colPickerColumn = this.customerMapTable.getColumnModel().getColumn(1);
        this.colEditorModel = new EventComboBoxModel(this.colsToMapOn);
        JComboBox tempComboBox = new JComboBox(this.colEditorModel);
        ComboBoxCellEditor tceditor = new ComboBoxCellEditor(tempComboBox);
        colPickerColumn.setCellEditor((TableCellEditor)tceditor);
        JScrollPane scroller = new JScrollPane(this.customerMapTable);
        this.add((Component)scroller, "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        this.headerFieldOnCsv = new JCheckBox("Header Field On csv", false);
        this.headerFieldOnCsv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportMapCustomerPanel.this.customerMapTable.invalidate();
                ImportMapCustomerPanel.this.customerMapTable.repaint();
                ImportMapCustomerPanel.this.automapButton.setEnabled(ImportMapCustomerPanel.this.headerFieldOnCsv.isSelected());
            }
        });
        if (this.customerData.size() == 1) {
            this.headerFieldOnCsv.setEnabled(false);
        }
        this.automapButton = new JButton("Auto Map");
        this.automapButton.setEnabled(this.headerFieldOnCsv.isSelected());
        this.automapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportMapCustomerPanel.this.autoMap();
                ImportMapCustomerPanel.this.customerMapTable.invalidate();
                ImportMapCustomerPanel.this.customerMapTable.repaint();
            }
        });
        this.previewButton = new JButton("Preview...");
        this.previewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ImportMapCustomerPanel.this.doPreviewDialog();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        bottomPanel.add(this.headerFieldOnCsv);
        bottomPanel.add(this.automapButton);
        bottomPanel.add(this.previewButton);
        this.add((Component)bottomPanel, "South");
    }

    private void doPreviewDialog() throws Exception {
        ImportedCustomerPanel panel = new ImportedCustomerPanel(this.buildCustomers(this.customerData));
        OkCancelDialogBuilder dialog = Dialogs.getOkCancelDialogBuilder(panel);
        dialog.hideCancel();
        dialog.setTitle("Confirm Import");
        dialog.setHtmlHeader("Please confirm that the below import is correct. Once you have imported your customer data, this cannot be reversed.");
        dialog.doShow();
    }

    private List<Customer> buildCustomers(EventList<String[]> newCustomers) throws Exception {
        ArrayList<Customer> custList = new ArrayList<Customer>();
        boolean skipHeader = this.isHeaderData();
        boolean firstRun = true;
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
        CustomerFieldMapper mapper = new CustomerFieldMapper(this.getColumnMappings(), this.getColumnNames(), format, this.categoryMap);
        for (String[] fields : newCustomers) {
            if (skipHeader && firstRun) {
                firstRun = false;
                continue;
            }
            Customer newCust = new Customer();
            mapper.setCustomerFieldsToSet(fields);
            mapper.setCustomerFields(newCust);
            custList.add(newCust);
        }
        return custList;
    }

    private void autoMap() {
        int row = 0;
        for (PropertiedObject.Property prop : customerFieldNames) {
            for (MapColumnDisplayer mcd : this.colsToMapOn) {
                if (mcd.getDisplayable() == "" || !prop.getUserVisibleLabel().toLowerCase().contains(mcd.getDisplayable().toLowerCase())) continue;
                this.mappingTable.setValueAt(mcd, row, 1);
            }
            ++row;
        }
    }

    public Map<PropertiedObject.Property, Integer> getColumnMappings() {
        HashMap<PropertiedObject.Property, Integer> toReturn = new HashMap<PropertiedObject.Property, Integer>();
        for (PropertiedObject.Property p : customerFieldNames) {
            Integer myInteger = null;
            if (this.columnMapping.get(p) != null) {
                myInteger = this.columnMapping.get(p).getIndex();
            }
            toReturn.put(p, myInteger);
        }
        return toReturn;
    }

    public PropertiedObject.Property[] getColumnNames() {
        return customerFieldNames;
    }

    public boolean isHeaderData() {
        if (this.headerFieldOnCsv != null) {
            return this.headerFieldOnCsv.isSelected();
        }
        return false;
    }

    public List<Customer> getCustomerList() throws Exception {
        return this.buildCustomers(this.customerData);
    }

    public class MapColumnDisplayer {
        private Integer index;
        private String description;

        public MapColumnDisplayer(Integer i, String desc) {
            this.index = i;
            this.description = desc;
        }

        public Integer getIndex() {
            return this.index;
        }

        public String getDisplayable() {
            if (ImportMapCustomerPanel.this.isHeaderData()) {
                return this.description;
            }
            if (this.index != null) {
                return "" + (this.index + 1);
            }
            return "";
        }

        public String toString() {
            return this.getDisplayable();
        }

        public boolean equals(Object obj) {
            if (obj instanceof String) {
                return this.toString().equals(obj.toString());
            }
            return super.equals(obj);
        }
    }

    class CustomerMappingTableModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            return customerFieldNames.length;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                if (Date.class.isAssignableFrom(customerFieldNames[rowIndex].getType())) {
                    return customerFieldNames[rowIndex].getUserVisibleLabel() + " (DD/MM/YYYY)";
                }
                return customerFieldNames[rowIndex].getUserVisibleLabel();
            }
            if (columnIndex == 1) {
                if (ImportMapCustomerPanel.this.columnMapping.get(customerFieldNames[rowIndex]) != null) {
                    return ((MapColumnDisplayer)ImportMapCustomerPanel.this.columnMapping.get(customerFieldNames[rowIndex])).getDisplayable();
                }
                return null;
            }
            if (ImportMapCustomerPanel.this.columnMapping.get(customerFieldNames[rowIndex]) != null) {
                Integer mappedInt = ((MapColumnDisplayer)ImportMapCustomerPanel.this.columnMapping.get(customerFieldNames[rowIndex])).getIndex();
                if (mappedInt != null) {
                    if (ImportMapCustomerPanel.this.isHeaderData()) {
                        return ((String[])ImportMapCustomerPanel.this.customerData.get(1))[mappedInt];
                    }
                    return ((String[])ImportMapCustomerPanel.this.customerData.get(0))[mappedInt];
                }
                return "";
            }
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            MapColumnDisplayer mcdObj;
            if (columnIndex == 1 && (mcdObj = (MapColumnDisplayer)aValue) != null) {
                if (Date.class.isAssignableFrom(customerFieldNames[rowIndex].getType()) && mcdObj.getIndex() != null) {
                    try {
                        String dateToParse = ((String[])ImportMapCustomerPanel.this.customerData.get(1))[mcdObj.getIndex()];
                        if (ImportMapCustomerPanel.this.isHeaderData() && !dateToParse.equals("")) {
                            DateTimeUtils.getMediumDateFormat().parse(dateToParse);
                        } else if (!ImportMapCustomerPanel.this.isHeaderData() && !dateToParse.equals("")) {
                            DateTimeUtils.getMediumDateFormat().parse(dateToParse);
                        }
                    }
                    catch (ParseException e) {
                        OrderMate.LOG.warn("Invalid date format given to Customer importer table " + e);
                        return;
                    }
                }
                ImportMapCustomerPanel.this.columnMapping.put(customerFieldNames[rowIndex], mcdObj);
            }
            super.setValueAt(aValue, rowIndex, columnIndex);
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Property";
            }
            if (column == 1) {
                return "Column";
            }
            return "Example";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                return true;
            }
            return super.isCellEditable(rowIndex, columnIndex);
        }
    }
}

