/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.dailytasks;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.SingleValueQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.TextSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.propertyaccessor.ChainPropertyAccessor;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.search.searchfield.java.StringSearchField;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.StringUtils;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.Action;
import officemate.OfficeMate;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.PropertyAccessorColumnFormat;
import ordermate.OrderMate;
import ordermate.database.ConcurrentDatabaseModificationException;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.stock.StockControlProperty;
import ordermate.database.stock.StockCount;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class ItemCountState
extends AbstractTableState<InventoryItemUnit> {
    public ItemCountState() {
        super("Item Count", AllPermissions.USE_STOCK_CONTROL, "View currenty set item counts");
        this.addAction((Action)new BasicAction("Reset All Countdowns"){

            public void actionPerformed(ActionEvent e) {
                if (Dialogs.showWarningDialog("Reset All Counts?", "This will remove all Item Countdowns currently in the system.")) {
                    StockControlProperty.getInstance().clearStockCount();
                    ItemCountState.this.refresh();
                }
            }
        });
    }

    @Override
    public OfficeMateObjectSearch<InventoryItemUnit> createSearchPanelFactory() {
        return new InventoryItemUnitSearch();
    }

    @Override
    protected TableStateCentralArea<InventoryItemUnit> createCentralArea() {
        ColumnTableFormat cols = new ColumnTableFormat();
        cols.addColumn((ColumnFormat)new PropertyAccessorColumnFormat("Category", new PropertiedObject.Property[]{InventoryItemUnit.Properties.ITEM, InventoryItem.Properties.CATEGORY, InventoryCategory.Properties.LABEL}, null));
        cols.addColumn((ColumnFormat)new PropertyColumnFormat(InventoryItemUnit.Properties.ITEM));
        cols.addColumn((ColumnFormat)new PropertyColumnFormat(InventoryItemUnit.Properties.SIZE));
        cols.addColumn((ColumnFormat)new PropertyColumnFormat(InventoryItemUnit.Properties.PORTION));
        cols.addColumn(new EditablePropertyColumnFormat("Quantity", (PropertyAccessor)new ChainPropertyAccessor(new PropertyAccessor[]{InventoryItemUnit.Properties.STOCK_COUNT, StockCount.Properties.QUANTITY}), null){

            @Override
            public Object setValue(Object baseObject, Object editedValue) {
                SalesQuantity qty = null;
                try {
                    if (editedValue == null || StringUtils.isEmpty((String)editedValue.toString().trim())) {
                        ((InventoryItemUnit)baseObject).cancelStockCount();
                    } else {
                        qty = new SalesQuantity(String.valueOf(editedValue));
                        ((InventoryItemUnit)baseObject).setStockCountQty(qty, OfficeMate.getInstance().getEventContext());
                    }
                }
                catch (ConcurrentDatabaseModificationException ex) {
                    OrderMate.LOG.error("Cannot modify count", (Throwable)ex);
                }
                catch (NumberFormatException ex) {
                    OrderMate.LOG.error("Cannot moidfy count - bad format", (Throwable)ex);
                }
                return baseObject;
            }
        });
        PersistentObjectTable<InventoryItemUnit> countTable = new PersistentObjectTable<InventoryItemUnit>(this.getObjectList(), cols);
        return countTable;
    }

    @Override
    protected Class<InventoryItemUnit> getDisplayingType() {
        return InventoryItemUnit.class;
    }

    class InventoryItemUnitSearcher
    extends PropertySearcher {
        private SingleValueQuerySearchFilter<InventoryCategory> categoryFilter;
        private TextSearchFilter labelFilter;

        public InventoryItemUnitSearcher() {
            super(InventoryItemUnit.class);
            this.categoryFilter = new ObjectSearchFilter(InventoryItem.Properties.CATEGORY);
            ObjectJoinSearchFilter joiner = new ObjectJoinSearchFilter(new PropertiedObject.Property[]{InventoryItemUnit.Properties.ITEM}, this.categoryFilter);
            this.addSearchFilter((SearchFilterI)joiner);
            this.labelFilter = new TextSearchFilter(InventoryItem.Properties.LABEL, TextSearchFilter.TextSearchStrategy.Like);
            joiner = new ObjectJoinSearchFilter(new PropertiedObject.Property[]{InventoryItemUnit.Properties.ITEM}, (SingleValueQuerySearchFilter)this.labelFilter);
            this.addSearchFilter((SearchFilterI)joiner);
        }

        protected ObjectQuery getBaseQuery() {
            return Query.select(InventoryItemUnit.class).active(InventoryItemUnit.class);
        }
    }

    class InventoryItemUnitSearch
    extends ObjectPropertySearch<InventoryItemUnit> {
        private ComboSearchField categoryField;
        private StringSearchField labelField;

        public InventoryItemUnitSearch() {
            super(InventoryItemUnit.class, new InventoryItemUnitSearcher(), new BasicEventList());
            InventoryItemUnitSearcher searcher = (InventoryItemUnitSearcher)this.getPropertySearcher();
            this.categoryField = new ComboSearchField("Category", (ISingleValueSearchFilter)searcher.categoryFilter, true, ItemCountState.this.getRefreshAction(), GlazedLists.eventList((Collection)InventoryCategory.getAllCategories()));
            this.addSearchField((SearchGuiField)this.categoryField);
            this.labelField = new StringSearchField("Label", (ISingleValueSearchFilter)searcher.labelFilter, ItemCountState.this.getRefreshAction());
            this.addSearchField((SearchGuiField)this.labelField);
        }
    }
}

