/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.dailytasks.accounting;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.Action;
import javax.swing.Icon;
import officemate.OfficeMate;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.OfficeMateGuiHandler;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.screens.dailytasks.accounting.AccountingExportScreen;
import ordermate.database.finance.debtors.group.DebtorGroup;
import ordermate.database.users.AllPermissions;
import ordermate.gui.dialogs.ProgressDialog;
import ordermate.integration.finance.AccountingExportFunction;
import ordermate.integration.finance.AccountingExportManager;
import ordermate.integration.finance.AccountingExportParams;
import ordermate.integration.finance.AccountingExporter;
import ordermate.integration.finance.RetryExportTask;

public class AccountingExportState
extends BasicOfficeMateState {
    private AccountingExportScreen screen;
    private ExportAction exportAction = new ExportAction();
    private RetryAction retryAction = new RetryAction();

    public AccountingExportState() {
        super("Accounting Export", AllPermissions.CONFIG_INTEGRATIONS, "Allows exporting accounting data.");
        this.addAction((Action)((Object)this.exportAction));
        this.addAction((Action)((Object)this.retryAction));
        this.screen = new AccountingExportScreen();
        this.screen.enableExportSignal.connect((Object)this, "enableExportButton");
        this.setScreenPanel(this.screen);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.screen.refresh();
    }

    public void enableExportButton(Boolean enabled) {
        this.exportAction.setEnabled(enabled);
    }

    private boolean checkFile() {
        String path = this.screen.getFileName().trim();
        File file = new File(path);
        if (file.exists()) {
            return Dialogs.showWarningDialog("Overwrite Existing File?", path + " already exists. Do you want to overwrite this file?");
        }
        return true;
    }

    private final class RetryAction
    extends BasicAction {
        public RetryAction() {
            super("Retry", (Icon)IconLoader.get((String)"/ordermate/images/refresh_icon22.png"), "Starts the accounting export process");
        }

        public void actionPerformed(ActionEvent e) {
            RetryExportTask retryExportTask = new RetryExportTask();
            retryExportTask.run();
            AccountingExportState.this.screen.refresh();
        }
    }

    private final class ExportTask
    extends AbstractTask {
        private String result;
        private AccountingExporter exporter;

        public ExportTask(AccountingExporter exporter) {
            this.exporter = exporter;
        }

        public String getName() {
            return "Export Accounting Data";
        }

        protected void performTask() throws Exception {
            AccountingExportParams params = new AccountingExportParams(AccountingExportState.this.screen.getStartDate(), AccountingExportState.this.screen.getEndDate(), AccountingExportState.this.screen.getFileName().trim());
            DebtorGroup selectedGroup = AccountingExportState.this.screen.getSelectedAccountGroup();
            if (selectedGroup != null) {
                params.setForGroup(selectedGroup);
            }
            AccountingExportState.this.screen.setupExportParameters(params);
            if (!this.exporter.getReportFormat().isExportToFile() || AccountingExportState.this.checkFile()) {
                try {
                    if (AccountingExportState.this.screen.getAccountingExportFunction().equals((Object)AccountingExportFunction.CUSTOMER_ACCOUNTS)) {
                        boolean confirmExport = Dialogs.showChoiceDialog("Accounting Export Warning", "WARNING: Exporting will cause Debtor Payments to be applied to any unsettled amounts. This action cannot be reversed. Do you wish to continue?");
                        if (confirmExport) {
                            this.result = this.exporter.export(AccountingExportState.this.screen.getAccountingExportFunction(), params);
                        }
                    } else {
                        this.result = this.exporter.export(AccountingExportState.this.screen.getAccountingExportFunction(), params);
                    }
                }
                catch (Exception ex) {
                    Dialogs.showErrorDialog("Export Failed", ex.getMessage());
                }
            }
        }

        protected int getTotalSubTasks() {
            return 0;
        }

        public String getResult() {
            return this.result;
        }
    }

    private final class ExportAction
    extends BasicAction {
        public ExportAction() {
            super("Export", (Icon)IconLoader.get((String)"/ordermate/images/left_arrow.png"), "Starts the accounting export process");
        }

        public void actionPerformed(ActionEvent e) {
            this.export();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void export() {
            this.setEnabled(false);
            AccountingExporter exporter = AccountingExportManager.getInstance().getAccountingIntegrationExporter((GuiHandler)new OfficeMateGuiHandler(), OfficeMate.getInstance().getEventContext());
            try {
                ExportTask exportTask = new ExportTask(exporter);
                ProgressDialog progressDialog = new ProgressDialog((Frame)OfficeMate.getApplicationFrame(), true, "Export Accounting Data", (Runnable)((Object)exportTask));
                progressDialog.start();
                if (exportTask.getResult() == null) {
                    String msgBody = exporter.getReportFormat().isExportToFile() ? "Successfully exported to \n\"" + AccountingExportState.this.screen.getFileName().trim() + "\"" : "Successfully exported data.";
                    Dialogs.showInfoDialog("Export Complete", msgBody);
                } else {
                    Dialogs.showErrorDialog("Export Failed", "Failed to export data.");
                }
            }
            finally {
                this.setEnabled(true);
            }
        }
    }
}

