/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.debtor.debtors;

import au.com.ordermate.util.Price;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import officemate.OfficeMate;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.components.AbstractObjectEditor;
import officemate.components.search.AbstractSearchDialog;
import officemate.components.search.SingleSearchDialog;
import officemate.components.search.objectsearch.CustomerSearcherGui;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.group.DebtorGroup;
import ordermate.database.finance.debtors.implementation.CustomerDebtor;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCategory;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.converter.PriceToStringConverter;
import ordermate.gui.binding.validators.NotEmptyValidator;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Validator;

public class DebtorEditPanel
extends AbstractObjectEditor<AbstractDebtor>
implements ActionListener {
    private EventList<DebtorGroup> debtorGroups = GlazedLists.eventList((Collection)DebtorGroup.getAllDebtorGroups());
    private JButton customerButton;
    private AbstractSearchDialog customerSearchDialog;
    private Customer customer;
    private EventList customerCategories = GlazedLists.eventList((Collection)CustomerCategory.getAllCategories());

    public DebtorEditPanel() {
        JTextField name = new JTextField(20);
        Binding nameBinding = this.getBindings().createBinding(AbstractDebtor.Properties.LABEL, (Object)name, "text");
        nameBinding.setValidator((Validator)new NotEmptyValidator());
        FieldPanelBuilder builder = new FieldPanelBuilder();
        builder.addRow("Name", (Component)name);
        JTextField creditLimit = new JTextField(20);
        Binding creditLimitBinding = this.getBindings().createBinding(AbstractDebtor.Properties.CREDIT_LIMIT, (Object)creditLimit, "text");
        creditLimitBinding.setConverter((Converter)new PriceToStringConverter(Price.DEFAULT_ROUND_AMOUNT));
        builder.addRow("Credit Limit", (Component)creditLimit);
        JCheckBox requiresNote = this.setupCheckBox(AbstractDebtor.Properties.NOTE_REQUIRED);
        builder.addRow("Invoice requires note", (Component)requiresNote);
        JComboBox groupBox = this.setupComboBox(AbstractDebtor.Properties.GROUP, (ComboBoxModel)new EventComboBoxModel(this.debtorGroups), (Validator)new NotEmptyValidator());
        builder.addRow("Group", (Component)groupBox);
        this.customerButton = new JButton();
        this.customerButton.addActionListener(this);
        builder.addRow("Customer", (Component)this.customerButton);
        this.customerSearchDialog = new SingleSearchDialog<Customer>(new CustomerSearcherGui(this.customerCategories), CustomerSearcherGui.DEFAULT_TABLE_FORMAT, "Customer", null);
        this.add(builder.getPanel());
    }

    @Override
    public void refresh() {
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.customerCategories, CustomerCategory.getAllCategories());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.debtorGroups, DebtorGroup.getAllDebtorGroups());
    }

    @Override
    public void saveObject() {
        super.saveObject();
        AbstractDebtor debtor = (AbstractDebtor)this.getObject();
        if (debtor.canAddCustomer()) {
            debtor = debtor.addCustomer(this.customer);
            this.getBindings().setObject((Object)debtor);
        }
    }

    @Override
    public void setObject(AbstractDebtor toEdit) {
        if (!toEdit.isPersistent() && toEdit.getGroup() == null && !this.debtorGroups.isEmpty()) {
            toEdit.setGroup((DebtorGroup)this.debtorGroups.get(0));
        }
        this.customerButton.setEnabled(true);
        if (toEdit instanceof CustomerDebtor) {
            this.customer = ((CustomerDebtor)toEdit).getCustomer();
            this.customerButton.setText(this.customer.getName());
        } else if (toEdit.canAddCustomer()) {
            this.customer = null;
            this.customerButton.setText("None");
        } else {
            this.customerButton.setText("None");
            this.customerButton.setEnabled(false);
        }
        super.setObject(toEdit);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.customerButton)) {
            Customer selected = (Customer)this.customerSearchDialog.doDialog(OfficeMate.getApplicationFrame());
            if (this.customerSearchDialog.wasCancelled()) {
                return;
            }
            if (selected == null) {
                this.customer = null;
                this.customerButton.setText("None");
            } else {
                this.customer = selected;
                this.customerButton.setText(selected.getName());
            }
        }
    }
}

