/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.debtor.debtors;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JRViewer;
import officemate.OfficeMate;
import officemate.adminkit.dialogs.Dialogs;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.sales.ItemGroup;
import ordermate.reports.printing.InvoiceReport;
import ordermate.reports.printing.StatementReport;

class PrintStatementsAction
extends BasicAction {
    private EventList debtors;

    public PrintStatementsAction(EventList toPrint) {
        super("Print Invoice Statements", (Icon)IconLoader.get((String)"/officemate/images/quickprint.png"));
        this.debtors = toPrint;
    }

    public void actionPerformed(ActionEvent evt) {
        JPanel box = new JPanel(new GridLayout(0, 1));
        box.add(new JLabel("<html>This will print invoice statements for the " + this.debtors.size() + " currently displaying debtors.<br>If a debtor has no outstanding sales then no statement will print."));
        JCheckBox check = new JCheckBox("Print un-paid invoices");
        box.add(check);
        int result = JOptionPane.showConfirmDialog(OfficeMate.getApplicationFrame(), box, "Invoice Statement Print Options", 2);
        if (result == 0) {
            PrintStatementTask printTask = new PrintStatementTask(check.isSelected());
            Dialogs.showProgressDialog(printTask);
            if (printTask.print != null) {
                JDialog reportDisplay = new JDialog();
                JRViewer viewer = new JRViewer(printTask.print);
                viewer.setFitWidthZoomRatio();
                reportDisplay.setContentPane((Container)viewer);
                reportDisplay.setSize(800, 600);
                reportDisplay.setVisible(true);
            }
        }
    }

    private class PrintStatementTask
    extends AbstractTask {
        private JasperPrint print;
        private boolean includeInvoices;

        public PrintStatementTask(boolean invoices) {
            this.includeInvoices = invoices;
        }

        public String getName() {
            return "Print Invoice Statements";
        }

        public int getTotalSubTasks() {
            return PrintStatementsAction.this.debtors.size();
        }

        protected void performTask() throws Exception {
            for (AbstractDebtor toPrint : PrintStatementsAction.this.debtors) {
                List sales = toPrint.getUnpaidSales();
                if (!sales.isEmpty()) {
                    try {
                        StatementReport report = new StatementReport(sales, Price.ZERO, "/ordermate/reports/printing/StatementPrintDataReport.jrxml");
                        report.generate();
                        this.print = report.addPagesToReport(this.print);
                        if (this.includeInvoices) {
                            for (DebtorSale sale : sales) {
                                if (sale.isPaid()) continue;
                                InvoiceReport invoiceReport = new InvoiceReport((ItemGroup)sale.getSaleAccount(), "/ordermate/reports/printing/InvoiceReportA4.jrxml", "Invoice Report A4 Path");
                                invoiceReport.generate();
                                this.print = invoiceReport.addPagesToReport(this.print);
                            }
                        }
                    }
                    catch (Exception e) {
                        OfficeMate.LOG.error("error generating report for debtor " + toPrint, (Throwable)e);
                    }
                }
                this.emitProgress();
            }
        }
    }
}

