/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.debtor.debtorsales;

import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import officemate.screens.debtor.debtorsales.DebtorSalesPanel;
import officemate.screens.debtor.debtorsales.FinanceTransactionPanel;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

class DebtorReportPanel
extends JPanel {
    private DebtorSalesPanel debtorSales;
    private FinanceTransactionPanel financeTransactions;
    private AbstractDebtor theDebtor;
    public final Signal<DebtorSale, ?, ?, ?, ?> debtorSaleEdited = Signals.createSignal(DebtorSale.class, (String)"debtorSale");
    public final Signal<Boolean, ?, ?, ?, ?> allDebtorsSelected = Signals.createSignal(Boolean.class, (String)"allDebtors");
    public final Signal<AbstractDebtor, ?, ?, ?, ?> debtorSelected = Signals.createSignal(AbstractDebtor.class, (String)"debtor");

    public DebtorReportPanel() {
        this.setLayout(new BorderLayout());
        this.debtorSales = new DebtorSalesPanel();
        this.debtorSales.debtorSaleEdited.connect((Object)this, "gotDebtorSaleEdited");
        this.debtorSales.debtorSelected.connect((Object)this, "gotDebtor");
        this.debtorSales.allDebtorsSelected.connect((Object)this, "gotAllDebtors");
        this.financeTransactions = new FinanceTransactionPanel();
        JTabbedPane tabs = new JTabbedPane();
        tabs.setBorder(Borders.DLU4_BORDER);
        tabs.addTab("Sales", this.debtorSales);
        tabs.addTab("Payments", this.financeTransactions);
        this.add((Component)tabs, "Center");
        this.setPreferredSize(new Dimension(600, 400));
        this.setSize(this.getPreferredSize());
        this.setMinimumSize(new Dimension(600, 400));
        this.setMaximumSize(new Dimension(600, 400));
    }

    public JComponent getComponent() {
        return this;
    }

    public void gotDebtorSaleEdited(DebtorSale sale) {
        this.debtorSaleEdited.emit((Object)sale);
    }

    public void setDebtor(AbstractDebtor toReport) {
        this.theDebtor = toReport;
        this.debtorSales.setObject(this.theDebtor);
        this.financeTransactions.setObject(this.theDebtor);
    }

    public void refresh() {
        this.debtorSales.refresh();
        this.theDebtor = this.debtorSales.getDebtor();
        this.financeTransactions.refresh();
    }

    public AbstractDebtor getDebtor() {
        return this.theDebtor;
    }

    public void gotDebtor(AbstractDebtor debtor) {
        this.theDebtor = debtor;
        this.debtorSelected.emit((Object)debtor);
    }

    public void gotAllDebtors(Boolean allDebtors) {
        this.theDebtor = null;
        this.allDebtorsSelected.emit((Object)allDebtors);
    }
}

