/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.debtor.debtorsales;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JRViewer;
import officemate.OfficeMate;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.columnformats.DebtorTransactionColumnFormat;
import officemate.adminkit.columnformats.SalesItemColumnFormat;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.PersistentDisplayableHighlighter;
import officemate.components.search.AbstractSearchDialog;
import officemate.components.search.SearchBarPanel;
import officemate.components.search.SingleSearchDialog;
import officemate.components.search.objectsearch.DebtorSearchState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TotalTableModel;
import officemate.screens.debtor.debtorsales.DebtorSalesColumnFormat;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.queries.finance.debtors.DebtorQueries;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesLineItem;
import ordermate.gui.UIFSplitPane;
import ordermate.reports.printing.InvoiceReport;
import ordermate.services.finance.debtors.DebtorDateFilterStrategy;
import ordermate.services.finance.debtors.DebtorSalesFilter;
import ordermate.services.finance.debtors.StatusDebtorSalesFilter;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTitledSeparator;
import org.jdesktop.swingx.decorator.Highlighter;

class DebtorSalesPanel
extends JPanel
implements ObjectEditor,
ActionListener {
    private PersistentObjectTable salesTable;
    private PersistentObjectTable itemsTable;
    private PersistentObjectTable transactionsTable;
    private EventList<SalesLineItem> displayingItems;
    private EventList<FinanceTransaction> displayingTransactions;
    private EventList<DebtorSale> debtorSales;
    private JComboBox paymentStatus;
    private JComboBox dateFilterStrategySelector;
    private JTextField invoiceNumber;
    private UIFSplitPane topBottomSplitter;
    private UIFSplitPane leftRightSplitter;
    private JCheckBox allDebtorCheckBox;
    private JXDatePicker startDatePicker;
    private JXDatePicker endDatePicker;
    private JButton debtorButton;
    private AbstractSearchDialog debtorDialog;
    private AbstractDebtor theDebtor;
    private DebtorDateFilterStrategy dateFilterStrategy;
    public final Signal<DebtorSale, ?, ?, ?, ?> debtorSaleEdited = Signals.createSignal(DebtorSale.class, (String)"debtorSale");
    public final Signal<AbstractDebtor, ?, ?, ?, ?> debtorSelected = Signals.createSignal(AbstractDebtor.class, (String)"debtor");
    public final Signal<Boolean, ?, ?, ?, ?> allDebtorsSelected = Signals.createSignal(Boolean.class, (String)"allDebtors");

    public DebtorSalesPanel() {
        super(new BorderLayout());
        this.addComponentListener(new Resizer());
        this.dateFilterStrategy = DebtorDateFilterStrategy.InvoiceDate;
        this.debtorSales = new BasicEventList();
        this.salesTable = new PersistentObjectTable<DebtorSale>(this.debtorSales, new DebtorSalesColumnFormat());
        this.salesTable.objectSelected().connect((Object)this, "gotSaleSelected");
        this.salesTable.noObjectSelected().connect((Object)this, "gotNoSelection");
        this.salesTable.getTable().addHighlighter((Highlighter)new PersistentDisplayableHighlighter(this.debtorSales, this.salesTable.getTable()));
        this.salesTable.objectEdited().connect((Object)this, "gotDebtorSaleEdited");
        PrintInvoiceAction printAction = new PrintInvoiceAction();
        this.salesTable.addSelectionDependentAction((Action)((Object)printAction));
        this.salesTable.add(TotalTableModel.createTotalTable(this.salesTable.getTable()), "South");
        this.salesTable.add((Component)new JXTitledSeparator("Sales"), "North");
        this.salesTable.setBorder(Borders.DLU2_BORDER);
        this.displayingItems = new BasicEventList();
        this.itemsTable = new PersistentObjectTable<SalesLineItem>(this.displayingItems, new SalesItemColumnFormat());
        this.itemsTable.add((Component)new JXTitledSeparator("Items Sold"), "North");
        this.itemsTable.setBorder(Borders.DLU2_BORDER);
        this.displayingTransactions = new BasicEventList();
        this.transactionsTable = new PersistentObjectTable<FinanceTransaction>(this.displayingTransactions, new DebtorTransactionColumnFormat());
        this.transactionsTable.add((Component)new JXTitledSeparator("Payments"), "North");
        this.transactionsTable.setBorder(Borders.DLU2_BORDER);
        this.debtorDialog = new SingleSearchDialog<AbstractDebtor>(new DebtorSearchState(), DebtorSearchState.DEFAULT_TABLE_FORMAT, "Debtor", null);
        JPanel north = new JPanel(new BorderLayout());
        north.add((Component)this.getFilterPanel(), "Center");
        JPanel printingPanel = new JPanel();
        printingPanel.add(new JButton((Action)((Object)new PrintShownInvoiceAction())));
        printingPanel.add(new JButton((Action)((Object)printAction)));
        north.add((Component)printingPanel, "East");
        this.add((Component)north, "North");
        this.leftRightSplitter = new UIFSplitPane();
        this.leftRightSplitter.setLeftComponent((Component)this.itemsTable);
        this.leftRightSplitter.setRightComponent((Component)this.transactionsTable);
        this.topBottomSplitter = new UIFSplitPane(0);
        this.topBottomSplitter.setTopComponent((Component)this.salesTable);
        this.topBottomSplitter.setBottomComponent((Component)this.leftRightSplitter);
        this.add((Component)this.topBottomSplitter, "Center");
    }

    public void setDebtor(AbstractDebtor debtor) {
        this.theDebtor = debtor;
        if (this.theDebtor != null) {
            this.debtorButton.setText(this.theDebtor.getLabel());
            this.debtorButton.setEnabled(true);
        } else {
            this.debtorButton.setText("Set Debtor...");
        }
    }

    private SearchBarPanel getFilterPanel() {
        SearchBarPanel filter = new SearchBarPanel();
        this.debtorButton = new JButton("Set Debtor...");
        this.debtorButton.addActionListener(this);
        filter.addSearchField("Debtor:", this.debtorButton);
        this.allDebtorCheckBox = new JCheckBox("");
        this.allDebtorCheckBox.addActionListener(this);
        this.allDebtorCheckBox.setName("allDebtorCheckBox");
        filter.addSearchField("All Debtors", this.allDebtorCheckBox);
        this.paymentStatus = new JComboBox<String>(new String[]{"All", "Paid", "Outstanding", "Overdue"});
        this.paymentStatus.addActionListener(this);
        ComponentUtils.setupComboBox((JComboBox)this.paymentStatus);
        filter.addSearchField("Status", this.paymentStatus);
        this.startDatePicker = OfficeMateAdminGuiUtils.getInstance().standardDatePickerSetup(new JXDatePicker(DateTimeUtils.getThreeMonthsAgo()));
        this.startDatePicker.setName("salesStartDate");
        this.endDatePicker = OfficeMateAdminGuiUtils.getInstance().standardDatePickerSetup(new JXDatePicker(DateTimeUtils.getThreeMonthsAgo()));
        this.endDatePicker.setName("salesEndDate");
        PropertyChangeListener dateChanged = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DebtorSalesPanel.this.update();
            }
        };
        this.startDatePicker.addPropertyChangeListener("date", dateChanged);
        this.endDatePicker.addPropertyChangeListener("date", dateChanged);
        this.dateFilterStrategySelector = new JComboBox<DebtorDateFilterStrategy>(DebtorDateFilterStrategy.values());
        this.dateFilterStrategySelector.setRenderer(this.getDateFilterTypeRenderer());
        this.dateFilterStrategySelector.setSelectedItem(DebtorDateFilterStrategy.InvoiceDate);
        ComponentUtils.setupComboBox((JComboBox)this.dateFilterStrategySelector);
        this.invoiceNumber = new JTextField(15);
        this.invoiceNumber.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                DebtorSalesPanel.this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DebtorSalesPanel.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DebtorSalesPanel.this.update();
            }
        });
        this.dateFilterStrategySelector.addActionListener(this);
        filter.addSearchField("Dates to Filter", this.dateFilterStrategySelector);
        filter.addSearchField("Date From", (Component)this.startDatePicker);
        filter.addSearchField("Date To", (Component)this.endDatePicker);
        filter.addSearchField("Invoice number", this.invoiceNumber);
        return filter;
    }

    public void gotDebtorSaleEdited(Object sale) {
        this.debtorSaleEdited.emit((Object)((DebtorSale)sale));
    }

    public void saveObject() {
    }

    public boolean isGuiValid() {
        return true;
    }

    public JComponent getComponent() {
        return this;
    }

    public void setObject(Object toEdit) {
        if (toEdit != null) {
            this.allDebtorCheckBox.setSelected(false);
        }
        this.setDebtor((AbstractDebtor)toEdit);
        this.update();
    }

    public Object getObject() {
        return this.getDebtor();
    }

    public AbstractDebtor getDebtor() {
        return this.theDebtor;
    }

    private void update() {
        StatusDebtorSalesFilter filter = new StatusDebtorSalesFilter();
        filter.setDateFilterStrategy(this.dateFilterStrategy);
        filter.setDate(this.startDatePicker.getDate());
        filter.setEndDate(this.endDatePicker.getDate());
        filter.setPaymentStatus(this.paymentStatus.getSelectedItem().toString());
        if (!this.invoiceNumber.getText().isEmpty()) {
            filter.setInvoiceNumbers(this.parseInvoiceNumbers(this.invoiceNumber.getText()));
        }
        this.debtorSales.clear();
        if (this.allDebtorCheckBox.isSelected()) {
            for (AbstractDebtor currDebtor : DebtorQueries.getAllDebtors()) {
                if (currDebtor == null) continue;
                this.debtorSales.addAll((Collection)currDebtor.getFilteredSales((DebtorSalesFilter)filter));
            }
        } else if (this.theDebtor != null) {
            this.debtorSales.addAll((Collection)this.theDebtor.getFilteredSales((DebtorSalesFilter)filter));
        }
    }

    private List parseInvoiceNumbers(String text) {
        ArrayList<Integer> toReturn = new ArrayList<Integer>();
        StringTokenizer tokens = new StringTokenizer(text, " ,;:/\\|");
        while (tokens.hasMoreElements()) {
            String part = (String)tokens.nextElement();
            try {
                toReturn.add(new Integer(part));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return toReturn;
    }

    void gotSaleSelected(Object selected) {
        DebtorSale selectedSale = (DebtorSale)selected;
        this.displayingItems.clear();
        this.displayingItems.addAll((Collection)selectedSale.getSaleAccount().getItems());
        this.displayingTransactions.clear();
        this.displayingTransactions.addAll(DebtorPayment.getFinanceTransactionsForDebtorSales(Collections.singletonList(selectedSale)));
    }

    void gotNoSelection() {
        this.displayingItems.clear();
        this.displayingTransactions.clear();
    }

    public void revertObject() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.debtorButton) {
            this.doDebtorDialog();
        } else if (e.getSource() == this.allDebtorCheckBox) {
            if (this.allDebtorCheckBox.isSelected()) {
                this.debtorButton.setEnabled(false);
                this.setDebtor(null);
            } else {
                this.debtorButton.setEnabled(true);
            }
            this.allDebtorsSelected.emit((Object)this.allDebtorCheckBox.isSelected());
            this.update();
        } else if (e.getSource() == this.paymentStatus) {
            boolean datesEnabled = this.paymentStatus.getSelectedItem().equals("All") || this.paymentStatus.getSelectedItem().equals("Paid");
            this.startDatePicker.setEnabled(datesEnabled);
            this.endDatePicker.setEnabled(datesEnabled);
            this.update();
        } else if (e.getSource() == this.dateFilterStrategySelector) {
            DebtorDateFilterStrategy selected;
            this.dateFilterStrategy = selected = (DebtorDateFilterStrategy)this.dateFilterStrategySelector.getSelectedItem();
            this.update();
        }
    }

    void doDebtorDialog() {
        AbstractDebtor debtor = (AbstractDebtor)this.debtorDialog.doDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame());
        if (!this.debtorDialog.wasCancelled()) {
            this.setDebtor(debtor);
            this.update();
            this.debtorSelected.emit((Object)debtor);
        }
    }

    public void refresh() {
        if (this.theDebtor != null) {
            this.theDebtor = (AbstractDebtor)PersistenceManager.reacquire((PersistentObjectI)this.theDebtor);
            this.setObject(this.theDebtor);
        }
    }

    private ListCellRenderer getDateFilterTypeRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel toReturn = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                DebtorDateFilterStrategy type = (DebtorDateFilterStrategy)value;
                toReturn.setText(type.getDisplayableName());
                return toReturn;
            }
        };
    }

    private class Resizer
    extends ComponentAdapter {
        private Resizer() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            DebtorSalesPanel.this.leftRightSplitter.setDividerLocation(0.5);
            DebtorSalesPanel.this.topBottomSplitter.setDividerLocation(0.7);
        }
    }

    private class PrintInvoiceAction
    extends BasicAction {
        public PrintInvoiceAction() {
            super("Print Invoice", (Icon)IconLoader.get((String)"/ordermate/images/print_icon22.png"), "Print Invoice");
        }

        public void actionPerformed(ActionEvent e) {
            DebtorSale sale = (DebtorSale)DebtorSalesPanel.this.salesTable.getSelectedObject();
            InvoiceReport report = new InvoiceReport((ItemGroup)sale.getSaleAccount(), "/ordermate/reports/printing/InvoiceReportA4.jrxml", "Invoice Report A4 Path");
            try {
                report.generate();
                JDialog reportDisplay = new JDialog();
                reportDisplay.setContentPane(report.getReportViewer());
                reportDisplay.setSize(800, 600);
                reportDisplay.setVisible(true);
            }
            catch (Exception e1) {
                OfficeMate.LOG.error("Error trying to print debtor statement", (Throwable)e1);
            }
        }
    }

    private static class PrintShownInvoicesTask
    extends AbstractTask {
        private JasperPrint print;
        private List sales;

        public PrintShownInvoicesTask(List newDebtorSales) {
            this.sales = newDebtorSales;
        }

        public String getName() {
            return "Print Shown Invoices";
        }

        public int getTotalSubTasks() {
            return this.sales.size();
        }

        protected void performTask() throws Exception {
            for (DebtorSale sale : this.sales) {
                InvoiceReport invoiceReport = new InvoiceReport((ItemGroup)sale.getSaleAccount(), "/ordermate/reports/printing/InvoiceReportA4.jrxml", "Invoice Report A4 Path");
                invoiceReport.generate();
                this.print = invoiceReport.addPagesToReport(this.print);
                this.emitProgress();
            }
        }
    }

    private class PrintShownInvoiceAction
    extends BasicAction {
        public PrintShownInvoiceAction() {
            super("Print Shown Invoices", (Icon)IconLoader.get((String)"/ordermate/images/print_icon22.png"), "Print Shown Invoices");
        }

        public void actionPerformed(ActionEvent e) {
            PrintShownInvoicesTask printTask = new PrintShownInvoicesTask((List)DebtorSalesPanel.this.debtorSales);
            Dialogs.showProgressDialog(printTask);
            if (printTask.print != null) {
                JDialog reportDisplay = new JDialog();
                JRViewer viewer = new JRViewer(printTask.print);
                viewer.setFitWidthZoomRatio();
                reportDisplay.setContentPane((Container)viewer);
                reportDisplay.setSize(800, 600);
                reportDisplay.setVisible(true);
            }
        }
    }
}

