/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.debtor.debtorsales;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import officemate.OfficeMate;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.columnformats.DebtorTransactionColumnFormat;
import officemate.components.search.AbstractSearchDialog;
import officemate.components.search.SearchBarPanel;
import officemate.components.search.SingleSearchDialog;
import officemate.components.search.objectsearch.DebtorSearchState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TotalTableModel;
import officemate.screens.debtor.debtorsales.DebtorSalesColumnFormat;
import ordermate.database.finance.DebtorTransactionGroupAdapter;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.DebtorPaymentAgent;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.sales.ItemGroup;
import ordermate.gui.UIFSplitPane;
import ordermate.reports.printing.DebtorPaymentReport;
import ordermate.reports.printing.InvoiceReport;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTitledSeparator;

class FinanceTransactionPanel
extends JPanel
implements ObjectEditor<AbstractDebtor>,
ActionListener {
    private MultiMap debtorPaymentsByTransaction = new MultiHashMap();
    private JXDatePicker startDatePicker;
    private JXDatePicker endDatePicker;
    private JComboBox paymentStatus;
    private EventList<DebtorSale> salesList;
    private EventList<FinanceTransaction> transactionList;
    private PersistentObjectTable salesTable;
    private PersistentObjectTable transactionTable;
    private AbstractDebtor debtor;
    private UIFSplitPane splitter;
    private JButton debtorButton;
    private AbstractSearchDialog debtorDialog;

    public FinanceTransactionPanel() {
        super(new BorderLayout());
        this.addComponentListener(new Resizer());
        this.transactionList = new BasicEventList();
        this.transactionTable = new PersistentObjectTable<FinanceTransaction>(this.transactionList, new DebtorTransactionColumnFormat());
        this.transactionTable.objectSelected().connect((Object)this, "gotPaymentSelected");
        this.transactionTable.add(TotalTableModel.createTotalTable(this.transactionTable.getTable()), "South");
        this.transactionTable.add((Component)new JXTitledSeparator("Payments"), "North");
        this.transactionTable.setBorder(Borders.DLU2_BORDER);
        PrintAllTransactionsAction printAllTrans = new PrintAllTransactionsAction();
        PrintTransactionAction printTrans = new PrintTransactionAction();
        this.transactionTable.addSelectionDependentAction((Action)((Object)printTrans));
        this.salesList = new BasicEventList();
        this.salesTable = new PersistentObjectTable<DebtorSale>(this.salesList, new DebtorSalesColumnFormat());
        PrintInvoiceAction printInvoiceAction = new PrintInvoiceAction();
        this.salesTable.addSelectionDependentAction((Action)((Object)printInvoiceAction));
        this.salesTable.add((Component)new JXTitledSeparator("Sales"), "North");
        this.salesTable.add(TotalTableModel.createTotalTable(this.salesTable.getTable()), "South");
        this.salesTable.setBorder(Borders.DLU2_BORDER);
        this.debtorDialog = new SingleSearchDialog<AbstractDebtor>(new DebtorSearchState(), DebtorSearchState.DEFAULT_TABLE_FORMAT, "Debtor", null);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)this.getFilterPanel(), "West");
        JPanel printingPanel = new JPanel(new FlowLayout(2));
        printingPanel.add(new JButton((Action)((Object)printInvoiceAction)));
        printingPanel.add(new JButton((Action)((Object)printTrans)));
        printingPanel.add(new JButton((Action)((Object)printAllTrans)));
        topPanel.add((Component)printingPanel, "Center");
        this.add((Component)topPanel, "North");
        this.splitter = new UIFSplitPane(0);
        this.splitter.setTopComponent((Component)this.transactionTable);
        this.splitter.setBottomComponent((Component)this.salesTable);
        this.add((Component)this.splitter, "Center");
    }

    private SearchBarPanel getFilterPanel() {
        SearchBarPanel filter = new SearchBarPanel();
        this.debtorButton = new JButton("Set Debtor...");
        this.debtorButton.addActionListener(this);
        filter.addSearchField("Debtor:", this.debtorButton);
        this.paymentStatus = new JComboBox<Object>(new Object[]{"All", "Assigned", "Unassigned"});
        this.paymentStatus.addActionListener(this);
        filter.addSearchField("Status", this.paymentStatus);
        ComponentUtils.setupComboBox((JComboBox)this.paymentStatus);
        this.startDatePicker = OfficeMateAdminGuiUtils.getInstance().standardDatePickerSetup(new JXDatePicker(DateTimeUtils.getThreeMonthsAgo()));
        this.startDatePicker.setName("paymentsStartDate");
        this.endDatePicker = OfficeMateAdminGuiUtils.getInstance().standardDatePickerSetup(new JXDatePicker(DateTimeUtils.getThreeMonthsAgo()));
        this.endDatePicker.setName("paymentsEndDate");
        PropertyChangeListener dateChanged = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FinanceTransactionPanel.this.update();
            }
        };
        this.startDatePicker.addPropertyChangeListener("date", dateChanged);
        this.endDatePicker.addPropertyChangeListener("date", dateChanged);
        filter.addSearchField("Date From", (Component)this.startDatePicker);
        filter.addSearchField("Date To", (Component)this.endDatePicker);
        return filter;
    }

    void doDebtorDialog() {
        AbstractDebtor theDebtor = (AbstractDebtor)this.debtorDialog.doDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame());
        if (!this.debtorDialog.wasCancelled()) {
            this.setObject(theDebtor);
        }
    }

    public void saveObject() {
    }

    public boolean isGuiValid() {
        return true;
    }

    public void setObject(AbstractDebtor toEdit) {
        this.debtor = toEdit;
        if (this.debtor != null) {
            this.debtorButton.setText(this.debtor.getLabel());
        } else {
            this.debtorButton.setText("Set Debtor...");
        }
        this.update();
    }

    public AbstractDebtor getObject() {
        return this.debtor;
    }

    public JComponent getComponent() {
        return this;
    }

    private void update() {
        this.transactionList.clear();
        this.debtorPaymentsByTransaction.clear();
        this.salesList.clear();
        if (this.debtor != null) {
            this.transactionList.addAll(this.getFinanceTransactions(this.debtor));
        }
    }

    private Set<FinanceTransaction> getFinanceTransactions(AbstractDebtor theDebtor) {
        HashSet<FinanceTransaction> financeTransactions = new HashSet<FinanceTransaction>();
        for (DebtorPayment payment : theDebtor.getAllPayments()) {
            if (!this.paymentMeetsFilter(payment)) continue;
            FinanceTransaction transaction = payment.getFinanceTransaction();
            financeTransactions.add(transaction);
            this.debtorPaymentsByTransaction.put((Object)payment.getFinanceTransaction(), (Object)payment);
        }
        return financeTransactions;
    }

    private boolean paymentMeetsFilter(DebtorPayment payment) {
        FinanceTransaction transaction = payment.getFinanceTransaction();
        if (transaction.getCreationTime() == null || transaction.getCreationTime().before(this.startDatePicker.getDate()) || transaction.getCreationTime().after(DateTimeUtils.getEndOfDay((Date)this.endDatePicker.getDate()))) {
            return false;
        }
        String status = this.paymentStatus.getSelectedItem().toString();
        if (status.equals("All")) {
            return true;
        }
        return payment.hasDebtorSale() == status.equals("Assigned");
    }

    void gotPaymentSelected(Object selected) {
        FinanceTransaction selectedTransaction = (FinanceTransaction)selected;
        Collection payments = (Collection)this.debtorPaymentsByTransaction.get((Object)selectedTransaction);
        this.salesList.clear();
        for (DebtorPayment payment : payments) {
            if (!payment.hasDebtorSale()) continue;
            this.salesList.add((Object)payment.getSale());
        }
    }

    public void revertObject() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.debtorButton) {
            this.doDebtorDialog();
        } else if (e.getSource() == this.paymentStatus) {
            this.update();
        }
    }

    public void refresh() {
        if (this.debtor != null) {
            this.debtor = (AbstractDebtor)PersistenceManager.reacquire((PersistentObjectI)this.debtor);
            this.setObject(this.debtor);
        }
    }

    private class Resizer
    extends ComponentAdapter {
        private Resizer() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            FinanceTransactionPanel.this.splitter.setDividerLocation(0.7);
        }
    }

    private class PrintTransactionAction
    extends BasicAction {
        public PrintTransactionAction() {
            super("Print Payments", (Icon)IconLoader.get((String)"/ordermate/images/print_icon22.png"), "Prints currently selected Payments");
        }

        public void actionPerformed(ActionEvent e) {
            DebtorTransactionGroupAdapter DTGAdapter = new DebtorTransactionGroupAdapter(new DebtorPaymentAgent(FinanceTransactionPanel.this.debtor));
            Iterator it = FinanceTransactionPanel.this.transactionTable.getAllSelectedObjects().iterator();
            while (it.hasNext()) {
                DTGAdapter.addFinanceTransaction((FinanceTransaction)it.next());
            }
            DebtorPaymentReport report = new DebtorPaymentReport(DTGAdapter);
            try {
                report.generate();
                JDialog reportDisplay = new JDialog();
                reportDisplay.setContentPane(report.getReportViewer());
                reportDisplay.setSize(800, 600);
                reportDisplay.setVisible(true);
            }
            catch (Exception e1) {
                OfficeMate.LOG.error("Error trying to print debtor payments.", (Throwable)e1);
            }
        }
    }

    private class PrintAllTransactionsAction
    extends BasicAction {
        public PrintAllTransactionsAction() {
            super("Print All Payments", (Icon)IconLoader.get((String)"/ordermate/images/print_icon22.png"), "Print all currently displayed payments");
        }

        public void actionPerformed(ActionEvent e) {
            DebtorTransactionGroupAdapter DTGAdapter = new DebtorTransactionGroupAdapter(new DebtorPaymentAgent(FinanceTransactionPanel.this.debtor));
            Iterator it = FinanceTransactionPanel.this.transactionList.iterator();
            while (it.hasNext()) {
                DTGAdapter.addFinanceTransaction((FinanceTransaction)it.next());
            }
            DebtorPaymentReport report = new DebtorPaymentReport(DTGAdapter);
            try {
                report.generate();
                JDialog reportDisplay = new JDialog();
                reportDisplay.setContentPane(report.getReportViewer());
                reportDisplay.setSize(800, 600);
                reportDisplay.setVisible(true);
            }
            catch (Exception e1) {
                OfficeMate.LOG.error("Error trying to print all debtor payments", (Throwable)e1);
            }
        }
    }

    private class PrintInvoiceAction
    extends BasicAction {
        public PrintInvoiceAction() {
            super("Print Invoice", (Icon)IconLoader.get((String)"/ordermate/images/print_icon22.png"), "Print Invoice");
        }

        public void actionPerformed(ActionEvent e) {
            DebtorSale sale = (DebtorSale)FinanceTransactionPanel.this.salesTable.getSelectedObject();
            InvoiceReport report = new InvoiceReport((ItemGroup)sale.getSaleAccount(), "/ordermate/reports/printing/InvoiceReportA4.jrxml", "Invoice Report A4 Path");
            try {
                report.generate();
                JDialog reportDisplay = new JDialog();
                reportDisplay.setContentPane(report.getReportViewer());
                reportDisplay.setSize(800, 600);
                reportDisplay.setVisible(true);
            }
            catch (Exception e1) {
                OfficeMate.LOG.error("Error trying to print debtor statement", (Throwable)e1);
            }
        }
    }
}

