/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock;

import au.com.ordermate.util.Assert;
import au.com.ordermate.util.image.IconLoader;
import javax.swing.JLabel;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.ObjectSelectorPanel;
import officemate.adminkit.fieldpanels.ObjectRefFieldPanel;
import officemate.adminkit.types.FieldType;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.config.Quantity;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockItem;

public class UsageStockAreaFieldPanel
extends ObjectRefFieldPanel {
    private JLabel sohFromLabel;
    private JLabel imageLabel;
    private JLabel sohToLabel;
    private StockItem usageItem;
    private double currentQuantity;
    private double originalQuantity;

    public UsageStockAreaFieldPanel(ObjectManager manager) {
        super(manager);
    }

    public void setUsage(StockItem item, double currentQty, double originalQty) {
        this.originalQuantity = originalQty;
        this.usageItem = item;
        this.currentQuantity = currentQty;
    }

    @Override
    public void gotObjectSelected(Object obj) {
        super.gotObjectSelected(obj);
        this.updateLabels((StockArea)obj);
    }

    @Override
    public void gotObjectSelected(Object obj, ObjectSelectorPanel panel) {
        this.gotObjectSelected(obj);
    }

    @Override
    public void setFieldType(FieldType fType) {
        super.setFieldType(fType);
        Assert.isEqual(StockArea.class, (Object)fType.getJavaClass(), (String)"Field type class must be StockArea");
        this.sohFromLabel = new JLabel();
        this.imageLabel = new JLabel();
        this.sohToLabel = new JLabel();
        this.add(this.sohFromLabel);
        this.add(this.imageLabel);
        this.add(this.sohToLabel);
    }

    public void updateLabels(StockItem item, double currentQty, double originalQty) {
        this.setUsage(item, currentQty, originalQty);
        this.updateLabels();
    }

    public void updateLabels() {
        this.updateLabels((StockArea)this.getValue());
    }

    public void updateLabels(StockArea area) {
        if (this.usageItem != null) {
            MeasureUnitContainer container = this.usageItem.getDisplayMeasureUnitContainer();
            double soh = this.usageItem.getStockOnHand(area).doubleValue();
            double from = soh + this.originalQuantity;
            double to = soh + (this.originalQuantity - this.currentQuantity);
            Quantity qtyFrom = new Quantity(container, from, false);
            Quantity qtyTo = new Quantity(container, to, false);
            this.sohFromLabel.setText(" (SOH: " + qtyFrom);
            this.imageLabel.setIcon(IconLoader.get((String)"/ordermate/images/next.png"));
            this.sohToLabel.setText(qtyTo + ")");
            this.revalidate();
            this.repaint();
        }
    }
}

