/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.adjust;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.util.Assert;
import au.com.ordermate.util.DateDMY_HM;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import officemate.adminkit.DefaultObjectEditorPanel;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.ObjectSelectorPanel;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.fieldpanels.DateTimeFieldPanel;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.fieldpanels.ObjectRefFieldPanel;
import officemate.adminkit.fieldpanels.QuantityFieldPanel;
import officemate.adminkit.fieldpanels.StringFieldPanel;
import officemate.screens.maintainstock.EditorData;
import officemate.screens.maintainstock.UsageStockAreaFieldPanel;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.config.MeasureUnitHelper;
import ordermate.database.config.Quantity;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockTake;
import ordermate.database.stock.usage.StockAdjustment;
import ordermate.database.users.AllPermissions;

public class StockAdjustmentEditorPanel
extends DefaultObjectEditorPanel {
    private static final String[] EDIT_FIELDS = new String[]{"Adjust Date", "Adjust Quantity", "Stock Item", "Reason", "User", "Stock Area", "Reason"};
    private StockAdjustment adj;
    private ObjectRefFieldPanel stockItemPanel;
    private ObjectSelectorPanel stockItemSelector;
    private QuantityFieldPanel qtyPanel;
    private DateTimeFieldPanel datePanel;
    private UsageStockAreaFieldPanel areaPanel;
    private static final EditorData lastAccessedState = new EditorData();

    public StockAdjustmentEditorPanel() {
        super(EDIT_FIELDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(ObjectManager manager, ObjectTemplate objectTemplate, Object obj) {
        super.init(manager, objectTemplate, obj);
        this.adj = (StockAdjustment)obj;
        Assert.isEqual(StockAdjustment.class, (Object)objectTemplate.getObjectJavaClass(), (String)("ObjectTemplate must be for StockAdjustments; was " + objectTemplate.getObjectJavaClass().getName()));
        ObjectRefFieldPanel userPanel = (ObjectRefFieldPanel)this.getFieldPanel("User");
        ObjectSelectorPanel userSelector = userPanel.getObjectSelector();
        if (this.isNewObject()) {
            userSelector.setSelectedObject(GuiApp.getAppComplex().getApplicationSecurity().getUser());
        }
        String userAccess = GuiApp.getAppComplex().getApplicationSecurity().getUser().getPermissionAccessLevel(AllPermissions.CHANGE_ADJUSTMENT_USER);
        userSelector.setEnabled(userAccess.equals("ENABLED"));
        userSelector.setVisible(!userAccess.equals("HIDDEN"));
        this.stockItemPanel = (ObjectRefFieldPanel)this.getFieldPanel("Stock Item");
        this.stockItemPanel.setName("Stock Item Panel");
        this.stockItemSelector = this.stockItemPanel.getObjectSelector();
        this.stockItemSelector.objectSelected.connect((Object)this, "gotStockItemSelected");
        this.qtyPanel = (QuantityFieldPanel)this.getFieldPanel("Adjust Quantity");
        this.qtyPanel.setName("QuantityAdj");
        this.datePanel = (DateTimeFieldPanel)this.getFieldPanel("Adjust Date");
        this.areaPanel = (UsageStockAreaFieldPanel)this.getFieldPanel("Stock Area");
        QuantityEventListener listener = new QuantityEventListener();
        this.qtyPanel.addChangeListenerToComponent(listener);
        this.qtyPanel.addFocusListenerToComponent(listener);
        if (this.isNewObject()) {
            StringFieldPanel reasonPanel = (StringFieldPanel)this.getFieldPanel("Reason");
            EditorData editorData = lastAccessedState;
            synchronized (editorData) {
                if (lastAccessedState.isInitialized()) {
                    userPanel.setValue(lastAccessedState.getUser());
                    if (lastAccessedState.getStockItem().isPersistent()) {
                        this.stockItemPanel.setValue(lastAccessedState.getStockItem());
                    }
                    this.qtyPanel.setValue(Quantity.ZERO());
                    this.areaPanel.setValue(lastAccessedState.getStockArea());
                    this.datePanel.setValue(lastAccessedState.getDate());
                    reasonPanel.setValue(lastAccessedState.getReason());
                }
            }
        } else if (this.adj.isFrozen()) {
            FieldPanel[] fieldPanels = this.getFieldPanels();
            for (int i = 0; i < fieldPanels.length; ++i) {
                FieldPanel panel = fieldPanels[i];
                panel.setEnabled(false);
            }
        }
        this.applyStockItemDefaults();
        this.updateAreaPanels();
    }

    private void updateAreaPanels() {
        this.updateAreaPanels((StockItem)this.stockItemPanel.getValue(), this.qtyPanel.getValue());
    }

    private void updateAreaPanels(StockItem item, Quantity currentQtyObj) {
        Quantity originalQty = this.adj != null ? this.adj.getQuantityUsed() : new Quantity(0.0);
        this.updateAreaPanels(item, currentQtyObj, originalQty);
    }

    private void updateAreaPanels(StockItem item, Quantity currentQtyObj, Quantity originalQtyObj) {
        if (this.adj == null || !this.adj.isFrozen()) {
            double currentQty = currentQtyObj.doubleValue();
            double originalQty = originalQtyObj.doubleValue();
            Quantity newQty = new Quantity(item.getDisplayMeasureUnitContainer(), originalQty, false);
            originalQty = newQty.doubleValue();
            item.reload();
            this.areaPanel.updateLabels(item, -currentQty, originalQty);
        }
    }

    @Override
    public String[] getInvalidFields() {
        String[] invalidFields = super.getInvalidFields();
        Date date = (Date)this.datePanel.getValue();
        StockTake stockTake = StockTake.getLastSavedStockTake();
        if (stockTake != null && date.before(stockTake.getDate())) {
            ArrayList<String> invalidList = new ArrayList<String>(invalidFields.length + 1);
            for (int i = 0; i < invalidFields.length; ++i) {
                invalidList.add(invalidFields[i]);
            }
            invalidList.add("Adjust Date");
            return invalidList.toArray(new String[0]);
        }
        return invalidFields;
    }

    @Override
    public boolean requestSaveAllowed() {
        boolean frozen;
        Date date = (Date)this.datePanel.getValue();
        StockTake stockTake = StockTake.getLastSavedStockTake();
        boolean bl = frozen = this.adj != null && this.adj.isFrozen();
        if (!frozen) {
            if (stockTake != null && date.before(stockTake.getDate())) {
                JOptionPane.showMessageDialog(this, "The adjustment date must be more recent than the last stocktake. (" + new DateDMY_HM(stockTake.getDate()) + ") \nPlease choose a more recent date.", "Can't create stock adjustment", 2);
                return false;
            }
            return super.requestSaveAllowed();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveObject() {
        boolean isNew = this.isNewObject();
        super.saveObject();
        if (isNew) {
            StockAdjustment obj = (StockAdjustment)this.getEditedObject();
            EditorData editorData = lastAccessedState;
            synchronized (editorData) {
                lastAccessedState.setUser(obj.getUser()).setStockItem(obj.getStockItem()).setQty(obj.getAdjustQty()).setStockArea(obj.getStockArea()).setDate(obj.getUsageDate()).setReason(obj.getReason()).setInitialized();
            }
        }
    }

    @Override
    protected FieldPanel createFieldPanel(String fieldName) {
        if (fieldName.equals("Stock Area")) {
            UsageStockAreaFieldPanel panel = new UsageStockAreaFieldPanel(this.getTemplate().getManager());
            panel.setFieldType(this.getTemplate().getFieldType(fieldName));
            return panel;
        }
        return super.createFieldPanel(fieldName);
    }

    private void applyStockItemDefaults() {
        StockItem defaultStockItem = (StockItem)this.stockItemPanel.getValue();
        MeasureUnitContainer defaultDispUnits = defaultStockItem != null ? defaultStockItem.getDisplayMeasureUnitContainer() : new MeasureUnitContainer(MeasureUnitHelper.getMeasureUnitForName((String)"units"));
        Quantity qty = new Quantity(defaultDispUnits, this.qtyPanel.getValue().getRawValue(), true);
        this.qtyPanel.setValue(new Quantity(defaultDispUnits, qty.getRawValue(), true));
    }

    void gotStockItemSelected(Object o) {
        this.applyStockItemDefaults();
        this.updateAreaPanels((StockItem)o, this.qtyPanel.getValue());
        this.repaint();
    }

    @Override
    public int getDialogMode() {
        if (this.adj != null && this.adj.isFrozen()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean requestCloseAllowed() {
        return this.getDialogMode() == 1;
    }

    private class QuantityEventListener
    implements ChangeListener,
    FocusListener {
        private QuantityEventListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            StockAdjustmentEditorPanel.this.updateAreaPanels();
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            StockAdjustmentEditorPanel.this.updateAreaPanels();
        }
    }
}

