/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.adjust;

import au.com.ordermate.application.ApplicationContext;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.sql.queries.SelectQuery;
import au.com.ordermate.util.DateDMY;
import au.com.ordermate.util.Price;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import officemate.adminkit.table.QueryTableModel;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.config.Quantity;

public class StockAdjustmentTableModel
extends QueryTableModel {
    private List<Date> creationDates;
    private ApplicationContext context;

    public StockAdjustmentTableModel(SelectQuery selQuery, String idField, String[] colNames, String[] colDisplayNames, ApplicationContext appContext) {
        super(selQuery, appContext.getDatabaseConnection(), idField, colNames, colDisplayNames);
        this.context = appContext;
        this.creationDates = new ArrayList<Date>();
    }

    @Override
    protected Object getTableValue(int row, int col, String colName, int dbColIndex, ResultSet rs) throws SQLException {
        if (col == 0) {
            Timestamp creationTS = rs.getTimestamp("stock_usage.CreationDate");
            Date creationDate = new Date(creationTS.getTime());
            this.creationDates.add(creationDate);
        }
        Object resultSetVal = super.getTableValue(row, col, colName, dbColIndex, rs);
        if (colName.equals("stock_usage.UsageDate")) {
            Date date = (Date)resultSetVal;
            return new DateDMY(date);
        }
        if (colName.equals("UsageValue")) {
            Number num = (Number)resultSetVal;
            return new Price(num.doubleValue(), 0.01);
        }
        if (colName.equals("-stock_usage.Quantity")) {
            MeasureUnitContainer unitContainer = null;
            try {
                Long measureStringLink = rs.getLong("stock_item.fk_display_measure_unit_container");
                unitContainer = (MeasureUnitContainer)PersistenceManager.getByID((long)measureStringLink, MeasureUnitContainer.class);
            }
            catch (SQLException e) {
                this.context.getLog().error("Not able to get MeasureUnitContainer.", (Throwable)e);
                return null;
            }
            Quantity retval = null;
            if (resultSetVal != null) {
                Number num = (Number)resultSetVal;
                retval = new Quantity(unitContainer, num.doubleValue(), true);
            }
            return retval;
        }
        return resultSetVal;
    }

    @Override
    protected Number getTotalValue(int column, double rawValue, String colName, int dbColIndex) {
        if (colName.equals("UsageValue")) {
            return new Price(rawValue, 0.01);
        }
        return super.getTotalValue(column, rawValue, colName, dbColIndex);
    }

    public Date getCreationDate(int row) {
        return this.creationDates.get(row);
    }

    @Override
    public void update() {
        this.creationDates.clear();
        super.update();
    }
}

