/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.invoice;

import au.com.ordermate.util.Assert;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.filters.ObjectFilter;
import officemate.adminkit.types.DoubleFieldType;
import officemate.adminkit.types.FieldType;
import officemate.adminkit.types.IntFieldType;
import officemate.adminkit.types.PriceFieldType;
import officemate.adminkit.types.QuantityFieldType;

public abstract class ObjectCalculationPanel
extends JPanel
implements TableColumnModelListener {
    private TableColumnModel colModelToImitate;
    private ObjectTemplate template;
    private List objects;
    private ObjectFilter filter = null;
    protected String[] fieldsToUse;
    private boolean[] fieldsToConsider = null;
    protected JTable table;
    private DefaultTableModel tableModel;

    public ObjectCalculationPanel(List objectList, ObjectTemplate objTemplate, String[] fieldNamesToUse, boolean[] fieldNamesToConsider, ObjectFilter objFilter) {
        super(new GridLayout(1, 1));
        if (fieldNamesToUse != null && fieldNamesToConsider != null) {
            Assert.isEqual((int)fieldNamesToUse.length, (int)fieldNamesToConsider.length, (String)"List of field names to use, and list of field names to consider should have same length");
        }
        this.fieldsToConsider = fieldNamesToConsider;
        this.filter = objFilter;
        this.fieldsToUse = fieldNamesToUse;
        this.template = objTemplate;
        this.objects = objectList;
        this.tableModel = new NonEditableTableModel();
        this.table = new JTable(this.tableModel);
        this.add(this.table);
        this.update();
    }

    public ObjectCalculationPanel(List objectList, ObjectTemplate objTemplate) {
        this(objectList, objTemplate, null, null, null);
    }

    public ObjectTemplate getTemplate() {
        return this.template;
    }

    public void setColumnModelToImitate(TableColumnModel newModel) {
        if (this.colModelToImitate != null) {
            this.colModelToImitate.removeColumnModelListener(this);
        }
        this.colModelToImitate = newModel;
        TableColumnModel oldModel = this.table.getColumnModel();
        int numCols = oldModel.getColumnCount();
        int minCols = Math.min(numCols, newModel.getColumnCount());
        for (int i = 0; i < minCols; ++i) {
            TableColumn oldCol = oldModel.getColumn(i);
            TableColumn newCol = newModel.getColumn(i);
            oldCol.setModelIndex(newCol.getModelIndex());
            oldCol.setIdentifier(newCol.getIdentifier());
            oldCol.setMaxWidth(newCol.getMaxWidth());
            oldCol.setMinWidth(newCol.getMinWidth());
            oldCol.setPreferredWidth(newCol.getPreferredWidth());
            oldCol.setWidth(oldCol.getWidth());
        }
        newModel.addColumnModelListener(this);
        this.repaint();
    }

    public String[] getColumnValues() {
        int numCols = this.table.getColumnCount();
        String[] colStrings = new String[numCols];
        for (int i = 0; i < numCols; ++i) {
            colStrings[i] = this.tableModel.getValueAt(0, i).toString();
        }
        return colStrings;
    }

    public TableColumnModel getColumnModelToImitate() {
        return this.colModelToImitate;
    }

    public void setObjects(List objs) {
        this.objects = objs;
        this.update();
    }

    public void setObjectFilter(ObjectFilter objFilter) {
        this.filter = objFilter;
        this.update();
    }

    protected abstract Number getCalcQuantity(List var1, ObjectTemplate var2, String var3, ObjectFilter var4);

    protected abstract Number getCalcPrice(List var1, ObjectTemplate var2, String var3, ObjectFilter var4);

    protected abstract Number getCalcInteger(List var1, ObjectTemplate var2, String var3, ObjectFilter var4);

    protected abstract Number getCalcDouble(List var1, ObjectTemplate var2, String var3, ObjectFilter var4);

    public void update() {
        this.tableModel = new NonEditableTableModel();
        if (this.fieldsToUse == null) {
            ArrayList<String> fieldsToUseList = new ArrayList<String>();
            for (String fieldName : this.template.getFields()) {
                fieldsToUseList.add(fieldName);
            }
            this.fieldsToUse = fieldsToUseList.toArray(new String[0]);
        }
        Object[] values = new Object[this.fieldsToUse.length];
        for (int i = 0; i < this.fieldsToUse.length; ++i) {
            String colName = this.fieldsToUse[i];
            this.tableModel.addColumn(colName);
            if (this.fieldsToConsider == null || this.fieldsToConsider[i]) {
                FieldType fType = this.template.getFieldType(colName);
                values[i] = fType instanceof QuantityFieldType ? (Number)this.getCalcQuantity(this.objects, this.template, colName, this.filter) : (Number)(fType instanceof PriceFieldType ? (Number)this.getCalcPrice(this.objects, this.template, colName, this.filter) : (Number)(fType instanceof DoubleFieldType ? (Number)this.getCalcDouble(this.objects, this.template, colName, this.filter) : (Number)(fType instanceof IntFieldType ? this.getCalcInteger(this.objects, this.template, colName, this.filter) : null)));
            }
            if (values[i] != null) continue;
            values[i] = " - ";
        }
        this.tableModel.addRow(values);
        this.table.setModel(this.tableModel);
        this.repaint();
    }

    public ObjectFilter getObjectFilter() {
        return this.filter;
    }

    public JTable getJTable() {
        return this.table;
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        this.setColumnModelToImitate(this.colModelToImitate);
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
        this.setColumnModelToImitate(this.colModelToImitate);
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
        this.setColumnModelToImitate(this.colModelToImitate);
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
        this.setColumnModelToImitate(this.colModelToImitate);
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
        this.setColumnModelToImitate(this.colModelToImitate);
    }

    protected static class NonEditableTableModel
    extends DefaultTableModel {
        protected NonEditableTableModel() {
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return false;
        }
    }
}

