/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.invoice;

import au.com.ordermate.application.ApplicationFrame;
import au.com.ordermate.application.ApplicationSecurity;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.util.Assert;
import au.com.ordermate.util.DateDMY_HM;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import officemate.adminkit.AddRemoveButtonPanel;
import officemate.adminkit.ObjectChangeRecorder;
import officemate.adminkit.ObjectEditorPanel;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.ObjectEditorDialog;
import officemate.adminkit.fieldpanels.DateFieldPanel;
import officemate.adminkit.print.Printing;
import officemate.adminkit.table.DefaultObjectTable;
import officemate.adminkit.templates.StockInvoiceEntryTemplate;
import officemate.screens.maintainstock.invoice.ObjectTotalsPanel;
import officemate.screens.maintainstock.invoice.StockInvoiceEntryEditorPanel;
import officemate.screens.maintainstock.invoice.StockInvoicePermission;
import officemate.screens.maintainstock.invoice.StockInvoiceTotalsPanel;
import officemate.screens.maintainstock.invoice.purchaseorder.PurchaseOrderReportProvider;
import ordermate.database.misc.ObjectChange;
import ordermate.database.misc.StockControlEventLog;
import ordermate.database.misc.SystemProperty;
import ordermate.database.queries.stock.StockItemQueries;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockInvoice;
import ordermate.database.stock.StockInvoiceEntry;
import ordermate.database.stock.StockSupplier;
import ordermate.database.stock.StockTake;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.reportbuilder.ReportProvider;

public class StockInvoiceEditorPanel
extends ObjectEditorPanel {
    private static final int FEE_ROUND_DEC_PLACES = 4;
    private static final String GST = Internationalization.getLiteralFor((String)"GST");
    private static final String INC_GST = MessageFormat.format(" (Inc {0}) ", GST);
    private static final String EX_GST = MessageFormat.format(" (Ex {0}) ", GST);
    private boolean creatingNew = false;
    private boolean awaitingInit = true;
    private boolean deletePurchaseOrder = false;
    private StockInvoice invoice;
    private StockInvoice oldPurchaseOrder;
    private ApplicationFrame frame = GuiApp.getAppComplex().getApplicationFrame();
    private ApplicationSecurity security = GuiApp.getAppComplex().getApplicationSecurity();
    private ObjectManager manager;
    private ObjectTemplate invoiceTemplate;
    private ObjectTemplate invoiceEntryTemplate;
    private AddRemoveButtonPanel buttonPanel;
    private DefaultObjectTable table;
    private JComboBox stockAreaCombo;
    private JComboBox supplierCombo;
    private DateFieldPanel datePanel;
    private JComponent datePanelDecorator;
    private JTextField orderNumberField;
    private JTextField invoiceNumField;
    private JTextField expectedTotalField;
    private JTextField adminCostFieldInc;
    private JTextField freightCostFieldInc;
    private JTextField discountFieldInc;
    private JTextField adminCostFieldEx;
    private JTextField freightCostFieldEx;
    private JTextField discountFieldEx;
    private JLabel incGSTLabel1 = new JLabel(INC_GST);
    private JLabel incGSTLabel2 = new JLabel(INC_GST);
    private JLabel incGSTLabel3 = new JLabel(INC_GST);
    private JLabel exGSTLabel1 = new JLabel(EX_GST);
    private JLabel exGSTLabel2 = new JLabel(EX_GST);
    private JLabel exGSTLabel3 = new JLabel(EX_GST);
    private JButton convertButton;
    private JLabel negExpectedTotalLabel = new JLabel(Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
    private JLabel negAdminCostLabel = new JLabel(Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
    private JLabel negFreightCostLabel = new JLabel(Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
    private JLabel negDiscountLabel = new JLabel(Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
    private JComboBox invoiceTypeCombo;
    private JLabel orderNumberLabel;
    private JLabel invoiceNumLabel;
    private JLabel stockAreaLabel;
    private JLabel supplierLabel;
    private JLabel dateLabel;
    private JLabel expectedTotalLabel;
    private JLabel adminCostLabel;
    private JLabel freightCostLabel;
    private JLabel discountLabel;
    private JLabel typeLabel;
    private JPanel adminCostPanel;
    private JPanel freightCostPanel;
    private JPanel discountPanel;
    private String[] usedTableFields = new String[]{"Stock Item", "Quantity", "Bonus", StockInvoiceEntryTemplate.GST, StockInvoiceEntryTemplate.COST_EX_GST, StockInvoiceEntryTemplate.COST_INC_GST, "Cost Override"};
    private JPanel northPanel;
    private JPanel tablesPanel;
    private JPanel eastPanel;
    private JPanel westTablePanel;
    private JPanel totalWrapperPanel;
    private ObjectTotalsPanel totalsPanel;
    private double TAX = SystemProperty.getInstance().getBaseTaxRate();
    private boolean allowMergeInvoiceOption = true;

    @Override
    public void init(ObjectManager objManager, ObjectTemplate objTemplate, Object editObject) {
        int result;
        boolean isPurchaseOrder;
        Assert.isTrue((boolean)this.awaitingInit, (String)"Cannot call init(), object has already been initialised");
        Assert.isEqual(StockInvoice.class, (Object)objTemplate.getObjectJavaClass(), (String)"Template must describe StockItem");
        Assert.isTrue((editObject == null || objTemplate.objectBelongs(editObject) ? 1 : 0) != 0, (String)("Edited object <" + editObject + "> must belong to template \"" + objTemplate + "\""));
        if (editObject != null) {
            Assert.isInstanceOf((Object)editObject, StockInvoice.class, (String)"Edited object must be a StockInvoice");
        }
        this.creatingNew = editObject == null;
        this.manager = objManager;
        this.invoice = (StockInvoice)editObject;
        this.invoiceTemplate = objTemplate;
        this.invoiceEntryTemplate = this.manager.getTemplate(StockInvoiceEntry.class);
        if (this.creatingNew) {
            this.invoice = new StockInvoice();
        }
        this.negExpectedTotalLabel.setName("negExpectedTotalLabel");
        this.negAdminCostLabel.setName("negAdminCostLabel");
        this.negFreightCostLabel.setName("negFreightCostLabel");
        this.negDiscountLabel.setName("negDiscountLabel");
        this.stockAreaLabel = new JLabel("Add stock to: ");
        this.dateLabel = new JLabel("Date: ");
        this.invoiceNumLabel = new JLabel("Invoice number: ");
        this.orderNumberLabel = new JLabel("Order number: ");
        this.supplierLabel = new JLabel("Supplier: ");
        this.adminCostLabel = new JLabel("Admin cost: ");
        this.freightCostLabel = new JLabel("Freight cost: ");
        this.discountLabel = new JLabel("Discount: ");
        this.expectedTotalLabel = new JLabel("Expected total: ");
        this.typeLabel = new JLabel("Type: ");
        this.stockAreaLabel.setHorizontalAlignment(4);
        this.dateLabel.setHorizontalAlignment(4);
        this.invoiceNumLabel.setHorizontalAlignment(4);
        this.orderNumberLabel.setHorizontalAlignment(4);
        this.supplierLabel.setHorizontalAlignment(4);
        this.adminCostLabel.setHorizontalAlignment(4);
        this.freightCostLabel.setHorizontalAlignment(4);
        this.discountLabel.setHorizontalAlignment(4);
        this.expectedTotalLabel.setHorizontalAlignment(4);
        this.typeLabel.setHorizontalAlignment(4);
        this.stockAreaCombo = new JComboBox<Object>(StockArea.getStockAreas().toArray());
        ComponentUtils.setupComboBox((JComboBox)this.stockAreaCombo);
        this.stockAreaCombo.setName("stockAreaCombo");
        OfficeMateAdminGuiUtils.getInstance().standardComboSetup(this.stockAreaCombo);
        if (!this.creatingNew) {
            this.stockAreaCombo.setSelectedItem(this.invoice.getStockArea());
        }
        this.datePanel = (DateFieldPanel)objTemplate.getFieldType("Date").getPanel(this.manager);
        if (!this.creatingNew && this.invoice != null) {
            this.datePanel.setValue(this.invoice.getDate());
        }
        HashSet<AWTKeyStroke> traversalKeys = new HashSet<AWTKeyStroke>();
        traversalKeys.add(AWTKeyStroke.getAWTKeyStroke(9, 0));
        traversalKeys.add(AWTKeyStroke.getAWTKeyStroke(10, 0));
        this.invoiceNumField = new JTextField(this.invoice.getInvoiceNumber());
        this.invoiceNumField.setName("invoiceNumField");
        this.invoiceNumField.addFocusListener(new HighlightFocusListener(this.invoiceNumField));
        this.invoiceNumField.setFocusTraversalKeys(0, traversalKeys);
        this.invoiceNumField.setPreferredSize(new Dimension(120, 10));
        this.orderNumberField = new JTextField(this.invoice.getOrderNumber());
        this.orderNumberField.setName("orderNumberField");
        this.orderNumberField.addFocusListener(new HighlightFocusListener(this.orderNumberField));
        this.orderNumberField.setFocusTraversalKeys(0, traversalKeys);
        this.expectedTotalField = new JTextField();
        this.expectedTotalField.setName("expectedTotalField");
        this.expectedTotalField.addFocusListener(new HighlightFocusListener(this.expectedTotalField));
        this.expectedTotalField.setFocusTraversalKeys(0, traversalKeys);
        InvoiceFocusListener updateListener = new InvoiceFocusListener();
        double adminCostVal = Math.abs(this.invoice.getAdminCost().doubleValue());
        this.adminCostFieldInc = new JTextField(Double.toString(MathsUtils.roundDoubleToDecPlaces((double)adminCostVal, (int)4)));
        this.adminCostFieldInc.setName("adminCostFieldInc");
        this.adminCostFieldInc.setPreferredSize(new Dimension(50, 20));
        this.adminCostFieldInc.addFocusListener(updateListener);
        this.adminCostFieldInc.addFocusListener(new HighlightFocusListener(this.adminCostFieldInc));
        this.adminCostFieldInc.setFocusTraversalKeys(0, traversalKeys);
        this.adminCostFieldEx = new JTextField(Double.toString(MathsUtils.roundDoubleToDecPlaces((double)FinanceUtils.removeTax((double)adminCostVal, (double)this.TAX), (int)4)));
        this.adminCostFieldEx.setPreferredSize(new Dimension(50, 20));
        this.adminCostFieldEx.addFocusListener(updateListener);
        this.adminCostFieldEx.addFocusListener(new HighlightFocusListener(this.adminCostFieldEx));
        this.adminCostFieldEx.setFocusTraversalKeys(0, traversalKeys);
        this.adminCostPanel = new JPanel();
        this.adminCostPanel.setLayout(new BoxLayout(this.adminCostPanel, 0));
        this.adminCostPanel.add(this.adminCostFieldInc);
        this.adminCostPanel.add(this.incGSTLabel1);
        this.adminCostPanel.add(this.adminCostFieldEx);
        this.adminCostPanel.add(this.exGSTLabel1);
        double freightCostVal = Math.abs(this.invoice.getFreightCost().doubleValue());
        this.freightCostFieldInc = new JTextField(Double.toString(MathsUtils.roundDoubleToDecPlaces((double)freightCostVal, (int)4)));
        this.freightCostFieldInc.setName("freightCostFieldInc");
        this.freightCostFieldInc.setPreferredSize(new Dimension(50, 20));
        this.freightCostFieldInc.addFocusListener(updateListener);
        this.freightCostFieldInc.addFocusListener(new HighlightFocusListener(this.freightCostFieldInc));
        this.freightCostFieldInc.setFocusTraversalKeys(0, traversalKeys);
        this.freightCostFieldEx = new JTextField(Double.toString(MathsUtils.roundDoubleToDecPlaces((double)FinanceUtils.removeTax((double)freightCostVal, (double)this.TAX), (int)4)));
        this.freightCostFieldEx.setPreferredSize(new Dimension(50, 20));
        this.freightCostFieldEx.addFocusListener(updateListener);
        this.freightCostFieldEx.addFocusListener(new HighlightFocusListener(this.freightCostFieldEx));
        this.freightCostFieldEx.setFocusTraversalKeys(0, traversalKeys);
        this.freightCostPanel = new JPanel();
        this.freightCostPanel.setLayout(new BoxLayout(this.freightCostPanel, 0));
        this.freightCostPanel.add(this.freightCostFieldInc);
        this.freightCostPanel.add(this.incGSTLabel2);
        this.freightCostPanel.add(this.freightCostFieldEx);
        this.freightCostPanel.add(this.exGSTLabel2);
        double discountVal = Math.abs(this.invoice.getDiscount().doubleValue());
        this.discountFieldInc = new JTextField(Double.toString(MathsUtils.roundDoubleToDecPlaces((double)discountVal, (int)4)));
        this.discountFieldInc.setName("discountFieldInc");
        this.discountFieldInc.setPreferredSize(new Dimension(50, 20));
        this.discountFieldInc.addFocusListener(updateListener);
        this.discountFieldInc.addFocusListener(new HighlightFocusListener(this.discountFieldInc));
        this.discountFieldInc.setFocusTraversalKeys(0, traversalKeys);
        this.discountFieldEx = new JTextField(Double.toString(MathsUtils.roundDoubleToDecPlaces((double)FinanceUtils.removeTax((double)discountVal, (double)this.TAX), (int)4)));
        this.discountFieldEx.setName("discountFieldEx");
        this.discountFieldEx.setPreferredSize(new Dimension(50, 20));
        this.discountFieldEx.addFocusListener(updateListener);
        this.discountFieldEx.addFocusListener(new HighlightFocusListener(this.discountFieldEx));
        this.discountFieldEx.setFocusTraversalKeys(0, traversalKeys);
        this.discountPanel = new JPanel();
        this.discountPanel.setLayout(new BoxLayout(this.discountPanel, 0));
        this.discountPanel.add(this.discountFieldInc);
        this.discountPanel.add(this.incGSTLabel3);
        this.discountPanel.add(this.discountFieldEx);
        this.discountPanel.add(this.exGSTLabel3);
        this.supplierCombo = new JComboBox<Object>(StockSupplier.getSuppliers().toArray());
        this.supplierCombo.setName("supplierCombo");
        ComponentUtils.setupComboBox((JComboBox)this.supplierCombo);
        OfficeMateAdminGuiUtils.getInstance().standardComboSetup(this.supplierCombo);
        if (!this.creatingNew) {
            this.supplierCombo.setSelectedItem(this.invoice.getSupplier());
        }
        this.invoiceTypeCombo = new JComboBox<String>(new String[]{"Invoice", "Credit Note", "Delivery Note"});
        ComponentUtils.setupComboBox((JComboBox)this.invoiceTypeCombo);
        this.invoiceTypeCombo.setName("invoiceTypeCombo");
        this.invoiceTypeCombo.setSelectedItem(this.invoice.getInvoiceType());
        this.invoiceTypeCombo.addActionListener(new InvoiceTypeActionListener());
        this.invoiceTypeCombo.setFocusable(false);
        Date date = this.invoice.getDate();
        if (date == null) {
            date = new Date();
        }
        this.datePanelDecorator = new StandardSecurityDecorator((JComponent)this.datePanel, AllPermissions.STOCK_INVOICE_DATE_CORRECTION);
        this.setupGUI();
        this.setupTable();
        this.setupTotalsPanel();
        this.updateButtonStates();
        if (!this.creatingNew) {
            Price expectedTotal = this.invoice.getExpectedTotal();
            String totalString = "";
            if (expectedTotal != null) {
                double expectedTotalVal = expectedTotal.doubleValue();
                totalString = String.valueOf(Math.abs(expectedTotalVal));
            }
            this.expectedTotalField.setText(totalString);
        }
        this.updateNegativeLabels();
        if (this.invoice.isFrozen()) {
            this.buttonPanel.enableAddButton(false);
            this.buttonPanel.enableRemoveButton(false);
            this.stockAreaCombo.setEnabled(false);
            this.supplierCombo.setEnabled(false);
            this.datePanelDecorator.setEnabled(false);
            this.orderNumberField.setEnabled(false);
            this.invoiceNumField.setEnabled(false);
            this.expectedTotalField.setEnabled(false);
            this.adminCostFieldInc.setEnabled(false);
            this.freightCostFieldInc.setEnabled(false);
            this.discountFieldInc.setEnabled(false);
            this.adminCostFieldEx.setEnabled(false);
            this.freightCostFieldEx.setEnabled(false);
            this.discountFieldEx.setEnabled(false);
            this.invoiceTypeCombo.setEnabled(false);
            if (this.convertButton != null) {
                this.convertButton.setEnabled(false);
            }
        }
        this.invoiceNumField.setVisible(!(isPurchaseOrder = this.invoice.getInvoiceType().equals("Purchase Order")));
        this.adminCostFieldInc.setVisible(!isPurchaseOrder);
        this.freightCostFieldInc.setVisible(!isPurchaseOrder);
        this.discountFieldInc.setVisible(!isPurchaseOrder);
        this.adminCostFieldEx.setVisible(!isPurchaseOrder);
        this.freightCostFieldEx.setVisible(!isPurchaseOrder);
        this.discountFieldEx.setVisible(!isPurchaseOrder);
        this.expectedTotalField.setVisible(!isPurchaseOrder);
        this.supplierCombo.setVisible(!isPurchaseOrder);
        this.invoiceNumLabel.setVisible(!isPurchaseOrder);
        this.expectedTotalLabel.setVisible(!isPurchaseOrder);
        this.adminCostLabel.setVisible(!isPurchaseOrder);
        this.freightCostLabel.setVisible(!isPurchaseOrder);
        this.discountLabel.setVisible(!isPurchaseOrder);
        this.negExpectedTotalLabel.setVisible(!isPurchaseOrder);
        this.negAdminCostLabel.setVisible(!isPurchaseOrder);
        this.negFreightCostLabel.setVisible(!isPurchaseOrder);
        this.negDiscountLabel.setVisible(!isPurchaseOrder);
        this.incGSTLabel1.setVisible(!isPurchaseOrder);
        this.incGSTLabel2.setVisible(!isPurchaseOrder);
        this.incGSTLabel3.setVisible(!isPurchaseOrder);
        this.exGSTLabel1.setVisible(!isPurchaseOrder);
        this.exGSTLabel2.setVisible(!isPurchaseOrder);
        this.exGSTLabel3.setVisible(!isPurchaseOrder);
        if (isPurchaseOrder) {
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            model.addElement("Purchase Order");
            this.invoiceTypeCombo.setModel(model);
            this.invoiceTypeCombo.setEnabled(false);
        }
        this.convertButton.setVisible(isPurchaseOrder);
        if (this.creatingNew) {
            this.invoice.setStockArea((StockArea)this.stockAreaCombo.getSelectedItem());
        }
        if (!this.invoice.isFrozen() && !this.creatingNew && this.invoice.getInvoiceType().equals("Delivery Note") && (result = JOptionPane.showConfirmDialog(this.frame.getFrame(), "Would you like to convert this Delivery Note into an Invoice?")) == 0) {
            this.invoice.setInvoiceType("Invoice");
            this.invoiceTypeCombo.setSelectedItem("Invoice");
        }
        this.awaitingInit = false;
    }

    private void updateNegativeLabels() {
        if (this.invoice.getInvoiceType().equals("Credit Note")) {
            this.negAdminCostLabel.setText("-" + Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
            this.negFreightCostLabel.setText("-" + Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
            this.negDiscountLabel.setText("-" + Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
            this.negExpectedTotalLabel.setText("-" + Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
        } else {
            this.negAdminCostLabel.setText(" " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
            this.negFreightCostLabel.setText(" " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
            this.negDiscountLabel.setText(" " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
            this.negExpectedTotalLabel.setText(" " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
        }
    }

    private void setupGUI() {
        this.setLayout(new BorderLayout());
        this.convertButton = new JButton("Convert to invoice");
        this.convertButton.setName("convertPOToInvoice");
        this.convertButton.setToolTipText("Converts this purchase order to an invoice.");
        this.convertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Assert.isEqual((Object)"Purchase Order", (Object)StockInvoiceEditorPanel.this.invoice.getInvoiceType(), (String)"Invoice to convert must be a purchase order");
                if (Dialogs.showChoiceDialog("Warning", "<HTML>You are about to change a 'Purchase Order' into an 'Invoice'!<BR> Do you really want to continue?")) {
                    StockInvoiceEditorPanel.this.invoice.setStockArea((StockArea)StockInvoiceEditorPanel.this.stockAreaCombo.getSelectedItem());
                    StockInvoiceEditorPanel.this.deletePurchaseOrder = true;
                    StockInvoiceEditorPanel.this.oldPurchaseOrder = StockInvoiceEditorPanel.this.invoice;
                    StockInvoice convertedInvoice = StockInvoiceEditorPanel.this.invoice.convertPurchaseOrderToInvoice();
                    StockInvoiceEditorPanel.this.removeAll();
                    StockInvoiceEditorPanel.this.awaitingInit = true;
                    StockInvoiceEditorPanel.this.init(StockInvoiceEditorPanel.this.manager, StockInvoiceEditorPanel.this.invoiceTemplate, convertedInvoice);
                    StockInvoiceEditorPanel.this.revalidate();
                    StockInvoiceEditorPanel.this.repaint();
                }
            }
        });
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints defaultGrid = new GridBagConstraints();
        defaultGrid.gridwidth = 1;
        defaultGrid.gridheight = 1;
        defaultGrid.weighty = 1.0;
        defaultGrid.insets = new Insets(2, 5, 2, 5);
        defaultGrid.fill = 1;
        defaultGrid.anchor = 18;
        this.northPanel = new JPanel(gridBag);
        defaultGrid.gridx = 0;
        defaultGrid.gridy = 0;
        defaultGrid.weightx = 0.0;
        gridBag.setConstraints(this.orderNumberLabel, defaultGrid);
        this.northPanel.add(this.orderNumberLabel);
        defaultGrid.gridx = 1;
        defaultGrid.gridy = 0;
        defaultGrid.weightx = 0.0;
        defaultGrid.anchor = 13;
        Component glue = Box.createHorizontalStrut(15);
        gridBag.setConstraints(glue, defaultGrid);
        this.northPanel.add(glue);
        defaultGrid.gridx = 2;
        defaultGrid.gridy = 0;
        defaultGrid.weightx = 1.0;
        defaultGrid.anchor = 18;
        gridBag.setConstraints(this.orderNumberField, defaultGrid);
        this.northPanel.add(this.orderNumberField);
        defaultGrid.gridx = 0;
        defaultGrid.gridy = 1;
        defaultGrid.weightx = 0.0;
        gridBag.setConstraints(this.invoiceNumLabel, defaultGrid);
        this.northPanel.add(this.invoiceNumLabel);
        defaultGrid.gridx = 2;
        defaultGrid.gridy = 1;
        defaultGrid.weightx = 1.0;
        gridBag.setConstraints(this.invoiceNumField, defaultGrid);
        this.northPanel.add(this.invoiceNumField);
        defaultGrid.gridx = 3;
        defaultGrid.gridy = 0;
        defaultGrid.weightx = 0.0;
        gridBag.setConstraints(this.dateLabel, defaultGrid);
        this.northPanel.add(this.dateLabel);
        defaultGrid.gridx = 4;
        defaultGrid.gridy = 0;
        defaultGrid.weightx = 0.0;
        gridBag.setConstraints(this.datePanelDecorator, defaultGrid);
        this.northPanel.add(this.datePanelDecorator);
        defaultGrid.gridx = 3;
        defaultGrid.gridy = 1;
        defaultGrid.weightx = 0.0;
        gridBag.setConstraints(this.stockAreaLabel, defaultGrid);
        this.northPanel.add(this.stockAreaLabel);
        defaultGrid.gridx = 4;
        defaultGrid.gridy = 1;
        defaultGrid.weightx = 0.0;
        gridBag.setConstraints(this.stockAreaCombo, defaultGrid);
        this.northPanel.add(this.stockAreaCombo);
        defaultGrid.gridx = 3;
        defaultGrid.gridy = 2;
        defaultGrid.weightx = 0.0;
        gridBag.setConstraints(this.supplierLabel, defaultGrid);
        this.northPanel.add(this.supplierLabel);
        defaultGrid.gridx = 4;
        defaultGrid.gridy = 2;
        defaultGrid.weightx = 0.0;
        gridBag.setConstraints(this.supplierCombo, defaultGrid);
        this.northPanel.add(this.supplierCombo);
        defaultGrid.gridx = 0;
        defaultGrid.gridy = 2;
        defaultGrid.weightx = 0.0;
        gridBag.setConstraints(this.adminCostLabel, defaultGrid);
        this.northPanel.add(this.adminCostLabel);
        defaultGrid.gridx = 1;
        defaultGrid.gridy = 2;
        defaultGrid.weightx = 0.0;
        defaultGrid.fill = 0;
        defaultGrid.anchor = 13;
        gridBag.setConstraints(this.negAdminCostLabel, defaultGrid);
        this.northPanel.add(this.negAdminCostLabel);
        defaultGrid.gridx = 2;
        defaultGrid.gridy = 2;
        defaultGrid.weightx = 1.0;
        defaultGrid.fill = 1;
        defaultGrid.anchor = 18;
        gridBag.setConstraints(this.adminCostPanel, defaultGrid);
        this.northPanel.add(this.adminCostPanel);
        defaultGrid.gridx = 0;
        defaultGrid.gridy = 3;
        defaultGrid.weightx = 0.0;
        gridBag.setConstraints(this.freightCostLabel, defaultGrid);
        this.northPanel.add(this.freightCostLabel);
        defaultGrid.gridx = 1;
        defaultGrid.gridy = 3;
        defaultGrid.weightx = 0.0;
        defaultGrid.fill = 0;
        defaultGrid.anchor = 13;
        gridBag.setConstraints(this.negFreightCostLabel, defaultGrid);
        this.northPanel.add(this.negFreightCostLabel);
        defaultGrid.gridx = 2;
        defaultGrid.gridy = 3;
        defaultGrid.weightx = 1.0;
        defaultGrid.fill = 1;
        defaultGrid.anchor = 18;
        gridBag.setConstraints(this.freightCostPanel, defaultGrid);
        this.northPanel.add(this.freightCostPanel);
        defaultGrid.gridx = 0;
        defaultGrid.gridy = 4;
        defaultGrid.weightx = 0.0;
        gridBag.setConstraints(this.discountLabel, defaultGrid);
        this.northPanel.add(this.discountLabel);
        defaultGrid.gridx = 1;
        defaultGrid.gridy = 4;
        defaultGrid.weightx = 0.0;
        defaultGrid.fill = 0;
        defaultGrid.anchor = 13;
        gridBag.setConstraints(this.negDiscountLabel, defaultGrid);
        this.northPanel.add(this.negDiscountLabel);
        defaultGrid.gridx = 2;
        defaultGrid.gridy = 4;
        defaultGrid.weightx = 1.0;
        defaultGrid.fill = 1;
        defaultGrid.anchor = 18;
        gridBag.setConstraints(this.discountPanel, defaultGrid);
        this.northPanel.add(this.discountPanel);
        defaultGrid.gridx = 0;
        defaultGrid.gridy = 5;
        defaultGrid.weightx = 0.0;
        gridBag.setConstraints(this.expectedTotalLabel, defaultGrid);
        this.northPanel.add(this.expectedTotalLabel);
        defaultGrid.gridx = 1;
        defaultGrid.gridy = 5;
        defaultGrid.weightx = 0.0;
        defaultGrid.fill = 0;
        defaultGrid.anchor = 13;
        gridBag.setConstraints(this.negExpectedTotalLabel, defaultGrid);
        this.northPanel.add(this.negExpectedTotalLabel);
        defaultGrid.gridx = 2;
        defaultGrid.gridy = 5;
        defaultGrid.weightx = 1.0;
        defaultGrid.fill = 1;
        defaultGrid.anchor = 18;
        gridBag.setConstraints(this.expectedTotalField, defaultGrid);
        this.northPanel.add(this.expectedTotalField);
        defaultGrid.gridx = 4;
        defaultGrid.gridy = 3;
        defaultGrid.weightx = 0.0;
        gridBag.setConstraints(this.invoiceTypeCombo, defaultGrid);
        this.northPanel.add(this.invoiceTypeCombo);
        defaultGrid.gridx = 3;
        defaultGrid.gridy = 3;
        defaultGrid.weightx = 0.0;
        gridBag.setConstraints(this.typeLabel, defaultGrid);
        this.northPanel.add(this.typeLabel);
        defaultGrid.gridx = 0;
        defaultGrid.gridy = 1;
        defaultGrid.weightx = 0.0;
        gridBag.setConstraints(this.convertButton, defaultGrid);
        this.northPanel.add(this.convertButton);
        this.tablesPanel = new JPanel(new BorderLayout());
        this.eastPanel = new JPanel(new BorderLayout());
        this.add((Component)this.northPanel, "North");
        this.add((Component)this.eastPanel, "East");
    }

    private void setupTotalsPanel() {
        boolean[] doTotalFields = new boolean[]{true, true, true, true, true, true, true};
        this.totalWrapperPanel = new JPanel(new BorderLayout());
        this.totalWrapperPanel.setName("totalWrapperPanel");
        this.totalWrapperPanel.add((Component)new JLabel("Totals:"), "North");
        this.totalsPanel = new StockInvoiceTotalsPanel(this.invoice.getEntries(), this.invoiceEntryTemplate, this.usedTableFields, doTotalFields, null, this.invoice);
        this.totalsPanel.getJTable().setFocusable(false);
        this.totalsPanel.setColumnModelToImitate(this.table.getColumnModel());
        this.totalWrapperPanel.add((Component)this.totalsPanel, "South");
        this.westTablePanel.add((Component)this.totalWrapperPanel, "South");
        this.totalsPanel.update();
    }

    private void setupTable() {
        this.buttonPanel = new AddRemoveButtonPanel.AddRemovePanelBuilder().setAllowPrint(true).setAddPermission(StockInvoicePermission.getAddPermission(this.invoice)).setRemovePermission(StockInvoicePermission.getRemovePermission(this.invoice)).build();
        this.buttonPanel.addPressed.connect((Object)this, "addObject");
        this.buttonPanel.editPressed.connect((Object)this, "editObject");
        this.buttonPanel.removePressed.connect((Object)this, "removeObject");
        this.buttonPanel.printPressed.connect((Object)this, "gotPrintPressed");
        this.table = new DefaultObjectTable(this.invoiceEntryTemplate, this.usedTableFields, null);
        this.table.setName("stockEntryTable");
        OfficeMateAdminGuiUtils.getInstance().standardTableSetup(this.table);
        this.table.setFocusable(false);
        this.table.objectSelected.connect((Object)this, "gotTableObjectSelected");
        this.table.objectChosen.connect((Object)this, "editObject");
        List entries = this.invoice.getEntries();
        for (StockInvoiceEntry entry : entries) {
            this.table.addObject(entry);
        }
        this.westTablePanel = new JPanel(new BorderLayout());
        this.table.getScroller().setName("tablePanel");
        this.westTablePanel.add((Component)this.table.getScroller(), "Center");
        this.tablesPanel.add((Component)this.westTablePanel, "Center");
        this.eastPanel.add((Component)this.buttonPanel, "North");
        this.add((Component)this.tablesPanel, "Center");
    }

    void gotPrintPressed() {
        if (this.invoice.getInvoiceType().equals("Purchase Order")) {
            PurchaseOrderReportProvider provider = new PurchaseOrderReportProvider(this.invoice.getEntries(), this.invoice.getSupplier());
            provider.addParam("PARAM_PO_NO", this.invoice.getLabel());
            provider.addParam("PARAM_PO_DATE", this.invoice.getDate());
            Dialogs.showJasperPrintDialog((ReportProvider)provider, this.frame.getFrame(), true);
        } else {
            StockSupplier supplier = this.invoice.getSupplier();
            String title = this.invoice.getInvoiceType() + ": " + this.invoice.getInvoiceNumber() + (!this.invoice.getOrderNumber().trim().equals("") ? " Order: " + this.invoice.getOrderNumber() : "") + " (" + DateTimeUtils.getLongFormat().format(this.invoice.getDate()) + ")";
            Printing.printJTableReport(this.table, title, "", 8, this.totalsPanel.getColumnValues(), supplier, false);
        }
    }

    void gotTableObjectSelected() {
        this.updateButtonStates();
    }

    void addObject() {
        if (StockItemQueries.stockItemsExist()) {
            this.frame.setStatusBarText("Creating invoice entry...");
            StockSupplier supplier = (StockSupplier)this.supplierCombo.getSelectedItem();
            StockInvoiceEntryEditorPanel editorView = new StockInvoiceEntryEditorPanel(supplier);
            editorView.setInvoice(this.invoice);
            editorView.init(this.manager, this.invoiceEntryTemplate, null);
            while (ObjectEditorDialog.doDialog(this.frame.getFrame(), (ObjectEditorPanel)editorView, true) == 0) {
                editorView.saveObject();
                StockInvoiceEntry entry = (StockInvoiceEntry)editorView.getEditedObject();
                Assert.isTrue((entry != null ? 1 : 0) != 0, (String)"Edited StockInvoiceEntry may not be null");
                this.table.addObject(entry);
                this.totalsPanel.setObjects(this.table.getObjectModel().getObjects());
                StockControlEventLog.logCreateStockInvoiceEntry((User)this.security.getUser(), (StockInvoiceEntry)entry);
                editorView = new StockInvoiceEntryEditorPanel(supplier);
                editorView.setInvoice(this.invoice);
                editorView.init(this.manager, this.invoiceEntryTemplate, null);
            }
            editorView.cancelObject();
            this.frame.resetStatusBarText();
            this.repaint();
        } else {
            JOptionPane.showMessageDialog(this, "No stock items have yet been configured; nothing can be added to invoice.", "Can't add invoice", 2);
        }
    }

    void editObject() {
        Object obj = this.table.getSelectedObject();
        ObjectChangeRecorder changeRecord = new ObjectChangeRecorder(this.invoiceEntryTemplate);
        changeRecord.snapshot(obj);
        Assert.isTrue((obj != null ? 1 : 0) != 0, (String)"Object selected for editing may not be null");
        StockSupplier supplier = (StockSupplier)this.supplierCombo.getSelectedItem();
        StockInvoiceEntryEditorPanel editorView = new StockInvoiceEntryEditorPanel(supplier);
        editorView.setInvoice(this.invoice);
        editorView.init(this.manager, this.invoiceEntryTemplate, obj);
        if (ObjectEditorDialog.doDialog(this.frame.getFrame(), editorView) == 0) {
            editorView.saveObject();
            StockInvoiceEntry invoiceEntry = (StockInvoiceEntry)editorView.getEditedObject();
            List<ObjectChange> changes = changeRecord.getChanges(invoiceEntry);
            StockControlEventLog.logEditStockInvoiceEntry((User)this.security.getUser(), (StockInvoiceEntry)invoiceEntry, changes);
            this.totalsPanel.update();
            this.table.revalidate();
            this.repaint();
        } else {
            editorView.cancelObject();
        }
    }

    void removeObject() {
        int selRow = this.table.getSelectedRow();
        StockInvoiceEntry entry = (StockInvoiceEntry)this.table.getSelectedObject();
        ObjectTemplate template = this.table.getTemplate();
        this.frame.setStatusBarText("Removing " + template.getName() + ":  " + template.getObjectText(entry));
        StockControlEventLog.logDeleteStockInvoiceEntry((User)this.security.getUser(), (StockInvoiceEntry)entry);
        this.table.removeObject(entry);
        this.invoice.removeEntry(entry);
        int rowCount = this.table.getModel().getRowCount();
        this.table.requestFocus();
        if (selRow < rowCount) {
            this.table.setRowSelectionInterval(selRow, selRow);
        } else if (rowCount > 0) {
            this.table.setRowSelectionInterval(rowCount - 1, rowCount - 1);
        }
        this.updateButtonStates();
        this.totalsPanel.setObjects(this.table.getObjectModel().getObjects());
        this.totalsPanel.repaint();
        this.repaint();
    }

    private void updateButtonStates() {
        boolean objectSelected = this.table.getSelectedObject() != null;
        this.buttonPanel.enableEditButton(objectSelected);
        this.buttonPanel.enableRemoveButton(objectSelected && !this.invoice.isFrozen());
    }

    private Price priceFromString(String text) {
        double retval = 0.0;
        try {
            retval = Double.parseDouble(text);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new Price(retval, 0.0);
    }

    private Price getExpectedTotal() {
        String text = this.expectedTotalField.getText();
        return this.priceFromString(text);
    }

    private Price getAdminCostFieldInc() {
        String text = this.adminCostFieldInc.getText();
        return this.priceFromString(text);
    }

    private Price getFreightCostFieldInc() {
        String text = this.freightCostFieldInc.getText();
        return this.priceFromString(text);
    }

    private Price getDiscountFieldInc() {
        String text = this.discountFieldInc.getText();
        return this.priceFromString(text);
    }

    private Price getAdminCostFieldEx() {
        String text = this.adminCostFieldEx.getText();
        return this.priceFromString(text);
    }

    private Price getFreightCostFieldEx() {
        String text = this.freightCostFieldEx.getText();
        return this.priceFromString(text);
    }

    private Price getDiscountFieldEx() {
        String text = this.discountFieldEx.getText();
        return this.priceFromString(text);
    }

    @Override
    public void saveObject() {
        if (StockTake.hasLiveStockTake() && !Dialogs.showChoiceDialog("Open stocktake warning", "<HTML>There is a live stocktake.<BR> By entering this invoice the expected quantity<BR>will change, but any counted quantities will not.<P>Do you want to continue?")) {
            return;
        }
        this.assignObjectProperties();
        if (this.deletePurchaseOrder && this.oldPurchaseOrder != null && this.oldPurchaseOrder.isPersistent()) {
            this.oldPurchaseOrder.delete();
        }
        this.invoice.save();
    }

    public void assignObjectProperties() {
        Date date = (Date)this.datePanel.getValue();
        this.invoice.setOrderNumber(this.orderNumberField.getText().trim());
        this.invoice.setInvoiceNumber(this.invoiceNumField.getText().trim());
        this.invoice.setSupplier((StockSupplier)this.supplierCombo.getSelectedItem());
        this.invoice.setDate(date);
        String invoiceType = (String)this.invoiceTypeCombo.getSelectedItem();
        this.invoice.setInvoiceType(invoiceType);
        StockArea newStockArea = (StockArea)this.stockAreaCombo.getSelectedItem();
        this.invoice.setStockArea(newStockArea);
        if (invoiceType.equals("Credit Note")) {
            this.invoice.setExpectedTotal(new Price(-this.getExpectedTotal().doubleValue(), 0.0));
            this.invoice.setAdminCost(new Price(-this.getAdminCostFieldInc().doubleValue(), 0.01));
            this.invoice.setFreightCost(new Price(-this.getFreightCostFieldInc().doubleValue(), 0.01));
            this.invoice.setDiscount(new Price(-this.getDiscountFieldInc().doubleValue(), 0.01));
        } else {
            this.invoice.setExpectedTotal(this.getExpectedTotal());
            this.invoice.setAdminCost(this.getAdminCostFieldInc());
            this.invoice.setFreightCost(this.getFreightCostFieldInc());
            this.invoice.setDiscount(this.getDiscountFieldInc());
        }
    }

    @Override
    public boolean requestSaveAllowed() {
        boolean frozen;
        Date theDate;
        String orderNum = this.orderNumberField.getText();
        String invoiceNum = this.invoiceNumField.getText();
        String invoiceType = (String)this.invoiceTypeCombo.getSelectedItem();
        if (!invoiceType.equals("Purchase Order")) {
            if (invoiceNum == null || invoiceNum.length() == 0) {
                JOptionPane.showMessageDialog(this, "'Invoice Number' field must not be blank.", "Can't save invoice", 2);
                return false;
            }
            StockInvoice forNumber = StockInvoice.getStockInvoiceForNumber((String)invoiceNum);
            if (forNumber != null && !forNumber.equals((Object)this.invoice)) {
                if (this.allowMergeInvoiceOption) {
                    if (JOptionPane.showConfirmDialog(this, "Invoice number must be unique; another invoice has \nalready taken this invoice number.\n\nIf you continue this Invoice will only be able to be merged \nunless you change the Invoice Number.", "Invoice number already exists", 2) == 2) {
                        return false;
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "Invoice number must be unique; another invoice has \nalready taken this invoice number.", "Can't save invoice", 2);
                    return false;
                }
            }
            Number actualTotal = this.totalsPanel.getTotal("Cost");
            Price expectedTotal = this.getExpectedTotal();
            if (expectedTotal != null && actualTotal != null) {
                int result;
                double roundedExpected;
                boolean totalsDontMatch;
                double roundedActual = Math.abs(MathsUtils.roundDoubleToDecPlaces((double)actualTotal.doubleValue(), (int)2));
                boolean bl = totalsDontMatch = roundedActual != (roundedExpected = Math.abs(MathsUtils.roundDoubleToDecPlaces((double)expectedTotal.doubleValue(), (int)2)));
                if (totalsDontMatch && (result = JOptionPane.showConfirmDialog(this, "The invoice total does not match the expected total, are you sure you want to save the invoice?", "Non-matching total", 0, 2)) != 0) {
                    return false;
                }
            }
        } else if (orderNum == null || orderNum.length() == 0) {
            JOptionPane.showMessageDialog(this, "'Order Number' field must not be blank.", "Can't save purchase order", 2);
            return false;
        }
        if ((theDate = (Date)this.datePanel.getValue()) == null) {
            JOptionPane.showMessageDialog(this, "A date must be entered for the invoice.");
            return false;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(theDate);
        int year = cal.get(1);
        if (year < 100) {
            cal.set(1, year + 2000);
            this.datePanel.setValue(cal.getTime());
        } else if (year < 1900) {
            JOptionPane.showMessageDialog(this, year + " is not a valid year.");
            return false;
        }
        Date date = DateTimeUtils.getEndOfDay((Date)((Date)this.datePanel.getValue()));
        StockTake stockTake = StockTake.getLastSavedStockTake();
        boolean bl = frozen = this.invoice != null && this.invoice.isFrozen();
        if (!frozen && stockTake != null && date.before(stockTake.getDate())) {
            JOptionPane.showMessageDialog(this, "The invoice date must be more recent than the last stocktake. (" + new DateDMY_HM(stockTake.getDate()) + ") \nPlease choose a more recent date. ", "Can't create invoice", 2);
            return false;
        }
        return true;
    }

    @Override
    public boolean requestCancelAllowed() {
        int result = JOptionPane.showConfirmDialog(this, "Are you sure you wish to cancel changes made? \nAll changes will be lost.", "Cancel changes?", 0, 2);
        return result == 0;
    }

    @Override
    public Object getEditedObject() {
        return this.invoice;
    }

    @Override
    public ObjectTemplate getTemplate() {
        return this.invoiceTemplate;
    }

    @Override
    public void cancelObject() {
        this.deletePurchaseOrder = false;
    }

    @Override
    public boolean isNewObject() {
        return this.creatingNew;
    }

    @Override
    public int getDialogMode() {
        if (this.invoice != null && this.invoice.isFrozen()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean requestCloseAllowed() {
        return this.getDialogMode() == 1;
    }

    public void setAllowMergeInvoiceOption(boolean value) {
        this.allowMergeInvoiceOption = value;
    }

    private class InvoiceFocusListener
    implements FocusListener {
        private InvoiceFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            Object src = e.getSource();
            if (src == StockInvoiceEditorPanel.this.adminCostFieldInc) {
                double adminCostInc = StockInvoiceEditorPanel.this.getAdminCostFieldInc().doubleValue();
                StockInvoiceEditorPanel.this.adminCostFieldEx.setText(Double.toString(MathsUtils.roundDouble((double)MathsUtils.roundDoubleToDecPlaces((double)FinanceUtils.removeTax((double)adminCostInc, (double)StockInvoiceEditorPanel.this.TAX), (int)4), (double)0.0)));
                StockInvoiceEditorPanel.this.invoice.setAdminCost(new Price(adminCostInc, 0.0));
            } else if (src == StockInvoiceEditorPanel.this.freightCostFieldInc) {
                double freightCostInc = StockInvoiceEditorPanel.this.getFreightCostFieldInc().doubleValue();
                StockInvoiceEditorPanel.this.freightCostFieldEx.setText(Double.toString(MathsUtils.roundDouble((double)MathsUtils.roundDoubleToDecPlaces((double)FinanceUtils.removeTax((double)freightCostInc, (double)StockInvoiceEditorPanel.this.TAX), (int)4), (double)0.0)));
                StockInvoiceEditorPanel.this.invoice.setFreightCost(new Price(freightCostInc, 0.0));
            } else if (src == StockInvoiceEditorPanel.this.discountFieldInc) {
                double discountInc = StockInvoiceEditorPanel.this.getDiscountFieldInc().doubleValue();
                StockInvoiceEditorPanel.this.discountFieldEx.setText(Double.toString(MathsUtils.roundDouble((double)MathsUtils.roundDoubleToDecPlaces((double)FinanceUtils.removeTax((double)discountInc, (double)StockInvoiceEditorPanel.this.TAX), (int)4), (double)0.0)));
                StockInvoiceEditorPanel.this.invoice.setDiscount(new Price(discountInc, 0.0));
            } else if (src == StockInvoiceEditorPanel.this.adminCostFieldEx) {
                double adminCostEx = StockInvoiceEditorPanel.this.getAdminCostFieldEx().doubleValue();
                double adminCostInc = FinanceUtils.addTax((double)adminCostEx, (double)StockInvoiceEditorPanel.this.TAX);
                StockInvoiceEditorPanel.this.adminCostFieldInc.setText(Double.toString(MathsUtils.roundDoubleToDecPlaces((double)adminCostInc, (int)4)));
                StockInvoiceEditorPanel.this.invoice.setAdminCost(new Price(adminCostInc, 0.0));
            } else if (src == StockInvoiceEditorPanel.this.freightCostFieldEx) {
                double freightCostEx = StockInvoiceEditorPanel.this.getFreightCostFieldEx().doubleValue();
                double freightCostInc = FinanceUtils.addTax((double)freightCostEx, (double)StockInvoiceEditorPanel.this.TAX);
                StockInvoiceEditorPanel.this.freightCostFieldInc.setText(Double.toString(MathsUtils.roundDoubleToDecPlaces((double)freightCostInc, (int)4)));
                StockInvoiceEditorPanel.this.invoice.setFreightCost(new Price(freightCostInc, 0.0));
            } else if (src == StockInvoiceEditorPanel.this.discountFieldEx) {
                double discountEx = StockInvoiceEditorPanel.this.getDiscountFieldEx().doubleValue();
                double discountInc = FinanceUtils.addTax((double)discountEx, (double)StockInvoiceEditorPanel.this.TAX);
                StockInvoiceEditorPanel.this.discountFieldInc.setText(Double.toString(MathsUtils.roundDoubleToDecPlaces((double)discountInc, (int)4)));
                StockInvoiceEditorPanel.this.invoice.setDiscount(new Price(discountInc, 0.0));
            }
            StockInvoiceEditorPanel.this.totalsPanel.update();
        }

        @Override
        public void focusGained(FocusEvent e) {
        }
    }

    private static class HighlightFocusListener
    implements FocusListener {
        private JTextComponent textComp;

        HighlightFocusListener(JTextComponent comp) {
            this.textComp = comp;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.textComp.setSelectionStart(0);
            this.textComp.setSelectionEnd(this.textComp.getText().length());
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    private class InvoiceTypeActionListener
    implements ActionListener {
        private InvoiceTypeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == StockInvoiceEditorPanel.this.invoiceTypeCombo) {
                StockInvoiceEditorPanel.this.invoice.setInvoiceType((String)StockInvoiceEditorPanel.this.invoiceTypeCombo.getSelectedItem());
                StockInvoiceEditorPanel.this.buttonPanel.setAddBtnPermission(StockInvoicePermission.getAddPermission(StockInvoiceEditorPanel.this.invoice));
                StockInvoiceEditorPanel.this.buttonPanel.setRemoveBtnPermission(StockInvoicePermission.getRemovePermission(StockInvoiceEditorPanel.this.invoice));
            }
            StockInvoiceEditorPanel.this.updateNegativeLabels();
            StockInvoiceEditorPanel.this.table.repaint();
            StockInvoiceEditorPanel.this.totalsPanel.update();
            StockInvoiceEditorPanel.this.totalsPanel.repaint();
        }
    }
}

