/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.invoice;

import au.com.ordermate.application.ApplicationContext;
import au.com.ordermate.application.ApplicationFrame;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.sql.SQL;
import au.com.ordermate.sql.queries.SelectQuery;
import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import officemate.adminkit.ObjectEditorPanel;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.dialogs.ObjectEditorDialog;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.list.QueryListModel;
import officemate.adminkit.search.SearchDialog;
import officemate.adminkit.searchpanels.StockItemSearchPanel;
import officemate.adminkit.templates.Templates;
import officemate.screens.maintainstock.invoice.StockInvoicePermission;
import officemate.screens.setup.stock.items.StockItemEditorPanel;
import ordermate.database.config.Quantity;
import ordermate.database.misc.SystemProperty;
import ordermate.database.queries.stock.StockItemQueries;
import ordermate.database.stock.StockInvoice;
import ordermate.database.stock.StockInvoiceEntry;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockSupplier;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.Permission;
import ordermate.database.users.User;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.internationalization.Internationalization;

public class StockInvoiceEntryEditorPanel
extends ObjectEditorPanel {
    private ApplicationContext context = GuiApp.getAppComplex().getApplicationContext();
    private ApplicationFrame frame = GuiApp.getAppComplex().getApplicationFrame();
    private final NumberFormat PRICE_FORMAT = new DecimalFormat("0.###");
    private JPanel mainPanel;
    private JPanel mainPanelWest;
    private JPanel prodCodePanel;
    private JPanel prodCodeNorthPanel;
    private JTextField prodCodeField = new JTextField();
    private JButton lookupButton = new JButton("Lookup");
    private JPanel stockItemPanel;
    private JPanel stockItemSouthPanel;
    private JPanel stockItemNorthPanel;
    private JPanel stockItemNorthEastPanel;
    private JComboBox stockItemCombo;
    private QueryListModel stockItemListModel;
    private JButton newButton;
    private JButton editButton;
    private JButton searchButton;
    private JCheckBox limitSupplierCheck = new JCheckBox("Only from supplier", true);
    private JPanel qtyPanel;
    private GridBagConstraints qtyPanelConstraints;
    private JLabel qtyLabel = new JLabel("Quantity");
    private JLabel bonusLabel = new JLabel("Bonus");
    private JLabel qtyPurchaseQtyLabel = new JLabel(" x");
    private JLabel bonusPurchaseQtyLabel = new JLabel(" x");
    private JLabel negQtyLabel = new JLabel("-");
    private JLabel negBonusLabel = new JLabel("-");
    private JLabel negIncCostLabel = new JLabel("-");
    private JLabel negExCostLabel = new JLabel("-");
    private JSpinner outerQtyField = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 9999999.0, 1.0));
    private JSpinner outerBonusQtyField = new JSpinner(new SpinnerNumberModel(0, 0, 9999999, 1));
    private JSpinner qtyField = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 9999999.0, 1.0));
    private JSpinner bonusField = new JSpinner(new SpinnerNumberModel(0, 0, 9999999, 1));
    private JSpinner unitQtyField = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 9999999.0, 1.0));
    private JSpinner unitBonusQtyField = new JSpinner(new SpinnerNumberModel(0, 0, 9999999, 1));
    private JLabel negOuterQtyLabel = new JLabel("-");
    private JLabel negOuterBonusLabel = new JLabel("-");
    private JLabel outerQtyLabel = new JLabel(" x");
    private JLabel outerBonusQtyLabel = new JLabel(" x");
    private JLabel negUnitQtyLabel = new JLabel("-");
    private JLabel negUnitBonusLabel = new JLabel("-");
    private JLabel unitQtyLabel = new JLabel(" x");
    private JLabel unitBonusQtyLabel = new JLabel(" x");
    private static final String GST = Internationalization.getLiteralFor((String)"GST");
    private JPanel costPanel;
    private JPanel costPanelNorth;
    private JLabel costLabel = new JLabel("Total Cost");
    private JLabel costPerUnitLabel = new JLabel("Purchase Cost x.x Units)");
    private JLabel oldCostLabel = new JLabel("Old Cost");
    private JLabel incGSTLabel = new JLabel("Inc. " + GST);
    private JLabel exGSTLabel = new JLabel("Ex. " + GST);
    private JComboBox priceUpdateCombo = new JComboBox();
    private JLabel priceUpdateLabel = new JLabel("Update price:");
    private JSpinner totalCostInc = new CustomNumberSpinner();
    private JSpinner totalCostEx = new CustomNumberSpinner();
    private JSpinner purchaseCostInc = new CustomNumberSpinner();
    private JSpinner purchaseCostEx = new CustomNumberSpinner();
    private JSpinner oldCostPerUnitInc = new CustomNumberSpinner();
    private JSpinner oldCostPerUnitEx = new CustomNumberSpinner();
    private JLabel costPerIndUnitLabel = new JLabel("Cost Per Unit");
    private JSpinner costPerIndUnitInc = new CustomNumberSpinner();
    private JSpinner costPerIndUnitEx = new CustomNumberSpinner();
    private JComponent totalCostExDecorator;
    private JComponent totalCostIncDecorator;
    private JComponent purchaseCostExDecorator;
    private JComponent purchaseCostIncDecorator;
    private JComponent costPerIndUnitIncDecorator;
    private JComponent costPerIndUnitExDecorator;
    private JComponent outerQtyFieldDecorator;
    private JComponent qtyFieldDecorator;
    private JComponent outerBonusQtyFieldDecorator;
    private JComponent bonusFieldDecorator;
    private JComponent unitQtyFieldDecorator;
    private JComponent unitBonusQtyFieldDecorator;
    private Quantity initialQty = null;
    private StockInvoice invoice = null;
    private StockSupplier expectedSupplier;
    private boolean createSupplierLink;
    private boolean processEventsAllowed = true;
    private ObjectTemplate template = null;
    private StockInvoiceEntry editedObject = null;
    private ObjectManager manager;
    private boolean creatingNew = false;
    private double TAX = SystemProperty.getInstance().getBaseTaxRate();
    private static final String STOCK_ITEM_TABLE = "stock_item";
    private static final String STOCK_ITEM_SUPPLIERS_TABLE = "stock_item_suppliers";
    private static final String STOCK_ITEM_SUPPLIER_LINK = "stock_item_suppliers.FK_stock_supplier";
    private static final String STOCK_ITEM_ID = "stock_item.ID";
    private static final String STOCK_ITEM_NAME = "stock_item.Name";
    private static final String UPDATE_PRICE_AVERAGE = "Average";
    private static final String UPDATE_PRICE_NEW = "New";
    private static final String UNKNOWN_OUTER_LABEL = "Unknown";
    private static final int QTY_DEC_ROUNDING_PLACES = 2;

    public StockInvoiceEntryEditorPanel(StockSupplier supplier) {
        if (supplier == null) {
            throw new IllegalArgumentException("StockSupplier must not be null");
        }
        this.expectedSupplier = supplier;
    }

    @Override
    public void init(ObjectManager objManager, ObjectTemplate objectTemplate, Object obj) {
        this.creatingNew = obj == null;
        this.prodCodeField.setName("prodCode");
        this.manager = objManager;
        this.template = objectTemplate;
        this.editedObject = (StockInvoiceEntry)obj;
        this.initComponentsPermission();
        this.setupGUI();
        this.attachListeners();
        this.applyObject((StockInvoiceEntry)obj);
        if (this.editedObject != null && this.editedObject.getInvoice().isFrozen()) {
            this.prodCodeField.setEnabled(false);
            this.lookupButton.setEnabled(false);
            this.stockItemCombo.setEnabled(false);
            this.newButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.searchButton.setEnabled(false);
            this.limitSupplierCheck.setEnabled(false);
            this.priceUpdateCombo.setEnabled(false);
            this.totalCostIncDecorator.setEnabled(false);
            this.totalCostExDecorator.setEnabled(false);
            this.purchaseCostIncDecorator.setEnabled(false);
            this.purchaseCostExDecorator.setEnabled(false);
            this.oldCostPerUnitInc.setEnabled(false);
            this.oldCostPerUnitEx.setEnabled(false);
            this.outerQtyFieldDecorator.setEnabled(false);
            this.qtyFieldDecorator.setEnabled(false);
            this.outerBonusQtyFieldDecorator.setEnabled(false);
            this.bonusFieldDecorator.setEnabled(false);
            this.unitQtyFieldDecorator.setEnabled(false);
            this.unitBonusQtyFieldDecorator.setEnabled(false);
            this.costPerIndUnitExDecorator.setEnabled(false);
            this.costPerIndUnitIncDecorator.setEnabled(false);
        }
    }

    private void applyObject(StockInvoiceEntry entry) {
        if (entry != null) {
            StockItem stockItem = entry.getStockItem();
            this.initialQty = entry.getTotalReceivedQuantity();
            this.initialQty = new Quantity(this.initialQty.getMeasureUnit(), Math.abs(this.initialQty.getRawValue()), true);
            double numReceived = Math.abs(entry.getNumReceived());
            double bonusReceived = Math.abs(entry.getBonusReceived());
            int outerQty = 0;
            int outerBonusQty = 0;
            double unitQty = 0.0;
            double unitBonusQty = 0.0;
            double qty = numReceived;
            double bonusQty = bonusReceived;
            if (this.stockItemHasOuterQty(stockItem)) {
                outerQty = (int)Math.floor(numReceived / stockItem.getOuterQuantity());
                outerBonusQty = (int)Math.floor(bonusReceived / stockItem.getOuterQuantity());
                qty = numReceived - (double)outerQty * stockItem.getOuterQuantity();
                bonusQty = bonusReceived - (double)outerBonusQty * stockItem.getOuterQuantity();
            }
            if (this.stockItemRequiresUnits(stockItem)) {
                double origQty = qty;
                double origBonusQty = bonusQty;
                qty = (int)Math.floor(origQty);
                bonusQty = (int)Math.floor(origBonusQty);
                unitQty = this.getUnitQtyForSelectedStockItem(stockItem) * (origQty % 1.0);
                unitBonusQty = this.getUnitQtyForSelectedStockItem(stockItem) * (origBonusQty % 1.0);
            }
            this.unitQtyField.setValue(MathsUtils.roundDoubleToDecPlaces((double)unitQty, (int)2));
            this.unitBonusQtyField.setValue(MathsUtils.roundDoubleToDecPlaces((double)unitBonusQty, (int)2));
            this.qtyField.setValue(new Double(qty));
            this.bonusField.setValue(new Double(bonusQty));
            this.outerQtyField.setValue(new Integer(outerQty));
            this.outerBonusQtyField.setValue(new Integer(outerBonusQty));
            double currentCost = this.creatingNew ? stockItem.getCurrentReplacementCost().doubleValue() : entry.getPricePaidPerUnit().doubleValue();
            currentCost = Math.abs(currentCost);
            double indCost = Math.abs(stockItem.getCurrentReplacementCost().doubleValue() / stockItem.getPurchaseQty().doubleValue());
            double oldCost = stockItem.getOldCost().doubleValue();
            int saveCostMode = entry.getSaveCostMode();
            switch (saveCostMode) {
                case 0: {
                    this.priceUpdateCombo.setSelectedItem(UPDATE_PRICE_AVERAGE);
                    break;
                }
                case 1: {
                    this.priceUpdateCombo.setSelectedItem(UPDATE_PRICE_NEW);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognised save cost mode: " + saveCostMode);
                }
            }
            this.limitSupplierCheck.setSelected(stockItem.hasSupplier(this.expectedSupplier));
            this.updateForSupplierCheckPress(false);
            this.processEventsAllowed = true;
            this.stockItemListModel.setSelectedID(stockItem.intID());
            this.processEventsAllowed = false;
            String prodCode = stockItem.getProductCode(this.expectedSupplier);
            if (prodCode != null) {
                this.prodCodeField.setText(prodCode);
            }
            this.setupAllQuantityLabels(stockItem);
            this.processEventsAllowed = true;
            this.purchaseCostInc.setValue(new Double(currentCost));
            this.oldCostPerUnitInc.setValue(new Double(oldCost));
            this.costPerIndUnitInc.setValue(new Double(indCost));
        } else {
            this.limitSupplierCheck.setSelected(true);
            this.updateForSupplierCheckPress();
            this.stockItemCombo.setSelectedIndex(0);
            this.qtyField.setValue(new Integer(1));
            switch (SystemProperty.getInstance().getStockInvoicePricePreference().ordinal()) {
                case 0: {
                    this.priceUpdateCombo.setSelectedItem(UPDATE_PRICE_AVERAGE);
                    break;
                }
                case 1: {
                    this.priceUpdateCombo.setSelectedItem(UPDATE_PRICE_NEW);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognised save cost mode: " + SystemProperty.getInstance().getStockInvoicePricePreference().ordinal());
                }
            }
        }
    }

    private void setupAllQuantityLabels(StockItem stockItem) {
        Quantity purchaseQty = stockItem.getPurchaseQty();
        this.qtyPurchaseQtyLabel.setText(" x " + purchaseQty);
        this.bonusPurchaseQtyLabel.setText(" x " + purchaseQty);
        this.setupOuterQtyFieldsAndLabels(stockItem);
        this.setupUnitQtyFieldsAndLabels(stockItem);
        this.costPerUnitLabel.setText("Purchase Cost (" + this.PRICE_FORMAT.format(purchaseQty.doubleValue()) + " Units)");
    }

    private void addWheresToQuery(SelectQuery query) {
        query.clearWhere();
        query.addWhere(SQL.isActive((String)STOCK_ITEM_TABLE));
    }

    private void setupGUI() {
        this.setLayout(new GridLayout(1, 1));
        boolean isCreditNote = this.invoice.getInvoiceType().equals("Credit Note");
        OfficeMateAdminGuiUtils.getInstance().standardSpinnerSetup(this.qtyField);
        OfficeMateAdminGuiUtils.getInstance().standardSpinnerSetup(this.outerBonusQtyField);
        OfficeMateAdminGuiUtils.getInstance().standardSpinnerSetup(this.qtyField);
        OfficeMateAdminGuiUtils.getInstance().standardSpinnerSetup(this.bonusField);
        OfficeMateAdminGuiUtils.getInstance().standardSpinnerSetup(this.unitQtyField);
        OfficeMateAdminGuiUtils.getInstance().standardSpinnerSetup(this.unitBonusQtyField);
        Border rightMargin = BorderFactory.createEmptyBorder(0, 0, 0, 4);
        this.qtyLabel.setHorizontalAlignment(4);
        this.bonusLabel.setHorizontalAlignment(4);
        this.costLabel.setHorizontalAlignment(4);
        this.costPerUnitLabel.setHorizontalAlignment(4);
        this.oldCostLabel.setHorizontalAlignment(4);
        this.priceUpdateLabel.setHorizontalAlignment(4);
        this.costPerIndUnitLabel.setHorizontalAlignment(4);
        this.qtyLabel.setBorder(rightMargin);
        this.bonusLabel.setBorder(rightMargin);
        this.costLabel.setBorder(rightMargin);
        this.costPerUnitLabel.setBorder(rightMargin);
        this.oldCostLabel.setBorder(rightMargin);
        this.priceUpdateLabel.setBorder(rightMargin);
        this.costPerIndUnitLabel.setBorder(rightMargin);
        this.newButton = new JButton(IconLoader.get((String)"/ordermate/images/new_icon16.png"));
        this.newButton.setToolTipText("New...");
        this.editButton = new JButton(IconLoader.get((String)"/ordermate/images/edit_icon16.png"));
        this.editButton.setToolTipText("Edit...");
        this.searchButton = new JButton(IconLoader.get((String)"/ordermate/images/search16.png"));
        this.searchButton.setToolTipText("Search...");
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanelWest = new JPanel();
        this.mainPanelWest.setLayout(new BoxLayout(this.mainPanelWest, 1));
        this.prodCodePanel = new JPanel(new BorderLayout());
        this.prodCodePanel.setBorder(BorderFactory.createTitledBorder("Product Code"));
        this.prodCodeNorthPanel = new JPanel(new BorderLayout());
        this.stockItemPanel = new JPanel(new BorderLayout());
        this.stockItemSouthPanel = new JPanel(new BorderLayout());
        this.stockItemNorthPanel = new JPanel(new BorderLayout());
        this.stockItemNorthEastPanel = new JPanel(new BorderLayout());
        this.stockItemPanel.setBorder(BorderFactory.createTitledBorder("Stock Item"));
        SelectQuery query = SQL.createQuery((String[])new String[]{STOCK_ITEM_TABLE, STOCK_ITEM_SUPPLIERS_TABLE});
        query.addSelectValue(STOCK_ITEM_ID);
        query.addSelectValue(STOCK_ITEM_NAME);
        query.addWhere(SQL.join((String)STOCK_ITEM_SUPPLIERS_TABLE, (String)STOCK_ITEM_TABLE));
        query.addWhere("stock_item_suppliers.FK_stock_supplier = " + this.expectedSupplier.getID());
        query.addGroupBy(STOCK_ITEM_ID);
        query.addOrderBy(STOCK_ITEM_NAME);
        this.addWheresToQuery(query);
        this.stockItemListModel = new QueryListModel(query, this.context.getDatabaseConnection(), STOCK_ITEM_ID, STOCK_ITEM_NAME);
        this.stockItemListModel.getQuery().addOrderBy(STOCK_ITEM_NAME);
        this.stockItemCombo = new JComboBox(this.stockItemListModel);
        this.stockItemCombo.setName("stockItemCombo");
        OfficeMateAdminGuiUtils.getInstance().standardComboSetup(this.stockItemCombo);
        ComponentUtils.setupComboBox((JComboBox)this.stockItemCombo);
        ComponentUtils.setupComboBox((JComboBox)this.priceUpdateCombo);
        GridBagLayout qtyPanelGridBag = new GridBagLayout();
        this.qtyPanelConstraints = new GridBagConstraints();
        this.qtyPanelConstraints.insets = new Insets(0, 0, 4, 0);
        this.qtyPanelConstraints.weightx = 0.0;
        this.qtyPanelConstraints.weighty = 1.0;
        this.qtyPanelConstraints.ipadx = 10;
        this.qtyPanelConstraints.fill = 1;
        this.qtyPanelConstraints.anchor = 18;
        this.qtyPanelConstraints.gridx = 0;
        this.qtyPanelConstraints.gridy = 0;
        qtyPanelGridBag.setConstraints(this.qtyLabel, this.qtyPanelConstraints);
        this.qtyPanelConstraints.gridx = 1;
        this.qtyPanelConstraints.gridy = 0;
        qtyPanelGridBag.setConstraints(this.negOuterQtyLabel, this.qtyPanelConstraints);
        this.qtyPanelConstraints.gridx = 2;
        this.qtyPanelConstraints.gridy = 0;
        qtyPanelGridBag.setConstraints(this.outerQtyFieldDecorator, this.qtyPanelConstraints);
        this.qtyPanelConstraints.gridx = 3;
        this.qtyPanelConstraints.gridy = 0;
        qtyPanelGridBag.setConstraints(this.outerQtyLabel, this.qtyPanelConstraints);
        this.qtyPanelConstraints.gridx = 4;
        this.qtyPanelConstraints.gridy = 0;
        qtyPanelGridBag.setConstraints(this.negQtyLabel, this.qtyPanelConstraints);
        this.qtyPanelConstraints.gridx = 5;
        this.qtyPanelConstraints.gridy = 0;
        qtyPanelGridBag.setConstraints(this.qtyFieldDecorator, this.qtyPanelConstraints);
        this.qtyPanelConstraints.gridx = 6;
        this.qtyPanelConstraints.gridy = 0;
        qtyPanelGridBag.setConstraints(this.qtyPurchaseQtyLabel, this.qtyPanelConstraints);
        this.qtyPanelConstraints.gridx = 7;
        this.qtyPanelConstraints.gridy = 0;
        qtyPanelGridBag.setConstraints(this.negUnitQtyLabel, this.qtyPanelConstraints);
        this.qtyPanelConstraints.gridx = 8;
        this.qtyPanelConstraints.gridy = 0;
        qtyPanelGridBag.setConstraints(this.unitQtyFieldDecorator, this.qtyPanelConstraints);
        this.qtyPanelConstraints.gridx = 9;
        this.qtyPanelConstraints.gridy = 0;
        qtyPanelGridBag.setConstraints(this.unitQtyLabel, this.qtyPanelConstraints);
        this.qtyPanelConstraints.gridx = 0;
        this.qtyPanelConstraints.gridy = 1;
        qtyPanelGridBag.setConstraints(this.bonusLabel, this.qtyPanelConstraints);
        this.qtyPanelConstraints.gridx = 1;
        this.qtyPanelConstraints.gridy = 1;
        qtyPanelGridBag.setConstraints(this.negOuterBonusLabel, this.qtyPanelConstraints);
        this.qtyPanelConstraints.gridx = 2;
        this.qtyPanelConstraints.gridy = 1;
        qtyPanelGridBag.setConstraints(this.outerBonusQtyFieldDecorator, this.qtyPanelConstraints);
        this.qtyPanelConstraints.gridx = 3;
        this.qtyPanelConstraints.gridy = 1;
        qtyPanelGridBag.setConstraints(this.outerBonusQtyLabel, this.qtyPanelConstraints);
        this.qtyPanelConstraints.gridx = 4;
        this.qtyPanelConstraints.gridy = 1;
        qtyPanelGridBag.setConstraints(this.negBonusLabel, this.qtyPanelConstraints);
        this.qtyPanelConstraints.gridx = 5;
        this.qtyPanelConstraints.gridy = 1;
        qtyPanelGridBag.setConstraints(this.bonusFieldDecorator, this.qtyPanelConstraints);
        this.qtyPanelConstraints.gridx = 6;
        this.qtyPanelConstraints.gridy = 1;
        qtyPanelGridBag.setConstraints(this.bonusPurchaseQtyLabel, this.qtyPanelConstraints);
        this.qtyPanelConstraints.gridx = 7;
        this.qtyPanelConstraints.gridy = 1;
        qtyPanelGridBag.setConstraints(this.negUnitBonusLabel, this.qtyPanelConstraints);
        this.qtyPanelConstraints.gridx = 8;
        this.qtyPanelConstraints.gridy = 1;
        qtyPanelGridBag.setConstraints(this.unitBonusQtyFieldDecorator, this.qtyPanelConstraints);
        this.qtyPanelConstraints.gridx = 9;
        this.qtyPanelConstraints.gridy = 1;
        qtyPanelGridBag.setConstraints(this.unitBonusQtyLabel, this.qtyPanelConstraints);
        this.qtyPanel = new JPanel(qtyPanelGridBag);
        this.qtyPanel.setBorder(BorderFactory.createTitledBorder("Quantity"));
        this.costPanel = new JPanel(new BorderLayout());
        this.costPanel.setBorder(BorderFactory.createTitledBorder("Cost"));
        this.oldCostPerUnitInc.setEnabled(false);
        this.oldCostPerUnitEx.setEnabled(false);
        this.priceUpdateCombo.addItem(UPDATE_PRICE_AVERAGE);
        this.priceUpdateCombo.addItem(UPDATE_PRICE_NEW);
        this.prodCodeField.setName("prodCodefield");
        this.prodCodePanel.add((Component)this.prodCodeNorthPanel, "North");
        this.prodCodeNorthPanel.add((Component)this.prodCodeField, "North");
        this.prodCodeNorthPanel.add((Component)this.lookupButton, "East");
        this.stockItemPanel.add((Component)this.stockItemSouthPanel, "South");
        this.stockItemNorthPanel.add((Component)this.stockItemNorthEastPanel, "East");
        this.stockItemPanel.add((Component)this.stockItemNorthPanel, "North");
        this.stockItemNorthPanel.add((Component)this.stockItemCombo, "North");
        this.stockItemNorthEastPanel.add((Component)new StandardSecurityDecorator((JComponent)this.newButton, AllPermissions.ADD_STOCK_ITEMS), "West");
        this.stockItemNorthEastPanel.add((Component)new StandardSecurityDecorator((JComponent)this.editButton, AllPermissions.EDIT_STOCK_ITEMS), "Center");
        this.stockItemNorthEastPanel.add((Component)this.searchButton, "East");
        this.limitSupplierCheck.setName("limitSupplierCheck");
        this.stockItemSouthPanel.add((Component)new StandardSecurityDecorator((JComponent)this.limitSupplierCheck, AllPermissions.ALLOW_ORDERING_FROM_SUPPLIERS), "West");
        this.unitQtyField.setName("unitQtyField");
        this.unitBonusQtyField.setName("unitBonusQtyField");
        this.qtyField.setName("qtyField");
        this.bonusField.setName("bonusField");
        this.outerQtyField.setName("outerQtyField");
        this.outerBonusQtyField.setName("outerBonusQtyField");
        this.qtyPanel.add(this.qtyPurchaseQtyLabel);
        if (isCreditNote) {
            this.qtyPanel.add(this.negUnitQtyLabel);
        }
        this.qtyPanel.add(this.unitQtyFieldDecorator);
        this.qtyPanel.add(this.unitQtyLabel);
        if (isCreditNote) {
            this.qtyPanel.add(this.negQtyLabel);
        }
        this.qtyPanel.add(this.qtyFieldDecorator);
        this.qtyPanel.add(this.qtyLabel);
        if (isCreditNote) {
            this.qtyPanel.add(this.negOuterQtyLabel);
        }
        this.qtyPanel.add(this.outerQtyFieldDecorator);
        this.qtyPanel.add(this.outerQtyLabel);
        this.qtyPanel.add(this.bonusPurchaseQtyLabel);
        if (isCreditNote) {
            this.qtyPanel.add(this.negUnitBonusLabel);
        }
        this.qtyPanel.add(this.unitBonusQtyFieldDecorator);
        this.qtyPanel.add(this.unitBonusQtyLabel);
        if (isCreditNote) {
            this.qtyPanel.add(this.negBonusLabel);
        }
        this.qtyPanel.add(this.bonusFieldDecorator);
        this.qtyPanel.add(this.bonusLabel);
        if (isCreditNote) {
            this.qtyPanel.add(this.negOuterBonusLabel);
        }
        this.qtyPanel.add(this.outerBonusQtyFieldDecorator);
        this.qtyPanel.add(this.outerBonusQtyLabel);
        GridBagLayout costPanelGridBag = new GridBagLayout();
        GridBagConstraints costPanelContraints = new GridBagConstraints();
        costPanelContraints.insets = new Insets(0, 0, 4, 0);
        costPanelContraints.ipadx = 10;
        costPanelContraints.ipady = 10;
        costPanelContraints.weightx = 1.0;
        costPanelContraints.weighty = 1.0;
        costPanelContraints.fill = 1;
        costPanelContraints.anchor = 18;
        this.costPanelNorth = new JPanel(costPanelGridBag);
        costPanelContraints.gridx = 2;
        costPanelContraints.gridy = 0;
        costPanelGridBag.setConstraints(this.exGSTLabel, costPanelContraints);
        this.costPanelNorth.add(this.exGSTLabel);
        costPanelContraints.gridx = 4;
        costPanelContraints.gridy = 0;
        costPanelGridBag.setConstraints(this.incGSTLabel, costPanelContraints);
        this.costPanelNorth.add(this.incGSTLabel);
        costPanelContraints.gridx = 0;
        costPanelContraints.gridy = 1;
        costPanelGridBag.setConstraints(this.costLabel, costPanelContraints);
        this.costPanelNorth.add(this.costLabel);
        if (isCreditNote) {
            costPanelContraints.gridx = 1;
            costPanelContraints.gridy = 1;
            costPanelGridBag.setConstraints(this.negExCostLabel, costPanelContraints);
            this.costPanelNorth.add(this.negExCostLabel);
        }
        costPanelContraints.gridx = 2;
        costPanelContraints.gridy = 1;
        costPanelGridBag.setConstraints(this.totalCostExDecorator, costPanelContraints);
        this.costPanelNorth.add(this.totalCostExDecorator);
        this.totalCostEx.setName("costEx");
        if (isCreditNote) {
            costPanelContraints.gridx = 3;
            costPanelContraints.gridy = 1;
            costPanelGridBag.setConstraints(this.negIncCostLabel, costPanelContraints);
            this.costPanelNorth.add(this.negIncCostLabel);
        }
        costPanelContraints.gridx = 4;
        costPanelContraints.gridy = 1;
        costPanelGridBag.setConstraints(this.totalCostIncDecorator, costPanelContraints);
        this.costPanelNorth.add(this.totalCostIncDecorator);
        this.totalCostInc.setName("costInc");
        costPanelContraints.gridx = 0;
        costPanelContraints.gridy = 2;
        costPanelGridBag.setConstraints(this.costPerUnitLabel, costPanelContraints);
        this.costPanelNorth.add(this.costPerUnitLabel);
        costPanelContraints.gridx = 2;
        costPanelContraints.gridy = 2;
        costPanelGridBag.setConstraints(this.purchaseCostExDecorator, costPanelContraints);
        this.costPanelNorth.add(this.purchaseCostExDecorator);
        this.purchaseCostEx.setName("costPerUnitEx");
        costPanelContraints.gridx = 4;
        costPanelContraints.gridy = 2;
        costPanelGridBag.setConstraints(this.purchaseCostIncDecorator, costPanelContraints);
        this.costPanelNorth.add(this.purchaseCostIncDecorator);
        this.purchaseCostInc.setName("costPerUnitInc");
        costPanelContraints.gridx = 0;
        costPanelContraints.gridy = 3;
        costPanelGridBag.setConstraints(this.costPerIndUnitLabel, costPanelContraints);
        this.costPanelNorth.add(this.costPerIndUnitLabel);
        costPanelContraints.gridx = 2;
        costPanelContraints.gridy = 3;
        costPanelGridBag.setConstraints(this.costPerIndUnitExDecorator, costPanelContraints);
        this.costPanelNorth.add(this.costPerIndUnitExDecorator);
        this.costPerIndUnitEx.setName("costPerIndUnitEx");
        costPanelContraints.gridx = 4;
        costPanelContraints.gridy = 3;
        costPanelGridBag.setConstraints(this.costPerIndUnitIncDecorator, costPanelContraints);
        this.costPanelNorth.add(this.costPerIndUnitIncDecorator);
        this.costPerIndUnitInc.setName("costPerIndUnitInc");
        costPanelContraints.gridx = 0;
        costPanelContraints.gridy = 4;
        costPanelGridBag.setConstraints(this.oldCostLabel, costPanelContraints);
        this.costPanelNorth.add(this.oldCostLabel);
        costPanelContraints.gridx = 2;
        costPanelContraints.gridy = 4;
        costPanelGridBag.setConstraints(this.oldCostPerUnitEx, costPanelContraints);
        this.costPanelNorth.add(this.oldCostPerUnitEx);
        costPanelContraints.gridx = 4;
        costPanelContraints.gridy = 4;
        costPanelGridBag.setConstraints(this.oldCostPerUnitInc, costPanelContraints);
        this.costPanelNorth.add(this.oldCostPerUnitInc);
        costPanelContraints.gridx = 0;
        costPanelContraints.gridy = 5;
        costPanelGridBag.setConstraints(this.priceUpdateLabel, costPanelContraints);
        this.costPanelNorth.add(this.priceUpdateLabel);
        costPanelContraints.gridx = 2;
        costPanelContraints.gridy = 5;
        StandardSecurityDecorator updateComp = new StandardSecurityDecorator((JComponent)this.priceUpdateCombo, AllPermissions.EDIT_PRICE_UPDATE_METHOD);
        costPanelGridBag.setConstraints((Component)updateComp, costPanelContraints);
        this.costPanelNorth.add((Component)updateComp);
        this.priceUpdateCombo.setName("priceUpdateCombo");
        this.costPanelNorth.setLayout(costPanelGridBag);
        this.costPanelNorth.revalidate();
        this.costPanel.add((Component)this.costPanelNorth, "North");
        this.mainPanelWest.add(this.prodCodePanel);
        this.mainPanelWest.add(this.stockItemPanel);
        this.mainPanel.add((Component)this.mainPanelWest, "Center");
        this.mainPanel.add((Component)this.costPanel, "East");
        this.mainPanel.add((Component)this.qtyPanel, "South");
        this.add(this.mainPanel);
    }

    private void attachListeners() {
        InnerEventListener listener = new InnerEventListener();
        this.stockItemCombo.addActionListener(listener);
        this.lookupButton.addActionListener(listener);
        this.prodCodeField.addActionListener(listener);
        this.limitSupplierCheck.addActionListener(listener);
        this.newButton.addActionListener(listener);
        this.editButton.addActionListener(listener);
        this.searchButton.addActionListener(listener);
        this.stockItemCombo.addItemListener(listener);
        this.qtyField.addChangeListener(listener);
        this.bonusField.addChangeListener(listener);
        this.totalCostInc.addChangeListener(listener);
        this.totalCostEx.addChangeListener(listener);
        this.purchaseCostInc.addChangeListener(listener);
        this.purchaseCostEx.addChangeListener(listener);
        this.oldCostPerUnitInc.addChangeListener(listener);
        this.outerQtyField.addChangeListener(listener);
        this.outerBonusQtyField.addChangeListener(listener);
        this.unitQtyField.addChangeListener(listener);
        this.unitBonusQtyField.addChangeListener(listener);
        this.costPerIndUnitEx.addChangeListener(listener);
        this.costPerIndUnitInc.addChangeListener(listener);
        this.prodCodeField.addFocusListener(listener);
        StockInvoiceEntryEditorPanel.getTextForSpinner(this.qtyField).addFocusListener(listener);
        StockInvoiceEntryEditorPanel.getTextForSpinner(this.bonusField).addFocusListener(listener);
        StockInvoiceEntryEditorPanel.getTextForSpinner(this.totalCostInc).addFocusListener(listener);
        StockInvoiceEntryEditorPanel.getTextForSpinner(this.totalCostEx).addFocusListener(listener);
        StockInvoiceEntryEditorPanel.getTextForSpinner(this.purchaseCostInc).addFocusListener(listener);
        StockInvoiceEntryEditorPanel.getTextForSpinner(this.purchaseCostEx).addFocusListener(listener);
        StockInvoiceEntryEditorPanel.getTextForSpinner(this.outerQtyField).addFocusListener(listener);
        StockInvoiceEntryEditorPanel.getTextForSpinner(this.outerBonusQtyField).addFocusListener(listener);
        StockInvoiceEntryEditorPanel.getTextForSpinner(this.unitQtyField).addFocusListener(listener);
        StockInvoiceEntryEditorPanel.getTextForSpinner(this.unitBonusQtyField).addFocusListener(listener);
        StockInvoiceEntryEditorPanel.getTextForSpinner(this.costPerIndUnitEx).addFocusListener(listener);
        StockInvoiceEntryEditorPanel.getTextForSpinner(this.costPerIndUnitInc).addFocusListener(listener);
    }

    public StockInvoice getInvoice() {
        return this.invoice;
    }

    public void setInvoice(StockInvoice inv) {
        this.invoice = inv;
    }

    private void updateForNewCostInc() {
        if (this.processEventsAllowed) {
            this.processEventsAllowed = false;
            double qty = this.getTotalQuantity();
            double newCostInc = StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.totalCostInc);
            double tax = 0.0;
            if (this.isTaxIncluded()) {
                tax = FinanceUtils.getTaxValue((double)newCostInc, (double)this.TAX);
            }
            double newCostEx = newCostInc - tax;
            this.totalCostInc.setValue(new Double(newCostInc));
            this.totalCostEx.setValue(new Double(newCostEx));
            if (qty > 0.0 && this.getSelectedStockItem() != null) {
                this.purchaseCostInc.setValue(new Double(newCostInc / qty * this.getUnitQtyForSelectedStockItem(this.getSelectedStockItem())));
                this.purchaseCostEx.setValue(new Double(newCostEx / qty * this.getUnitQtyForSelectedStockItem(this.getSelectedStockItem())));
                this.costPerIndUnitEx.setValue(new Double(newCostEx / qty));
                this.costPerIndUnitInc.setValue(new Double(newCostInc / qty));
            }
            this.processEventsAllowed = true;
        }
    }

    private void updateForNewCostEx() {
        if (this.processEventsAllowed) {
            this.processEventsAllowed = false;
            double qty = this.getTotalQuantity();
            double newCostEx = StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.totalCostEx);
            double tax = 0.0;
            if (this.isTaxIncluded()) {
                tax = newCostEx * this.TAX;
            }
            double newCostInc = newCostEx + tax;
            this.totalCostInc.setValue(new Double(newCostInc));
            if (qty > 0.0 && this.getSelectedStockItem() != null) {
                this.purchaseCostInc.setValue(new Double(newCostInc / qty * this.getUnitQtyForSelectedStockItem(this.getSelectedStockItem())));
                this.purchaseCostEx.setValue(new Double(newCostEx / qty * this.getUnitQtyForSelectedStockItem(this.getSelectedStockItem())));
                this.costPerIndUnitEx.setValue(new Double(newCostEx / qty));
                this.costPerIndUnitInc.setValue(new Double(newCostInc / qty));
            }
            this.processEventsAllowed = true;
        }
    }

    private void updateForNewPurchaseCostInc() {
        if (this.processEventsAllowed) {
            this.processEventsAllowed = false;
            double qty = this.getTotalQuantity();
            double newPurchaseCostInc = StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.purchaseCostInc);
            double tax = 0.0;
            if (this.isTaxIncluded()) {
                tax = FinanceUtils.getTaxValue((double)newPurchaseCostInc, (double)this.TAX);
            }
            double newPurchaseCostEx = newPurchaseCostInc - tax;
            double newCostPerUnitInc = this.getSelectedStockItem() == null ? newPurchaseCostInc : newPurchaseCostInc / this.getUnitQtyForSelectedStockItem(this.getSelectedStockItem());
            double newCostPerUnitEx = this.getSelectedStockItem() == null ? newPurchaseCostEx : newPurchaseCostEx / this.getUnitQtyForSelectedStockItem(this.getSelectedStockItem());
            this.purchaseCostEx.setValue(new Double(newPurchaseCostEx));
            this.totalCostInc.setValue(new Double(newCostPerUnitInc * qty));
            this.totalCostEx.setValue(new Double(newCostPerUnitEx * qty));
            if (this.getSelectedStockItem() != null) {
                double totCostInc = StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.totalCostInc);
                double totCostEx = StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.totalCostEx);
                if (totCostEx > 0.0) {
                    this.costPerIndUnitEx.setValue(new Double(totCostEx / qty));
                } else {
                    this.costPerIndUnitEx.setValue(new Double(0.0));
                }
                if (totCostInc > 0.0) {
                    this.costPerIndUnitInc.setValue(new Double(totCostInc / qty));
                } else {
                    this.costPerIndUnitInc.setValue(new Double(0.0));
                }
            }
            this.processEventsAllowed = true;
        }
    }

    private void updateForNewPurchaseCostEx() {
        if (this.processEventsAllowed) {
            this.processEventsAllowed = false;
            double qty = this.getTotalQuantity();
            double newPurchaseCostEx = StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.purchaseCostEx);
            double tax = 0.0;
            if (this.isTaxIncluded()) {
                tax = newPurchaseCostEx * this.TAX;
            }
            double newPurchaseCostInc = newPurchaseCostEx + tax;
            this.purchaseCostInc.setValue(new Double(newPurchaseCostInc));
            double newCostPerUnitInc = this.getSelectedStockItem() == null ? StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.purchaseCostInc) : StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.purchaseCostInc) / this.getUnitQtyForSelectedStockItem(this.getSelectedStockItem());
            double newCostPerUnitEx = this.getSelectedStockItem() == null ? newPurchaseCostEx : newPurchaseCostEx / this.getUnitQtyForSelectedStockItem(this.getSelectedStockItem());
            this.totalCostInc.setValue(new Double(newCostPerUnitInc * qty));
            this.totalCostEx.setValue(new Double(newCostPerUnitEx * qty));
            if (this.getSelectedStockItem() != null) {
                double totCostInc = StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.totalCostInc);
                double totCostEx = StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.totalCostEx);
                this.costPerIndUnitEx.setValue(new Double(totCostEx / qty));
                this.costPerIndUnitInc.setValue(new Double(totCostInc / qty));
            }
            this.processEventsAllowed = true;
        }
    }

    private void updateForNewCostPerIndUnitInc() {
        if (this.processEventsAllowed) {
            this.processEventsAllowed = false;
            double qty = this.getTotalQuantity();
            double newCostPerUnitInc = StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.costPerIndUnitInc);
            double tax = 0.0;
            if (this.isTaxIncluded()) {
                tax = FinanceUtils.getTaxValue((double)newCostPerUnitInc, (double)this.TAX);
            }
            double newCostPerUnitEx = newCostPerUnitInc - tax;
            this.costPerIndUnitEx.setValue(new Double(newCostPerUnitEx));
            double newPurchaseCostInc = new Double(newCostPerUnitInc * this.getUnitQtyForSelectedStockItem(this.getSelectedStockItem()));
            double newPurchaseCostEx = new Double(newCostPerUnitEx * this.getUnitQtyForSelectedStockItem(this.getSelectedStockItem()));
            this.purchaseCostInc.setValue(newPurchaseCostInc);
            this.purchaseCostEx.setValue(newPurchaseCostEx);
            this.totalCostInc.setValue(new Double(newCostPerUnitInc * qty));
            this.totalCostEx.setValue(new Double(newCostPerUnitEx * qty));
            this.processEventsAllowed = true;
        }
    }

    private void updateForNewCostPerIndUnitEx() {
        if (this.processEventsAllowed) {
            this.processEventsAllowed = false;
            double qty = this.getTotalQuantity();
            double newCostPerUnitEx = StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.costPerIndUnitEx);
            double tax = 0.0;
            if (this.isTaxIncluded()) {
                tax = newCostPerUnitEx * this.TAX;
            }
            double newCostPerUnitInc = newCostPerUnitEx + tax;
            this.costPerIndUnitInc.setValue(new Double(newCostPerUnitInc));
            double newPurchaseCostInc = new Double(newCostPerUnitInc * this.getUnitQtyForSelectedStockItem(this.getSelectedStockItem()));
            double newPurchaseCostEx = new Double(newCostPerUnitEx * this.getUnitQtyForSelectedStockItem(this.getSelectedStockItem()));
            this.purchaseCostInc.setValue(newPurchaseCostInc);
            this.purchaseCostEx.setValue(newPurchaseCostEx);
            this.totalCostInc.setValue(newCostPerUnitInc * qty);
            this.totalCostEx.setValue(newCostPerUnitEx * qty);
            this.processEventsAllowed = true;
        }
    }

    private void updateForNewOldCostInc() {
        if (this.processEventsAllowed) {
            this.processEventsAllowed = false;
            double newOldCostInc = StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.oldCostPerUnitInc);
            double tax = 0.0;
            if (this.isTaxIncluded()) {
                tax = FinanceUtils.getTaxValue((double)newOldCostInc, (double)this.TAX);
            }
            double newOldCostEx = newOldCostInc - tax;
            this.oldCostPerUnitEx.setValue(new Double(newOldCostEx));
            this.processEventsAllowed = true;
        }
    }

    private void updateForNewQuantity() {
        if (this.processEventsAllowed) {
            double newQty = this.getTotalQuantity();
            double currentCostPerUnitInc = StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.purchaseCostInc);
            this.totalCostInc.setValue(new Double(currentCostPerUnitInc * newQty / this.getUnitQtyForSelectedStockItem(this.getSelectedStockItem())));
        }
    }

    private void updateForSupplierCheckPress() {
        this.updateForSupplierCheckPress(true);
    }

    private void updateForSupplierCheckPress(boolean reactiveEventsAllowed) {
        if (this.processEventsAllowed) {
            this.processEventsAllowed = false;
            long currentSelectedID = this.stockItemListModel.getSelectedID();
            SelectQuery query = this.stockItemListModel.getQuery();
            this.addWheresToQuery(query);
            if (this.limitSupplierCheck.isSelected()) {
                query.setFromTables(new String[]{STOCK_ITEM_TABLE, STOCK_ITEM_SUPPLIERS_TABLE});
                query.addWhere(SQL.join((String)STOCK_ITEM_SUPPLIERS_TABLE, (String)STOCK_ITEM_TABLE));
                query.addWhere("stock_item_suppliers.FK_stock_supplier = " + this.expectedSupplier.intID());
                query.addGroupBy(STOCK_ITEM_ID);
            } else {
                query.setFromTables(new String[]{STOCK_ITEM_TABLE});
            }
            this.stockItemListModel.update();
            this.processEventsAllowed = reactiveEventsAllowed;
            int index = this.stockItemListModel.getIndexForID(currentSelectedID);
            if (index != -1) {
                this.stockItemListModel.setSelectedID(currentSelectedID);
            } else if (this.stockItemListModel.getSize() > 0) {
                this.stockItemListModel.setSelectedIndex(0);
            } else {
                this.limitSupplierCheck.setSelected(false);
                this.updateForSupplierCheckPress();
            }
        }
    }

    private void updateForNewStockItem() {
        if (this.processEventsAllowed) {
            StockItem newStockItem = this.getSelectedStockItem();
            if (this.editedObject != null) {
                this.editedObject.setTaxIncluded(newStockItem.isTaxIncluded());
            }
            if (newStockItem != null) {
                this.processEventsAllowed = false;
                String prodCode = newStockItem.getProductCode(this.expectedSupplier);
                if (prodCode == null) {
                    prodCode = this.prodCodeField.getText();
                }
                this.prodCodeField.setText(prodCode);
                this.setupAllQuantityLabels(newStockItem);
                double pricePerUnit = newStockItem.getCurrentReplacementCost().doubleValue();
                this.purchaseCostInc.setValue(new Double(pricePerUnit));
                this.processEventsAllowed = true;
                this.updateForNewPurchaseCostInc();
                this.oldCostPerUnitInc.setValue(newStockItem.getOldCost());
            } else {
                this.stockItemListModel.setSelectedIndex(0);
            }
        }
    }

    public void updateForProdCode() {
        if (this.processEventsAllowed) {
            long idToSelect;
            int indexToSelect;
            String prodCode = this.prodCodeField.getText();
            StockItem newStockItem = null;
            newStockItem = this.limitSupplierCheck.isSelected() ? StockItemQueries.getStockItemForSupplierAndCode((StockSupplier)this.expectedSupplier, (String)prodCode) : StockItemQueries.getStockItemForCode((String)prodCode);
            boolean invalidCode = true;
            if (newStockItem != null && (indexToSelect = this.stockItemListModel.getIndexForID(idToSelect = newStockItem.intID())) != -1) {
                this.stockItemListModel.setSelectedIndex(indexToSelect);
                invalidCode = false;
            }
            if (invalidCode) {
                this.processEventsAllowed = false;
                this.prodCodeField.setText(this.getSelectedStockItem().getProductCode(this.expectedSupplier));
                this.processEventsAllowed = true;
            }
        }
    }

    private void onNewPressed() {
        ObjectTemplate stockItemTemplate = Templates.STOCK_ITEM;
        ObjectEditorPanel editorView = stockItemTemplate.getNewEditPanel(stockItemTemplate.createNewObject());
        StockItemEditorPanel defaultView = (StockItemEditorPanel)editorView;
        FieldPanel supplierTable = defaultView.getFieldPanel("Suppliers/Codes");
        ArrayList<Pair> supplierCodeList = new ArrayList<Pair>();
        Pair supplierCode = new Pair((Object)this.invoice.getSupplier(), (Object)"");
        supplierCodeList.add(supplierCode);
        supplierTable.setValue(supplierCodeList);
        if (ObjectEditorDialog.doDialog(this.frame.getFrame(), editorView) == 0) {
            editorView.saveObject();
            StockItem stockItem = (StockItem)editorView.getEditedObject();
            this.manager.saveObject(stockItem, stockItemTemplate);
            this.stockItemListModel.update();
            int index = this.stockItemListModel.getIndexForID(stockItem.intID());
            this.stockItemListModel.setSelectedIndex(index);
        } else {
            editorView.cancelObject();
        }
    }

    private void onEditPressed() {
        ObjectTemplate stockItemTemplate = Templates.STOCK_ITEM;
        StockItem stockItem = this.getSelectedStockItem();
        if (stockItem != null) {
            ObjectEditorPanel editorView = stockItemTemplate.getNewEditPanel(stockItem);
            if (ObjectEditorDialog.doDialog(this.frame.getFrame(), editorView) == 0) {
                editorView.saveObject();
                this.manager.saveObject(editorView.getEditedObject(), stockItemTemplate);
                this.stockItemListModel.update();
                int index = this.stockItemListModel.getIndexForID(stockItem.intID());
                this.stockItemListModel.setSelectedIndex(index);
                this.updateForNewStockItem();
            }
        }
    }

    private void onSearchPressed() {
        StockSupplier supplier = null;
        if (this.limitSupplierCheck.isSelected()) {
            supplier = this.expectedSupplier;
        }
        StockItemSearchPanel panel = new StockItemSearchPanel(supplier);
        Long selectedID = SearchDialog.search(this.frame.getFrame(), panel, "Search for Stock Items");
        if (selectedID != null && selectedID.intValue() > 0) {
            this.context.getLog().info("Selected: " + selectedID);
            this.stockItemListModel.setSelectedID(selectedID.intValue());
        }
    }

    private static JTextField getTextForSpinner(JSpinner spinner) {
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)spinner.getEditor();
        return editor.getTextField();
    }

    private static double getDoubleFromSpinner(JSpinner spinner) {
        return ((Number)spinner.getValue()).doubleValue();
    }

    private StockItem getSelectedStockItem() {
        long selectedID = this.stockItemListModel.getSelectedID();
        return (StockItem)PersistenceManager.getByID((long)selectedID, StockItem.class);
    }

    @Override
    public void saveObject() {
        double numReceived = this.getTotalPurchaseQuantity();
        double bonusReceived = this.getTotalPurchaseQuantityBonus();
        Price totalPrice = new Price(StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.totalCostInc), 0.0);
        StockItem stockItem = this.getSelectedStockItem();
        boolean itemChanged = false;
        Price newPrice = new Price(StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.purchaseCostInc), 0.0);
        if (!stockItem.getCurrentReplacementCost().equals((Object)newPrice)) {
            stockItem.setCurrentCost(newPrice);
            itemChanged = true;
        }
        if (this.createSupplierLink) {
            stockItem.addSupplier(this.expectedSupplier);
            itemChanged = true;
        }
        if (itemChanged) {
            stockItem.save();
        }
        if (this.invoice.getInvoiceType().equals("Credit Note")) {
            numReceived = -numReceived;
            bonusReceived = -bonusReceived;
            totalPrice = new Price(-totalPrice.doubleValue(), 0.0);
        }
        if (this.editedObject == null) {
            this.editedObject = new StockInvoiceEntry();
        }
        this.invoice.addEntry(this.editedObject);
        this.editedObject.setStockItem(stockItem);
        this.editedObject.setNumReceived(numReceived);
        this.editedObject.setBonusReceived(bonusReceived);
        this.editedObject.setPricePaid(totalPrice);
        this.editedObject.setTaxIncluded(stockItem.isTaxIncluded());
        boolean useNewCost = this.priceUpdateCombo.getSelectedItem().equals(UPDATE_PRICE_NEW);
        if (useNewCost) {
            this.editedObject.setSaveCostMode(1);
        } else {
            this.editedObject.setSaveCostMode(0);
        }
    }

    @Override
    public void cancelObject() {
    }

    @Override
    public Object getEditedObject() {
        return this.editedObject;
    }

    @Override
    public boolean isNewObject() {
        return this.editedObject == null;
    }

    @Override
    public boolean requestSaveAllowed() {
        boolean allowSave;
        this.createSupplierLink = false;
        StockItem stockItem = this.getSelectedStockItem();
        boolean bl = allowSave = stockItem != null;
        if (stockItem != null && !stockItem.hasSupplier(this.expectedSupplier)) {
            User user = GuiApp.getAppComplex().getApplicationSecurity().getUser();
            if (user.hasPermission(AllPermissions.EDIT_STOCK_ITEMS)) {
                String warning = "The stock item you have is not connected to this supplier. \nWould you like to associate it with " + this.expectedSupplier.getLabel() + "?";
                int result = JOptionPane.showConfirmDialog(this, warning, "Change supplier? ", 1, 2);
                if (result == 0) {
                    this.createSupplierLink = true;
                } else {
                    allowSave = result == 1;
                }
            } else {
                allowSave = true;
            }
        }
        if (allowSave && stockItem != null) {
            double stockWarn = SystemProperty.getInstance().getStockPriceWarn();
            String PERCENT_LIMIT_STRING = (int)(stockWarn * 100.0) + "%";
            double proposedPrice = StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.purchaseCostInc);
            double oldPrice = stockItem.getCurrentReplacementCost().doubleValue();
            double diff = Math.abs(proposedPrice - oldPrice);
            if (oldPrice != 0.0 && diff / oldPrice > stockWarn) {
                int result = JOptionPane.showConfirmDialog(this, "Price has been changed by more than " + PERCENT_LIMIT_STRING + ", are you sure you wish to save? ", "Large price change", 2);
                allowSave = result == 0;
            }
        }
        return allowSave;
    }

    private boolean isTaxIncluded() {
        if (this.editedObject != null) {
            return this.editedObject.isTaxIncluded();
        }
        return this.getSelectedStockItem().isTaxIncluded();
    }

    @Override
    public boolean requestCancelAllowed() {
        return true;
    }

    @Override
    public ObjectTemplate getTemplate() {
        return this.template;
    }

    @Override
    public int getDialogMode() {
        if (this.invoice != null && this.invoice.isFrozen()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean requestCloseAllowed() {
        return this.getDialogMode() == 1;
    }

    private double getTotalQuantity() {
        double total = StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.qtyField) * this.getUnitQtyForSelectedStockItem(this.getSelectedStockItem()) + StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.outerQtyField) * this.getOuterQtyForSelectedStockItem() * this.getUnitQtyForSelectedStockItem(this.getSelectedStockItem());
        if (this.stockItemRequiresUnits(this.getSelectedStockItem()) && StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.unitQtyField) != 0.0) {
            total += StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.unitQtyField);
        }
        return total;
    }

    private double getTotalPurchaseQuantity() {
        double total = StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.qtyField) + StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.outerQtyField) * this.getOuterQtyForSelectedStockItem();
        if (this.stockItemRequiresUnits(this.getSelectedStockItem()) && StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.unitQtyField) != 0.0) {
            total += StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.unitQtyField) / this.getUnitQtyForSelectedStockItem(this.getSelectedStockItem());
        }
        return total;
    }

    private double getTotalPurchaseQuantityBonus() {
        double total = StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.bonusField) + StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.outerBonusQtyField) * this.getOuterQtyForSelectedStockItem();
        if (this.stockItemRequiresUnits(this.getSelectedStockItem()) && StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.unitBonusQtyField) != 0.0) {
            total += StockInvoiceEntryEditorPanel.getDoubleFromSpinner(this.unitBonusQtyField) / this.getUnitQtyForSelectedStockItem(this.getSelectedStockItem());
        }
        return total;
    }

    private void setupOuterQtyFieldsAndLabels(StockItem stockItem) {
        String outerQtyName = UNKNOWN_OUTER_LABEL;
        if (stockItem != null && !stockItem.getOuterName().isEmpty()) {
            outerQtyName = stockItem.getOuterName();
        }
        this.outerQtyLabel.setText(" x " + outerQtyName);
        this.outerBonusQtyLabel.setText(" x " + outerQtyName);
        boolean hasOuter = this.stockItemHasOuterQty(stockItem);
        this.outerQtyFieldDecorator.setEnabled(hasOuter);
        this.outerBonusQtyFieldDecorator.setEnabled(hasOuter);
        this.outerQtyLabel.setEnabled(hasOuter);
        this.outerBonusQtyLabel.setEnabled(hasOuter);
        this.negOuterBonusLabel.setEnabled(hasOuter);
        this.negOuterQtyLabel.setEnabled(hasOuter);
        if (!hasOuter) {
            this.outerQtyField.setValue(0);
            this.outerBonusQtyField.setValue(0);
        }
    }

    private void setupUnitQtyFieldsAndLabels(StockItem stockItem) {
        this.unitQtyLabel.setText(" x 1 " + stockItem.getDisplayMeasureUnitContainer());
        this.unitBonusQtyLabel.setText(" x 1 " + stockItem.getDisplayMeasureUnitContainer());
        boolean reqUnits = this.stockItemRequiresUnits(stockItem);
        this.unitQtyFieldDecorator.setEnabled(reqUnits);
        this.unitBonusQtyFieldDecorator.setEnabled(reqUnits);
        this.unitQtyLabel.setEnabled(reqUnits);
        this.unitBonusQtyLabel.setEnabled(reqUnits);
        this.negUnitBonusLabel.setEnabled(reqUnits);
        this.negUnitQtyLabel.setEnabled(reqUnits);
        this.costPerIndUnitExDecorator.setEnabled(reqUnits);
        this.costPerIndUnitIncDecorator.setEnabled(reqUnits);
        if (!reqUnits) {
            this.unitQtyField.setValue(0);
            this.unitBonusQtyField.setValue(0);
        }
    }

    private double getOuterQtyForSelectedStockItem() {
        StockItem selectedStockItem = this.getSelectedStockItem();
        if (selectedStockItem != null && this.stockItemHasOuterQty(selectedStockItem)) {
            return selectedStockItem.getOuterQuantity();
        }
        return 0.0;
    }

    private double getUnitQtyForSelectedStockItem(StockItem stockItem) {
        if (stockItem != null && this.stockItemRequiresUnits(stockItem)) {
            return stockItem.getPurchaseQty().doubleValue();
        }
        return 1.0;
    }

    private boolean stockItemHasOuterQty(StockItem stockItem) {
        return stockItem != null && stockItem.getOuterQuantity() > 1.0;
    }

    private boolean stockItemRequiresUnits(StockItem stockItem) {
        return stockItem != null && stockItem.getPurchaseQty().doubleValue() != 1.0;
    }

    private void initComponentsPermission() {
        this.initPriceCompPermission();
        this.initQtyCompPermission();
    }

    private void initQtyCompPermission() {
        Permission qtyPermission = StockInvoicePermission.getQtyPermission(this.invoice, this.creatingNew);
        this.outerQtyFieldDecorator = new StandardSecurityDecorator((JComponent)this.outerQtyField, qtyPermission);
        this.qtyFieldDecorator = new StandardSecurityDecorator((JComponent)this.qtyField, qtyPermission);
        this.outerBonusQtyFieldDecorator = new StandardSecurityDecorator((JComponent)this.outerBonusQtyField, qtyPermission);
        this.bonusFieldDecorator = new StandardSecurityDecorator((JComponent)this.bonusField, qtyPermission);
        this.unitQtyFieldDecorator = new StandardSecurityDecorator((JComponent)this.unitQtyField, qtyPermission);
        this.unitBonusQtyFieldDecorator = new StandardSecurityDecorator((JComponent)this.unitBonusQtyField, qtyPermission);
    }

    private void initPriceCompPermission() {
        Permission permission = StockInvoicePermission.getPricePermission(this.invoice, this.creatingNew);
        this.totalCostExDecorator = new StandardSecurityDecorator((JComponent)this.totalCostEx, permission);
        this.totalCostIncDecorator = new StandardSecurityDecorator((JComponent)this.totalCostInc, permission);
        this.purchaseCostExDecorator = new StandardSecurityDecorator((JComponent)this.purchaseCostEx, permission);
        this.purchaseCostIncDecorator = new StandardSecurityDecorator((JComponent)this.purchaseCostInc, permission);
        this.costPerIndUnitIncDecorator = new StandardSecurityDecorator((JComponent)this.costPerIndUnitInc, permission);
        this.costPerIndUnitExDecorator = new StandardSecurityDecorator((JComponent)this.costPerIndUnitEx, permission);
    }

    private class InnerEventListener
    implements ActionListener,
    ChangeListener,
    FocusListener,
    ItemListener {
        private InnerEventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source != StockInvoiceEntryEditorPanel.this.stockItemCombo) {
                if (source == StockInvoiceEntryEditorPanel.this.lookupButton) {
                    StockInvoiceEntryEditorPanel.this.updateForProdCode();
                } else if (source == StockInvoiceEntryEditorPanel.this.prodCodeField) {
                    StockInvoiceEntryEditorPanel.this.updateForProdCode();
                } else if (source == StockInvoiceEntryEditorPanel.this.newButton) {
                    StockInvoiceEntryEditorPanel.this.onNewPressed();
                } else if (source == StockInvoiceEntryEditorPanel.this.editButton) {
                    StockInvoiceEntryEditorPanel.this.onEditPressed();
                } else if (source == StockInvoiceEntryEditorPanel.this.searchButton) {
                    StockInvoiceEntryEditorPanel.this.onSearchPressed();
                } else if (source == StockInvoiceEntryEditorPanel.this.limitSupplierCheck) {
                    StockInvoiceEntryEditorPanel.this.updateForSupplierCheckPress();
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object source = e.getSource();
            if (source == StockInvoiceEntryEditorPanel.this.qtyField || source == StockInvoiceEntryEditorPanel.this.outerQtyField || source == StockInvoiceEntryEditorPanel.this.unitQtyField) {
                StockInvoiceEntryEditorPanel.this.updateForNewQuantity();
            } else if (source == StockInvoiceEntryEditorPanel.this.totalCostInc) {
                StockInvoiceEntryEditorPanel.this.updateForNewCostInc();
            } else if (source == StockInvoiceEntryEditorPanel.this.totalCostEx) {
                StockInvoiceEntryEditorPanel.this.updateForNewCostEx();
            } else if (source == StockInvoiceEntryEditorPanel.this.purchaseCostInc) {
                StockInvoiceEntryEditorPanel.this.updateForNewPurchaseCostInc();
            } else if (source == StockInvoiceEntryEditorPanel.this.purchaseCostEx) {
                StockInvoiceEntryEditorPanel.this.updateForNewPurchaseCostEx();
            } else if (source == StockInvoiceEntryEditorPanel.this.oldCostPerUnitInc) {
                StockInvoiceEntryEditorPanel.this.updateForNewOldCostInc();
            } else if (source == StockInvoiceEntryEditorPanel.this.costPerIndUnitInc) {
                StockInvoiceEntryEditorPanel.this.updateForNewCostPerIndUnitInc();
            } else if (source == StockInvoiceEntryEditorPanel.this.costPerIndUnitEx) {
                StockInvoiceEntryEditorPanel.this.updateForNewCostPerIndUnitEx();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() == StockInvoiceEntryEditorPanel.this.prodCodeField) {
                StockInvoiceEntryEditorPanel.this.prodCodeField.setSelectionStart(0);
                StockInvoiceEntryEditorPanel.this.prodCodeField.setSelectionEnd(StockInvoiceEntryEditorPanel.this.prodCodeField.getText().length());
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            Object source = e.getSource();
            if (source == StockInvoiceEntryEditorPanel.getTextForSpinner(StockInvoiceEntryEditorPanel.this.qtyField) || source == StockInvoiceEntryEditorPanel.getTextForSpinner(StockInvoiceEntryEditorPanel.this.outerQtyField) || source == StockInvoiceEntryEditorPanel.getTextForSpinner(StockInvoiceEntryEditorPanel.this.unitQtyField)) {
                StockInvoiceEntryEditorPanel.this.updateForNewQuantity();
            } else if (source == StockInvoiceEntryEditorPanel.getTextForSpinner(StockInvoiceEntryEditorPanel.this.totalCostInc)) {
                StockInvoiceEntryEditorPanel.this.updateForNewCostInc();
            } else if (source == StockInvoiceEntryEditorPanel.getTextForSpinner(StockInvoiceEntryEditorPanel.this.totalCostEx)) {
                StockInvoiceEntryEditorPanel.this.updateForNewCostEx();
            } else if (source == StockInvoiceEntryEditorPanel.getTextForSpinner(StockInvoiceEntryEditorPanel.this.purchaseCostInc)) {
                StockInvoiceEntryEditorPanel.this.updateForNewPurchaseCostInc();
            } else if (source == StockInvoiceEntryEditorPanel.getTextForSpinner(StockInvoiceEntryEditorPanel.this.purchaseCostEx)) {
                StockInvoiceEntryEditorPanel.this.updateForNewPurchaseCostEx();
            } else if (source == StockInvoiceEntryEditorPanel.getTextForSpinner(StockInvoiceEntryEditorPanel.this.costPerIndUnitInc)) {
                StockInvoiceEntryEditorPanel.this.updateForNewCostPerIndUnitInc();
            } else if (source == StockInvoiceEntryEditorPanel.getTextForSpinner(StockInvoiceEntryEditorPanel.this.costPerIndUnitEx)) {
                StockInvoiceEntryEditorPanel.this.updateForNewCostPerIndUnitEx();
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (source == StockInvoiceEntryEditorPanel.this.stockItemCombo) {
                StockInvoiceEntryEditorPanel.this.updateForNewStockItem();
            }
        }
    }

    private static class CustomNumberSpinner
    extends JSpinner {
        CustomNumberSpinner() {
            this(0.0, 0.0, 9999999.0, 1.0);
        }

        CustomNumberSpinner(double val, double min, double max, double step) {
            super(new SpinnerNumberModel(val, min, max, step));
            OfficeMateAdminGuiUtils.getInstance().standardSpinnerSetup(this);
        }

        @Override
        protected JComponent createEditor(SpinnerModel model) {
            if (model instanceof SpinnerNumberModel) {
                return new JSpinner.NumberEditor((JSpinner)this, "######0.00");
            }
            return super.createEditor(model);
        }
    }
}

