/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.invoice;

import ordermate.database.stock.StockInvoice;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.Permission;

public class StockInvoicePermission {
    public static Permission getAddPermission(StockInvoice invoice) {
        String invoiceType = invoice.getInvoiceType();
        if (invoiceType.equals("Invoice")) {
            return AllPermissions.INVOICE_ITEM_ADD;
        }
        if (invoiceType.equals("Delivery Note")) {
            return AllPermissions.DELIVERY_NOTE_ITEM_ADD;
        }
        if (invoiceType.equals("Credit Note")) {
            return AllPermissions.CREDIT_NOTE_ITEM_ADD;
        }
        if (invoiceType.equals("Purchase Order")) {
            return AllPermissions.PURCHASE_ORDER_ITEM_ADD;
        }
        throw new IllegalArgumentException("Invalid invoice type!");
    }

    public static Permission getRemovePermission(StockInvoice invoice) {
        String invoiceType = invoice.getInvoiceType();
        if (invoiceType.equals("Invoice")) {
            return AllPermissions.INVOICE_ITEM_REMOVE;
        }
        if (invoiceType.equals("Delivery Note")) {
            return AllPermissions.DELIVERY_NOTE_ITEM_REMOVE;
        }
        if (invoiceType.equals("Credit Note")) {
            return AllPermissions.CREDIT_NOTE_ITEM_REMOVE;
        }
        if (invoiceType.equals("Purchase Order")) {
            return AllPermissions.PURCHASE_ORDER_ITEM_REMOVE;
        }
        throw new IllegalArgumentException("Invalid invoice type!");
    }

    public static Permission getPricePermission(StockInvoice invoice, boolean isAdding) {
        String invoiceType = invoice.getInvoiceType();
        if (invoiceType.equals("Invoice")) {
            return AllPermissions.INVOICE_PRICE_CORRECTION;
        }
        if (invoiceType.equals("Delivery Note")) {
            return AllPermissions.DELIVERY_NOTE_PRICE_CORRECTION;
        }
        if (invoiceType.equals("Credit Note")) {
            return AllPermissions.CREDIT_NOTE_PRICE_CORRECTION;
        }
        if (invoiceType.equals("Purchase Order")) {
            return AllPermissions.PURCHASE_ORDER_PRICE_CORRECTION;
        }
        throw new IllegalArgumentException("Invalid invoice type!");
    }

    public static Permission getQtyPermission(StockInvoice invoice, boolean isAdding) {
        if (isAdding) {
            return StockInvoicePermission.getAddPermission(invoice);
        }
        String invoiceType = invoice.getInvoiceType();
        if (invoiceType.equals("Invoice")) {
            return AllPermissions.INVOICE_QTY_CORRECTION;
        }
        if (invoiceType.equals("Delivery Note")) {
            return AllPermissions.DELIVERY_NOTE_QTY_CORRECTION;
        }
        if (invoiceType.equals("Credit Note")) {
            return AllPermissions.CREDIT_NOTE_QTY_CORRECTION;
        }
        if (invoiceType.equals("Purchase Order")) {
            return AllPermissions.PURCHASE_ORDER_QTY_CORRECTION;
        }
        throw new IllegalArgumentException("Invalid invoice type!");
    }
}

