/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.invoice;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.guicore.task.AbstractGuiTask;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.sql.SQL;
import au.com.ordermate.sql.queries.SelectQuery;
import au.com.ordermate.util.Assert;
import au.com.ordermate.util.DateDMY;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.FinanceUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import officemate.adminkit.DateRangePanel;
import officemate.adminkit.ObjectChangeRecorder;
import officemate.adminkit.ObjectEditorPanel;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.ObjectEditorDialog;
import officemate.adminkit.print.Printing;
import officemate.adminkit.state.ActionFactory;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.table.LinkedTotalTable;
import officemate.adminkit.table.QueryTable;
import officemate.adminkit.templates.Templates;
import officemate.screens.ObjectManagerI;
import officemate.screens.maintainstock.invoice.OldInvoicesLookDifferentCellRenderer;
import officemate.screens.maintainstock.invoice.StockInvoiceTableModel;
import officemate.screens.maintainstock.invoice.external.ImportInvoiceAction;
import officemate.screens.maintainstock.invoice.external.ManualExportAction;
import officemate.screens.maintainstock.invoice.purchaseorder.EmailPurchaseOrderAction;
import ordermate.database.integration.accounting.AccountingIntegrationConfig;
import ordermate.database.misc.StockControlEventLog;
import ordermate.database.misc.SystemProperty;
import ordermate.database.queries.stock.StockItemQueries;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockInvoice;
import ordermate.database.stock.StockSupplier;
import ordermate.database.stock.StockTake;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.PermissionGroup;
import ordermate.database.users.User;
import ordermate.gui.FieldPanelBuilder;
import ordermate.integration.finance.myob.mapping.FinanceExportStyle;
import ordermate.internationalization.Internationalization;

public class StockInvoiceState
extends BasicOfficeMateState {
    static final String DB_INVOICE_ID = "stock_invoice.ID";
    static final String DB_CREATION_DATE = "stock_invoice.CreationDate";
    static final String DB_INVOICE_DATE = "stock_invoice.Date";
    static final String DB_INVOICE_INVOICE_NUM = "stock_invoice.InvoiceNumber";
    static final String DB_INVOICE_ORDER_NUM = "stock_invoice.OrderNumber";
    static final String DB_SUPPLIER_NAME = "stock_supplier.Name";
    static final String DB_INVOICE_TAX_AMOUNT = "TaxAmount";
    static final String DB_INVOICE_EX_TAX_TOTAL = "TotalExTax";
    static final String DB_INVOICE_INC_TAX_TOTAL = "TotalIncTax";
    static final String DB_INVOICE_TYPE = "stock_invoice.invoice_type";
    static final String DB_INVOICE_CREATION_DATE = "stock_invoice.CreationDate";
    static final String DB_INVOICE_EXPECTED_TOTAL = "stock_invoice.ExpectedTotal";
    static final String DB_INVOICE_DATE_EXPORTED = "stock_invoice.date_exported";
    private static final String GST = Internationalization.getLiteralFor((String)"GST");
    private static final String INC_GST_COL_NAME = MessageFormat.format("Total (Inc {0})", GST);
    private static final String EX_GST_COL_NAME = MessageFormat.format("Total (Ex {0})", GST);
    private static final String GST_AMOUNT = MessageFormat.format("{0} Amount", GST);
    private JPanel innerPanel;
    private JPanel northPanel;
    private JPanel eastPanel;
    private JPanel northWestPanel;
    private JPanel tablePanel;
    private SelectQuery query;
    private StockInvoiceTableModel tableModel;
    private QueryTable table;
    private final ObjectTemplate invoiceTemplate;
    private JComboBox supplierCombo;
    private JComboBox areaCombo;
    private JComboBox invoiceTypeCombo;
    private JTextField invoiceNumberField;
    private DateRangePanel datePanel;
    private LinkedTotalTable totalsTable;
    private JPanel totalWrapperPanel;
    private JPanel centrePanel;
    private JCheckBox lastStockTakeCheck = new JCheckBox("Since last stocktake");
    private Date lastUsedStartDate;
    private Date lastUsedEndDate;
    private boolean alreadySetup = false;
    private boolean updatesAllowed = true;
    private EmailPurchaseOrderAction emailAction;
    private ManualExportAction exportAction;

    public StockInvoiceState() {
        super("Invoices", AllPermissions.ACCESS_INVOICES_SCREEN, "View, create and modify invoices");
        this.invoiceTemplate = Templates.STOCK_INVOICE;
        this.innerPanel = new JPanel(new BorderLayout());
        this.innerPanel.setName("Invoices");
        this.setScreenPanel(this.innerPanel);
        this.addAction((Action)ActionFactory.createPermissibleNewAction(this, AllPermissions.ADD_INVOICES));
        this.addAction((Action)ActionFactory.createPermissibleEditAction(this, AllPermissions.EDIT_INVOICES));
        this.addAction((Action)ActionFactory.createPermissibleDeleteAction(this, AllPermissions.DELETE_INVOICES));
        this.addImportInvoiceAction();
        this.addEmailPurchaseOrderAction();
    }

    private void addImportInvoiceAction() {
        ImportInvoiceAction importAction = new ImportInvoiceAction();
        ImportInvoiceAction.doAfterActionHandled.connect((Object)this, "refresh");
        this.addAction((Action)((Object)importAction));
    }

    private void addEmailPurchaseOrderAction() {
        this.emailAction = new EmailPurchaseOrderAction();
        this.emailAction.retrieveInvoice.connect((Object)this, "gotEmailAction");
        this.addAction((Action)((Object)this.emailAction));
    }

    private void addManualExportAction() {
        if (this.exportAction == null) {
            this.exportAction = new ManualExportAction();
            this.exportAction.retrieveInvoice.connect((Object)this, "gotExportAction");
        }
        this.addAction((Action)((Object)this.exportAction));
    }

    private void removeManualExportAction() {
        if (this.exportAction != null) {
            this.removeStateSpecificAction((Action)((Object)this.exportAction));
        }
    }

    @Override
    public boolean supportsNew() {
        return true;
    }

    @Override
    public boolean supportsRefresh() {
        return true;
    }

    @Override
    public boolean supportsPrint() {
        return true;
    }

    @Override
    protected void onStart() {
        StockTake lastSaved;
        GuiApp.getAppComplex().getApplicationFrame().setStatusBarText("Loading invoice screen...");
        if (!this.alreadySetup) {
            this.alreadySetup = Dialogs.showProgressDialog((AbstractTask)new InvoiceSetupTask());
            if (!this.alreadySetup) {
                Dialogs.showErrorDialog("Error Loading Screen", "Please contact OrderMate Support");
                return;
            }
        } else {
            this.refresh();
        }
        this.lastStockTakeCheck.setEnabled((lastSaved = StockTake.getLastSavedStockTake()) != null);
        this.updateButtonStates();
        GuiApp.getAppComplex().getApplicationFrame().resetStatusBarText();
        this.removeManualExportAction();
        if (FinanceExportStyle.Xero.equals((Object)AccountingIntegrationConfig.getInstance().getType())) {
            this.addManualExportAction();
        }
    }

    @Override
    protected void onEnd() {
    }

    @Override
    public void doRefreshAction() {
        this.refresh();
    }

    @Override
    public void doNewAction() {
        this.addObject();
    }

    private void setupGUI() {
        this.northPanel = new JPanel(new BorderLayout());
        this.northWestPanel = new JPanel();
        this.northWestPanel.setLayout(new BoxLayout(this.northWestPanel, 0));
        this.northWestPanel.add(this.getInvoiceTextField());
        this.northWestPanel.add(this.getComboBoxes());
        this.innerPanel.add((Component)this.northPanel, "North");
        this.centrePanel = new JPanel(new BorderLayout());
        this.innerPanel.add((Component)this.centrePanel, "Center");
        this.eastPanel = new JPanel(new BorderLayout());
        this.northPanel.add((Component)this.eastPanel, "East");
        this.northPanel.add((Component)this.northWestPanel, "West");
    }

    private void setupDates() {
        this.datePanel = new DateRangePanel();
        this.datePanel.datesChanged.connect((Object)this, "gotDatesChanged");
        this.datePanel.setUsesTradingDayBoundaries(false);
        Date now = new Date();
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        Date startOfMonth = new Date(cal.getTimeInMillis());
        this.datePanel.setEndDate(now);
        this.datePanel.setStartDate(startOfMonth);
        this.lastUsedStartDate = startOfMonth;
        this.lastUsedEndDate = now;
        this.eastPanel.add((Component)this.datePanel, "Center");
    }

    private void setupTable() {
        this.query = SQL.createQuery((String[])new String[]{"stock_invoice JOIN stock_supplier ON stock_invoice.FK_stock_supplier = stock_supplier.ID LEFT JOIN stock_invoice_entry ON stock_invoice_entry.FK_stock_invoice = stock_invoice.ID AND " + SQL.isActive((String)"stock_invoice_entry")});
        this.query.addSelectValue(DB_INVOICE_ID);
        this.query.addSelectValue("stock_invoice.CreationDate");
        this.query.addSelectValue(DB_INVOICE_DATE);
        this.query.addSelectValue(DB_INVOICE_INVOICE_NUM);
        this.query.addSelectValue(DB_INVOICE_ORDER_NUM);
        this.query.addSelectValue(DB_SUPPLIER_NAME);
        this.query.addSelectValue("stock_invoice.CreationDate");
        this.query.addSelectValue(DB_INVOICE_EXPECTED_TOTAL);
        this.query.addSelectValue(DB_INVOICE_DATE_EXPORTED);
        double taxMult = FinanceUtils.getTaxMultiplier((double)SystemProperty.getInstance().getBaseTaxRate());
        double exTaxMult = FinanceUtils.getRemoveTaxMultiplier((double)SystemProperty.getInstance().getBaseTaxRate());
        this.query.addSelectValue("IF(stock_invoice_entry.ID IS NOT NULL, SUM(stock_invoice_entry.PricePaid * IF(stock_invoice_entry.tax_included, " + taxMult + ", 0)), 0)  + (AdminCost + FreightCost - Discount) * " + taxMult + " AS " + DB_INVOICE_TAX_AMOUNT);
        this.query.addSelectValue("IF(stock_invoice_entry.ID IS NOT NULL, SUM(stock_invoice_entry.PricePaid * IF(stock_invoice_entry.tax_included, " + exTaxMult + ", 1)), 0)  + (AdminCost + FreightCost - Discount) * " + exTaxMult + " AS " + DB_INVOICE_EX_TAX_TOTAL);
        this.query.addSelectValue("IF(stock_invoice_entry.ID IS NOT NULL, SUM(stock_invoice_entry.PricePaid), 0)  + AdminCost + FreightCost - Discount AS TotalIncTax");
        this.query.addSelectValue(DB_INVOICE_TYPE);
        this.query.addOrderBy(DB_INVOICE_DATE, false);
        this.query.addGroupBy(DB_INVOICE_ID);
        this.addWheresToQuery();
        String[] dbColumns = new String[]{"stock_invoice.CreationDate", DB_INVOICE_DATE, DB_INVOICE_INVOICE_NUM, DB_INVOICE_ORDER_NUM, DB_SUPPLIER_NAME, DB_INVOICE_TAX_AMOUNT, DB_INVOICE_EX_TAX_TOTAL, DB_INVOICE_INC_TAX_TOTAL, DB_INVOICE_TYPE, DB_INVOICE_DATE_EXPORTED};
        String taxLabel = SystemProperty.getInstance().getBaseTaxLabel();
        String[] displayColumns = new String[]{"Created On", "Date", "Invoice number", "Order number", "Supplier", GST_AMOUNT, EX_GST_COL_NAME, INC_GST_COL_NAME, "Type", "Date Exported"};
        this.tableModel = new StockInvoiceTableModel(this.query, GuiApp.getAppComplex().getApplicationContext().getDatabaseConnection(), DB_INVOICE_ID, dbColumns, displayColumns);
        this.tableModel.addTotalColumn(DB_INVOICE_TAX_AMOUNT);
        this.tableModel.addTotalColumn(DB_INVOICE_EX_TAX_TOTAL);
        this.tableModel.addTotalColumn(DB_INVOICE_INC_TAX_TOTAL);
        this.table = new QueryTable(this.tableModel);
        this.table.setName("StockInvoiceTable");
        OfficeMateAdminGuiUtils.getInstance().standardTableSetup(this.table);
        this.loadRenderer();
        this.table.objectSelected.connect((Object)this, "gotTableObjectSelected");
        this.table.objectChosen.connect((Object)this, "gotTableObjectChosen");
        JPanel buttonWrapperPanel = new JPanel(new BorderLayout());
        this.tablePanel = new JPanel(new BorderLayout());
        this.tablePanel.setName("Table Panel");
        this.tablePanel.add((Component)this.table.getScroller(), "Center");
        this.tablePanel.add((Component)buttonWrapperPanel, "East");
        this.centrePanel.add((Component)buttonWrapperPanel, "East");
        this.centrePanel.add((Component)this.tablePanel, "Center");
    }

    public void addWheresToQuery() {
        this.query.clearWhere();
        this.query.addWhere(SQL.isActive((String)"stock_invoice"));
    }

    @Override
    public void refresh() {
        this.updatesAllowed = false;
        Object comboSelected = this.supplierCombo.getSelectedItem();
        this.supplierCombo.setModel(new DefaultComboBoxModel<Object>(StockSupplier.getSuppliers().toArray()));
        this.supplierCombo.insertItemAt("(All)", 0);
        this.supplierCombo.setSelectedIndex(0);
        this.supplierCombo.setSelectedItem(comboSelected);
        comboSelected = this.areaCombo.getSelectedItem();
        this.areaCombo.setModel(new DefaultComboBoxModel<Object>(StockArea.getStockAreas().toArray()));
        this.areaCombo.insertItemAt("(All)", 0);
        this.areaCombo.setSelectedIndex(0);
        this.areaCombo.setSelectedItem(comboSelected);
        this.loadRenderer();
        this.updateQuery(this.invoiceNumberField.getText().trim(), this.getCurrentSupplier(), this.getCurrentStockArea(), this.getCurrentInvoiceType(), this.datePanel.getStartDate(), this.datePanel.getEndDate());
        this.updatesAllowed = true;
    }

    private void loadRenderer() {
        Date from;
        StockTake lastStockTake = StockTake.getLastSavedStockTake();
        if (lastStockTake != null) {
            from = lastStockTake.getDate();
        } else {
            Calendar cal = Calendar.getInstance();
            DateTimeUtils.clearTimePart((Calendar)cal);
            cal.set(1, 2001);
            from = cal.getTime();
        }
        this.table.setCellRendererForAll(new OldInvoicesLookDifferentCellRenderer(from));
    }

    private void setupCheckBox() {
        this.lastStockTakeCheck.setSelected(false);
        this.lastStockTakeCheck.setMinimumSize(new Dimension(100, 20));
        this.lastStockTakeCheck.setPreferredSize(new Dimension(120, 20));
        this.eastPanel.add((Component)this.lastStockTakeCheck, "South");
        this.lastStockTakeCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StockInvoiceState.this.updatesAllowed = false;
                boolean sinceLastStockTake = StockInvoiceState.this.lastStockTakeCheck.isSelected();
                if (sinceLastStockTake) {
                    StockInvoiceState.this.lastUsedStartDate = StockInvoiceState.this.datePanel.getStartDate();
                    StockInvoiceState.this.lastUsedEndDate = StockInvoiceState.this.datePanel.getApparentEndDate();
                    StockTake lastSaved = StockTake.getLastSavedStockTake();
                    Date lastSavedDate = null;
                    lastSavedDate = lastSaved != null ? lastSaved.getDate() : new Date();
                    StockInvoiceState.this.datePanel.setStartDate(lastSavedDate);
                    StockInvoiceState.this.datePanel.setEndDate(new Date());
                    StockInvoiceState.this.datePanel.setEnabled(false);
                } else {
                    StockInvoiceState.this.datePanel.setStartDate(StockInvoiceState.this.lastUsedStartDate);
                    StockInvoiceState.this.datePanel.setEndDate(StockInvoiceState.this.lastUsedEndDate);
                    StockInvoiceState.this.datePanel.setEnabled(true);
                }
                StockInvoiceState.this.updatesAllowed = true;
                StockInvoiceState.this.refresh();
                StockInvoiceState.this.updateButtonStates();
            }
        });
    }

    private Component getInvoiceTextField() {
        this.invoiceNumberField = new JTextField();
        this.invoiceNumberField.setName("invoiceNumberField");
        this.invoiceNumberField.setPreferredSize(new Dimension(80, 20));
        FieldPanelBuilder builder = new FieldPanelBuilder(0, 3);
        builder.addRow("Invoice number:", (Component)this.invoiceNumberField);
        builder.getPanel().setAlignmentY(0.0f);
        return builder.getPanel();
    }

    private Component getComboBoxes() {
        this.supplierCombo = new JComboBox<Object>(StockSupplier.getSuppliers().toArray());
        this.supplierCombo.setName("supplierCombo");
        this.supplierCombo.insertItemAt("(All)", 0);
        this.supplierCombo.setSelectedIndex(0);
        OfficeMateAdminGuiUtils.getInstance().standardComboSetup(this.supplierCombo);
        this.supplierCombo.addActionListener(new UpdateOnActionListener());
        this.areaCombo = new JComboBox<Object>(StockArea.getStockAreas().toArray());
        this.areaCombo.setName("areaCombo");
        this.areaCombo.insertItemAt("(All)", 0);
        this.areaCombo.setSelectedIndex(0);
        OfficeMateAdminGuiUtils.getInstance().standardComboSetup(this.areaCombo);
        this.areaCombo.addActionListener(new UpdateOnActionListener());
        this.invoiceTypeCombo = new JComboBox<Object>(StockInvoice.getInvoiceTypes().toArray());
        this.invoiceTypeCombo.setName("invoiceTypeCombo");
        this.invoiceTypeCombo.insertItemAt("(All)", 0);
        this.invoiceTypeCombo.setSelectedIndex(0);
        OfficeMateAdminGuiUtils.getInstance().standardComboSetup(this.invoiceTypeCombo);
        FieldPanelBuilder builder = new FieldPanelBuilder(0);
        builder.addRow("Supplier:", (Component)this.supplierCombo);
        builder.addRow("Area:", (Component)this.areaCombo);
        builder.addRow("Type:", (Component)this.invoiceTypeCombo);
        JPanel comboPanel = builder.getPanel();
        comboPanel.setAlignmentY(0.0f);
        return comboPanel;
    }

    public void updateQuery(String invoiceNum, StockSupplier supplier, StockArea area, String invoiceType, Date from, Date to) {
        boolean sinceLastStockTake;
        this.addWheresToQuery();
        if (supplier != null) {
            this.query.addWhere("stock_supplier.ID = " + supplier.getID());
        }
        if (area != null) {
            this.query.addWhere("stock_invoice.FK_stock_area = " + area.getID());
        }
        if (invoiceType != null) {
            this.query.addWhere("stock_invoice.invoice_type = '" + invoiceType + "' ");
        }
        if (invoiceNum.length() > 0) {
            this.query.addWhere("stock_invoice.InvoiceNumber LIKE '%" + invoiceNum + "%' ");
        }
        if (!(sinceLastStockTake = this.lastStockTakeCheck.isSelected())) {
            Timestamp sqlFrom = new Timestamp(from.getTime());
            Timestamp sqlTo = new Timestamp(to.getTime());
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(sqlFrom);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            sqlFrom = new Timestamp(calendar.getTimeInMillis());
            this.query.addWhere("stock_invoice.Date >= '" + sqlFrom + "'");
            this.query.addWhere("stock_invoice.Date <= '" + sqlTo + "'");
        } else {
            StockTake lastSaved = StockTake.getLastSavedStockTake();
            long fromMillis = lastSaved != null ? lastSaved.getDate().getTime() : System.currentTimeMillis();
            Timestamp sqlFrom = new Timestamp(fromMillis);
            this.query.addWhere("stock_invoice.CreationDate >= '" + sqlFrom + "'");
        }
        this.table.updateModel();
        this.totalsTable.setColumnValues(this.table.getTotals());
        this.table.revalidate();
        this.table.repaint();
        this.totalsTable.repaint();
    }

    private void updateButtonStates(StockInvoice inv) {
        boolean isObjectSelected = this.table.getSelectedRow() != -1;
        this.toggleDefaultAction(this.getEditAction(), isObjectSelected);
        this.toggleDefaultAction(this.getDeleteAction(), isObjectSelected && !inv.isFrozen());
    }

    private void updateButtonStates() {
        this.updateButtonStates(this.getCurrentStockInvoice());
    }

    void gotTableObjectChosen() {
        this.doEditAction();
    }

    private void setupTotalsPanel() {
        this.totalsTable = new LinkedTotalTable(this.table.getColumnModel());
        this.totalsTable.setName("totalsTable");
        this.totalWrapperPanel = new JPanel(new BorderLayout());
        this.totalWrapperPanel.add((Component)new JLabel("Totals:"), "North");
        this.totalWrapperPanel.add((Component)this.totalsTable, "Center");
        this.tablePanel.add((Component)this.totalWrapperPanel, "South");
    }

    public void gotTableObjectSelected(Long id) {
        StockInvoice inv = StockInvoice.getInvoice((Long)id);
        this.updateButtonStates(inv);
    }

    private StockSupplier getCurrentSupplier() {
        Object obj = this.supplierCombo.getSelectedItem();
        return obj instanceof StockSupplier ? (StockSupplier)obj : null;
    }

    private StockArea getCurrentStockArea() {
        Object obj = this.areaCombo.getSelectedItem();
        return obj instanceof StockArea ? (StockArea)obj : null;
    }

    private String getCurrentInvoiceType() {
        Object obj = this.invoiceTypeCombo.getSelectedItem();
        return this.invoiceTypeCombo.getSelectedIndex() != 0 ? (String)obj : null;
    }

    private StockInvoice getCurrentStockInvoice() {
        long invoiceID = this.table.getSelectedObjectID();
        return (StockInvoice)PersistenceManager.getByID((long)invoiceID, StockInvoice.class);
    }

    void gotDatesChanged() {
        this.refresh();
    }

    @Override
    public void doPrintAction() {
        String title = "Invoice report";
        DateDMY start = new DateDMY((Date)this.datePanel.getSQLStartDate());
        DateDMY end = new DateDMY((Date)this.datePanel.getSQLEndDate());
        String dateString = " from " + start + " to " + end;
        StockSupplier supplier = this.getCurrentSupplier();
        String supplierString = supplier != null ? " Supplier: " + supplier.getLabel() : "";
        Object[] totals = this.totalsTable.getColumnStrings();
        Printing.printJTableReport(this.table, title + dateString, supplierString, 8, totals);
    }

    private void addObject() {
        if (!(StockSupplier.stockSuppliersExist() && StockArea.stockAreasExist() && StockItemQueries.stockItemsExist())) {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "To create an invoice, please ensure that you have set up at least one\n    - Stock Area \n    - Stock Item \n    - Stock Supplier", "Can't create invoice!", 2);
            return;
        }
        Object createdObj = null;
        GuiApp.getAppComplex().getApplicationFrame().setStatusBarText("Creating " + this.invoiceTemplate.getName() + "...");
        ObjectEditorPanel editorView = this.invoiceTemplate.getNewEditPanel(null);
        if (ObjectEditorDialog.doDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), editorView) == 0) {
            editorView.saveObject();
            createdObj = editorView.getEditedObject();
            Assert.isTrue((createdObj != null ? 1 : 0) != 0, (String)"Failed to create an object");
            StockControlEventLog.logCreateStockInvoice((User)this.getUser(), (StockInvoice)((StockInvoice)createdObj));
            this.refresh();
        } else {
            editorView.cancelObject();
        }
        GuiApp.getAppComplex().getApplicationFrame().resetStatusBarText();
    }

    private boolean isEditAllowed() {
        User currentUser = this.getUser();
        PermissionGroup permissionGroup = currentUser.getPermissionGroup();
        if (permissionGroup == null) {
            return false;
        }
        return permissionGroup.hasPermission(AllPermissions.EDIT_INVOICES);
    }

    @Override
    public void doEditAction() {
        if (!(StockSupplier.stockSuppliersExist() && StockArea.stockAreasExist() && StockItemQueries.stockItemsExist())) {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "To edit an invoice, please ensure that you have set up at least one\n    - Stock Area \n    - Stock Item \n    - Stock Supplier", "Can't edit invoice!", 2);
            return;
        }
        if (!this.isEditAllowed()) {
            return;
        }
        StockInvoice editedObj = this.getCurrentStockInvoice();
        ObjectChangeRecorder changeRecorder = new ObjectChangeRecorder(this.invoiceTemplate);
        changeRecorder.snapshot(editedObj);
        GuiApp.getAppComplex().getApplicationFrame().setStatusBarText("Editing " + this.invoiceTemplate.getName() + ":  " + this.invoiceTemplate.getObjectText(editedObj));
        ObjectEditorPanel editorView = this.invoiceTemplate.getNewEditPanel(editedObj);
        int result = ObjectEditorDialog.doDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), editorView);
        if (result == 0) {
            editorView.saveObject();
            StockControlEventLog.logEditStockInvoice((User)this.getUser(), (StockInvoice)editedObj, changeRecorder.getChanges(editedObj));
            ((ObjectManagerI)GuiApp.getAppComplex().getApplicationContext()).getObjectManager().saveObject(editedObj, this.invoiceTemplate);
            this.refresh();
        } else if (result != 2) {
            editorView.cancelObject();
        }
        GuiApp.getAppComplex().getApplicationFrame().resetStatusBarText();
    }

    @Override
    public void doDeleteAction() {
        int result = JOptionPane.showConfirmDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "Are you sure you wish to delete the selected invoice? \nThis operation cannot be undone.", "Delete invoice?", 0, 2);
        if (result == 0) {
            int selRow = this.table.getSelectedRow();
            StockInvoice removedObj = this.getCurrentStockInvoice();
            GuiApp.getAppComplex().getApplicationFrame().setStatusBarText("Removing " + this.invoiceTemplate.getName() + ":  " + this.invoiceTemplate.getObjectText(removedObj));
            StockControlEventLog.logDeleteStockInvoice((User)this.getUser(), (StockInvoice)removedObj);
            removedObj.delete();
            this.refresh();
            int rowCount = this.table.getModel().getRowCount();
            this.table.requestFocus();
            if (selRow < rowCount) {
                this.table.setRowSelectionInterval(selRow, selRow);
            } else if (rowCount > 0) {
                this.table.setRowSelectionInterval(rowCount - 1, rowCount - 1);
            }
            GuiApp.getAppComplex().getApplicationFrame().resetStatusBarText();
            this.updateButtonStates();
        }
    }

    void gotEmailAction() {
        this.emailAction.setWorkingInvoice(this.getCurrentStockInvoice());
    }

    void gotExportAction() {
        this.exportAction.setParameters(this.datePanel.getStartDate(), this.datePanel.getEndDate(), this.table.getSelectedObjectIDs());
    }

    private class UpdateOnActionListener
    implements ActionListener {
        private UpdateOnActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StockInvoiceState.this.updatesAllowed) {
                StockInvoiceState.this.refresh();
            }
        }
    }

    private class InvoiceSetupTask
    extends AbstractGuiTask {
        private InvoiceSetupTask() {
        }

        public String getName() {
            return "Loading invoice screen...";
        }

        public void doGuiTask() throws Exception {
            StockInvoiceState.this.setupGUI();
            this.emitProgress();
            StockInvoiceState.this.setupTable();
            this.emitProgress();
            StockInvoiceState.this.setupTotalsPanel();
            this.emitProgress();
            StockInvoiceState.this.setupDates();
            this.emitProgress();
            StockInvoiceState.this.setupCheckBox();
            this.emitProgress();
            if (StockInvoiceState.this.table.getModel().getRowCount() > 0) {
                StockInvoiceState.this.table.getSelectionModel().setSelectionInterval(0, 0);
            }
            StockInvoiceState.this.alreadySetup = true;
            StockInvoiceState.this.refresh();
            this.emitProgress();
        }

        public int getTotalSubTasks() {
            return 6;
        }
    }
}

