/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.invoice.external;

import java.util.List;
import javax.swing.JOptionPane;
import officemate.OfficeMate;
import officemate.adminkit.dialogs.Dialogs;
import officemate.screens.maintainstock.invoice.external.StockResolverPanel;
import officemate.screens.maintainstock.invoice.external.StockSupplierResolverPanel;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockSupplier;
import ordermate.integration.invoicing.ExternalInvoiceResolver;

public class DefaultInvoiceResolver
extends ExternalInvoiceResolver {
    protected StockItem doDuplicateItems(StockItem prototype, List<StockItem> items) {
        StringBuilder SB = new StringBuilder("<html>There are two or more stock items with the same external identifier.\n");
        SB.append("Which stock item should be use in this instance?\n<html><ol>");
        for (StockItem item : items) {
            SB.append("<li>").append(item.getLabel()).append(" - ").append(item.getPurchaseQty()).append(item.getIngredientMeasureUnit()).append("</li>");
        }
        SB.append("</ol></html>");
        int selection = JOptionPane.showOptionDialog(OfficeMate.getApplicationFrame(), SB.toString(), "Duplicate Items", 0, 3, null, items.toArray(), items.get(0));
        if (selection >= 0 && selection < items.size()) {
            return items.get(selection);
        }
        return null;
    }

    protected StockItem doMatchItem(StockItem prototype) {
        StringBuilder SB = new StringBuilder("<html>No match could be found for the Stock Item.  Please select the appropriate match for the Stock Item:<br><br>");
        SB.append("<b>").append(prototype.getLabel()).append("</b>");
        SB.append("<table border=\"0\">");
        SB.append("<tr>");
        SB.append("<td>Outer Qty:</td>");
        SB.append("<td>").append(prototype.getOuterQuantity()).append("</td>");
        SB.append("</tr>");
        SB.append("<tr>");
        SB.append("<td>Inner Qty:</td>");
        SB.append("<td>").append(prototype.getPurchaseQty()).append("</td>");
        SB.append("</tr>");
        SB.append("<tr>");
        SB.append("<td>Base Cost:</td>");
        SB.append("<td>").append(prototype.getCurrentReplacementCost()).append("</td>");
        SB.append("</tr>");
        if (prototype.getBarcodes().size() > 0) {
            SB.append("<tr>");
            SB.append("<td>Barcode:</td>");
            SB.append("<td>").append((String)prototype.getBarcodes().get(0)).append("</td>");
            SB.append("</tr>");
        } else {
            SB.append("<tr>");
            SB.append("<td>No Barcode</td>");
            SB.append("</tr>");
        }
        SB.append("</table>");
        SB.append("</html>");
        StockResolverPanel panel = new StockResolverPanel(prototype);
        if (Dialogs.showOkCancelCustomDialog("Select Stock Item", SB.toString(), panel, panel.okSignal)) {
            return panel.getSelectedStockItem();
        }
        return null;
    }

    protected StockSupplier doMissingSupplier(StockSupplier prototype) {
        StringBuilder SB = new StringBuilder("<html>No match could be found for the Stock Supplier.<br><br>Please select the appropriate match:<br><br>");
        SB.append("<b>").append(prototype.getLabel()).append("</b>").append("<table border=\"0\">").append("<tr>");
        SB.append("<td>Address 1:</td>").append("<td>").append(prototype.getAddress1()).append("</td>").append("</tr>");
        SB.append("<td>Address 2:</td>").append("<td>").append(prototype.getAddress2()).append("</td>").append("</tr>");
        SB.append("<td>Email:</td>").append("<td>").append(prototype.getEmail()).append("</td>").append("</tr>");
        SB.append("<td>Phone:</td>").append("<td>").append(prototype.getPhone()).append("</td>").append("</tr>");
        SB.append("<td>Fax:</td>").append("<td>").append(prototype.getFax()).append("</td>").append("</tr>").append("</table></html>");
        StockSupplierResolverPanel resolverPanel = new StockSupplierResolverPanel(prototype);
        if (Dialogs.showOkCancelCustomDialog("Select Stock Supplier", SB.toString(), resolverPanel, resolverPanel.okSignal)) {
            return resolverPanel.getSelectedSupplier();
        }
        return null;
    }
}

