/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.invoice.external;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import officemate.adminkit.dialogs.Dialogs;
import officemate.screens.maintainstock.invoice.external.ImportedInvoicePanel;
import officemate.screens.maintainstock.invoice.external.InvoiceImporter;
import ordermate.database.integration.InvoiceIntegrationConfig;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockInvoice;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class ImportInvoiceAction
extends BasicAction {
    public static final Signal doAfterActionHandled = Signals.createSignal();

    public ImportInvoiceAction() {
        super(HtmlUtils.htmlCenter((String)"Import Invoice"), (Icon)IconLoader.get((String)"/ordermate/images/button_import.png"), "Import an invoice from a third party invoice provider.");
    }

    public void actionPerformed(ActionEvent e) {
        List configs = PersistenceManager.getObjectList(InvoiceIntegrationConfig.class, (String)Query.select(InvoiceIntegrationConfig.class).toString(), null);
        if (configs.size() == 0) {
            Dialogs.showErrorDialog("No Integration", "No Stock Invoice integrations have been set up.");
        }
        InvoiceIntegrationConfig config = (InvoiceIntegrationConfig)configs.get(0);
        if (configs.size() > 1) {
            config = (InvoiceIntegrationConfig)Dialogs.showOptionDialog("Select Integration Type", "Multiple stock invoice integration has been configured. Please select which one...", configs);
        }
        if (config == null) {
            return;
        }
        StockArea stockArea = config.getStockArea();
        if (stockArea == null) {
            stockArea = (StockArea)StockArea.getStockAreas().get(0);
        }
        if (StockArea.getStockAreas().size() > 1) {
            ArrayList<StockArea> stockAreas = new ArrayList<StockArea>(StockArea.getStockAreas());
            stockAreas.remove(stockArea);
            stockAreas.add(0, stockArea);
            stockArea = (StockArea)Dialogs.showOptionDialog("Select stock area for invoices", "Multiple stock areas has been configured. Please select which one...", stockAreas);
        }
        InvoiceImporter importer = new InvoiceImporter(config.getType());
        List<StockInvoice> invoices = importer.importInvoices();
        if (config.getStockArea() != stockArea) {
            for (StockInvoice invoice : invoices) {
                invoice.setStockArea(stockArea);
            }
        }
        if (invoices != null && !invoices.isEmpty()) {
            this.handleInvoices(invoices);
            doAfterActionHandled.emit();
        }
    }

    private void handleInvoices(List<StockInvoice> invoices) {
        ImportedInvoicePanel panel = new ImportedInvoicePanel(invoices);
        Dialogs.showOkCustomDialog("Imported Invoices", "All Invoices imported are shown in the table below.  Invoice can be added, merged or dropped.", panel);
    }
}

