/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.invoice.external;

import au.com.ordermate.glazedlists.ChangeableMatcherEditor;
import au.com.ordermate.glazedlists.PropertyMatcher;
import au.com.ordermate.glazedlists.TermPrefixMatcher;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.impl.matchers.OrMatcher;
import ca.odell.glazedlists.matchers.Matcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.database.stock.StockItem;

public class StockItemSuggestor {
    private StockItem prototypeItem;
    private Map<StockItem, String[]> stockTermMap = new HashMap<StockItem, String[]>();
    private EventList<StockItem> stockList;
    private FilterList<StockItem> filteredList;
    private TermPrefixMatcher<StockItem> descMatcher;
    private PropertyMatcher<StockItem> barcodeMatcher;
    private ChangeableMatcherEditor<StockItem> dynamicMatcher;

    public StockItemSuggestor() {
        List items = PersistenceManager.getObjectList(StockItem.class, (String)Query.select(StockItem.class).active(StockItem.class).toString());
        for (StockItem item : items) {
            this.stockTermMap.put(item, TermPrefixMatcher.splitToTerms((String)item.getLabel(), (boolean)true, (boolean)true));
        }
        this.descMatcher = new TermPrefixMatcher<StockItem>(){

            protected String[] getPrefixTerms(StockItem value) {
                return (String[])StockItemSuggestor.this.stockTermMap.get(value);
            }

            public void setPrefixString(String stringToProcess) {
                this.setPrefixTerms(1.splitToTerms((String)stringToProcess, (boolean)true, (boolean)true));
            }
        };
        this.barcodeMatcher = new PropertyMatcher((PropertyAccessor)StockItem.Properties.BARCODES);
        OrMatcher matcher = new OrMatcher(new Matcher[]{this.barcodeMatcher, this.descMatcher});
        this.stockList = GlazedLists.eventList((Collection)items);
        this.dynamicMatcher = new ChangeableMatcherEditor((Matcher)matcher);
        this.filteredList = new FilterList(this.stockList, this.dynamicMatcher);
    }

    public List<StockItem> getTopSuggestions() {
        return this.filteredList;
    }

    public List<StockItem> getAllStockItems() {
        return this.stockList;
    }

    public StockItem getPrototype() {
        return this.prototypeItem;
    }

    public void setPrototype(StockItem prototype) {
        this.prototypeItem = prototype;
        if (this.prototypeItem.getBarcodes().size() == 0) {
            this.barcodeMatcher.clearMatchValue();
        } else {
            this.barcodeMatcher.setMatchValue(this.prototypeItem.getBarcodes().get(0));
        }
        String[] processedTerms = this.processTerms(TermPrefixMatcher.splitToTerms((String)this.prototypeItem.getLabel(), (boolean)true, (boolean)true));
        this.descMatcher.setPrefixTerms(processedTerms);
        this.dynamicMatcher.matcherChanged();
    }

    private String[] processTerms(String[] terms) {
        ArrayList<String> processedTerms = new ArrayList<String>();
        int counter = 0;
        for (String term : terms) {
            if (Character.isLetter(term.charAt(0))) {
                if (term.length() > 2) {
                    processedTerms.add(term.substring(0, 2));
                } else {
                    processedTerms.add(term);
                }
                ++counter;
            }
            if (counter >= 3) break;
        }
        return processedTerms.toArray(new String[processedTerms.size()]);
    }

    public List<StockItem> getSuggestionStockList() {
        ArrayList<StockItem> items = new ArrayList<StockItem>();
        for (StockItem item : this.stockTermMap.keySet()) {
            if (!this.descMatcher.matches((Object)item)) continue;
            items.add(item);
        }
        return items;
    }
}

