/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.invoice.purchaseorder;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.message.Email;
import au.com.ordermate.message.MessageServer;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.StringUtils;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import officemate.screens.maintainstock.invoice.purchaseorder.PurchaseOrderReportProvider;
import ordermate.OrderMate;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.stock.StockInvoice;
import ordermate.integration.cloudback.OMOutgoingServiceResponse;
import ordermate.integration.cloudback.nudge.NudgeManager;

public class PurchaseOrderMailmanTask
extends AbstractTask
implements Serializable {
    private final StockInvoice invoice;
    private final String bodyText;
    private boolean taskResult;

    PurchaseOrderMailmanTask(StockInvoice theInvoice, String theBodyText) {
        this.invoice = theInvoice;
        this.bodyText = theBodyText;
    }

    public boolean getResult() {
        return this.taskResult;
    }

    public String getName() {
        return "Sending PO Email to Supplier...";
    }

    protected void performTask() throws Exception {
        this.taskResult = this.sendEmail();
    }

    protected int getTotalSubTasks() {
        return 0;
    }

    protected boolean sendEmail() {
        boolean result = false;
        if (!this.isInvoiceValid()) {
            return result;
        }
        Email toSend = this.createEmail();
        File toAttach = this.getPurchaseOrderReport(BusinessInfo.getInstance().getName());
        if (toAttach == null || !toAttach.exists() || !toAttach.isFile()) {
            OrderMate.LOG.error("The purchase order report to email, " + this.invoice.getOrderNumber() + " , could not be created and PDF-ified!");
            return false;
        }
        toSend.addAttachment(toAttach);
        OrderMate.LOG.info("Purchase Order " + this.invoice.getOrderNumber() + " generated, preparing to send...");
        if (NudgeManager.isNudgeConfigured()) {
            OMOutgoingServiceResponse nudgeResponse = NudgeManager.getInstance().sendEmail(toSend);
            result = nudgeResponse.isSuccessful();
        } else {
            MessageServer server = MessageServer.getServer();
            OrderMate.LOG.info("PurchaseOrderMailman connected to MessageServer!");
            server.connectSmtp();
            OrderMate.LOG.info("PurchaseOrderMailman connected to SMTP!");
            if (server.isSmtpConnected()) {
                result = server.send(toSend.createMessage(server.getSession()));
                OrderMate.LOG.info("PurchaseOrderMailman successfully sent the purchase order!");
            }
        }
        toAttach.delete();
        return result;
    }

    protected Email createEmail() {
        Email toSend = new Email();
        toSend.setSubject(BusinessInfo.getInstance().getName() + " Purchase Order: " + this.invoice.getOrderNumber());
        toSend.setText(this.bodyText != null ? this.bodyText : "");
        String emailSender = SystemProperty.getInstance().getEmailSender();
        if (!StringUtils.isEmpty((String)emailSender)) {
            toSend.addSender(emailSender, emailSender);
        }
        toSend.addToRecipient(this.invoice.getSupplier().getEmail(), this.invoice.getSupplier().getName());
        return toSend;
    }

    private File getPurchaseOrderReport(String businessName) {
        PurchaseOrderReportProvider provider = new PurchaseOrderReportProvider(this.invoice.getEntries(), this.invoice.getSupplier());
        provider.addParam("PARAM_PO_NO", this.invoice.getOrderNumber());
        provider.addParam("PARAM_PO_DATE", this.invoice.getDate());
        JasperPrint report = this.generateReport(provider);
        if (report == null) {
            OrderMate.LOG.error("Failed to create jasper report for StockInvoice " + this.invoice.toString());
            return null;
        }
        File file = new File(businessName + "-PurchaseOrder-" + this.invoice.getSupplier().getName() + DateTimeUtils.getDetailedDateString((Date)new Date()) + ".pdf");
        try {
            JasperExportManager.exportReportToPdfFile((JasperPrint)report, (String)file.getName());
        }
        catch (JRException e) {
            OrderMate.LOG.error("Failed to export jasper report " + report.getName() + " to PDF!", (Throwable)e);
        }
        return file;
    }

    private JasperPrint generateReport(PurchaseOrderReportProvider provider) {
        JasperPrint toReturn = null;
        try {
            toReturn = provider.getReportPrint();
        }
        catch (JRException e) {
            OrderMate.LOG.error("Failed to generate jasper report for PurchaseOrderReportProvider", (Throwable)e);
        }
        return toReturn;
    }

    private boolean isInvoiceValid() {
        if (this.invoice == null || this.invoice.getSupplier() == null || this.invoice.getSupplier().getEmail() == null || !"Purchase Order".equals(this.invoice.getInvoiceType())) {
            OrderMate.LOG.warn("StockInvoice was deemed invalid by the PurchaseOrderMailman. This invoice will not be sent.");
            return false;
        }
        return true;
    }
}

