/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.stocktake;

import au.com.ordermate.OrderMateLog;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import ordermate.database.config.Quantity;

public class QuantityCellEditor
extends DefaultCellEditor {
    private Quantity currentQty;

    public QuantityCellEditor() {
        super(new JTextField());
    }

    @Override
    public Component getTableCellEditorComponent(JTable theTable, Object theValue, boolean isSelected, int row, int column) {
        Object value = theValue;
        if (!(value instanceof Quantity)) {
            value = null;
        }
        this.currentQty = (Quantity)value;
        if (value == null) {
            JTextField text = (JTextField)super.getTableCellEditorComponent(theTable, new Double(0.0), isSelected, row, column);
            text.selectAll();
            return text;
        }
        Quantity quantity = (Quantity)value;
        JTextField text = (JTextField)super.getTableCellEditorComponent(theTable, new Double(quantity.doubleValue(3)), isSelected, row, column);
        text.selectAll();
        return text;
    }

    @Override
    public Object getCellEditorValue() {
        Object editedValue = super.getCellEditorValue();
        if (editedValue == null || String.valueOf(editedValue).length() == 0) {
            this.currentQty = null;
            return this.currentQty;
        }
        try {
            double value = Double.parseDouble(String.valueOf(editedValue));
            this.currentQty = this.currentQty != null ? new Quantity(this.currentQty.getMeasureUnit(), value * this.currentQty.getMeasureUnit().getValue()) : new Quantity(value);
        }
        catch (NumberFormatException ex) {
            OrderMateLog.LOG.warn("Invalid input into quantity field.", (Throwable)ex);
        }
        return this.currentQty;
    }
}

