/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.stocktake;

import au.com.ordermate.application.ApplicationComplex;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import officemate.OfficeMate;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.print.Printing;
import officemate.adminkit.table.LinkedTotalTable;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.misc.StockControlEventLog;
import ordermate.database.reports.stocktake.StockTakeReportMaker;
import ordermate.database.searchers.stock.stocktake.StockEntryAggregate;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockTake;
import ordermate.database.stock.StockTakeEntry;
import ordermate.database.users.User;
import ordermate.scheduler.AutoSender;

class StockTakeHelper {
    private ApplicationComplex complex;

    StockTakeHelper(ApplicationComplex appComplex) {
        this.complex = appComplex;
    }

    void deleteStockTake(StockTake toDelete) {
        int result = JOptionPane.showConfirmDialog(this.complex.getApplicationFrame().getFrame(), "Are you sure you want to delete the live stocktake?", "Delete stocktake?", 0);
        if (result == 0) {
            StockTake currentStockTake = toDelete;
            currentStockTake.delete();
            StockControlEventLog.logStockTakeModification((EventContext)OfficeMate.getInstance().getEventContext(), (String)"Deleted");
        }
    }

    void newStockTake() {
        Dialogs.showProgressDialog(new AbstractTask(){

            public String getName() {
                return "Creating stocktake...";
            }

            public void performTask() throws Exception {
                StockTake.createStockTake();
                this.emitProgress();
                StockControlEventLog.logStockTakeModification((EventContext)OfficeMate.getInstance().getEventContext(), (String)"Created");
            }

            public int getTotalSubTasks() {
                return 1;
            }
        });
    }

    boolean updateStocktake(final StockTake stocktake) {
        if (!stocktake.isLive()) {
            JOptionPane.showMessageDialog(this.complex.getApplicationFrame().getFrame(), "Stocktake has already been saved, cannot save again.", "Cannot save", 0);
            return false;
        }
        int result = JOptionPane.showConfirmDialog(this.complex.getApplicationFrame().getFrame(), "Saving will override all current stock levels with those \nrecorded here, and all recorded values will be permanently frozen. \n<html><font color=\"red\"> THIS OPERATION CANNOT BE UNDONE. </font></html>\n\nAre you sure you wish to save and update?", "Save and Update?", 0, 2);
        if (result == 0) {
            if (stocktake.hasUncounted()) {
                int zeroResult = JOptionPane.showConfirmDialog(this.complex.getApplicationFrame().getFrame(), "Uncounted items still remain; would you like to zero the remaining uncounted entries?", "Zero uncounted items?", 1);
                if (zeroResult == 0) {
                    Dialogs.showProgressDialog(new AbstractTask(){
                        List<StockArea> areas = StockArea.getStockAreas();

                        public String getName() {
                            return "Zeroing Uncounted";
                        }

                        protected void performTask() throws Exception {
                            for (StockArea area : this.areas) {
                                stocktake.setUncountedToZero(area);
                                this.emitProgress();
                            }
                            StockControlEventLog.logStockTakeModification((EventContext)OfficeMate.getInstance().getEventContext(), (String)"Zeroed uncounted items");
                        }

                        protected int getTotalSubTasks() {
                            return this.areas.size();
                        }
                    });
                } else if (zeroResult == 2) {
                    return false;
                }
            }
            StockControlEventLog.logStocktakeSaveUpdate((User)this.complex.getApplicationSecurity().getUser(), (StockTake)stocktake);
            Dialogs.showProgressDialog(new StocktakeSaveTask(stocktake));
            return true;
        }
        return false;
    }

    void print(StockTake stocktake, StockArea area, StockGroup group, JTable activeTable, LinkedTotalTable totalsTable, boolean showRec, boolean showNRec, boolean showVar) {
        String groupString = group != null ? " Group: " + group.toString() : "";
        String areaString = area != null ? " Area: " + area.toString() : "";
        String recordedString = "";
        String heading = "Stocktake Report";
        if (!showRec || !showNRec) {
            if (showVar) {
                heading = "Variance Report";
                if (showRec) {
                    recordedString = "(Including recorded items)";
                } else if (showNRec) {
                    recordedString = "(Including unrecorded items)";
                }
            } else if (showRec) {
                recordedString = "(Recorded items only)";
            } else if (showNRec) {
                recordedString = "(Unrecorded items only)";
            }
        }
        String title = heading + ": " + stocktake.getDate();
        Printing.printJTableReport(activeTable, title, groupString + areaString + recordedString, 8, totalsTable.getColumnStrings());
    }

    boolean setUncountedToZero(StockTake stocktake, StockArea area) {
        int result = JOptionPane.showConfirmDialog(this.complex.getApplicationFrame().getFrame(), "This should only be done once the first count has been completed. \nAre you sure you want to zero all uncounted items in this stock area?", "Zero uncounted?", 0, 3);
        if (result == 0) {
            stocktake.setUncountedToZero(area);
            return true;
        }
        return false;
    }

    boolean checkEntriesChanged(List<StockTakeEntry> entries) {
        boolean changed = false;
        if (!entries.isEmpty() && !(entries.get(0) instanceof StockEntryAggregate)) {
            for (StockTakeEntry entry : entries) {
                StockTakeEntry reacquired;
                if (entry instanceof StockEntryAggregate || (reacquired = (StockTakeEntry)PersistenceManager.reacquire((PersistentObjectI)entry)).getVariance().equals((Object)entry.getVariance())) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            String log = "Attempting to save or print Stocktake while it's different between screen and db.";
            OrderMate.LOG.warn(log);
            StockControlEventLog.logStockTakeModification((EventContext)OfficeMate.getInstance().getEventContext(), (String)log);
            Dialogs.showInfoDialog("StockTake has Changed", "The currently displayed stocktake appears to have\nbeen modified from another terminal.\n\nPlease review the values are correct before proceeding.");
            return true;
        }
        return false;
    }

    void emailReport() {
        AutoSender.getInstance().emailReport(StockTakeReportMaker.class);
    }

    private static class StocktakeSaveTask
    extends AbstractTask {
        StockTake stockTake;

        public StocktakeSaveTask(StockTake stockTakeToSave) {
            this.stockTake = stockTakeToSave;
        }

        public String getName() {
            return "Saving stocktake...";
        }

        public void performTask() throws Exception {
            this.stockTake.updateStock();
            this.emitProgress();
        }

        public int getTotalSubTasks() {
            return 1;
        }
    }
}

