/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.stocktake;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.configuration.Config;
import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.gui.actions.PermissibleAction;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.OperationFailedException;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import officemate.OfficeMate;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.state.login.LoginState;
import officemate.adminkit.table.GroupedTable;
import officemate.adminkit.table.GroupedTableModel;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.strategy.SaveStrategyFactory;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.SplitTableState;
import officemate.components.table.TableStateCentralArea;
import officemate.components.table.TotalsTableModelBuilder;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.PropertyAccessorColumnFormat;
import officemate.components.tree.StockGroupTreeFilterPanel;
import officemate.screens.maintainstock.stocktake.QuantityCellEditor;
import officemate.screens.maintainstock.stocktake.StockTakeEntrySearch;
import officemate.screens.maintainstock.stocktake.StockTakeHelper;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.misc.StockControlEventLog;
import ordermate.database.queries.stock.StockItemQueries;
import ordermate.database.reports.stocktake.StockTakeReportProvider;
import ordermate.database.reports.stocktake.StockTakeView;
import ordermate.database.reports.stocktake.StockTakeViewFactory;
import ordermate.database.searchers.stock.stocktake.StockTakeSearcher;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockTake;
import ordermate.database.stock.StockTakeEntry;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.ColumnVisibilityHelper;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.reports.dynamicjasper.reportbuilder.ReportProvider;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import ordermate.signals.Signal;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class StockTakeState
extends AbstractEditableTableState<StockTakeEntry>
implements ActionListener {
    private static final int REFRESH_TIME = 600000;
    private static final String[] totalColumns = new String[]{StockTakeEntry.Properties.VARIANCE_COST.getUserVisibleLabel(), StockTakeEntry.Properties.VARIANCE_COST_EX.getUserVisibleLabel(), StockTakeEntry.Properties.TOTAL_ACTUAL_VALUE.getUserVisibleLabel(), StockTakeEntry.Properties.TOTAL_ACTUAL_VALUE_EX.getUserVisibleLabel()};
    private static final PropertiedObject.Property[] exTaxColumns = new PropertiedObject.Property[]{StockTakeEntry.Properties.VARIANCE_COST_EX, StockTakeEntry.Properties.TOTAL_ACTUAL_VALUE_EX};
    private static final PropertiedObject.Property[] incTaxColumns = new PropertiedObject.Property[]{StockTakeEntry.Properties.VARIANCE_COST, StockTakeEntry.Properties.TOTAL_ACTUAL_VALUE};
    private StockTakeViewFactory viewFactory = new StockTakeViewFactory();
    private StockTakeView view = StockTakeView.NORMAL_VIEW;
    private JCheckBox expectedColVisibleCheck;
    private ColumnVisibilityHelper expectedColumnHelper;
    private JCheckBox groupBox;
    private JPanel controlPanel;
    private PermissibleAction createNewStocktake;
    private PermissibleAction setToZero;
    private PermissibleAction update;
    private PermissibleAction edit;
    private PermissibleAction deleteLive;
    private Timer refreshTimer;
    private int lastRow;
    private StockTakeEntrySearch stockTakeEntrySearch;

    public StockTakeState(StockTakeEntrySearch stockTakeEntrySearch) {
        super("Stocktakes", AllPermissions.ACCESS_STOCKTAKES_SCREEN, "Create, modify and save stocktakes");
        this.stockTakeEntrySearch = stockTakeEntrySearch;
        this.setSaveStrategy(SaveStrategyFactory.getInstantSaveStrategy(0L));
        this.refreshTimer = new Timer(600000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JXTable table = StockTakeState.this.getCentralArea().getTable();
                StockTakeState.this.lastRow = table.getSelectedRow();
                StockTakeState.this.refresh();
            }
        });
        this.refreshTimer.setRepeats(true);
    }

    @Override
    protected void init() {
        PersistenceManager.getObjectList(StockItem.class, (String)Query.select(StockItem.class).active(StockItem.class).toString());
        if (this.initCalled) {
            return;
        }
        super.init();
    }

    public ColumnVisibilityHelper getExpectedColumnHelper() {
        return this.expectedColumnHelper;
    }

    public StockTakeView getView() {
        return this.view;
    }

    @Override
    protected void onStart() {
        GuiApp.getAppComplex().getApplicationFrame().setStatusBarText("Loading Stocktake screen...");
        if (!StockArea.stockAreasExist() || !StockItemQueries.stockItemsExist()) {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "To view the Stocktake screen, please ensure that you have set up at least one\n    - Stock Area \n    - Stock Item ", "Can't view Stocktake screen!", 2);
        } else {
            super.onStart();
            if (this.isFirstRun()) {
                this.configureNav();
                this.groupOnStockGroup(true);
                this.groupBox.setSelected(true);
            }
        }
        GuiApp.getAppComplex().getApplicationFrame().resetStatusBarText();
        this.refreshTimer.start();
    }

    @Override
    protected void onEnd() {
        this.refreshTimer.stop();
        super.onEnd();
    }

    @Override
    protected OfficeMateObjectSearch<StockTakeEntry> createSearchPanelFactory() {
        if (!this.stockTakeEntrySearch.aggregationUpdated.isConnected()) {
            this.stockTakeEntrySearch.aggregationUpdated.connect((Object)this, "updateView");
        }
        return this.stockTakeEntrySearch;
    }

    protected StockTakeEntrySearch getSearchFactory() {
        return (StockTakeEntrySearch)super.getSearchFactory();
    }

    @Override
    protected ObjectEditor<StockTakeEntry> createObjectEditor() {
        return null;
    }

    @Override
    public String getTypeName() {
        return "StockTake";
    }

    private void setupControlPanel() {
        this.controlPanel = new JPanel(new BorderLayout());
        this.controlPanel.add((Component)super.getControlPanel(), "West");
        boolean expectedAllowed = this.getUser().hasPermission(AllPermissions.DISPLAY_STOCKTAKE_EXPECTED_COLUMN);
        this.expectedColVisibleCheck = new JCheckBox();
        this.expectedColVisibleCheck.setName("Display Expected Column");
        this.expectedColVisibleCheck.setSelected(expectedAllowed);
        StandardSecurityDecorator showExpectedWrapper = new StandardSecurityDecorator((JComponent)this.expectedColVisibleCheck, AllPermissions.DISPLAY_STOCKTAKE_EXPECTED_COLUMN);
        this.groupBox = new JCheckBox();
        this.groupBox.setName("Group Results");
        this.groupBox.addActionListener(this);
        FieldPanelBuilder builder = new FieldPanelBuilder();
        builder.addRow("Show ExpectedQty", (Component)showExpectedWrapper);
        builder.addRow("Group by Stock Group", (Component)this.groupBox);
        this.controlPanel.add((Component)builder.getPanel(), "Center");
    }

    @Override
    public boolean supportsPrint() {
        return true;
    }

    @Override
    public Action getPrintAction() {
        if (Config.getBooleanValue((String)"oldSkoolStockTakePrint")) {
            return super.getPrintAction();
        }
        return new PrintAction();
    }

    @Override
    public JPanel getControlPanel() {
        if (this.controlPanel == null) {
            this.setupControlPanel();
        }
        return this.controlPanel;
    }

    @Override
    protected TableStateCentralArea<StockTakeEntry> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new PropertyAccessorColumnFormat(StockTakeEntry.Properties.STOCK_ITEM, StockItem.Properties.STOCK_GROUP), new PropertyColumnFormat(StockTakeEntry.Properties.STOCK_ITEM), new PropertyColumnFormat(StockTakeEntry.Properties.STOCK_AREA), new PropertyColumnFormat((PropertiedObject.Property)StockTakeEntry.Properties.EXPECTED_QUANTITY), new EditablePropertyColumnFormat(StockTakeEntry.Properties.OUTER_QTY), new EditablePropertyColumnFormat(StockTakeEntry.Properties.UNIT_QTY), new PropertyColumnFormat((PropertiedObject.Property)StockTakeEntry.Properties.ACTUAL_QUANTITY), new PropertyColumnFormat((PropertiedObject.Property)StockTakeEntry.Properties.TOTAL_ACTUAL_VALUE), new PropertyColumnFormat((PropertiedObject.Property)StockTakeEntry.Properties.TOTAL_ACTUAL_VALUE_EX), new PropertyColumnFormat((PropertiedObject.Property)StockTakeEntry.Properties.VARIANCE), new PropertyColumnFormat((PropertiedObject.Property)StockTakeEntry.Properties.VARIANCE_COST), new PropertyColumnFormat((PropertiedObject.Property)StockTakeEntry.Properties.VARIANCE_COST_EX)});
        PersistentObjectTable mainTable = new PersistentObjectTable(this.getObjectList(), format, new PropertiedObject.Property[0]);
        ((EventTableModel)mainTable.getTable().getModel()).addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                StockTakeState.this.tableChanged();
            }
        });
        mainTable.getTable().setColumnControlVisible(false);
        ArrayList<String> ignore = new ArrayList<String>();
        ignore.add(StockTakeEntry.Properties.OUTER_QTY.getUserVisibleLabel());
        ignore.add(StockTakeEntry.Properties.UNIT_QTY.getUserVisibleLabel());
        ignore.add(StockTakeEntry.Properties.ACTUAL_QUANTITY.getUserVisibleLabel());
        ignore.add(StockTakeEntry.Properties.EXPECTED_QUANTITY.getUserVisibleLabel());
        mainTable.setTotalsBuilder(new TotalsTableModelBuilder(ignore));
        StockGroupTreeFilterPanel treePanel = new StockGroupTreeFilterPanel((Refreshable)this.getSearchFactory(), this.getSearchFactory().getStockGroupSearch());
        SplitTableState<StockTakeEntry> splitter = SplitTableState.createHorizontalSplit(treePanel, mainTable);
        return splitter;
    }

    @Override
    protected Class<StockTakeEntry> getDisplayingType() {
        return StockTakeEntry.class;
    }

    private void configureNav() {
        Signal<User, ?, ?, ?, ?> login = LoginState.getInstance().login;
        User user = GuiApp.getAppComplex().getApplicationSecurity().getUser();
        this.createNewStocktake = new PermissibleAction("New", AllPermissions.CREATE_STOCKTAKE, login, IconLoader.get((String)"/ordermate/images/new_icon22.png"), "Create a new stocktake or switch to the current Live stocktake", user){

            public void actionPerformed(ActionEvent e) {
                StockTakeState.this.doNewStocktake();
            }
        };
        this.update = new PermissibleAction("Save", AllPermissions.SAVE_STOCKTAKE, login, IconLoader.get((String)"/ordermate/images/save.png"), "Save and Update the stocktake", user){

            public void actionPerformed(ActionEvent e) {
                StockTakeState.this.doUpdate();
            }
        };
        this.setToZero = new PermissibleAction("Set Empty To Zero", AllPermissions.EDIT_STOCKTAKE, login, IconLoader.get((String)"/ordermate/images/settozero.png"), "Sets the count for all uncounted items to zero.", user){

            public void actionPerformed(ActionEvent e) {
                StockTakeState.this.doSetAllNonRecordedValuesToZero();
            }
        };
        this.edit = new PermissibleAction("Edit", AllPermissions.EDIT_STOCKTAKE, login, IconLoader.get((String)"/ordermate/images/edit_icon22.png"), "Edit the current live stocktake", user){

            public void actionPerformed(ActionEvent e) {
                StockTakeState.this.doEdit((StockTakeEntry)StockTakeState.this.getCentralArea().getSelectedObject());
            }
        };
        this.deleteLive = new PermissibleAction("Delete", AllPermissions.DELETE_STOCKTAKE, login, IconLoader.get((String)"/ordermate/images/delete_icon22.png"), "Delete the current live stocktake", user){

            public void actionPerformed(ActionEvent e) {
                StockTakeState.this.deleteStockTake();
            }
        };
        this.addAction((Action)this.createNewStocktake);
        this.addAction((Action)this.update);
        this.addAction((Action)this.setToZero);
        this.addAction((Action)this.edit);
        this.addAction((Action)this.deleteLive);
    }

    private void doNewStocktake() {
        StockTake stocktake = this.getCurrentStockTake();
        if (stocktake == null || !stocktake.isLive()) {
            StockTake livetake = StockTake.getLiveStockTake();
            if (livetake == null) {
                try {
                    livetake = StockTake.createStockTake();
                    StockControlEventLog.logStockTakeModification((EventContext)OfficeMate.getInstance().getEventContext(), (String)"Created");
                }
                catch (OperationFailedException ex) {
                    OrderMateLog.LOG.warn("Problem creating stocktake:", (Throwable)ex);
                    Dialogs.showErrorDialog("Cannot create Stocktake", "The Stocktake could not be created.");
                    livetake = null;
                }
            }
            if (livetake != null) {
                StockTakeEntrySearch search = this.getSearchFactory();
                search.reaquireSearchOptions();
                search.setSelectedStocktake(livetake);
            }
        }
    }

    @Override
    protected void doDelete(List toDelete) {
    }

    private void deleteStockTake() {
        if (!this.checkStockTakeStillLive()) {
            return;
        }
        StockTake currentStockTake = this.getCurrentStockTake();
        if (currentStockTake != null && currentStockTake.isLive()) {
            StockTakeHelper helper = new StockTakeHelper(GuiApp.getAppComplex());
            helper.deleteStockTake(currentStockTake);
            StockTakeEntrySearch search = this.getSearchFactory();
            search.reaquireSearchOptions();
            search.selectFirstStocktake();
            this.tableChanged();
        }
    }

    @Override
    protected boolean doEdit(StockTakeEntry entry) {
        if (!this.checkStockTakeStillLive()) {
            return false;
        }
        this.refreshTimer.stop();
        if (entry != null) {
            int row;
            JXTable table = this.getCentralArea().getTable();
            this.lastRow = row = table.getSelectedRow();
            int col = table.getColumnModel().getColumnIndex(StockTakeEntry.Properties.UNIT_QTY);
            table.getSelectionModel().setSelectionInterval(row, row);
            table.grabFocus();
            this.refreshTimer.start();
            return table.editCellAt(row, col);
        }
        this.refreshTimer.start();
        return false;
    }

    private void doUpdate() {
        if (this.checkStockTakeStillLive() && this.getCurrentStockTake() != null) {
            StockTake currentStockTake = this.getCurrentStockTake();
            currentStockTake = (StockTake)PersistenceManager.reacquire((PersistentObjectI)currentStockTake);
            StockTakeHelper helper = new StockTakeHelper(GuiApp.getAppComplex());
            StockControlEventLog.logStockTakeModification((EventContext)OfficeMate.getInstance().getEventContext(), (String)"Attempting to save.");
            if (!helper.checkEntriesChanged((List<StockTakeEntry>)this.getObjectList())) {
                if (helper.updateStocktake(currentStockTake)) {
                    StockControlEventLog.logStockTakeModification((EventContext)OfficeMate.getInstance().getEventContext(), (String)"Updated, saved and closed");
                    StockTakeEntrySearch search = this.getSearchFactory();
                    search.reaquireSearchOptions();
                    search.setSelectedStocktake(currentStockTake);
                    helper.emailReport();
                    this.tableChanged();
                }
            } else {
                this.refresh();
            }
        }
    }

    private void doSetAllNonRecordedValuesToZero() {
        if (!this.checkStockTakeStillLive()) {
            return;
        }
        StockTake currentStockTake = this.getCurrentStockTake();
        if (currentStockTake != null) {
            currentStockTake = (StockTake)PersistenceManager.reacquire((PersistentObjectI)currentStockTake);
            StockTakeHelper helper = new StockTakeHelper(GuiApp.getAppComplex());
            if (helper.setUncountedToZero(currentStockTake, this.getCurrentArea())) {
                StockControlEventLog.logStockTakeModification((EventContext)OfficeMate.getInstance().getEventContext(), (String)"Set remaining to zero");
                this.refresh();
            }
        }
    }

    @Override
    protected StockTakeEntry createNewObject() {
        return null;
    }

    private void tableChanged() {
        StockTake currentStockTake = this.getCurrentStockTake();
        boolean isLive = currentStockTake != null && currentStockTake.isLive();
        this.getCentralArea().getTable().setEditable(isLive && !this.getSearchFactory().isAggregated());
        if (this.createNewStocktake != null) {
            this.createNewStocktake.setEnabled(!isLive);
            this.deleteLive.setEnabled(isLive);
            this.update.setEnabled(isLive);
            this.setToZero.setEnabled(isLive);
            this.edit.setEnabled(isLive);
        }
    }

    private StockTake getCurrentStockTake() {
        Boolean liveness;
        Object[][] result;
        StockTake stockTake = this.getSearchFactory().getSelectedStockTake();
        if (stockTake != null && stockTake.isLive() && stockTake.isPersistent() && (result = PersistenceManager.getPersistenceDelegate().executeQuery("SELECT Live FROM stock_take WHERE ID = ?", new Object[]{stockTake.getID()})) != null && result.length == 1 && (liveness = (Boolean)result[0][0]) != null && Boolean.FALSE.equals(liveness)) {
            OrderMate.LOG.info("Stocktake has been closed by another user!");
            stockTake = (StockTake)PersistenceManager.reacquire((PersistentObjectI)stockTake);
        }
        return stockTake;
    }

    private StockArea getCurrentArea() {
        return this.getSearchFactory().getSelectedStockArea();
    }

    @Override
    protected void postRefresh() {
        super.postRefresh();
        StockTakeEntrySearch search = this.getSearchFactory();
        search.reaquireSearchOptions();
        if (this.lastRow >= 0) {
            JXTable table = this.getCentralArea().getTable();
            table.getSelectionModel().setSelectionInterval(this.lastRow, this.lastRow);
            table.grabFocus();
            table.scrollRowToVisible(this.lastRow);
        }
    }

    void updateView() {
        TableColumnExt column;
        StockTakeView newView = this.viewFactory.makeView(this.getSearchFactory().getAggregatedType());
        JXTable table = this.getCentralArea().getTable();
        if (this.view != null) {
            for (PropertiedObject.Property prop : this.view.getInvalidProperties()) {
                column = table.getColumnExt((Object)prop);
                if (column == null) continue;
                column.setVisible(true);
            }
        }
        this.view = newView;
        for (PropertiedObject.Property prop : this.view.getInvalidProperties()) {
            column = table.getColumnExt((Object)prop);
            if (column == null) continue;
            column.setVisible(false);
        }
    }

    private void groupOnStockGroup(boolean value) {
        String toGroup = null;
        if (value) {
            toGroup = "Stock Group";
        }
        ((PersistentObjectTable)((SplitTableState)this.getCentralArea()).getWrappedTableArea()).groupOn(toGroup, totalColumns);
        if (this.expectedColumnHelper != null) {
            this.expectedColumnHelper.unbind();
        }
        this.expectedColumnHelper = new ColumnVisibilityHelper((Object[])new PropertiedObject.Property[]{StockTakeEntry.Properties.EXPECTED_QUANTITY, StockTakeEntry.Properties.VARIANCE, StockTakeEntry.Properties.VARIANCE_COST, StockTakeEntry.Properties.VARIANCE_COST_EX}, this.expectedColVisibleCheck, this.getCentralArea().getTable());
        this.expectedColVisibleCheck.addActionListener(this);
        TableCellRenderer defaultRenderer = this.getCentralArea().getTable().getDefaultRenderer(Object.class);
        TableColumnExt outerQuantity = this.getCentralArea().getTable().getColumnExt((Object)StockTakeEntry.Properties.OUTER_QTY);
        outerQuantity.setCellRenderer(new OuterUnitRenderer(defaultRenderer));
        outerQuantity.setCellEditor(new OuterUnitEditor());
        TableColumnExt unitQuantity = this.getCentralArea().getTable().getColumnExt((Object)StockTakeEntry.Properties.UNIT_QTY);
        unitQuantity.setCellRenderer(new UnitQuantityRenderer(defaultRenderer));
        unitQuantity.setCellEditor(new UnitQuantityEditor());
        TableColumnExt expectedQuantity = this.getCentralArea().getTable().getColumnExt((Object)StockTakeEntry.Properties.EXPECTED_QUANTITY);
        expectedQuantity.setCellRenderer(defaultRenderer);
        TableColumnExt actualQuantity = this.getCentralArea().getTable().getColumnExt((Object)StockTakeEntry.Properties.ACTUAL_QUANTITY);
        actualQuantity.setCellEditor(new QuantityCellEditor());
        NoValueRenderer blankRenderer = new NoValueRenderer(defaultRenderer, StockTakeEntry.Properties.RAW_ACTUAL_QTY);
        blankRenderer.setHorizontalAlignment(4);
        actualQuantity.setCellRenderer(blankRenderer);
        this.getCentralArea().getTable().getColumnExt((Object)StockTakeEntry.Properties.VARIANCE).setCellRenderer((TableCellRenderer)blankRenderer);
        TableColumnExt stockItemCol = this.getCentralArea().getTable().getColumnExt((Object)StockTakeEntry.Properties.STOCK_ITEM);
        stockItemCol.setPreferredWidth(210);
        TableColumnExt stockAreaCol = this.getCentralArea().getTable().getColumnExt((Object)StockTakeEntry.Properties.STOCK_AREA);
        stockAreaCol.setPreferredWidth(25);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gotObjectEdited(StockTakeEntry editedObject) {
        if (!this.checkStockTakeStillLive()) {
            return;
        }
        super.gotObjectEdited(editedObject);
        if (editedObject != null) {
            StockTakeEntry updatedEntry = this.getCurrentStockTake().updateStockTakeEntry(editedObject);
            EventList entries = this.getObjectList();
            try {
                entries.getReadWriteLock().writeLock().lock();
                int index = entries.indexOf((Object)editedObject);
                if (index >= 0 && index < entries.size()) {
                    entries.set(index, (Object)updatedEntry);
                }
                StockControlEventLog.logStockTakeEntryUpdated((EventContext)OfficeMate.getInstance().getEventContext(), (StockTakeEntry)updatedEntry);
            }
            finally {
                entries.getReadWriteLock().writeLock().unlock();
            }
        }
    }

    private boolean checkStockTakeStillLive() {
        StockTake currentStockTake = this.getCurrentStockTake();
        if (currentStockTake != null && !currentStockTake.isLive()) {
            Dialogs.showInfoDialog("Cannot Edit Stocktake", "The stocktake has been closed by another user.");
            this.tableChanged();
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.groupBox) {
            this.groupOnStockGroup(this.groupBox.isSelected());
        }
        this.updateView();
    }

    class NoValueRenderer
    extends JLabel
    implements TableCellRenderer {
        private TableCellRenderer wrappedRenderer;
        private PropertiedObject.Property prop;

        public NoValueRenderer(TableCellRenderer renderer, PropertiedObject.Property dependentProperty) {
            this.wrappedRenderer = renderer;
            this.prop = dependentProperty;
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component superRenderer = this.wrappedRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setBackground(superRenderer.getBackground());
            int index = row;
            if (table instanceof GroupedTable) {
                index = ((GroupedTableModel)table.getModel()).getOriginalRow(row);
            }
            EventList list = StockTakeState.this.getObjectList();
            list.getReadWriteLock().readLock().lock();
            if (index >= 0 && index < StockTakeState.this.getObjectList().size()) {
                PersistentObject item = (PersistentObject)StockTakeState.this.getObjectList().get(index);
                if (item != null && item.getPropertyValue(this.prop) == null) {
                    this.setText("");
                } else {
                    this.setText(String.valueOf(((JLabel)superRenderer).getText()));
                }
            } else {
                this.setText("");
            }
            list.getReadWriteLock().readLock().unlock();
            return this;
        }
    }

    class UnitQuantityRenderer
    extends AbstractQuantityRenderer
    implements TableCellRenderer {
        public UnitQuantityRenderer(TableCellRenderer renderer) {
            super(renderer);
        }

        @Override
        protected double convertValue(Number value, StockItem item) {
            return value.doubleValue() / item.getDisplayMeasureUnitContainer().getMultiplier();
        }

        @Override
        protected String getSuffix(StockItem item) {
            if (item.getDisplayMeasureUnitContainer().getMeasureContainer() != null) {
                String label = item.getDisplayMeasureUnitContainer().getMeasureContainer().getLabel();
                if ("<none>".equals(label)) {
                    DecimalFormat df = new DecimalFormat("0.###");
                    label = " x " + df.format(item.getDisplayMeasureUnitContainer().getMultiplier()) + item.getDisplayMeasureUnitContainer().getMeasureUnit().getSuffix();
                }
                return label;
            }
            return item.getDisplayMeasureUnitContainer().getMeasureUnit().getSuffix();
        }

        @Override
        protected boolean canRender(StockItem item) {
            return true;
        }
    }

    class OuterUnitRenderer
    extends AbstractQuantityRenderer {
        public OuterUnitRenderer(TableCellRenderer renderer) {
            super(renderer);
        }

        @Override
        protected double convertValue(Number value, StockItem item) {
            return value.doubleValue() / (item.getDisplayMeasureUnitContainer().getMultiplier() * item.getOuterQuantity() * item.getPurchaseQty().doubleValue());
        }

        @Override
        protected String getSuffix(StockItem item) {
            return item.getOuterName();
        }

        @Override
        protected boolean canRender(StockItem item) {
            return item.getOuterQuantity() != 1.0 || item.getPurchaseQty().doubleValue() != 1.0;
        }
    }

    abstract class AbstractQuantityRenderer
    extends JLabel
    implements TableCellRenderer {
        private DecimalFormat dc = new DecimalFormat("0.###");
        private TableCellRenderer wrappedRenderer;

        public AbstractQuantityRenderer(TableCellRenderer renderer) {
            this.wrappedRenderer = renderer;
            this.setHorizontalAlignment(4);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = this.wrappedRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setBackground(comp.getBackground());
            int index = row;
            index = table instanceof GroupedTable ? ((GroupedTableModel)table.getModel()).getOriginalRow(row) : ((JXTable)table).convertRowIndexToModel(index);
            EventList list = StockTakeState.this.getObjectList();
            list.getReadWriteLock().readLock().lock();
            if (index >= 0 && index < StockTakeState.this.getObjectList().size()) {
                StockItem item = ((StockTakeEntry)StockTakeState.this.getObjectList().get(index)).getStockItem();
                if (this.canRender(item)) {
                    StringBuilder SB = new StringBuilder();
                    if (value == null) {
                        SB.append("____");
                    } else if (value instanceof Number) {
                        SB.append(this.dc.format(this.convertValue((Number)value, item)));
                    }
                    String suffix = this.getSuffix(item).trim();
                    if (!suffix.isEmpty()) {
                        SB.append(" ");
                        SB.append(this.getSuffix(item).trim());
                    }
                    this.setText(SB.toString());
                } else {
                    this.setText("");
                }
            } else {
                this.setText("");
            }
            list.getReadWriteLock().readLock().unlock();
            return this;
        }

        protected abstract double convertValue(Number var1, StockItem var2);

        protected abstract String getSuffix(StockItem var1);

        protected abstract boolean canRender(StockItem var1);
    }

    class UnitQuantityEditor
    extends AbstractQuantityEditor {
        UnitQuantityEditor() {
        }

        @Override
        protected Double convertToRaw(double value, StockItem item) {
            if (item != null && item.getDisplayMeasureUnitContainer() != null) {
                return value * item.getDisplayMeasureUnitContainer().getMultiplier();
            }
            OrderMate.LOG.warn("Null item or measure unit container for item, could not correctly display the raw unit!");
            return null;
        }

        @Override
        protected String convertToDisplay(double value, StockItem item) {
            return this.dc.format(value / item.getDisplayMeasureUnitContainer().getMultiplier());
        }

        @Override
        protected boolean canEdit(StockItem item) {
            return StockTakeState.this.checkStockTakeStillLive();
        }
    }

    class OuterUnitEditor
    extends AbstractQuantityEditor {
        OuterUnitEditor() {
        }

        @Override
        protected Double convertToRaw(double value, StockItem item) {
            return value * (item.getDisplayMeasureUnitContainer().getMultiplier() * item.getOuterQuantity() * item.getPurchaseQty().doubleValue());
        }

        @Override
        protected String convertToDisplay(double value, StockItem item) {
            return this.dc.format(value / (item.getDisplayMeasureUnitContainer().getMultiplier() * item.getOuterQuantity() * item.getPurchaseQty().doubleValue()));
        }

        @Override
        protected boolean canEdit(StockItem item) {
            return StockTakeState.this.checkStockTakeStillLive() && (item.getOuterQuantity() != 1.0 || item.getPurchaseQty().doubleValue() != 1.0);
        }
    }

    abstract class AbstractQuantityEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        protected DecimalFormat dc = new DecimalFormat("0.###");
        private JTextField textField = new JTextField();
        private StockItem currentItem;

        @Override
        public Object getCellEditorValue() {
            String value = this.textField.getText();
            if (value == null) {
                return null;
            }
            String toParse = value.trim();
            if (toParse.length() == 0) {
                return null;
            }
            try {
                return this.convertToRaw(Double.parseDouble(toParse), this.currentItem);
            }
            catch (NumberFormatException ex) {
                OrderMateLog.LOG.warn("Invalid numerical quantity:", (Throwable)ex);
                this.cancelCellEditing();
                return null;
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            int index = row;
            index = table instanceof GroupedTable ? ((GroupedTableModel)table.getModel()).getOriginalRow(row) : ((JXTable)table).convertRowIndexToModel(index);
            if (index < 0 || index >= StockTakeState.this.getObjectList().size()) {
                this.currentItem = null;
                this.textField.setText("");
                this.textField.setEditable(false);
                return this.textField;
            }
            this.currentItem = ((StockTakeEntry)StockTakeState.this.getObjectList().get(index)).getStockItem();
            if (!this.canEdit(this.currentItem)) {
                this.textField.setText("");
                this.textField.setEditable(false);
            } else {
                if (value == null) {
                    value = table.getValueAt(row, column);
                }
                if (value != null) {
                    String original = String.valueOf(value).trim();
                    if (original.indexOf(" ") > 0) {
                        original = original.substring(0, original.indexOf(" "));
                    }
                    this.textField.setText(this.convertToDisplay(Double.parseDouble(original), this.currentItem));
                } else {
                    this.textField.setText("");
                }
                this.textField.setEditable(true);
                this.textField.setSelectionStart(0);
                this.textField.setSelectionEnd(this.textField.getText().length());
            }
            return this.textField;
        }

        protected abstract String convertToDisplay(double var1, StockItem var3);

        protected abstract Double convertToRaw(double var1, StockItem var3);

        protected abstract boolean canEdit(StockItem var1);
    }

    private class PrintAction
    extends BasicAction {
        public PrintAction() {
            super("Print", (Icon)IconLoader.get((String)"/ordermate/images/print_icon22.png"), "Print the report of the stocktake");
        }

        public void actionPerformed(ActionEvent e) {
            StockControlEventLog.logStockTakeModification((EventContext)OfficeMate.getInstance().getEventContext(), (String)"Attempting to print.");
            StockTakeHelper helper = new StockTakeHelper(GuiApp.getAppComplex());
            if (!helper.checkEntriesChanged((List<StockTakeEntry>)StockTakeState.this.getObjectList())) {
                StockTakeReportProvider provider = new StockTakeReportProvider(StockTakeState.this.expectedColumnHelper.isVisible(), StockTakeState.this.view, (StockTakeSearcher)StockTakeState.this.getSearchFactory().getPropertySearcher());
                provider.addParam("OM_USER", (Object)StockTakeState.this.getUser());
                Dialogs.showJasperPrintDialog((ReportProvider)provider);
            } else {
                StockTakeState.this.refresh();
            }
        }
    }
}

