/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintenance.advanced.contest;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.persistence.PropertiedObject;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.util.Collection;
import javax.swing.table.TableCellEditor;
import officemate.components.strategy.DeferredSaveStrategy;
import officemate.components.strategy.StrategySaveCancelListener;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.PopupEditableColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import officemate.screens.maintenance.advanced.contest.ContestItemUnitEntityEditor;
import officemate.screens.maintenance.advanced.contest.ContestOptionEntityEditor;
import officemate.screens.maintenance.advanced.contest.ContestPlusEntityEditor;
import officemate.screens.maintenance.advanced.contest.ContestSearch;
import officemate.screens.maintenance.advanced.contest.GenericContestEntityEditor;
import ordermate.database.contest.Contest;
import ordermate.database.contest.ContestEntityType;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.inventory.InventoryAddGroup;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.queries.inventory.InventoryGroupQueries;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.AbstractColumnFormat;
import ordermate.reports.table.ColumnFormat;

public class ContestSetupState
extends AbstractEditableTableState<Contest>
implements StrategySaveCancelListener {
    private GenericContestEntityEditor<Contest, InventoryGroup> sectionEntityEditor;
    private GenericContestEntityEditor<Contest, InventoryCategory> categoryEntityEditor;
    private ContestItemUnitEntityEditor itemUnitEntityEditor;
    private GenericContestEntityEditor<Contest, InventoryCombo> comboEntityEditor;
    private GenericContestEntityEditor<Contest, InventoryAddGroup> plusGroupEditor;
    private ContestPlusEntityEditor plusEditor;
    private GenericContestEntityEditor<Contest, InventoryOptionGroup> optionGroupEditor;
    private ContestOptionEntityEditor optionEditor;
    private final EventList systemStates = GlazedLists.eventList(SystemState.defaultEditableSystemStates.values());

    public ContestSetupState() {
        super("Contests", AllPermissions.ACCESS_SALES_REPORT, "Edit a contest and its entities");
        DeferredSaveStrategy strategy = new DeferredSaveStrategy((Refreshable)this).setRefreshOnSave(false);
        this.setSaveStrategy(strategy);
    }

    @Override
    public void preSave() {
    }

    @Override
    public void preCancel() {
    }

    @Override
    public void postSave() {
    }

    @Override
    public void onEnd() {
        this.promptForSave();
        super.onEnd();
    }

    @Override
    protected ObjectEditor<Contest> createObjectEditor() {
        return null;
    }

    @Override
    protected Contest createNewObject() {
        return new Contest("New Contest");
    }

    @Override
    public String getTypeName() {
        return "Contests Setup";
    }

    @Override
    protected TableStateCentralArea<Contest> createCentralArea() {
        this.categoryEntityEditor = new GenericContestEntityEditor(ContestEntityType.Category, GlazedLists.eventList((Collection)InventoryCategory.getAllCategories()));
        this.sectionEntityEditor = new GenericContestEntityEditor(ContestEntityType.Section, GlazedLists.eventList((Collection)InventoryGroupQueries.getAllGroups()));
        this.itemUnitEntityEditor = new ContestItemUnitEntityEditor();
        this.comboEntityEditor = new GenericContestEntityEditor(ContestEntityType.Combo, GlazedLists.eventList((Collection)InventoryCombo.getAllActiveCombos()));
        this.plusGroupEditor = new GenericContestEntityEditor(ContestEntityType.PlusGroup, GlazedLists.eventList((Collection)InventoryAddGroup.getAllAddGroups()));
        this.plusEditor = new ContestPlusEntityEditor();
        this.optionGroupEditor = new GenericContestEntityEditor(ContestEntityType.OptionGroup, GlazedLists.eventList((Collection)InventoryOptionGroup.getOptionGroups()));
        this.optionEditor = new ContestOptionEntityEditor();
        PersistentObjectTable<Contest> centralArea = new PersistentObjectTable<Contest>(this.getObjectList(), new ColumnTableFormat((ColumnFormat[])new AbstractColumnFormat[]{new EditablePropertyColumnFormat(Contest.Properties.NAME), new EditablePropertyColumnFormat(Contest.Properties.DESCRIPTION), new EditablePropertyColumnFormat(Contest.Properties.SHOW_IN_WAITERMATE), new EditablePropertyColumnFormat(Contest.Properties.SYSTEM_STATE).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(this.systemStates))), new PopupEditableColumnFormat((PropertiedObject.Property)Contest.Properties.CATEGORIES, this.categoryEntityEditor, this), new PopupEditableColumnFormat((PropertiedObject.Property)Contest.Properties.SECTIONS, this.sectionEntityEditor, this), new PopupEditableColumnFormat((PropertiedObject.Property)Contest.Properties.ITEM_UNITS, this.itemUnitEntityEditor, this).setName("Items"), new PopupEditableColumnFormat((PropertiedObject.Property)Contest.Properties.COMBOS, this.comboEntityEditor, this), new PopupEditableColumnFormat((PropertiedObject.Property)Contest.Properties.PLUS_GROUPS, this.plusGroupEditor, this), new PopupEditableColumnFormat((PropertiedObject.Property)Contest.Properties.PLUSES, this.plusEditor, this), new PopupEditableColumnFormat((PropertiedObject.Property)Contest.Properties.OPTION_GROUPS, this.optionGroupEditor, this), new PopupEditableColumnFormat((PropertiedObject.Property)Contest.Properties.OPTIONS, this.optionEditor, this)}));
        centralArea.getTable().getColumn(0).setHeaderValue("Contests");
        centralArea.getTable().setName("ContestSetupTable");
        return centralArea;
    }

    protected ContestSearch createSearchPanelFactory() {
        return new ContestSearch();
    }

    @Override
    protected Class<Contest> getDisplayingType() {
        return Contest.class;
    }
}

