/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintenance.advanced.humpback;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.filter.AbstractSearcher;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ordermate.OrderMate;

class HumpSyncSearcher
extends AbstractSearcher<PersistentObject> {
    private final ISingleValueSearchFilter<Class> classFilter = new ClassSearchFilter();
    private final HasMasterIdSearchFilter hasMasterIdFilter = new HasMasterIdSearchFilter();
    private final ObjectSearchFilter<String> idFilter = new ObjectSearchFilter<String>(null){

        public ObjectQuery addQueryRestriction(ObjectQuery query) {
            if (this.hasSearchValue()) {
                String id = (String)super.getSearchValue();
                try {
                    Long actualId = Long.parseLong(id);
                    query.whereFunction("ID = " + actualId);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return query;
        }
    };
    private final MasterIdSearchFilter masterIdFilter = new MasterIdSearchFilter();
    private final ObjectSearchFilter<String> labelFilter;

    HumpSyncSearcher() {
        super(PersistentObject.class);
        this.labelFilter = new ObjectSearchFilter(PersistentDisplayableObject.Properties.LABEL);
    }

    public ISingleValueSearchFilter<Class> getClassFilter() {
        return this.classFilter;
    }

    public ISingleValueSearchFilter<Boolean> getHasMasterIdFilter() {
        return this.hasMasterIdFilter;
    }

    public ObjectQuery getObjectQuery() {
        Class clazz = (Class)this.classFilter.getSearchValue();
        ObjectQuery query = Query.select((Class)clazz);
        if (this.hasMasterIdFilter.hasSearchValue()) {
            if (this.hasMasterIdFilter.getSearchValue().booleanValue()) {
                query.whereFunction("masterId is not null");
            } else {
                query.whereFunction("masterId is null");
            }
        }
        this.idFilter.addQueryRestriction(query);
        this.masterIdFilter.addQueryRestriction(query);
        if (PropertiedObject.PropsHelper.getProperties((Class)clazz).hasProperty("systemState")) {
            query.active(clazz);
        }
        return query;
    }

    public List<PersistentObject> search() {
        if (this.isActive()) {
            ObjectQuery query = this.getObjectQuery();
            try {
                ArrayList<PersistentObject> objects = PersistenceManager.getObjectList((Class)((Class)this.classFilter.getSearchValue()), (String)query.toString());
                if (this.labelFilter.hasSearchValue()) {
                    String label = (String)this.labelFilter.getSearchValue();
                    ArrayList<PersistentObject> newList = new ArrayList<PersistentObject>();
                    for (PersistentObject obj : objects) {
                        if (!obj.toString().toLowerCase().contains(label)) continue;
                        newList.add(obj);
                    }
                    objects = newList;
                }
                return objects;
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot retrieve humpback sync objects", (Throwable)ex);
            }
        }
        return Collections.emptyList();
    }

    public ISingleValueSearchFilter<String> getIdFilter() {
        return this.idFilter;
    }

    public ISingleValueSearchFilter<String> getMasterIdFilter() {
        return this.masterIdFilter;
    }

    public ISingleValueSearchFilter<String> getLabelFilter() {
        return this.labelFilter;
    }

    class MasterIdSearchFilter
    extends ObjectSearchFilter<String> {
        public MasterIdSearchFilter() {
            super(null);
        }

        public ObjectQuery addQueryRestriction(ObjectQuery query) {
            if (this.hasSearchValue()) {
                String value = (String)this.getSearchValue();
                query.whereFunction("masterId = " + value);
            }
            return query;
        }
    }

    class HasMasterIdSearchFilter
    implements ISingleValueSearchFilter<Boolean> {
        Boolean hasMasterId = Boolean.FALSE;

        HasMasterIdSearchFilter() {
        }

        public boolean hasSearchValue() {
            return this.hasMasterId != null;
        }

        public void clearSearch() {
            this.hasMasterId = null;
        }

        public PropertiedObject.Property getProperty() {
            return null;
        }

        public void setProperty(PropertiedObject.Property prop) {
        }

        public void setSearchValue(Boolean value) {
            this.hasMasterId = value;
        }

        public Boolean getSearchValue() {
            return this.hasMasterId;
        }
    }

    class ClassSearchFilter<T>
    implements ISingleValueSearchFilter<Class<T>> {
        private Class<T> clazz;

        ClassSearchFilter() {
        }

        public boolean hasSearchValue() {
            return this.clazz != null;
        }

        public void clearSearch() {
            this.clazz = null;
        }

        public PropertiedObject.Property getProperty() {
            return null;
        }

        public void setProperty(PropertiedObject.Property prop) {
        }

        public void setSearchValue(Class<T> value) {
            this.clazz = value == null ? null : value;
        }

        public Class<T> getSearchValue() {
            return this.clazz;
        }
    }
}

