/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintenance.advanced.unknown.linking;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.util.image.IconLoader;
import au.com.ordermate.util.image.ImageHelper;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import officemate.OfficeMate;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.search.SearchDialog;
import officemate.adminkit.searchpanels.InventoryAddSearchPanel;
import officemate.adminkit.searchpanels.InventoryComboSearchPanel;
import officemate.adminkit.searchpanels.InventoryItemSearchPanel;
import officemate.adminkit.searchpanels.InventoryOptionSearchPanel;
import officemate.adminkit.searchpanels.InventoryRemoveSearchPanel;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.maintenance.advanced.unknown.AbstractSalesUnknownState;
import officemate.screens.maintenance.advanced.unknown.linking.SalesUnknownLinkingTableFormat;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.InventoryRemove;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.sales.unknown.SalesUnknown;
import ordermate.database.sales.unknown.SalesUnknownType;

public class SalesUnknownLinkingState
extends AbstractSalesUnknownState {
    public SalesUnknownLinkingState() {
        super("Online Menu Mapping", "Shows all unknown entities received from third parties and allows linking back to real menu entities.");
        this.addAction((Action)((Object)new SalesUnknownLinkAction()));
    }

    @Override
    protected ColumnTableFormat getTableFormat() {
        return new SalesUnknownLinkingTableFormat();
    }

    @Override
    protected boolean showLinked() {
        return false;
    }

    class SalesUnknownLinkAction
    extends BasicAction {
        private static final String NO_SELECTION_ERROR_TITLE = "No selection!";
        private static final String NO_SELECTION_ERROR_MESSAGE = "Please select at least one menu mapping to link.";
        private static final String INVALID_SELECTION_ERROR_TITLE = "Invalid selection!";
        private static final String INVALID_SELECTION_ERROR_MESSAGE = "You cannot add links for multiple mappings of different types at once. Please select only mappings of the same type before trying to add a link.";
        private static final String PROMPT_FOR_PROFILE_TITLE = "Which profile?";
        private static final String PROMPT_FOR_PROFILE_MESSAGE = "Please select an inventory profile...";

        public SalesUnknownLinkAction() {
            this.setText("Link Selected");
            this.setToolTipText("Links the selected online menu entities to a POS menu entity.");
            ImageIcon icon = IconLoader.get((String)"/officemate/images/link-white-22.png");
            icon.setImage(new ImageHelper().tintImage(icon.getImage(), Color.BLACK, 0.5f));
            this.setIcon(icon);
        }

        public void actionPerformed(ActionEvent e) {
            List<SalesUnknown> selected = SalesUnknownLinkingState.this.getCentralArea().getAllSelectedObjects();
            if (selected.isEmpty()) {
                Dialogs.showErrorDialog(NO_SELECTION_ERROR_TITLE, NO_SELECTION_ERROR_MESSAGE);
                return;
            }
            if (!this.isSelectionValid(selected)) {
                Dialogs.showErrorDialog(INVALID_SELECTION_ERROR_TITLE, INVALID_SELECTION_ERROR_MESSAGE);
                return;
            }
            SearchDialog<?> searchDialog = this.getSearchDialogForType(selected.get(0).getType().getPosClass());
            if (searchDialog != null) {
                searchDialog.setVisible(true);
                if (!searchDialog.wasCancelled()) {
                    for (SalesUnknown selection : selected) {
                        selection.setPosId(searchDialog.getFoundObject().getID());
                        selection.save();
                    }
                    SalesUnknownLinkingState.this.refresh();
                }
            }
        }

        private boolean isSelectionValid(List<SalesUnknown> selected) {
            SalesUnknownType type = selected.get(0).getType();
            for (SalesUnknown unknown : selected) {
                if (type.equals((Object)unknown.getType())) continue;
                return false;
            }
            return true;
        }

        private <T> SearchDialog<?> getSearchDialogForType(Class<T> type) {
            if (InventoryItemUnit.class.equals(type)) {
                InventoryProfile profile = this.promptForProfile();
                if (profile != null) {
                    return new SearchDialog(OfficeMate.getApplicationFrame(), new InventoryItemSearchPanel(profile, true), "Find Item...");
                }
            } else if (InventoryCombo.class.equals(type)) {
                InventoryProfile profile = this.promptForProfile();
                if (profile != null) {
                    return new SearchDialog(OfficeMate.getApplicationFrame(), new InventoryComboSearchPanel(profile), "Find Combo...");
                }
            } else {
                if (InventoryAdd.class.equals(type)) {
                    return new SearchDialog(OfficeMate.getApplicationFrame(), new InventoryAddSearchPanel(), "Find Add...");
                }
                if (InventoryRemove.class.equals(type)) {
                    InventoryProfile profile = this.promptForProfile();
                    if (profile != null) {
                        return new SearchDialog(OfficeMate.getApplicationFrame(), new InventoryRemoveSearchPanel(profile), "Find Remove...");
                    }
                } else if (InventoryOption.class.equals(type)) {
                    return new SearchDialog(OfficeMate.getApplicationFrame(), new InventoryOptionSearchPanel(true), "Find Option...");
                }
            }
            return null;
        }

        private InventoryProfile promptForProfile() {
            return (InventoryProfile)Dialogs.showOptionDialog(PROMPT_FOR_PROFILE_TITLE, PROMPT_FOR_PROFILE_MESSAGE, InventoryProfile.getAllProfiles());
        }
    }
}

