/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintenance.advanced.unknown.linking;

import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.StringUtils;
import officemate.screens.maintenance.advanced.unknown.AbstractSalesUnknownTableFormat;
import ordermate.database.sales.unknown.SalesUnknown;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

class SalesUnknownLinkingTableFormat
extends AbstractSalesUnknownTableFormat {
    private static final ColumnFormat[] formats = new ColumnFormat[]{SalesUnknownLinkingTableFormat.createTypeColumnFormat(), new PropertyColumnFormat(SalesUnknown.Properties.LABEL), new PropertyColumnFormat(SalesUnknown.Properties.SOURCE), new PropertyColumnFormat(SalesUnknown.Properties.DATE), SalesUnknownLinkingTableFormat.createTimeColumnFormat(), SalesUnknownLinkingTableFormat.createAccountColumnFormat(), SalesUnknownLinkingTableFormat.createOptionalColumnFormat("Price", SalesUnknown.Properties.PRICE), SalesUnknownLinkingTableFormat.createOptionalColumnFormat("Quantity", SalesUnknown.Properties.QUANTITY), SalesUnknownLinkingTableFormat.createExternalIdFormat(), SalesUnknownLinkingTableFormat.createOrderIdColumnFormat()};

    public SalesUnknownLinkingTableFormat() {
        super(formats);
    }

    private static ColumnFormat createExternalIdFormat() {
        return new PropertyColumnFormat("Third Party Entity ID", SalesUnknown.Properties.EXT_ID){

            public Object resolveColumnValue(Object baseObject) {
                String value = ((SalesUnknown)baseObject).getExtId();
                if (!StringUtils.isEmpty((String)value)) {
                    if (value.startsWith("-")) {
                        return value.substring(1);
                    }
                    return value;
                }
                return "None Set";
            }
        };
    }

    private static PropertyColumnFormat createTimeColumnFormat() {
        return new PropertyColumnFormat(SalesUnknown.Properties.TIME){

            public Object resolveColumnValue(Object baseObject) {
                return DateTimeUtils.getSimpleTimeFormat().format(((SalesUnknown)baseObject).getTime());
            }
        };
    }

    private static PropertyColumnFormat createAccountColumnFormat() {
        return new PropertyColumnFormat("Receipt No", SalesUnknown.Properties.ACCOUNT){

            public Object resolveColumnValue(Object baseObject) {
                if (((SalesUnknown)baseObject).getAccount() != null) {
                    return ((SalesUnknown)baseObject).getAccount().getID();
                }
                return null;
            }
        };
    }

    private static PropertyColumnFormat createOrderIdColumnFormat() {
        return new PropertyColumnFormat("Third Party Order ID", SalesUnknown.Properties.ORDER_ID){

            public Object resolveColumnValue(Object baseObject) {
                return ((SalesUnknown)baseObject).getOrderId() == null ? "" : ((SalesUnknown)baseObject).getOrderId();
            }
        };
    }
}

