/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintenance.advanced.unknown.unlinking;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.util.image.IconLoader;
import au.com.ordermate.util.image.ImageHelper;
import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.ImageIcon;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.maintenance.advanced.unknown.AbstractSalesUnknownState;
import officemate.screens.maintenance.advanced.unknown.SyncHumpBackAction;
import officemate.screens.maintenance.advanced.unknown.unlinking.SalesUnknownUnlinkingTableFormat;
import ordermate.database.sales.unknown.SalesUnknown;

public class SalesUnknownUnlinkingState
extends AbstractSalesUnknownState {
    public SalesUnknownUnlinkingState() {
        super("Already Linked", "Shows all unknown entities received from third parties that are already linked to real menu entities and provides a place for unlinking.");
        this.addAction((Action)((Object)new SalesUnknownUnlinkAction()));
        this.addAction((Action)((Object)new SyncHumpBackAction(new RefreshAction((Refreshable)this))));
    }

    @Override
    protected ColumnTableFormat getTableFormat() {
        return new SalesUnknownUnlinkingTableFormat();
    }

    @Override
    protected boolean showLinked() {
        return true;
    }

    class SalesUnknownUnlinkAction
    extends BasicAction {
        private static final String NO_SELECTION_ERROR_TITLE = "No selection!";
        private static final String NO_SELECTION_ERROR_MESSAGE = "Please select at least one menu mapping to link.";
        private static final String CONFIRMATION_TITLE = "Confirm?";
        private static final String CONFIRMATION_MESSAGE = "Are you sure you wish to remove this link? This cannot be undone.";

        SalesUnknownUnlinkAction() {
            this.setText("Unlink Selected");
            this.setToolTipText("Unlinks the selected online menu entities from the POS menu entity.");
            ImageIcon icon = IconLoader.get((String)"/officemate/images/link-broken-white-22.png");
            icon.setImage(new ImageHelper().tintImage(icon.getImage(), Color.BLACK, 0.5f));
            this.setIcon(icon);
        }

        public void actionPerformed(ActionEvent e) {
            if (SalesUnknownUnlinkingState.this.getCentralArea().getAllSelectedObjects().isEmpty()) {
                Dialogs.showErrorDialog(NO_SELECTION_ERROR_TITLE, NO_SELECTION_ERROR_MESSAGE);
            } else if (Dialogs.showWarningDialog(CONFIRMATION_TITLE, CONFIRMATION_MESSAGE)) {
                for (SalesUnknown selected : SalesUnknownUnlinkingState.this.getCentralArea().getAllSelectedObjects()) {
                    selected.setPosId(null);
                    selected.save();
                }
                SalesUnknownUnlinkingState.this.refresh();
            }
        }
    }
}

