/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.messaging.sms;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.configuration.Config;
import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.search.searchfield.java.StringSearchField;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import officemate.OfficeMate;
import officemate.components.search.AbstractSearchDialog;
import officemate.components.search.MultiItemSearchDialog;
import officemate.components.search.objectsearch.CustomerSearcherGui;
import officemate.components.search.objectsearch.UserSearchState;
import officemate.components.search.searchfield.ObjectSearchField;
import ordermate.OrderMate;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.users.User;
import ordermate.services.messages.SendSmsExecutable;

public class SmsSendPanel
extends JPanel
implements ActionListener {
    private static final Dimension DIALOG_SIZE = new Dimension(500, 400);
    private final String HTML_FORMAT_COLOR_RED_TAG = "<html><font color=\"red\">";
    private final String HTML_FORMAT_COLOR_END_TAG = "</font></html>";
    private final int COLUMN_PHONE_NR = 1;
    private final int MAX_SHORT_MESSAGE_SIZE = 160;
    private GraphPaperLayout layout;
    private JButton btnClose;
    private JButton btnSend;
    private JButton btnAddCustomer;
    private JButton btnAddUser;
    private JButton btnAddCustom;
    private JButton btnRemove;
    private AddCustomerSearchField searchFieldCustomer;
    private AddUserSearchField searchFieldUser;
    private JTable tableReceivers;
    private DefaultTableModel tableModelReceivers;
    private JScrollPane tableReceiversScrollPane;
    private JTextArea message;
    private JScrollPane messageScrollPane;
    private JLabel sizeCount;
    private JDialog sendDialog;
    private Window topWindow;

    public SmsSendPanel(Window parent) {
        this.topWindow = parent;
        if (!SwingUtilities.isEventDispatchThread() && Config.isDebuging()) {
            throw new IllegalStateException("Not running the EDT.");
        }
        this.setLayout((LayoutManager)this.getPanelLayout());
        this.init();
        this.setSize(DIALOG_SIZE);
    }

    private void init() {
        if (this.initButtons()) {
            this.add((Component)new JLabel("To:"), new Rectangle(0, 0, 4, 1));
            this.add((Component)this.getReceiversTableScrollPane(), new Rectangle(0, 1, 5, 5));
            this.add((Component)this.btnAddCustomer, new Rectangle(5, 1, 2, 1));
            this.add((Component)this.btnAddUser, new Rectangle(5, 2, 2, 1));
            this.add((Component)this.btnAddCustom, new Rectangle(5, 3, 2, 1));
            this.add((Component)this.btnRemove, new Rectangle(5, 4, 2, 1));
            this.add((Component)new JLabel("Message:"), new Rectangle(0, 6, 4, 1));
            this.add((Component)this.getMessageTextAreaScrollPane(), new Rectangle(0, 7, 7, 3));
            this.add((Component)this.getSizeCountLabel(), new Rectangle(0, 10, 2, 1));
            this.add((Component)this.btnClose, new Rectangle(3, 10, 2, 1));
            this.add((Component)this.btnSend, new Rectangle(5, 10, 2, 1));
        }
    }

    public void openSendDialog() {
        this.clearAllComponents();
        this.getSendDialog().setVisible(true);
    }

    private void closeSendDialog() {
        this.getSendDialog().setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.btnClose)) {
            this.closeSendDialog();
        } else if (e.getSource().equals(this.btnSend)) {
            this.doSendMessage(new Runnable(){

                @Override
                public void run() {
                    SmsSendPanel.this.closeSendDialog();
                }
            }, new Runnable(){

                @Override
                public void run() {
                }
            });
        } else if (e.getSource().equals(this.btnAddCustom)) {
            String phoneNr = JOptionPane.showInputDialog(this, "Enter a custom mobile phone number: ", "Custom mobile phone number", 3);
            if (phoneNr != null && !phoneNr.trim().isEmpty()) {
                this.addItemsToReceiver(phoneNr, "< Custom Number >");
            }
        } else if (e.getSource().equals(this.btnRemove) && this.tableReceivers.getSelectedRow() >= 0) {
            this.tableModelReceivers.removeRow(this.tableReceivers.getSelectedRow());
        }
    }

    private void removeAllItemsFromReceiverTable() {
        for (int i = this.tableModelReceivers.getRowCount() - 1; i >= 0; --i) {
            this.tableModelReceivers.removeRow(i);
        }
        this.tableReceivers.repaint();
    }

    public void addItemsToReceiver(String phoneNr, String name) {
        Object[] tableItem = new String[]{name, phoneNr};
        if (!this.isPhoneNumberAlreadyInList(phoneNr)) {
            this.tableModelReceivers.addRow(tableItem);
        }
    }

    private void removeItemFromReceiver(String phoneNr) {
        if (this.tableModelReceivers.getDataVector().size() > 0) {
            for (int i = 0; i < this.tableModelReceivers.getRowCount(); ++i) {
                if (!this.tableModelReceivers.getValueAt(i, 1).equals(phoneNr)) continue;
                this.tableModelReceivers.removeRow(i);
                return;
            }
        }
    }

    private boolean isPhoneNumberAlreadyInList(String number) {
        if (this.tableModelReceivers.getDataVector().size() > 0) {
            for (int i = 0; i < this.tableModelReceivers.getRowCount(); ++i) {
                if (!this.tableModelReceivers.getValueAt(i, 1).equals(number)) continue;
                return true;
            }
        }
        return false;
    }

    private void doSendMessage(Runnable afterSuccessfulSendRunnable, Runnable afterFailedSendRunnable) {
        try {
            if (this.tableModelReceivers.getRowCount() > 0) {
                List<String> phoneNumbers = this.getAllPhoneNumbersFromTable();
                if (this.getMessageTextArea().getText().length() > 0 && !this.getMessageTextArea().getText().equals("")) {
                    if (this.sendMessageToNumbers(phoneNumbers, this.getMessageTextArea().getText()).booleanValue()) {
                        afterSuccessfulSendRunnable.run();
                    } else {
                        this.setErrorText("Error while sending...");
                        afterFailedSendRunnable.run();
                    }
                } else {
                    this.setErrorText("Empty message...");
                    afterFailedSendRunnable.run();
                }
            } else {
                this.setErrorText("No Recipients...");
                afterFailedSendRunnable.run();
            }
        }
        catch (Exception e) {
            OrderMate.LOG.error("Error while sending SMS to several receivers...");
            this.setErrorText("Error while sending...");
            afterFailedSendRunnable.run();
        }
    }

    private List<String> getAllPhoneNumbersFromTable() {
        ArrayList<String> numbers = new ArrayList<String>();
        if (this.tableModelReceivers.getRowCount() > 0) {
            for (int iRow = 0; iRow < this.tableModelReceivers.getRowCount(); ++iRow) {
                numbers.add((String)this.tableModelReceivers.getValueAt(iRow, 1));
            }
        }
        return numbers;
    }

    private Boolean sendMessageToNumbers(List<String> numbers, String message) {
        return (Boolean)PersistenceManager.getServerConnection().runSync((Executable)new SendSmsExecutable(numbers, message, GuiApp.getAppComplex().getApplicationSecurity().getUser()));
    }

    private void updateSizeCounter(int size) {
        String text = size + "/" + 160;
        if (size > 160) {
            this.getSizeCountLabel().setText("<html><font color=\"red\">" + text + "</font></html>");
        } else {
            this.getSizeCountLabel().setText(text);
        }
    }

    private void setErrorText(String error) {
        this.getSizeCountLabel().setText("<html><font color=\"red\">" + error + "</font></html>");
    }

    private void clearAllComponents() {
        this.removeAllItemsFromReceiverTable();
        this.getMessageTextArea().setText("");
        this.updateSizeCounter(0);
    }

    private JDialog getSendDialog() {
        if (this.sendDialog == null) {
            this.sendDialog = new JDialog((Window)OfficeMate.getApplicationFrame(), "Send SMS", Dialog.ModalityType.APPLICATION_MODAL);
            this.sendDialog.setSize(DIALOG_SIZE);
            this.sendDialog.getContentPane().add(this);
            this.sendDialog.setIconImage(IconLoader.get((String)"/officemate/images/pda_blue.png").getImage());
            this.sendDialog.setLocationRelativeTo(this.topWindow);
        }
        return this.sendDialog;
    }

    private GraphPaperLayout getPanelLayout() {
        if (this.layout == null) {
            this.layout = new GraphPaperLayout(new Dimension(7, 11), 5, 5);
        }
        return this.layout;
    }

    private JScrollPane getReceiversTableScrollPane() {
        if (this.tableReceiversScrollPane == null) {
            this.tableReceiversScrollPane = new JScrollPane(this.getReceiversTable());
        }
        return this.tableReceiversScrollPane;
    }

    private JTable getReceiversTable() {
        if (this.tableReceivers == null) {
            this.tableReceivers = new JTable();
            if (this.tableModelReceivers == null) {
                this.tableModelReceivers = new NonEditableTableModel();
            }
            this.tableReceivers.setModel(this.tableModelReceivers);
        }
        return this.tableReceivers;
    }

    private JScrollPane getMessageTextAreaScrollPane() {
        if (this.messageScrollPane == null) {
            this.messageScrollPane = new JScrollPane(this.getMessageTextArea());
        }
        return this.messageScrollPane;
    }

    private JTextArea getMessageTextArea() {
        if (this.message == null) {
            this.message = new JTextArea();
            this.message.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    SmsSendPanel.this.updateSizeCounter(SmsSendPanel.this.message.getText().length());
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }
            });
            this.message.setEditable(true);
            this.message.setLineWrap(true);
        }
        return this.message;
    }

    private JLabel getSizeCountLabel() {
        if (this.sizeCount == null) {
            this.sizeCount = new JLabel();
            this.sizeCount.setText("0/160");
        }
        return this.sizeCount;
    }

    private boolean initButtons() {
        try {
            if (this.btnClose == null) {
                this.btnClose = new JButton("Cancel");
                this.btnClose.addActionListener(this);
            }
            if (this.btnSend == null) {
                this.btnSend = new JButton("Send");
                this.btnSend.addActionListener(this);
            }
            if (this.btnAddCustomer == null) {
                this.btnAddCustomer = this.getCustomerSearchButton();
                this.btnAddCustomer.addActionListener(this);
            }
            if (this.btnAddUser == null) {
                this.btnAddUser = this.getUserSearchButton();
                this.btnAddUser.addActionListener(this);
            }
            if (this.btnAddCustom == null) {
                this.btnAddCustom = new JButton("Add Custom");
                this.btnAddCustom.addActionListener(this);
            }
            if (this.btnRemove == null) {
                this.btnRemove = new JButton("Remove");
                this.btnRemove.addActionListener(this);
            }
            return true;
        }
        catch (Exception e) {
            OrderMate.LOG.error("error while loadin the buttons in send sms panel...");
            e.printStackTrace();
            return false;
        }
    }

    private JButton getCustomerSearchButton() {
        if (this.searchFieldCustomer == null) {
            this.searchFieldCustomer = new AddCustomerSearchField(this);
        }
        return (JButton)this.searchFieldCustomer.getGuiComponent();
    }

    private JButton getUserSearchButton() {
        if (this.searchFieldUser == null) {
            this.searchFieldUser = new AddUserSearchField(this);
        }
        return (JButton)this.searchFieldUser.getGuiComponent();
    }

    private class SmsCustomerSearchState
    extends CustomerSearcherGui {
        public SmsCustomerSearchState(EventList customerCategories) {
            super(customerCategories);
            this.getSearcher().addSearchFilter((SearchFilterI)new ObjectSearchFilter(Customer.Properties.PRIMARY_PHONE_NUMBER){

                public ObjectQuery addQueryRestriction(ObjectQuery query) {
                    return query.startsWith(this.getProperty(), "614").or().startsWith(this.getProperty(), "00614");
                }
            });
        }
    }

    private class AddCustomerSearchField
    extends ObjectSearchField {
        private AbstractSearchDialog searchStateDialog;
        private SmsSendPanel parentComponent;

        public AddCustomerSearchField(SmsSendPanel parentComponent) {
            super(Customer.Properties.ID, new SmsCustomerSearchState(GlazedLists.eventList((Collection)CustomerCategory.getAllCategories())), CustomerSearcherGui.DEFAULT_TABLE_FORMAT, "Customers");
            this.parentComponent = parentComponent;
            this.searchStateDialog = new MultiItemSearchDialog(new SmsCustomerSearchState(GlazedLists.eventList((Collection)CustomerCategory.getAllCategories())), CustomerSearcherGui.DEFAULT_TABLE_FORMAT, "Customer", IconLoader.get((String)"/officemate/images/pda_blue_16.png")){

                @Override
                public Object doDialogGetResult() {
                    BasicEventList result = (BasicEventList)super.doDialogGetResult();
                    AddCustomerSearchField.this.doHandleResult((List<Customer>)result);
                    return result;
                }
            };
            ((JButton)this.getGuiComponent()).setText("Add Customer");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.searchStateDialog.doDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame());
        }

        protected void doHandleResult(List<Customer> result) {
            if (result != null && !result.isEmpty()) {
                for (Customer customer : result) {
                    if (customer.getPhoneNumber().equals("")) continue;
                    this.parentComponent.addItemsToReceiver(customer.getPhoneNumber(), customer.getName());
                }
            }
        }
    }

    private class SmsUserSearchState<T extends User>
    extends UserSearchState {
        public SmsUserSearchState(Class<T> searchClass) {
            super(searchClass);
            this.addSearchField((SearchGuiField)new StringSearchField("Mobile Number:", User.Properties.MOBILE, (Action)new RefreshAction((Refreshable)this)));
            this.getPropertySearcher().addSearchFilter((SearchFilterI)new ObjectSearchFilter(User.Properties.MOBILE){

                public ObjectQuery addQueryRestriction(ObjectQuery query) {
                    return query.not().isNull(this.getProperty());
                }
            });
        }
    }

    private class AddUserSearchField
    extends ObjectSearchField {
        private AbstractSearchDialog searchStateDialog;
        private SmsSendPanel parentComponent;

        public AddUserSearchField(SmsSendPanel parentComponent) {
            super(User.Properties.ID, new UserSearchState<User>(User.class), UserSearchState.DEFAULT_MOBILE_TABLE_FORMAT, "");
            this.parentComponent = parentComponent;
            this.searchStateDialog = new MultiItemSearchDialog(new SmsUserSearchState<User>(User.class), UserSearchState.DEFAULT_MOBILE_TABLE_FORMAT, "", IconLoader.get((String)"/officemate/images/pda_blue_16.png")){

                @Override
                public Object doDialogGetResult() {
                    BasicEventList result = (BasicEventList)super.doDialogGetResult();
                    AddUserSearchField.this.doHandleResult((List<User>)result);
                    return result;
                }
            };
            ((JButton)this.getGuiComponent()).setText("Add User");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.searchStateDialog.doDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame());
        }

        protected void doHandleResult(List<User> result) {
            if (result != null && !result.isEmpty()) {
                for (User user : result) {
                    if (user.getMobile().equals("")) continue;
                    this.parentComponent.addItemsToReceiver(user.getMobile(), user.getName());
                }
            }
        }
    }

    private class NonEditableTableModel
    extends DefaultTableModel {
        public NonEditableTableModel() {
            this.addColumn("Recipient Name");
            this.addColumn("Phone Number");
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

