/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.accountType;

import au.com.ordermate.oquery.GroupBy;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.util.DateTimeUtils;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JTable;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.search.searchfield.TimeRangeSearchField;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.table.TotalTableModel;
import officemate.components.tableformat.ColumnTableFormat;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.reports.AccountTotalsReport;
import ordermate.database.sales.Account;
import ordermate.database.searchers.reports.AccountTotalsReportSearcher;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import org.jdesktop.swingx.JXTable;

public class AccountTypeReportState
extends AbstractTableState<AccountTotalsReport> {
    private AccountTotalsReportSearcher searcher;

    public AccountTypeReportState() {
        super("Account sales", AllPermissions.ACCESS_SALES_REPORT, "View sales and tax reports.");
    }

    @Override
    public TableStateCentralArea<AccountTotalsReport> createCentralArea() {
        ColumnFormat[] columns = new ColumnFormat[]{new PropertyColumnFormat(AccountTotalsReport.Properties.ACCOUNT_TYPE), new PropertyColumnFormat(AccountTotalsReport.Properties.ACCOUNT_STATE), new PropertyColumnFormat(AccountTotalsReport.Properties.COUNT), new PropertyColumnFormat((PropertiedObject.Property)AccountTotalsReport.Properties.AVERAGE), new PropertyColumnFormat(AccountTotalsReport.Properties.TOTAL), new PropertyColumnFormat(AccountTotalsReport.Properties.TOTAL_TAX)};
        PersistentObjectTable<AccountTotalsReport> tablePanel = new PersistentObjectTable<AccountTotalsReport>(this.getObjectList(), new ColumnTableFormat(columns));
        JXTable totals = new JXTable();
        new TotalTableModel((JTable)tablePanel.getTable(), (JTable)totals);
        tablePanel.add((Component)totals, "South");
        tablePanel.add((Component)this.getSearchFactory().getSearchPanel(), "North");
        return tablePanel;
    }

    @Override
    public Class<AccountTotalsReport> getDisplayingType() {
        return AccountTotalsReport.class;
    }

    public AccountTotalsReportSearcher getSearcher() {
        if (this.searcher == null) {
            this.searcher = new AccountTotalsReportSearcher(new GroupBy(Account.Properties.ACCOUNT_TYPE), false);
        }
        return this.searcher;
    }

    @Override
    public OfficeMateObjectSearch<AccountTotalsReport> createSearchPanelFactory() {
        ObjectPropertySearch<AccountTotalsReport> guiSearch = new ObjectPropertySearch<AccountTotalsReport>(AccountTotalsReport.class, (ObjectQuerySearcher<AccountTotalsReport>)this.getSearcher(), (EventList<AccountTotalsReport>)new BasicEventList());
        RefreshAction refreshAction = new RefreshAction(guiSearch);
        guiSearch.addSearchField((SearchGuiField)new DateRangeSearchField("Date Range", this.searcher.getTradingDayDateFilter(), DateTimeUtils.getThreeMonthsAgoCal().getTime(), (Action)new RefreshAction(guiSearch)));
        guiSearch.addSearchField(new TimeRangeSearchField(this.searcher.getTimeFilter(), (Action)refreshAction));
        guiSearch.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Sales Location", this.searcher.getSalesLocationFilter(), (Action)refreshAction, GlazedLists.eventList((Collection)SalesLocation.getSalesLocations())));
        return guiSearch;
    }
}

