/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.adjustments;

import au.com.ordermate.glazedlists.GlazedListUtils;
import au.com.ordermate.glazedlists.PropertyComparator;
import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.filter.implementation.FixedRangeSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.CheckBoxSearchField;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.OffsetFunction;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import java.awt.Component;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Action;
import javax.swing.ListCellRenderer;
import officemate.adminkit.state.SearchGuiState;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.renderers.DisplayableListCellRenderer;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.search.searchfield.TimeRangeSearchField;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import ordermate.database.config.ExperimentalFeatureHelper;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.reports.AdjustmentsReport;
import ordermate.database.searchers.reports.adjustments.AdjustmentsReportSearcher;
import ordermate.database.users.Permission;
import ordermate.database.users.User;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import org.jdesktop.swingx.table.TableColumnExt;

public class AdjustmentsReportSearchState
extends AbstractTableState
implements SearchGuiState {
    private final RefreshAction refreshAction = new RefreshAction((Refreshable)this);
    private final EventList usersList = GlazedLists.eventList((Collection)User.getUsers());
    private final EventList allTypesList = GlazedLists.eventList((Collection)PriceAdjustmentType.getAll());
    private final EventList discountsList = GlazedLists.eventList((Collection)PriceAdjustmentType.getAllUserDisplayableDiscounts());
    private final EventList surchargesList = GlazedLists.eventList((Collection)PriceAdjustmentType.getAllUserDisplayableSurcharges());
    private final AdjustmentsReportSearcher searcher;
    private final PeriodReportAdapter periodAdapter;
    private EventList dates;
    private EventList<AdjustmentsReport> objectList;
    private List<TableColumnExt> perUnitCols;
    private TableColumnExt targetCol;

    public AdjustmentsReportSearchState(AdjustmentsReportSearcher reportSearcher, String stateName, Permission permission, String description, PeriodReportAdapter adapter) {
        super(stateName, permission, description);
        this.searcher = reportSearcher;
        this.periodAdapter = adapter;
    }

    protected TableStateCentralArea createCentralArea() {
        String directionName = this.searcher.getDirectionSearchFilter() != null && this.searcher.getDirectionSearchFilter().hasSearchValue() ? ((PriceAdjustmentDirection)this.searcher.getDirectionSearchFilter().getSearchValue()).getLabel() : "Adjustment";
        PersistentObjectTable centralTable = new PersistentObjectTable(this.getObjectList(), new ColumnTableFormat((ColumnFormat[])new PropertyColumnFormat[]{new PropertyColumnFormat("Created", (PropertyAccessor)AdjustmentsReport.Properties.CREATION_DATE, (Format)DateTimeUtils.getConsistentReportFormat()), new PropertyColumnFormat(directionName, AdjustmentsReport.Properties.NAME), new PropertyColumnFormat("User", (PropertiedObject.Property)AdjustmentsReport.Properties.USER_NAME), new PropertyColumnFormat("Cost", AdjustmentsReport.Properties.SAVED_TOTAL), new PropertyColumnFormat("Type", (PropertiedObject.Property)AdjustmentsReport.Properties.TYPE), new PropertyColumnFormat("Target", (PropertiedObject.Property)AdjustmentsReport.Properties.TARGET), new PropertyColumnFormat("Account Type", AdjustmentsReport.Properties.ACCOUNT_TYPE), new PropertyColumnFormat("Qty", AdjustmentsReport.Properties.QUANTITY), new PropertyColumnFormat("Unit", (PropertiedObject.Property)AdjustmentsReport.Properties.TARGET_UNIT), new PropertyColumnFormat("Size", AdjustmentsReport.Properties.SIZE), new PropertyColumnFormat("Unit ID", AdjustmentsReport.Properties.INVENTORY_ITEM_UNIT_ID)}));
        centralTable.add((Component)this.getSearchFactory().getSearchPanel(), "North");
        this.perUnitCols = new ArrayList<TableColumnExt>();
        this.perUnitCols.add(centralTable.getTable().getColumnExt((Object)AdjustmentsReport.Properties.ACCOUNT_TYPE));
        this.perUnitCols.add(centralTable.getTable().getColumnExt((Object)AdjustmentsReport.Properties.SIZE));
        this.perUnitCols.add(centralTable.getTable().getColumnExt((Object)AdjustmentsReport.Properties.QUANTITY));
        this.perUnitCols.add(centralTable.getTable().getColumnExt((Object)AdjustmentsReport.Properties.TARGET_UNIT));
        this.targetCol = centralTable.getTable().getColumnExt((Object)AdjustmentsReport.Properties.TARGET);
        TableColumnExt unitIdCol = centralTable.getTable().getColumnExt((Object)AdjustmentsReport.Properties.INVENTORY_ITEM_UNIT_ID);
        if (ExperimentalFeatureHelper.isShowItemIds()) {
            this.perUnitCols.add(unitIdCol);
        } else {
            unitIdCol.setVisible(false);
        }
        return centralTable;
    }

    protected Class getDisplayingType() {
        return AdjustmentsReport.class;
    }

    public AdjustmentsReportSearcher getSearcher() {
        return this.searcher;
    }

    protected OfficeMateObjectSearch createSearchPanelFactory() {
        BasicEventList mainList = new BasicEventList();
        PropertyComparator comparator = new PropertyComparator(AdjustmentsReport.Properties.CREATION_DATE);
        this.objectList = new SortedList((EventList)mainList, (Comparator)comparator);
        ObjectPropertySearch<AdjustmentsReport> propSearch = new ObjectPropertySearch<AdjustmentsReport>(this.getDisplayingType(), (ObjectQuerySearcher)this.searcher, this.objectList){

            @Override
            protected List<AdjustmentsReport> resolveObjectQuery(ObjectQuery query, Class clazz) {
                return AdjustmentsReportSearchState.this.searcher.getObjectList(query);
            }
        };
        if (this.periodAdapter == null) {
            propSearch.addSearchField((SearchGuiField)new DateRangeSearchField("Date Range", this.searcher.getTradingDayDateRangeFilter(), DateTimeUtils.getOneMonthAgoCal().getTime(), (Action)this.refreshAction));
        } else {
            this.dates = GlazedLists.eventList((Collection)this.periodAdapter.getDateList());
            FixedRangeSearchFilter searchProp = this.searcher.getFixedRangeFilter();
            searchProp.setOffsetFunction((OffsetFunction)this.periodAdapter.getDateOffset());
            this.searcher.addSearchFilter((SearchFilterI)searchProp);
            propSearch.addSearchField((SearchGuiField)new ComboSearchField(this.periodAdapter.getLabel(), (ISingleValueSearchFilter)searchProp, false, (Action)this.refreshAction, this.dates, (Format)this.periodAdapter.getFormatter()));
        }
        propSearch.addSearchField((SearchGuiField)new MultiSelectComboSearchField("User", (Action)this.refreshAction, this.usersList, null, this.searcher.getUserSearchFilter(), new JCheckBoxCellRenderer()));
        ArrayList<PriceAdjustmentLevel> levels = new ArrayList<PriceAdjustmentLevel>();
        levels.add(PriceAdjustmentLevel.ACCOUNT_LEVEL);
        levels.add(PriceAdjustmentLevel.ITEM_LEVEL);
        propSearch.addSearchField((SearchGuiField)new ComboSearchField("Level", (ISingleValueSearchFilter)this.searcher.getLevelFilter(), true, (Action)this.refreshAction, GlazedLists.eventList(levels)));
        MultiSelectComboSearchField types = new MultiSelectComboSearchField("Type", (Action)this.refreshAction, this.allTypesList, null, this.searcher.getTypeSearchFilter(), new JCheckBoxCellRenderer());
        types.setRenderer((ListCellRenderer)new DisplayableListCellRenderer());
        if (PriceAdjustmentDirection.DISCOUNT.equals(this.searcher.getDirectionSearchFilter().getSearchValue())) {
            types.setListData(this.discountsList);
        } else if (PriceAdjustmentDirection.SURCHARGE.equals(this.searcher.getDirectionSearchFilter().getSearchValue())) {
            types.setListData(this.surchargesList);
        }
        propSearch.addSearchField((SearchGuiField)types);
        propSearch.addSearchField(new TimeRangeSearchField(this.getSearcher().getTimeFilter(), (Action)this.refreshAction));
        propSearch.addSearchField((SearchGuiField)new CheckBoxSearchField("By Unit", this.searcher.getPerUnitFilter(), (Action)this.refreshAction));
        propSearch.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Sales Location", (Action)this.refreshAction, GlazedLists.eventList((Collection)SalesLocation.getSalesLocations()), null, this.searcher.getSalesLocationFilter()));
        return propSearch;
    }

    @Override
    public void refresh() {
        super.refresh();
        boolean perUnit = this.getSearcher().isPerUnit();
        for (TableColumnExt col : this.perUnitCols) {
            col.setVisible(perUnit);
        }
        this.targetCol.setVisible(!perUnit);
        if (this.periodAdapter != null) {
            GlazedListUtils.setAsList((EventList)this.dates, new ArrayList(this.periodAdapter.getDateList()));
        }
    }
}

