/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.adjustments.configurable;

import ar.com.fdvs.dj.domain.builders.BuilderException;
import au.com.ordermate.persistence.PropertiedObject;
import officemate.adminkit.state.CompositeGuiState;
import officemate.screens.reports.adjustments.AdjustmentsReportSearchState;
import officemate.screens.reports.jasper.JasperReportState;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.reports.AdjustmentsReport;
import ordermate.database.reports.adjustments.NameAdjustmentsReportProvider;
import ordermate.database.reports.adjustments.NameAdjustmentsSummaryReportProvider;
import ordermate.database.reports.adjustments.UserAdjustmentsReportProvider;
import ordermate.database.reports.adjustments.UserAdjustmentsSummaryReportProvider;
import ordermate.database.searchers.reports.adjustments.AdjustmentsReportSearcher;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.Permission;
import ordermate.reports.dynamicjasper.reportbuilder.ReportProvider;

public abstract class ConfigurableAdjustmentsReportState
extends CompositeGuiState {
    private AdjustmentsReportSearchState searchState;
    private JasperReportState byNameReportState;
    private JasperReportState byUserReportState;
    private JasperReportState byNameReportSummaryState;
    private JasperReportState byUserReportSummaryState;
    private final AdjustmentsReportSearcher searcher;
    private final UserAdjustmentsReportProvider userAdjReportProvider;
    private final NameAdjustmentsReportProvider nameAdjReportProvider;
    private final UserAdjustmentsSummaryReportProvider userAdjSummaryReportProvider;
    private final NameAdjustmentsSummaryReportProvider nameAdjSummaryReportProvider;
    private final PriceAdjustmentDirection direction;

    public ConfigurableAdjustmentsReportState(String titlePrefix, AdjustmentsReportSearcher theSearcher, PriceAdjustmentDirection direction, Permission permission) throws BuilderException {
        super(direction.getLabel() + " Report", permission, direction.getLabel() + " report for a period.");
        if (!((PriceAdjustmentDirection)theSearcher.getDirectionSearchFilter().getSearchValue()).equals((Object)direction)) {
            throw new IllegalArgumentException("Searcher should be searching for : " + direction + " but was " + theSearcher.getDirectionSearchFilter().getSearchValue());
        }
        if (!titlePrefix.isEmpty()) {
            titlePrefix = titlePrefix + " ";
        }
        this.searcher = theSearcher;
        this.nameAdjReportProvider = new NameAdjustmentsReportProvider(this.searcher, titlePrefix + direction.getLabel() + " Report");
        this.userAdjReportProvider = new UserAdjustmentsReportProvider(this.searcher, titlePrefix + direction.getLabel() + " Report by User", (PropertiedObject.Property)AdjustmentsReport.Properties.USER_NAME);
        this.nameAdjSummaryReportProvider = new NameAdjustmentsSummaryReportProvider(this.searcher, titlePrefix + direction.getLabel() + " Report");
        this.userAdjSummaryReportProvider = new UserAdjustmentsSummaryReportProvider(this.searcher, titlePrefix + direction.getLabel() + " Report by User");
        this.direction = direction;
    }

    @Override
    protected void init() {
        if (this.searchState == null) {
            this.searchState = this.createSearchState();
        }
        if (this.byNameReportState == null) {
            this.byNameReportState = new JasperReportState((ReportProvider)this.nameAdjReportProvider, "Report by " + this.direction.getLabel(), this.getAccessPermission(), "View " + this.direction.getLabel());
        }
        if (this.byUserReportState == null) {
            this.byUserReportState = new JasperReportState((ReportProvider)this.userAdjReportProvider, "Report by User", this.getAccessPermission(), "View " + this.direction.getLabel() + " by User");
        }
        if (this.byNameReportSummaryState == null) {
            this.byNameReportSummaryState = new JasperReportState((ReportProvider)this.nameAdjSummaryReportProvider, "Summary by " + this.direction.getLabel(), this.getAccessPermission(), "View " + this.direction.getLabel() + " Summary");
        }
        if (this.byUserReportSummaryState == null) {
            this.byUserReportSummaryState = new JasperReportState((ReportProvider)this.userAdjSummaryReportProvider, "Summary by User", this.getAccessPermission(), "View " + this.direction.getLabel() + " Summary by User");
        }
        this.addTabbedSubState(this.searchState);
        this.addTabbedSubState(this.byUserReportState);
        this.addTabbedSubState(this.byNameReportState);
        this.addTabbedSubState(this.byUserReportSummaryState);
        this.addTabbedSubState(this.byNameReportSummaryState);
        super.init();
    }

    @Override
    protected void onStart() {
        if (this.nameAdjReportProvider != null) {
            this.nameAdjReportProvider.setUser(this.getUser());
        }
        if (this.userAdjReportProvider != null) {
            this.userAdjReportProvider.setUser(this.getUser());
        }
        if (this.nameAdjSummaryReportProvider != null) {
            this.nameAdjSummaryReportProvider.setUser(this.getUser());
        }
        if (this.userAdjSummaryReportProvider != null) {
            this.userAdjSummaryReportProvider.setUser(this.getUser());
        }
        super.onStart();
    }

    protected final AdjustmentsReportSearcher getReportSearcher() {
        return this.searcher;
    }

    protected AdjustmentsReportSearchState createSearchState() {
        return new AdjustmentsReportSearchState(this.searcher, "Search", this.getAccessPermission(), "Create and search for dollars per head report.", null);
    }

    protected static Permission getPermission() {
        return AllPermissions.VIEW_DISCOUNT_REPORT;
    }

    protected JasperReportState getByNameReport() {
        return this.byNameReportState;
    }

    protected JasperReportState getByUserReport() {
        return this.byUserReportState;
    }
}

