/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.cogs;

import au.com.ordermate.util.MathsUtils;
import javax.swing.table.AbstractTableModel;
import officemate.adminkit.table.PriceGroupedTableModel;
import officemate.screens.reports.cogs.COGSReportState;

public class COGSGroupedTableModel
extends PriceGroupedTableModel {
    private double cogs;
    private double sales;

    public COGSGroupedTableModel(AbstractTableModel wrappedModel, String groupedCol, String[] totalledCols) {
        super(wrappedModel, groupedCol, totalledCols);
    }

    @Override
    protected Object createTotalValue(Object group, double value, int row, int col) {
        String colName = this.getColumnName(col);
        if (colName.equals("Est. Cost")) {
            this.cogs = value;
        }
        if (colName.equals(COGSReportState.DISPLAYLABEL_SALES_EX)) {
            this.sales = value;
        }
        if (colName.equals("Qty Sold")) {
            return new Integer((int)value);
        }
        if (colName.equals("GP %")) {
            if (this.sales == 0.0) {
                return Double.NaN;
            }
            double gpPercent = 100.0 * (this.sales - this.cogs) / this.sales;
            return new Double(MathsUtils.roundDoubleToDecPlaces((double)gpPercent, (int)2));
        }
        return super.createTotalValue(group, value, row, col);
    }
}

