/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.cogs;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.guicore.task.AbstractGuiTask;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.sql.queries.SelectQuery;
import au.com.ordermate.util.GuiUtils;
import ca.odell.glazedlists.GlazedLists;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.sql.RowSet;
import javax.sql.rowset.Predicate;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import officemate.adminkit.DateRangePanel;
import officemate.adminkit.DateTimeRangePanel;
import officemate.adminkit.MenuGroupTreePanel;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.filters.MenuGroupByProfileFilter;
import officemate.adminkit.search.SearchDialog;
import officemate.adminkit.searchpanels.InventoryItemSearchPanel;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.state.SearchGuiState;
import officemate.adminkit.table.GroupedTable;
import officemate.adminkit.table.LinkedTotalTable;
import officemate.adminkit.table.QueryTable;
import officemate.screens.ObjectManagerI;
import officemate.screens.reports.cogs.COGSGroupedTableCellRenderer;
import officemate.screens.reports.cogs.COGSGroupedTableModel;
import officemate.screens.reports.cogs.COGSTableModel;
import officemate.screens.reports.cogs.SQLDeletedItemsLookDifferentCellRenderer;
import ordermate.OrderMate;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.misc.ConfigShift;
import ordermate.database.queries.inventory.InventoryProfileQueries;
import ordermate.database.reports.cogs.COGSReport;
import ordermate.database.reports.cogs.COGSReportProvider;
import ordermate.database.reports.cogs.COGSReportSearcher;
import ordermate.database.users.AllPermissions;
import ordermate.gui.FieldPanelBuilder;
import ordermate.internationalization.Internationalization;

public class COGSReportState
extends BasicOfficeMateState
implements SearchGuiState<COGSReport> {
    static final String DISPLAYLABEL_QTY_SOLD = "Qty Sold";
    static final String DISPLAYLABEL_COGS = "Est. Cost";
    static final String DISPLAYLABEL_SALES = "Sales";
    static final String DISPLAYLABEL_SALES_EX = MessageFormat.format("Sales (Ex {0})", Internationalization.getLiteralFor((String)"GST"));
    static final String DISPLAYLABEL_GP_PERCENT = "GP %";
    static final String DISPLAYLABEL_GP_VALUE = "GP " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN");
    static final String DISPLAYLABEL_GROUP = "Group";
    private JPanel innerPanel;
    private JPanel northPanel;
    private JPanel tablePanel;
    private JPanel rightPanel;
    private JPanel eastPanel;
    private JPanel southPanel;
    private JPanel northWestPanel;
    private JPanel totalsPanel;
    private JSplitPane splitter;
    private MenuGroupTreePanel treePanel = null;
    private DateTimeRangePanel dateTimePanel = null;
    private DateRangePanel datePanel = null;
    private LinkedTotalTable totalsTable;
    private JComboBox profilesCombo;
    private MultiSelectComboSearchField shiftsCombo;
    private MultiSelectComboSearchField salesLocationsCombo;
    private JCheckBox unsoldCheck;
    private JCheckBox entireTDCheck;
    private boolean entireTD = false;
    private GroupedTable groupedTable;
    private JCheckBox groupedCheck;
    private boolean groupResults = true;
    private QueryTable table;
    private COGSTableModel tableModel;
    private boolean alreadySetup = false;
    private boolean allowUpdate = true;
    private final COGSReportSearcher searcher = new COGSReportSearcher();
    private COGSReportProvider provider = new COGSReportProvider(this.searcher);
    private Date startDate;
    private Date endDate;

    public COGSReportState() {
        super("COGS", AllPermissions.ACCESS_COGS_REPORT, "Cost Of Goods Report, shows COGS per item over a time period");
        this.innerPanel = new JPanel(new BorderLayout());
        this.setScreenPanel(this.innerPanel);
    }

    @Override
    protected void onStart() {
        GuiApp.getAppComplex().getApplicationFrame().setStatusBarText("Loading COGS Report screen...");
        GuiApp.getAppComplex().getApplicationContext().getLog().info("-----COGS Setup----");
        if (!this.alreadySetup) {
            this.alreadySetup = Dialogs.showProgressDialog((AbstractTask)new CogsSetupTask(true));
            if (!this.alreadySetup) {
                Dialogs.showErrorDialog("Error Loading Screen", "Please contact OrderMate Support");
                return;
            }
        } else {
            Dialogs.showProgressDialog((AbstractTask)new CogsSetupTask(false));
        }
        GuiApp.getAppComplex().getApplicationFrame().resetStatusBarText();
    }

    private void setupSearcher() {
        this.searcher.setShowUnsold(this.unsoldCheck.isSelected());
        this.searcher.getDateRangeFilter().setStart((Comparable)this.startDate);
        this.searcher.getDateRangeFilter().setEnd((Comparable)this.endDate);
        this.searcher.initWebFilter();
        this.searcher.getProfileFilter().setSearchValue((Object)this.getCurrentMenuProfile());
        this.searcher.getGroupFilter().setSearchValue((Object)this.getCurrentMenuGroup());
        this.searcher.getSalesLocationFilter().setSearchValue(this.getCurrentSalesLocations());
    }

    @Override
    public ObjectQuerySearcher<COGSReport> getSearcher() {
        return this.searcher;
    }

    @Override
    protected void onEnd() {
    }

    private void setupGUI() {
        FieldPanelBuilder fieldBuilder = new FieldPanelBuilder(3, 3);
        fieldBuilder.addRow("Menu Profile:", this.getMenuProfileSelector());
        fieldBuilder.addRow("Shift:", (Component)this.getShiftSelector().getComboBox());
        fieldBuilder.addRow("Sales Location:", (Component)this.getSalesLocationsSelector().getComboBox());
        fieldBuilder.getPanel().setAlignmentY(0.0f);
        FieldPanelBuilder checkBuilder = new FieldPanelBuilder(0, 3);
        checkBuilder.addRow("", this.getUnsoldCheck());
        checkBuilder.addRow("", this.getGroupCheck());
        checkBuilder.addRow("", this.getEntireTDCheck());
        checkBuilder.getPanel().setAlignmentY(0.0f);
        this.splitter = new JSplitPane();
        this.northWestPanel = new JPanel();
        this.northWestPanel.setLayout(new BoxLayout(this.northWestPanel, 0));
        this.northWestPanel.add(fieldBuilder.getPanel());
        this.northWestPanel.add(checkBuilder.getPanel());
        this.northPanel = new JPanel(new BorderLayout());
        this.northPanel.add((Component)this.northWestPanel, "West");
        this.rightPanel = new JPanel(new BorderLayout());
        this.tablePanel = new JPanel(new BorderLayout());
        this.eastPanel = new JPanel(new BorderLayout());
        this.southPanel = new JPanel(new GridLayout(2, 1));
        this.tablePanel.add((Component)this.southPanel, "South");
        this.splitter.setRightComponent(this.rightPanel);
        this.rightPanel.add((Component)this.tablePanel, "Center");
        this.rightPanel.add((Component)this.eastPanel, "East");
        this.innerPanel.add((Component)this.splitter, "Center");
        this.innerPanel.add((Component)this.northPanel, "North");
    }

    private Component getGroupCheck() {
        this.groupedCheck = new JCheckBox("Group Results", this.groupResults);
        this.groupedCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                COGSReportState.this.groupResults = COGSReportState.this.groupedCheck.isSelected();
                COGSReportState.this.refresh();
            }
        });
        return this.groupedCheck;
    }

    private void setupTable() {
        int[] colsToShow = new int[]{5, 0, 3, 4, 6, 7, 8, 9, 12, 11, 10};
        String[] displayColumns = new String[]{DISPLAYLABEL_GROUP, "Name", "Size", "Portion", "Price Level", DISPLAYLABEL_QTY_SOLD, DISPLAYLABEL_COGS, DISPLAYLABEL_SALES, DISPLAYLABEL_SALES_EX, DISPLAYLABEL_GP_PERCENT, DISPLAYLABEL_GP_VALUE};
        this.tableModel = new COGSTableModel(InventoryProfileQueries.Reports.GetSalesAndCOGS.getQuery((InventoryProfile)this.getCurrentMenuProfile(), null, null, (Date)this.startDate, (Date)this.endDate, (String)this.shiftsCombo.getComboBox().getSelectedItem().toString(), (String)this.salesLocationsCombo.getComboBox().getSelectedItem().toString(), (boolean)false, (boolean)this.entireTDCheck.isSelected()).getSQL(), 1, colsToShow, displayColumns, GuiApp.getAppComplex().getApplicationContext());
        this.tableModel.addTotalResultSetColumn(7);
        this.tableModel.addTotalResultSetColumn(8);
        this.tableModel.addTotalResultSetColumn(9);
        this.tableModel.addTotalResultSetColumn(12);
        this.tableModel.addTotalResultSetColumn(11);
        this.tableModel.addTotalResultSetColumn(10);
        this.table = new QueryTable(this.tableModel);
        OfficeMateAdminGuiUtils.getInstance().standardTableSetup(this.table);
        SQLDeletedItemsLookDifferentCellRenderer renderer = new SQLDeletedItemsLookDifferentCellRenderer();
        this.table.setCellRendererForAll(renderer);
        this.tablePanel.add((Component)this.table.getScroller(), "Center");
    }

    private GroupedTable getNewGroupedTable() {
        COGSGroupedTableModel model = new COGSGroupedTableModel((AbstractTableModel)this.table.getModel(), DISPLAYLABEL_GROUP, new String[]{DISPLAYLABEL_QTY_SOLD, DISPLAYLABEL_COGS, DISPLAYLABEL_SALES, DISPLAYLABEL_SALES_EX, DISPLAYLABEL_GP_PERCENT, DISPLAYLABEL_GP_VALUE});
        this.groupedTable = new GroupedTable(model);
        OfficeMateAdminGuiUtils.getInstance().standardTableSetup((JTable)((Object)this.groupedTable));
        this.groupedTable.setCellRendererForAll(new COGSGroupedTableCellRenderer());
        return this.groupedTable;
    }

    private Number[] getCorrectTotals(Number[] theNormalTotals) {
        Number[] normalTotals = theNormalTotals;
        if (this.groupResults) {
            int titleColumn = this.tableModel.findColumn(DISPLAYLABEL_GROUP);
            Number[] newTotals = new Number[normalTotals.length - 1];
            int write = 0;
            for (int read = 0; read < normalTotals.length; ++read) {
                if (read == titleColumn) continue;
                newTotals[write++] = normalTotals[read];
            }
            normalTotals = newTotals;
        }
        return normalTotals;
    }

    public JTable getActiveTable() {
        return this.groupResults ? this.groupedTable : this.table;
    }

    private void refreshTotalValues() {
        if (this.tablePanel != null && this.totalsPanel != null) {
            this.tablePanel.remove(this.totalsPanel);
        }
        JLabel totalsLabel = new JLabel("Total:");
        TableColumnModel columnModel = this.getActiveTable().getColumnModel();
        this.totalsTable = new LinkedTotalTable(columnModel);
        this.totalsTable.setName("Totals");
        this.totalsPanel = new JPanel(new GridLayout(0, 1));
        this.totalsPanel.add(totalsLabel);
        this.totalsPanel.add(this.totalsTable);
        this.tablePanel.add((Component)this.totalsPanel, "South");
        this.totalsTable.setColumnValues(this.getCorrectTotals(this.tableModel.getTotals()));
    }

    private void setupDates() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        Date startOfMonth = new Date(cal.getTimeInMillis());
        cal = new GregorianCalendar();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        Date endOfToday = new Date(cal.getTimeInMillis());
        this.startDate = startOfMonth;
        this.endDate = endOfToday;
        this.dateTimePanel = new DateTimeRangePanel();
        this.dateTimePanel.datesChanged.connect((Object)this, "gotDatesChanged");
        this.dateTimePanel.setStartDate(this.startDate);
        this.dateTimePanel.setEndDate(this.endDate);
        this.datePanel = new DateRangePanel();
        this.datePanel.setUsesTradingDayBoundaries(true);
        this.datePanel.datesChanged.connect((Object)this, "gotDatesChanged");
        this.datePanel.setStartDate(this.startDate);
        this.datePanel.setEndDate(this.endDate);
        if (this.entireTD) {
            this.northPanel.add((Component)this.datePanel, "East");
        } else {
            this.northPanel.add((Component)this.dateTimePanel, "East");
        }
    }

    private Component getMenuProfileSelector() {
        this.profilesCombo = new JComboBox(InventoryProfile.getAllProfiles());
        this.profilesCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (COGSReportState.this.allowUpdate) {
                    COGSReportState.this.refresh();
                }
            }
        });
        OfficeMateAdminGuiUtils.getInstance().standardComboSetup(this.profilesCombo);
        this.profilesCombo.setPreferredSize(new Dimension(140, 20));
        this.profilesCombo.setName("Profiles");
        return this.profilesCombo;
    }

    private MultiSelectComboSearchField getShiftSelector() {
        this.shiftsCombo = new MultiSelectComboSearchField("Shift", null, GlazedLists.eventList((Collection)ConfigShift.getAllConfigShiftsNames()), null, new MultiOptionSearchFilter(ConfigShift.Properties.LABEL), new JCheckBoxCellRenderer());
        this.shiftsCombo.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (COGSReportState.this.allowUpdate) {
                    COGSReportState.this.refresh();
                }
            }
        });
        return this.shiftsCombo;
    }

    private MultiSelectComboSearchField getSalesLocationsSelector() {
        this.salesLocationsCombo = new MultiSelectComboSearchField("Sales Location", null, GlazedLists.eventList((Collection)SalesLocation.getSalesLocations()), null, new MultiOptionSearchFilter(SalesLocation.Properties.LABEL));
        return this.salesLocationsCombo;
    }

    private void setupTree() {
        this.treePanel = new MenuGroupTreePanel(((ObjectManagerI)GuiApp.getAppComplex().getApplicationContext()).getObjectManager(), this.getCurrentMenuProfile());
        this.treePanel.objectSelected.connect((Object)this, "gotTreeObjectSelected");
        this.splitter.setLeftComponent(this.treePanel);
    }

    private Component getUnsoldCheck() {
        this.unsoldCheck = new JCheckBox("Show Unsold", false);
        this.unsoldCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                COGSReportState.this.updateQuery();
            }
        });
        return this.unsoldCheck;
    }

    private Component getEntireTDCheck() {
        this.entireTDCheck = new JCheckBox("Entire Trading Day", this.entireTD);
        this.entireTDCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                COGSReportState.this.entireTD = COGSReportState.this.entireTDCheck.isSelected();
                if (COGSReportState.this.entireTD) {
                    COGSReportState.this.northPanel.remove(COGSReportState.this.dateTimePanel);
                    COGSReportState.this.northPanel.add((Component)COGSReportState.this.datePanel, "East");
                    COGSReportState.this.startDate = COGSReportState.this.datePanel.getStartDate();
                    COGSReportState.this.endDate = COGSReportState.this.datePanel.getEndDate();
                } else {
                    COGSReportState.this.northPanel.remove(COGSReportState.this.datePanel);
                    COGSReportState.this.northPanel.add((Component)COGSReportState.this.dateTimePanel, "East");
                    COGSReportState.this.startDate = COGSReportState.this.dateTimePanel.getStartDate();
                    COGSReportState.this.endDate = COGSReportState.this.dateTimePanel.getEndDate();
                }
                COGSReportState.this.searcher.getDateRangeFilter().setStart((Comparable)COGSReportState.this.startDate);
                COGSReportState.this.searcher.getDateRangeFilter().setEnd((Comparable)COGSReportState.this.endDate);
                COGSReportState.this.refresh();
            }
        });
        return this.entireTDCheck;
    }

    @Override
    public boolean supportsRefresh() {
        return true;
    }

    @Override
    public void doRefreshAction() {
        this.refresh();
    }

    @Override
    public void refresh() {
        this.allowUpdate = false;
        if (this.treePanel == null) {
            this.allowUpdate = true;
            return;
        }
        this.northPanel.revalidate();
        this.northPanel.repaint();
        Object treeSel = this.treePanel.getTree().getSelectedObject();
        Object comboSel = this.profilesCombo.getSelectedItem();
        this.profilesCombo.setModel(new DefaultComboBoxModel(InventoryProfile.getAllProfiles()));
        this.profilesCombo.setSelectedItem(comboSel);
        this.treePanel.setMenuProfile(this.getCurrentMenuProfile());
        this.treePanel.getTree().setSelectedObject(treeSel);
        Long selectedID = OfficeMateAdminGuiUtils.getInstance().getSelectedID(this.table, this.groupResults ? this.groupedTable : null);
        int selectedTableRow = OfficeMateAdminGuiUtils.getInstance().getSelectedTableRow(this.table, this.groupResults ? this.groupedTable : null);
        this.updateQuery();
        OfficeMateAdminGuiUtils.getInstance().selectIfPossible(this.table, this.groupResults ? this.groupedTable : null, selectedID, selectedTableRow);
        this.allowUpdate = true;
    }

    @Override
    public boolean supportsSearch() {
        return true;
    }

    @Override
    public void doSearchAction() {
        InventoryItemSearchPanel searchPanel = new InventoryItemSearchPanel(this.getCurrentMenuProfile());
        Long id = SearchDialog.search(GuiApp.getAppComplex().getApplicationFrame().getFrame(), searchPanel, "Find Menu Item...");
        if (id != null) {
            JScrollPane scrollerToUse;
            Object tableToUse;
            int tableRow;
            this.unsoldCheck.setSelected(true);
            this.treePanel.getTree().setSelectedObject(null);
            int originalRow = this.table.getQueryTableModel().getRow(id);
            if (this.groupResults) {
                tableRow = this.groupedTable.getGroupedTableModel().getGroupedRow(originalRow);
                this.groupedTable.setRowSelectionInterval(tableRow, tableRow);
                tableToUse = this.groupedTable;
                scrollerToUse = this.groupedTable.getScroller();
            } else {
                tableRow = originalRow;
                this.table.setRowSelectionInterval(tableRow, tableRow);
                tableToUse = this.table;
                scrollerToUse = this.table.getScroller();
            }
            GuiUtils.scrollToTableRow((JScrollPane)scrollerToUse, (JTable)tableToUse, (int)tableRow);
            this.table.repaint();
        }
    }

    private void updateQuery() {
        if (this.entireTD) {
            this.startDate = this.datePanel.getStartDate();
            this.endDate = this.datePanel.getEndDate();
        } else {
            this.startDate = this.dateTimePanel.getStartDate();
            this.endDate = this.dateTimePanel.getEndDate();
        }
        this.setupSearcher();
        this.updateQuery(this.getCurrentMenuProfile(), this.getCurrentMenuGroup(), this.startDate, this.endDate, this.shiftsCombo.getComboBox().getSelectedItem().toString(), this.salesLocationsCombo.getComboBox().getSelectedItem().toString(), this.unsoldCheck.isSelected(), this.entireTD);
    }

    private void updateQuery(Date start, Date end, String shifts, String locations) {
        this.updateQuery(this.getCurrentMenuProfile(), this.getCurrentMenuGroup(), start, end, shifts, locations, this.unsoldCheck.isSelected(), this.entireTD);
    }

    private void updateQuery(InventoryProfile profile, InventoryGroup group, Date start, Date end, String shifts, String locations, boolean showUnsold, boolean entireTDay) {
        this.allowUpdate = false;
        ArrayList<InventoryGroup> groups = null;
        if (group != null) {
            List subGroups = group.getRecursiveSubGroups();
            groups = new ArrayList<InventoryGroup>(subGroups.size() + 1);
            groups.add(group);
            groups.addAll(subGroups);
        }
        SelectQuery query = InventoryProfileQueries.Reports.GetSalesAndCOGS.getQueryPerItemUnit((InventoryProfile)profile, null, null, (Date)start, (Date)end, (String)shifts, (String)locations, (boolean)showUnsold, (boolean)entireTDay);
        if (this.groupResults) {
            query.clearOrderBy();
            query.addOrderBy("inventory_group.Name");
            query.addOrderBy("inventory_item.Name");
        }
        this.tableModel.setQuery(query);
        this.tableModel.clearClientFilters();
        this.tableModel.addClientFilter(this.createGroupFilter(groups));
        this.table.updateModel();
        this.tablePanel.remove(this.table.getScroller());
        if (this.groupedTable != null) {
            this.tablePanel.remove(this.groupedTable.getScroller());
        }
        if (this.groupResults) {
            this.tablePanel.add((Component)this.getNewGroupedTable().getScroller(), "Center");
        } else {
            this.tablePanel.add((Component)this.table.getScroller(), "Center");
        }
        this.refreshTotalValues();
        this.tablePanel.revalidate();
        this.totalsTable.revalidate();
        this.tablePanel.repaint();
        this.totalsTable.repaint();
        this.allowUpdate = true;
    }

    private Predicate createGroupFilter(final List<InventoryGroup> groups) {
        if (groups == null) {
            return null;
        }
        return new Predicate(){
            final int GROUP_COL_INDEX = 6;

            @Override
            public boolean evaluate(RowSet rs) {
                try {
                    if (!rs.isBeforeFirst() && !rs.isAfterLast()) {
                        return this.matches(rs.getString(6));
                    }
                }
                catch (SQLException sqlE) {
                    OrderMate.LOG.error("SQLException evaluating predicate for groups : " + groups, (Throwable)sqlE);
                }
                return false;
            }

            private boolean matches(String val) {
                for (InventoryGroup group : groups) {
                    if (!val.toString().equalsIgnoreCase(group.getLabel())) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean evaluate(Object value, int column) throws SQLException {
                if (column == 6) {
                    return this.matches(value + "");
                }
                return true;
            }

            @Override
            public boolean evaluate(Object value, String columnName) throws SQLException {
                if (columnName.equals("inventory_group.Name")) {
                    return this.matches(value + "");
                }
                return true;
            }
        };
    }

    public void buildProvider() {
        if (this.shiftsCombo.getComboBox().getSelectedItem() != null && !this.shiftsCombo.getComboBox().getSelectedItem().equals("Any")) {
            this.searcher.getShiftFilter().setSearchValue((Object)this.shiftsCombo.getComboBox().getSelectedItem().toString());
        }
        if (this.salesLocationsCombo.getComboBox().getSelectedItem() != null && !this.salesLocationsCombo.getComboBox().getSelectedItem().equals("Any")) {
            this.searcher.getSalesLocationFilter().setSearchValue((Object)this.salesLocationsCombo.getComboBox().getSelectedItem().toString());
        }
        this.searcher.initWebFilter();
        if (this.provider == null) {
            this.provider = new COGSReportProvider(this.searcher);
        } else {
            this.provider.setSearcher(this.searcher);
        }
        this.provider.setGrouped(this.groupResults);
    }

    private InventoryProfile getCurrentMenuProfile() {
        Object obj = this.profilesCombo.getSelectedItem();
        return obj instanceof InventoryProfile ? (InventoryProfile)obj : null;
    }

    private InventoryGroup getCurrentMenuGroup() {
        Object obj = this.treePanel.getSelectedObject();
        return obj instanceof InventoryGroup ? (InventoryGroup)obj : null;
    }

    private List<SalesLocation> getCurrentSalesLocations() {
        Object[] locs = this.salesLocationsCombo.getRenderer().getSelectedObjects();
        if (locs != null && locs.length > 0) {
            ArrayList<SalesLocation> locations = new ArrayList<SalesLocation>();
            for (Object next : locs) {
                locations.add(SalesLocation.getSalesLocationForName((String)String.valueOf(next)));
            }
            return locations;
        }
        return Collections.emptyList();
    }

    private void applyProfile(InventoryProfile profile) {
        this.allowUpdate = false;
        this.treePanel.setObjectFilter(new MenuGroupByProfileFilter(profile));
        if (this.table != null) {
            this.allowUpdate = true;
            this.gotTreeObjectSelected(this.treePanel.getTree().getObjectTreeModel().getRoot());
            this.allowUpdate = false;
            if (this.table.getRowCount() > 0) {
                this.table.setRowSelectionInterval(0, 0);
            }
        }
        this.allowUpdate = true;
    }

    void gotProfileSelected(Object obj) {
        if (this.treePanel != null) {
            Dialogs.showProgressDialog(new LoadMenuProfileTask((InventoryProfile)obj));
        }
    }

    private void gotTreeObjectSelected(Object o) {
        if (this.allowUpdate) {
            InventoryGroup group = o instanceof InventoryGroup ? (InventoryGroup)o : null;
            this.updateQuery(this.getCurrentMenuProfile(), group, this.startDate, this.endDate, this.shiftsCombo.getComboBox().getSelectedItem().toString(), this.salesLocationsCombo.getComboBox().getSelectedItem().toString(), this.unsoldCheck.isSelected(), this.entireTD);
        }
    }

    void gotDatesChanged() {
        if (this.entireTD && this.datePanel != null || this.dateTimePanel != null) {
            Dialogs.showProgressDialog((AbstractTask)new CogsSetupTask(false));
        }
    }

    private class LoadMenuProfileTask
    extends AbstractTask {
        InventoryProfile prof;

        public LoadMenuProfileTask(InventoryProfile profile) {
            this.prof = profile;
        }

        public String getName() {
            return "Loading menu profile '" + this.prof.getLabel() + "'...";
        }

        public void performTask() throws Exception {
            COGSReportState.this.applyProfile(this.prof);
        }

        public int getTotalSubTasks() {
            return 1;
        }
    }

    private class CogsSetupTask
    extends AbstractGuiTask {
        boolean doFullSetup;

        public CogsSetupTask(boolean fullSetup) {
            this.doFullSetup = fullSetup;
        }

        public String getName() {
            return "Loading COGS Report screen...";
        }

        public void performTask() throws Exception {
            if (this.doFullSetup) {
                super.performTask();
            } else {
                COGSReportState.this.refresh();
            }
        }

        protected void doGuiTask() throws Exception {
            COGSReportState.this.setupGUI();
            COGSReportState.this.setupTree();
            COGSReportState.this.setupDates();
            COGSReportState.this.setupTable();
            COGSReportState.this.getNewGroupedTable();
            COGSReportState.this.setupSearcher();
            COGSReportState.this.buildProvider();
            COGSReportState.this.splitter.setDividerLocation(160);
            if (COGSReportState.this.table != null && COGSReportState.this.table.getRowCount() > 0) {
                COGSReportState.this.table.setRowSelectionInterval(0, 0);
            }
            COGSReportState.this.updateQuery(COGSReportState.this.startDate, COGSReportState.this.endDate, COGSReportState.this.shiftsCombo.getComboBox().getSelectedItem().toString(), COGSReportState.this.salesLocationsCombo.getComboBox().getSelectedItem().toString());
            COGSReportState.this.treePanel.setObjectFilter(new MenuGroupByProfileFilter(COGSReportState.this.getCurrentMenuProfile()));
        }

        public int getTotalSubTasks() {
            return 1;
        }
    }
}

