/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.cogs;

import au.com.ordermate.application.ApplicationContext;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import officemate.adminkit.table.QueryTableModel;

public class COGSTableModel
extends QueryTableModel {
    static final int COL_SALES = 7;
    private List<Boolean> deletedList = new ArrayList<Boolean>();
    private ApplicationContext context;

    public COGSTableModel(String selQuery, int idField, int[] colNames, String[] colDisplayNames, ApplicationContext dbContext) {
        super(selQuery, dbContext.getDatabaseConnection(), idField, colNames, colDisplayNames);
        this.context = dbContext;
    }

    @Override
    public void update() {
        this.deletedList.clear();
        super.update();
    }

    @Override
    protected Object getTableValue(int row, int col, String colName, int dbColIndex, ResultSet rs) throws SQLException {
        try {
            if (dbColIndex == 8 || dbColIndex == 9 || dbColIndex == 10 || dbColIndex == 12) {
                double priceVal = rs.getDouble(colName);
                Price price = new Price(priceVal, 0.01);
                return price;
            }
            if (dbColIndex == 11) {
                double val = rs.getDouble(colName);
                Double roundedVal = new Double(MathsUtils.roundDoubleToDecPlaces((double)val, (int)2));
                return roundedVal;
            }
            if (dbColIndex == 7) {
                return new Double(MathsUtils.roundDoubleToDecPlaces((double)rs.getDouble(colName), (int)1));
            }
            if (col == 0) {
                String systemState = COGSTableModel.getResultSetString(rs, 2);
                boolean deleted = !systemState.equals("ACTIVE");
                this.deletedList.add(deleted ? Boolean.TRUE : Boolean.FALSE);
            }
        }
        catch (SQLException e) {
            this.context.getLog().error("Cannot access table.", (Throwable)e);
            return null;
        }
        return super.getTableValue(row, col, null, dbColIndex + 1, rs);
    }

    @Override
    protected Number getTotalValue(int column, double rawValue, String colName, int dbColIndex) {
        if (dbColIndex == 8 || dbColIndex == 9 || dbColIndex == 10 || dbColIndex == 12) {
            return new Price(rawValue, 0.01);
        }
        if (dbColIndex == 11) {
            double salesEx = this.getTotalForResultSetColumn(12).doubleValue();
            double cogs = this.getTotalForResultSetColumn(8).doubleValue();
            if (salesEx == 0.0) {
                return Double.NaN;
            }
            double percent = 100.0 * (salesEx - cogs) / salesEx;
            Double roundedVal = new Double(MathsUtils.roundDoubleToDecPlaces((double)percent, (int)2));
            return roundedVal;
        }
        if (dbColIndex == 7) {
            return new Integer((int)rawValue);
        }
        return super.getTotalValue(column, rawValue, colName, dbColIndex);
    }

    public boolean isRowDeleted(int row) {
        boolean deleted = false;
        if (this.deletedList.size() > row) {
            Boolean b = this.deletedList.get(row);
            deleted = b;
        }
        return deleted;
    }
}

