/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.combos;

import au.com.ordermate.glazedlists.GlazedListUtils;
import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.filter.implementation.FixedRangeSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.OffsetFunction;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import officemate.adminkit.state.SearchGuiState;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ItemPropertySearch;
import officemate.components.search.searchfield.TimeRangeSearchField;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.reports.sales.general.ComboSoldReport;
import ordermate.database.searchers.reports.ItemSearcher;
import ordermate.database.searchers.reports.sales.general.ComboSoldReportSearcher;
import ordermate.database.users.User;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.ColumnVisibilityHelper;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class ComboSoldReportSearchState
extends AbstractTableState<ComboSoldReport>
implements SearchGuiState<ComboSoldReport> {
    private final ComboSoldReportSearcher searcher;
    private RefreshAction refreshAction = new RefreshAction((Refreshable)this);
    private EventList<Date> dates;
    private JCheckBox showCOGSCheckBox;

    public ComboSoldReportSearchState(ComboSoldReportSearcher searcher) {
        super("Search", null, "Search Combos to report on.");
        this.searcher = searcher;
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        new ColumnVisibilityHelper((Object[])new PropertiedObject.Property[]{ComboSoldReport.Properties.COGS, ComboSoldReport.Properties.COGS_PERCENTAGE}, this.showCOGSCheckBox, this.getCentralArea().getTable());
    }

    @Override
    public void onStart() {
        super.onStart();
        this.showCOGSCheckBox.setSelected(SystemProperty.getInstance().isStockControlEnabled());
    }

    @Override
    protected TableStateCentralArea<ComboSoldReport> createCentralArea() {
        return new PersistentObjectTable<ComboSoldReport>(this.getObjectList(), new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat("Combo Name", ComboSoldReport.Properties.COMBO_NAME), new PropertyColumnFormat("Combo Type", ComboSoldReport.Properties.COMBO_TYPE), new PropertyColumnFormat("Item Name", ComboSoldReport.Properties.ITEM_NAME), new PropertyColumnFormat("Item Size", ComboSoldReport.Properties.ITEM_SIZE), new PropertyColumnFormat("Item Portion", ComboSoldReport.Properties.PORTION), new PropertyColumnFormat("Items Sold", ComboSoldReport.Properties.ITEMS_SOLD), new PropertyColumnFormat("Items Sold Total", ComboSoldReport.Properties.UNIT_PRICE), new PropertyColumnFormat("Item Discount", (PropertiedObject.Property)ComboSoldReport.Properties.DISCOUNT), new PropertyColumnFormat("$ COGS", ComboSoldReport.Properties.COGS), new PropertyColumnFormat("% COGS", (PropertiedObject.Property)ComboSoldReport.Properties.COGS_PERCENTAGE).setFormatter((Format)new DecimalFormat("0.0%"))}));
    }

    @Override
    protected Class<ComboSoldReport> getDisplayingType() {
        return ComboSoldReport.class;
    }

    @Override
    public ObjectQuerySearcher<ComboSoldReport> getSearcher() {
        return this.searcher;
    }

    @Override
    public void refresh() {
        super.refresh();
        PeriodReportAdapter periodAdapter = this.searcher.getPeriod();
        if (periodAdapter != null) {
            GlazedListUtils.setAsList(this.dates, new ArrayList(periodAdapter.getDateList()));
        }
    }

    @Override
    protected OfficeMateObjectSearch createSearchPanelFactory() {
        ItemPropertySearch<ComboSoldReport> search = new ItemPropertySearch<ComboSoldReport>(ComboSoldReport.class, this.getSearcher(), (EventList)new BasicEventList()){

            @Override
            protected ObjectQuerySearcher<ComboSoldReport> getPropertySearcher() {
                ObjectQuerySearcher propertySearcher = super.getPropertySearcher();
                propertySearcher.removeSearchFilter((SearchFilterI)ComboSoldReportSearchState.this.searcher.getTerminalFilter());
                return propertySearcher;
            }
        };
        PeriodReportAdapter periodAdapter = this.searcher.getPeriod();
        if (periodAdapter == null) {
            search.addSearchField((SearchGuiField)new DateRangeSearchField("Date", this.searcher.getTradingDayDateRangeFilter(), DateTimeUtils.getOneMonthAgoCal().getTime(), (Action)this.refreshAction));
        } else {
            this.dates = GlazedLists.eventList((Collection)periodAdapter.getDateList());
            FixedRangeSearchFilter searchProp = this.searcher.getFixedRangeFilter();
            searchProp.setOffsetFunction((OffsetFunction)periodAdapter.getDateOffset());
            this.searcher.addSearchFilter((SearchFilterI)searchProp);
            search.addSearchField((SearchGuiField)new ComboSearchField(periodAdapter.getLabel(), (ISingleValueSearchFilter)searchProp, false, (Action)this.refreshAction, this.dates, (Format)periodAdapter.getFormatter()));
        }
        search.comboSoldSearchSetup((ItemSearcher<ComboSoldReport>)this.searcher, (Action)this.refreshAction);
        search.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Combos", (Action)this.refreshAction, GlazedLists.eventList((Collection)InventoryCombo.getAllCombos()), null, this.searcher.getComboFilter(), new JCheckBoxCellRenderer()));
        search.addSearchField((SearchGuiField)new ComboSearchField("Profile", this.searcher.getProfileFilter(), true, (Action)this.refreshAction, GlazedLists.eventList((Collection)InventoryProfile.getAllProfiles())));
        search.addSearchField((SearchGuiField)new MultiSelectComboSearchField("User", (Action)this.refreshAction, GlazedLists.eventList((Collection)User.getUsers()), null, this.searcher.getUserFilter(), new JCheckBoxCellRenderer()));
        search.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Sales Location", (Action)this.refreshAction, GlazedLists.eventList((Collection)SalesLocation.getSalesLocations()), null, this.searcher.getSalesLocationFilter(), new JCheckBoxCellRenderer()));
        search.addSearchField(new TimeRangeSearchField(this.searcher.getTimeFilter(), (Action)this.refreshAction));
        FieldPanelBuilder builder = new FieldPanelBuilder();
        JPanel additionalFields = new JPanel();
        additionalFields.setLayout(new BoxLayout(additionalFields, 1));
        this.showCOGSCheckBox = new JCheckBox((Action)this.refreshAction);
        this.showCOGSCheckBox.setText("");
        this.showCOGSCheckBox.setName("showCOGSCheckBox");
        builder.addRow("Show COGS", (Component)this.showCOGSCheckBox);
        additionalFields.add(builder.getPanel());
        search.addToSearchPanel(additionalFields);
        return search;
    }
}

