/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.covers;

import ar.com.fdvs.dj.domain.builders.BuilderException;
import au.com.ordermate.configuration.Config;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.screens.reports.covers.substates.DailyCoversReportState;
import officemate.screens.reports.covers.substates.DayOfWeekCoversReportState;
import officemate.screens.reports.covers.substates.MonthlyCoversReportState;
import officemate.screens.reports.covers.substates.WeeklyCoversReportState;
import ordermate.OrderMate;

public class CoversReportState
extends BasicOfficeMateState {
    public CoversReportState() {
        super("Dollars per head", null, "View and search for dollars per head report");
        this.addDailyCoversReport();
        this.addDayOfWeekReport();
        this.addWeeklyReport();
        this.addMonthlyReport();
    }

    private void addDayOfWeekReport() {
        try {
            this.addSubState(new DayOfWeekCoversReportState());
        }
        catch (BuilderException ex) {
            this.handleException(ex, "day of week");
        }
    }

    private void addDailyCoversReport() {
        try {
            this.addSubState(new DailyCoversReportState());
        }
        catch (BuilderException ex) {
            this.handleException(ex, "Daily covers report");
        }
    }

    private void addWeeklyReport() {
        try {
            this.addSubState(new WeeklyCoversReportState());
        }
        catch (BuilderException ex) {
            this.handleException(ex, "weekly covers report");
        }
    }

    private void handleException(BuilderException ex, String desc) {
        String msg = "Could not build : " + desc + " this report will not be available";
        if (Config.isDebuging()) {
            throw new RuntimeException(msg, ex);
        }
        OrderMate.LOG.error(msg, (Throwable)ex);
    }

    private void addMonthlyReport() {
        try {
            this.addSubState(new MonthlyCoversReportState());
        }
        catch (BuilderException ex) {
            this.handleException(ex, "Monthly covers report");
        }
    }
}

