/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.custom;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.search.control.RefreshAction;
import officemate.screens.reports.custom.CustomReportJasperToolbarFactory;
import officemate.screens.reports.custom.CustomReportStateHelper;
import officemate.screens.reports.jasper.JasperReportState;
import officemate.screens.reports.jasper.JasperToolbarFactory;
import ordermate.database.reports.config.custom.CustomReport;
import ordermate.database.reports.config.custom.CustomReportProvider;
import ordermate.database.reports.config.custom.CustomReportSearchParams;
import ordermate.database.reports.config.custom.compiler.CustomReportCompiler;
import ordermate.database.users.AllPermissions;
import ordermate.reports.dynamicjasper.reportbuilder.ReportProvider;

public class FormalCustomReportState
extends JasperReportState
implements Refreshable {
    private final CustomReport report;
    private CustomReportJasperToolbarFactory toolbar;

    public FormalCustomReportState(CustomReport report) {
        super(null, report.getTitle(), AllPermissions.ACCESS_SALES_REPORT, report.getSubTitle());
        this.report = report;
    }

    @Override
    public String getAccessLevel() {
        if (CustomReportStateHelper.getCustomReportsToDisplay(this.getUser()).contains(this.report)) {
            return super.getAccessLevel();
        }
        return "HIDDEN";
    }

    @Override
    protected JasperToolbarFactory createJasperToolbarFactory() {
        this.toolbar = new CustomReportJasperToolbarFactory(new RefreshAction((Refreshable)this), this.getUser(), false);
        return this.toolbar;
    }

    @Override
    public void refresh() {
        super.refresh();
        CustomReportCompiler compiler = new CustomReportCompiler(new CustomReportSearchParams(this.report));
        compiler.setPeriodReportAdapter(this.toolbar.getAdapter());
        compiler.setReportDate(this.toolbar.getPeriodPanel().getStartDate());
        compiler.compileReport();
        this.setReportProvider((ReportProvider)new CustomReportProvider(compiler));
        this.displayReport();
    }
}

