/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.dailysummary;

import au.com.ordermate.glazedlists.GlazedListUtils;
import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.filter.implementation.FixedRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.util.DateTimeUtils;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.FlowLayout;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.JPanel;
import officemate.screens.reports.jasper.JasperReportState;
import officemate.screens.reports.jasper.JasperToolbarFactory;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.reports.dailysummary.provider.DailySummaryReportProvider;
import ordermate.database.users.Permission;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.dynamicjasper.reportbuilder.ReportProvider;

public class DailySummaryByLocationReportState
extends JasperReportState {
    public DailySummaryByLocationReportState(Permission permission, boolean byCategory) {
        super((ReportProvider)new DailySummaryReportProvider(true), "By Location", permission, "View a daily summary report broken down by sales location.");
        if (byCategory) {
            ((DailySummaryReportProvider)this.getProvider()).getSearcher().setByCategory();
        } else {
            ((DailySummaryReportProvider)this.getProvider()).getSearcher().setByAccountType();
        }
    }

    @Override
    protected JasperToolbarFactory createJasperToolbarFactory() {
        return new ByLocationJasperToolbarFactory();
    }

    class ByLocationJasperToolbarFactory
    extends JasperToolbarFactory {
        private ComboSearchField weekField;
        private EventList<Date> weeks;

        ByLocationJasperToolbarFactory() {
        }

        @Override
        protected JPanel getCustomReportControlPanel() {
            FixedRangeSearchFilter dateFilter = ((DailySummaryReportProvider)DailySummaryByLocationReportState.this.getProvider()).getSearcher().getParams().getFixedRangeFilter();
            this.weeks = GlazedLists.eventList(new ArrayList(PeriodReportAdapter.WEEK_ENDING.getDateList()));
            this.weekField = new ComboSearchField("Week Ending", (ISingleValueSearchFilter)dateFilter, false, DailySummaryByLocationReportState.this.getRefreshAction(), this.weeks, (Format)DateTimeUtils.getShortDateFormat());
            JPanel holder = new JPanel(new FlowLayout(0));
            holder.add(this.weekField.getJLabelForComponent());
            holder.add(this.weekField.getGuiComponent());
            MultiOptionSearchFilter locationsFilter = ((DailySummaryReportProvider)DailySummaryByLocationReportState.this.getProvider()).getSearcher().getParams().getSalesLocationsFilter();
            List locationsList = PersistenceManager.getObjectList(SalesLocation.class, (String)Query.select(SalesLocation.class).active(SalesLocation.class).toString());
            MultiSelectComboSearchField locationsField = new MultiSelectComboSearchField("Sales Location", DailySummaryByLocationReportState.this.getRefreshAction(), GlazedLists.eventList((Collection)locationsList), null, locationsFilter, new JCheckBoxCellRenderer());
            holder.add(locationsField.getJLabelForComponent());
            holder.add(locationsField.getGuiComponent());
            return holder;
        }

        @Override
        public void refreshSearchOptions() {
            super.refreshSearchOptions();
            GlazedListUtils.setAsList(this.weeks, new ArrayList(PeriodReportAdapter.WEEK_ENDING.getDateList()));
        }
    }
}

