/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.dailysummary;

import au.com.ordermate.glazedlists.GlazedListUtils;
import au.com.ordermate.oquery.search.filter.implementation.FixedRangeSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.util.DateTimeUtils;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.FlowLayout;
import java.text.Format;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JPanel;
import officemate.screens.reports.jasper.JasperReportState;
import officemate.screens.reports.jasper.JasperToolbarFactory;
import ordermate.database.reports.dailysummary.provider.DailySummaryReportProvider;
import ordermate.database.users.Permission;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.dynamicjasper.reportbuilder.ReportProvider;

public class DailySummaryTotalReportState
extends JasperReportState {
    public DailySummaryTotalReportState(Permission permission, boolean byCategory) {
        super((ReportProvider)new DailySummaryReportProvider(false), "Summary", permission, "View a summary of sales, debtor activity, voucher activity, productivity and reconciliations for a week.");
        if (byCategory) {
            ((DailySummaryReportProvider)this.getProvider()).getSearcher().setByCategory();
        } else {
            ((DailySummaryReportProvider)this.getProvider()).getSearcher().setByAccountType();
        }
    }

    @Override
    protected JasperToolbarFactory createJasperToolbarFactory() {
        return new DayOfWeekJasperToolbarFactory();
    }

    class DayOfWeekJasperToolbarFactory
    extends JasperToolbarFactory {
        private EventList<Date> weeks;

        DayOfWeekJasperToolbarFactory() {
        }

        @Override
        protected JPanel getCustomReportControlPanel() {
            FixedRangeSearchFilter dateFilter = ((DailySummaryReportProvider)DailySummaryTotalReportState.this.getProvider()).getSearcher().getParams().getFixedRangeFilter();
            this.weeks = GlazedLists.eventList(new ArrayList(PeriodReportAdapter.WEEK_ENDING.getDateList()));
            ComboSearchField field = new ComboSearchField("Week Ending", (ISingleValueSearchFilter)dateFilter, false, DailySummaryTotalReportState.this.getRefreshAction(), this.weeks, (Format)DateTimeUtils.getShortDateFormat());
            JPanel holder = new JPanel(new FlowLayout(0));
            holder.add(field.getJLabelForComponent());
            holder.add(field.getGuiComponent());
            return holder;
        }

        @Override
        public void refreshSearchOptions() {
            super.refreshSearchOptions();
            GlazedListUtils.setAsList(this.weeks, new ArrayList(PeriodReportAdapter.WEEK_ENDING.getDateList()));
        }
    }
}

